---
generated_at: 2026-02-04 10:05:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：32-make-distribution.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間の推定値**：根拠不足（ビルド環境依存で「数十分〜1時間」は推測）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `dev/make-distribution.sh`（スクリプト本体、338行）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧定義、行32）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | dist/ディレクトリにバイナリディストリビューションを生成する | E-01（33行目、199-200行目） | ○ |
| C-02 | --tgzオプションでtar.gzアーカイブを作成する | E-01（60-61行目、308-318行目） | ○ |
| C-03 | --pipオプションでPythonパッケージを作成する | E-01（63-64行目、253-264行目） | ○ |
| C-04 | --rオプションでRパッケージを作成する | E-01（66-67行目、267-286行目） | ○ |
| C-05 | --connectオプションでSpark Connectディストリビューションを作成する | E-01（69-70行目、319-336行目） | ○ |
| C-06 | JAVA_HOME未設定時にrpm、whichの順でJavaを検出する | E-01（105-121行目） | ○ |
| C-07 | JAVA_HOME未設定・検出不可でエラー終了する | E-01（123-126行目） | ○ |
| C-08 | Maven/SBTコマンド不在でエラー終了する | E-01（136-144行目） | ○ |
| C-09 | set -eとset -o pipefailが有効 | E-01（27-29行目） | ○ |
| C-10 | MAVEN_OPTSのデフォルトが-Xss128m -Xmx4g -XX:ReservedCodeCacheSize=128m | E-01（178行目） | ○ |
| C-11 | fat JARを生成し自己完結型 | E-01（24行目コメント） | ○ |
| C-12 | Mavenビルド時にテスト・javadoc・scaladocをスキップする | E-01（183-189行目） | ○ |
| C-13 | 既存のdist/を削除してから新規作成する | E-01（199行目） | ○ |
| C-14 | examples JARの重複を除去する | E-01（225-230行目） | ○ |
| C-15 | RELEASEファイルにバージョン・ビルドフラグ・gitリビジョンを記録する | E-01（201-202行目） | ○ |
| C-16 | macOSではtar引数に--no-mac-metadata等が付与される | E-01（314-316行目） | ○ |
| C-17 | Spark Connectではbin/スクリプトにSPARK_CONNECT_MODE環境変数を注入する | E-01（326-332行目） | ○ |
| C-18 | pip用パッケージはclassic/connect/clientの3種類 | E-01（258-260行目） | ○ |
| C-19 | SparkRはSpark 4.0.0以降で非推奨 | E-01（52行目） | ○ |
| C-20 | 目標処理時間は数十分〜1時間程度 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ビルド処理時間はマシンスペック・ネットワーク環境・ビルドオプションに大きく依存するため、具体的な数値の根拠がない
  - 候補：CI/CDパイプラインの実績データ / ビルドベンチマーク結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - スクリプトの処理フローはソースコードと高い整合性を持ち、オプション体系も正確に記述されている

## 6) レビュアーチェックリスト（最小）
- [ ] ビルドオプション（--tgz, --pip, --r, --connect等）の説明がソースコードと一致しているか確認
- [ ] MAVEN_OPTSのデフォルト値が正確か確認
- [ ] Spark Connectディストリビューションで注入される環境変数の対象スクリプトが網羅されているか確認
- [ ] dist/ディレクトリに配置されるファイル種類が正確か確認
