---
generated_at: 2026-02-04 10:10:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：33-docker-image-tool.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間が環境依存**：根拠不足（具体的な数値なし）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `bin/docker-image-tool.sh`（スクリプト本体、337行）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧定義、行33）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RELEASEファイルの有無でリリースビルド/開発ビルドを判定する | E-01（34-36行目） | ○ |
| C-02 | 開発ビルド時にビルドコンテキストを最小化する | E-01（89-127行目） | ○ |
| C-03 | 3種類のビルドコンテキスト（base/pyspark/sparkr）を作成する | E-01（91, 114, 122行目） | ○ |
| C-04 | kubernetes/dockerfilesの存在を検証する | E-01（147-149行目） | ○ |
| C-05 | Spark JARの存在を検証する | E-01（153-157行目） | ○ |
| C-06 | sparkイメージをベースにビルドする | E-01（177-179行目） | ○ |
| C-07 | PySpark/SparkRイメージはbase_imgとしてsparkイメージを参照する | E-01（166-170行目） | ○ |
| C-08 | クロスビルドでlinux/amd64,linux/arm64に対応する | E-01（175行目） | ○ |
| C-09 | クロスビルド時に--pushが自動付与される | E-01（184-186行目） | ○ |
| C-10 | --provenance=falseが付与される | E-01（184行目） | ○ |
| C-11 | minikubeオプションで直接minikubeのDockerデーモンを使用する | E-01（309-315行目） | ○ |
| C-12 | minikube不在/停止時にエラー終了する | E-01（309-314行目） | ○ |
| C-13 | push時にリポジトリ未指定でエラー終了する | E-01（326-329行目） | ○ |
| C-14 | pushはspark, spark-py, spark-rの順に実行する | E-01（218-222行目） | ○ |
| C-15 | イメージ不在時にpushをスキップする | E-01（60-67行目） | ○ |
| C-16 | SPARK_UIDオプションでコンテナ内ユーザーUIDを変更可能 | E-01（162-164行目） | ○ |
| C-17 | -nオプションで--no-cacheビルドが可能 | E-01（305行目） | ○ |
| C-18 | -bオプションで追加ビルド引数を渡せる | E-01（306行目） | ○ |
| C-19 | EXITトラップでビルドコンテキストが自動クリーンアップされる | E-01（44行目） | ○ |
| C-20 | load-spark-env.shをsourceして環境を読み込む | E-01（30行目） | ○ |
| C-21 | PySpark Dockerfile未指定時はPySparkイメージビルドをスキップする | E-01（173, 189行目） | ○ |
| C-22 | 目標処理時間は環境依存 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Dockerイメージビルドの所要時間はDockerキャッシュ状態・ネットワーク速度・マシンスペックに依存するため具体的な数値の根拠がない
  - 候補：CI/CD実績データ / Dockerビルドベンチマーク

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - スクリプトの処理フローはソースコードと高い整合性を持ち、オプション体系も正確に記述されている

## 6) レビュアーチェックリスト（最小）
- [ ] Dockerイメージ名（spark, spark-py, spark-r）の命名規則が正確か確認
- [ ] クロスビルド時のアーキテクチャ（linux/amd64, linux/arm64）が正確か確認
- [ ] 開発ビルドコンテキストに含まれるファイルの一覧が網羅的か確認
- [ ] minikubeオプション使用時の動作が正確か確認
