---
generated_at: 2026-02-04 10:20:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：35-run-tests.py

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **全テスト実行時間の推定値**：根拠不足（「数時間」は推測値）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `dev/run-tests.py`（スクリプト本体、660行）
- E-02: `dev/sparktestsupport/__init__.py`（ERROR_CODES定義、40行）
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧定義、行35）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルト並列度は8 | E-01（424行目） | ○ |
| C-02 | デフォルトPython実行環境はpython3.11 | E-01（429行目） | ○ |
| C-03 | work/ディレクトリとivy2キャッシュを削除する | E-01（477-481行目） | ○ |
| C-04 | JAVA_HOME/bin/javaまたはPATH上のjavaを検出する | E-01（49-62行目） | ○ |
| C-05 | java不在時にexit 2で終了する | E-01（487-492行目） | ○ |
| C-06 | HOME未設定時にexit 1で終了する | E-01（468-473行目） | ○ |
| C-07 | ビルドツールはsbtに固定 | E-01（509行目） | ○ |
| C-08 | HadoopプロファイルのデフォルトはHadoop3 | E-01（511行目） | ○ |
| C-09 | GitHub Actions環境を検出しテスト環境を決定する | E-01（512-515行目） | ○ |
| C-10 | APACHE_SPARK_REFによる変更ファイル検出 | E-01（540-543行目） | ○ |
| C-11 | GITHUB_PREV_SHAによる変更ファイル検出 | E-01（544-547行目） | ○ |
| C-12 | rootモジュールが変更モジュールに含まれる場合は全モジュール対象 | E-01（553-556行目） | ○ |
| C-13 | SCALA_PROFILE設定時にchange-scala-version.shを呼び出す | E-01（585-587行目） | ○ |
| C-14 | Apache RATチェックを実行する | E-01（591-592行目） | ○ |
| C-15 | Scala/Java/Python/Rのスタイルチェックを実行する | E-01（594-615行目） | ○ |
| C-16 | 依存関係テスト（test-dependencies.sh）を実行する | E-01（617-618行目） | ○ |
| C-17 | SBTビルド時にMiMaを実行する | E-01（624-627行目） | ○ |
| C-18 | MiMa後にアセンブリビルドが必要（SPARK-13294） | E-01（628-630行目） | ○ |
| C-19 | PySparkテストでコードカバレッジ時に並列度1に制限 | E-01（380-384行目） | ○ |
| C-20 | SKIP_PYTHON/SKIP_R環境変数でテストスキップ可能 | E-01（636, 644行目） | ○ |
| C-21 | SKIP_MIMAでMiMaスキップ可能 | E-01（626行目） | ○ |
| C-22 | ERROR_CODESでブロック別エラーコードが定義されている | E-02（22-39行目） | ○ |
| C-23 | SBT出力フィルタでResolving/Merging/Includingを非表示 | E-01（154-156行目） | ○ |
| C-24 | doctestが_test()関数で実行される | E-01（648-654行目） | ○ |
| C-25 | 全テスト実行で数時間かかる | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 全テスト実行時間の「数時間」はプロジェクト規模からの推測であり、具体的なベンチマークデータがない
  - 候補：GitHub Actions実行履歴 / CI/CD実績データ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - スクリプトの構造と処理フローはソースコードと高い整合性を持ち、エラーコード体系も正確に文書化されている

## 6) レビュアーチェックリスト（最小）
- [ ] コマンドライン引数のデフォルト値がソースコードと一致しているか確認
- [ ] ERROR_CODESの各ブロック名とエラーコードの対応が正確か確認
- [ ] GitHub Actions環境での変更ファイル検出ロジック（APACHE_SPARK_REF, GITHUB_PREV_SHA）の説明が正確か確認
- [ ] テスト実行順序がソースコードのmain()関数と一致しているか確認
- [ ] 各SKIP_*環境変数の効果が正確に記述されているか確認
