---
generated_at: 2026-02-04 10:25:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：36-test-dependencies.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間の推定値**：根拠不足（「数分〜十数分」は推測値）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `dev/test-dependencies.sh`（スクリプト本体、151行）
- E-02: `dev/run-tests.py`（run_build_tests関数、403-405行目）
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧定義、行36）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LC_ALL=Cでsort出力の一貫性を確保する | E-01（25-27行目） | ○ |
| C-02 | HADOOP_MODULE_PROFILESに複数プロファイルが含まれる | E-01（33-34行目） | ○ |
| C-03 | HADOOP_HIVE_PROFILESはhadoop-3-hive-2.3のみ | E-01（36-38行目） | ○ |
| C-04 | exec-maven-plugin.versionをMavenから取得する | E-01（40-41行目） | ○ |
| C-05 | project.versionをexec:exec経由で取得する | E-01（49-53行目） | ○ |
| C-06 | Scala 2.13以外でスキップする | E-01（63-71行目） | ○ |
| C-07 | guava・jetty-ioの事前取得（SPARK-37302対応） | E-01（55-58行目） | ○ |
| C-08 | テンポラリバージョンはpython3のランダム番号で生成 | E-01（73行目） | ○ |
| C-09 | EXITトラップでバージョン復元・テンポラリPOM削除 | E-01（75-81行目） | ○ |
| C-10 | versions:setでテンポラリバージョンに切り替え | E-01（84行目） | ○ |
| C-11 | Maven jar:jar + jar:test-jar + install:install + clean を実行 | E-01（92行目） | ○ |
| C-12 | Maven validate を実行 | E-01（95行目） | ○ |
| C-13 | dependency:build-classpathでクラスパスを取得 | E-01（99行目） | ○ |
| C-14 | awkでartifact_id/version/classifier/jar_name形式に変換 | E-01（101-118行目） | ○ |
| C-15 | sparkのJARを除外してソートする | E-01（118行目） | ○ |
| C-16 | --replace-manifestでdev/pr-depsをdev/depsに移動 | E-01（121-126行目） | ○ |
| C-17 | git diff --no-indexでマニフェストを比較する | E-01（130-135行目） | ○ |
| C-18 | 差分がある場合exit 1でエラー終了する | E-01（137-143行目） | ○ |
| C-19 | 正常終了時にdev/pr-depsを削除する | E-01（146-148行目） | ○ |
| C-20 | run-tests.pyのrun_build_tests関数から呼び出される | E-02（403-405行目） | ○ |
| C-21 | set -exが有効でコマンドトレースが出力される | E-01（20行目） | ○ |
| C-22 | 目標処理時間は数分〜十数分 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 処理時間はMaven依存関係解決のネットワーク状態とキャッシュ状態に大きく依存するため具体的な数値の根拠がない
  - 候補：CI/CD実績データ / Maven実行ベンチマーク

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - スクリプトの処理フローとエラー処理はソースコードと高い整合性を持つ。EXITトラップによるバージョン復元メカニズムも正確に記述されている

## 6) レビュアーチェックリスト（最小）
- [ ] HADOOP_MODULE_PROFILESとHADOOP_HIVE_PROFILESの値が最新か確認
- [ ] テンポラリバージョンの生成・復元ロジックが正確に記述されているか確認
- [ ] awkによるクラスパス解析のロジック（classifier抽出）の説明が正確か確認
- [ ] --replace-manifestオプションの動作説明が正確か確認
- [ ] EXITトラップのreset_version関数の動作が正確に記述されているか確認
