---
generated_at: 2026-02-04 10:15:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-stop-master.sh バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `sbin/stop-master.sh`（ソースコード）
- E-02: `sbin/spark-config.sh`（ソースコード）
- E-03: `sbin/spark-daemon.sh`（ソースコード）
- E-04: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | stop-master.shはMasterデーモンを停止する | E-01 L21, L28 | ○ |
| C-02 | SPARK_HOMEが未設定の場合自動検出する | E-01 L23-25 | ○ |
| C-03 | spark-config.shをsourceする | E-01 L27 | ○ |
| C-04 | spark-daemon.sh stopを呼び出す | E-01 L28 | ○ |
| C-05 | クラス名はorg.apache.spark.deploy.master.Master | E-01 L28 | ○ |
| C-06 | インスタンス番号は1 | E-01 L28 | ○ |
| C-07 | PIDファイルからプロセスIDを読み取る | E-03 L216-217 | ○ |
| C-08 | killシグナルで停止しPIDファイルを削除 | E-03 L220 | ○ |
| C-09 | プロセス未起動時は"no {command} to stop" | E-03 L222-223, L225 | ○ |
| C-10 | コマンドライン引数を受け取らない | E-01（引数処理なし） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全主張に対してソースコードから根拠が確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 非常にシンプルな停止スクリプト

## 6) レビュアーチェックリスト（最小）
- [ ] killシグナル（SIGTERM）でMasterが正常にシャットダウンするか確認
- [ ] PIDファイルのパスが正しいか確認
