---
generated_at: 2026-02-04 10:20:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-start-worker.sh バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `sbin/start-worker.sh`（ソースコード）
- E-02: `sbin/spark-config.sh`（ソースコード）
- E-03: `sbin/spark-daemon.sh`（ソースコード）
- E-04: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 起動クラスはorg.apache.spark.deploy.worker.Worker | E-01 L40 | ○ |
| C-02 | 第1引数にMaster URLが必須 | E-01 L42, L59 | ○ |
| C-03 | 引数なしの場合exit 1 | E-01 L50 | ○ |
| C-04 | --help/-hでヘルプ表示 | E-01 L42-51 | ○ |
| C-05 | デフォルトWebUIポートは8081 | E-01 L63-65 | ○ |
| C-06 | SPARK_WORKER_INSTANCES未設定時は1インスタンス起動 | E-01 L86-87 | ○ |
| C-07 | SPARK_WORKER_INSTANCES設定時はN個起動 | E-01 L88-91 | ○ |
| C-08 | ポート番号はベースポートからインクリメント | E-01 L78 | ○ |
| C-09 | WebUIポートはインスタンス番号に応じてインクリメント | E-01 L80 | ○ |
| C-10 | SPARK_WORKER_PORT未設定時はポートフラグなし | E-01 L73-74 | ○ |
| C-11 | spark-daemon.sh start経由で起動 | E-01 L82-83 | ○ |
| C-12 | SPARK_WORKER_INSTANCESはSpark 3.0以降非推奨 | E-01 L25 | ○ |
| C-13 | spark-config.shをsourceする | E-01 L53 | ○ |
| C-14 | load-spark-env.shをsourceする | E-01 L55 | ○ |
| C-15 | クラス名はSparkSubmitでも参照される | E-01 L38-39 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全主張に対してソースコードから根拠が確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 標準的なデーモン起動スクリプト

## 6) レビュアーチェックリスト（最小）
- [ ] SPARK_WORKER_INSTANCES使用時の非推奨警告を運用チームに周知しているか確認
- [ ] 複数インスタンス起動時のポート番号割り当てが運用環境で問題ないか確認
- [ ] Master URLの形式（spark://host:port）が正しいか確認
