---
generated_at: 2026-02-04 10:25:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-stop-worker.sh バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `sbin/stop-worker.sh`（ソースコード）
- E-02: `sbin/spark-config.sh`（ソースコード）
- E-03: `sbin/spark-daemon.sh`（ソースコード）
- E-04: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 全Workerインスタンスを停止する | E-01 L20-21, L28 | ○ |
| C-02 | SPARK_HOMEが未設定の場合自動検出する | E-01 L30-32 | ○ |
| C-03 | spark-config.shをsourceする | E-01 L34 | ○ |
| C-04 | load-spark-env.shをsourceする | E-01 L36 | ○ |
| C-05 | SPARK_WORKER_INSTANCES未設定時はインスタンス1を停止 | E-01 L38-39 | ○ |
| C-06 | SPARK_WORKER_INSTANCES設定時はN個を順次停止 | E-01 L40-43 | ○ |
| C-07 | spark-daemon.sh stop Worker経由で停止 | E-01 L39, L42 | ○ |
| C-08 | インスタンス番号は1から開始 | E-01 L39, L42 | ○ |
| C-09 | killシグナルで停止しPIDファイルを削除 | E-03 L216-226 | ○ |
| C-10 | プロセス未起動時は"no {command} to stop" | E-03 L222-223, L225 | ○ |
| C-11 | コマンドライン引数を受け取らない | E-01（引数処理なし） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全主張に対してソースコードから根拠が確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 標準的な停止スクリプト

## 6) レビュアーチェックリスト（最小）
- [ ] SPARK_WORKER_INSTANCESの値が起動時と停止時で一致しているか運用手順で担保されているか確認
- [ ] killシグナル（SIGTERM）でWorkerが正常にシャットダウンするか確認
