---
generated_at: 2026-02-04 10:40:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：9-decommission-worker.sh バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **--block-until-exitのwait動作**：PIDファイルパスの変数参照に不整合の可能性がある

## 2) 参照した情報（Evidence一覧）

- E-01: `sbin/decommission-worker.sh`（ソースコード）
- E-02: `sbin/spark-config.sh`（ソースコード）
- E-03: `sbin/spark-daemon.sh`（ソースコード）
- E-04: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Workerをデコミッション（安全停止）する | E-01 L20-21, L41-45 | ○ |
| C-02 | set -exが設定されている | E-01 L30 | ○ |
| C-03 | SPARK_HOMEが未設定の場合自動検出する | E-01 L32-34 | ○ |
| C-04 | spark-config.shをsourceする | E-01 L36 | ○ |
| C-05 | load-spark-env.shをsourceする | E-01 L38 | ○ |
| C-06 | SPARK_WORKER_INSTANCES未設定時はインスタンス1をデコミッション | E-01 L40-41 | ○ |
| C-07 | SPARK_WORKER_INSTANCES設定時はN個をデコミッション | E-01 L42-45 | ○ |
| C-08 | spark-daemon.sh decommission経由で実行 | E-01 L41, L44 | ○ |
| C-09 | デコミッションはSIGPWRシグナルで実装 | E-03 L235 | ○ |
| C-10 | --block-until-exitオプションでプロセス終了を待機 | E-01 L51-56 | ○ |
| C-11 | K8s環境でのPod終了待機に対応 | E-01 L48-50 | ○ |
| C-12 | デーモン未起動時は"no {command} to decommission" | E-03 L237-238, L240 | ○ |
| C-13 | PIDファイルはデコミッション時に削除されない | E-03 L229-241（stopとの比較） | ○ |
| C-14 | 複数インスタンス時は0番目のみを待機 | E-01 L53 | ○ |
| C-15 | --block-until-exitのwait動作が正しく機能する | E-01 L55-56（変数$commandが未定義の可能性） | △ |

## 4) 不足情報（Unknown / Missing）
- C-15: `--block-until-exit` のPIDファイルパス構築で変数 `$command` が使用されているが、この変数はスクリプト内で定義されていない。`spark-daemon.sh` 内でのみ定義される変数であり、`decommission-worker.sh` のコンテキストでは未定義になる可能性がある。実際の動作確認が必要。
  - 候補：Sparkの実行テスト / Kubernetes環境での動作検証 / コード修正の必要性確認

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - `--block-until-exit` オプションのPIDファイルパス構築に未定義変数の使用が見られる。本番環境での動作検証が推奨される

## 6) レビュアーチェックリスト（最小）
- [ ] `--block-until-exit` オプション使用時のPIDファイルパス内の変数 `$command` が正しく解決されるか確認
- [ ] SIGPWRシグナルがWorkerプロセスで正しくハンドルされるか確認
- [ ] Kubernetes環境での `--block-until-exit` の動作を検証
- [ ] デコミッション中のタスク移行が正しく動作するか確認
