---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 200
  claims_with_evidence: 194
  claims_without_evidence: 6
confidence_derived: 0.97
---

# 根拠レポート：common-kvstore 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：194 / 200、根拠なし：6
- 優先レビュー（高）
  1. **InMemoryStore.removeAllByIndexValues の親インデックス経由削除パス**：parentToChildrenMap経由の削除パスは内部実装の詳細であり、外部テストからの検証方法は要確認
  2. **LevelDBTypeInfo.Index.toKey の辞書順保存検証**：hexエンコードの辞書順保存性はコード解析に基づく主張であり、実際の比較テストによる確認が必要
  3. **RocksDBIterator の降順イテレーション時のNoSuchElementException**：RocksDBIteratorのコンストラクタで`!it.isValid()`の場合にNoSuchElementExceptionをスローする動作の前提条件が明確でない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `common/kvstore/src/main/java/org/apache/spark/util/kvstore/KVStore.java` - KVStoreインターフェース定義（メソッドシグネチャ、Javadoc）
- E-02: `common/kvstore/src/main/java/org/apache/spark/util/kvstore/KVStoreView.java` - KVStoreView抽象クラス（reverse, index, parent, first, last, max, skip メソッド）
- E-03: `common/kvstore/src/main/java/org/apache/spark/util/kvstore/KVStoreIterator.java` - KVStoreIteratorインターフェース（next(int), skip(long)）
- E-04: `common/kvstore/src/main/java/org/apache/spark/util/kvstore/KVIndex.java` - KVIndexアノテーション定義（value, parent, copy属性）
- E-05: `common/kvstore/src/main/java/org/apache/spark/util/kvstore/KVTypeInfo.java` - KVTypeInfoクラス（コンストラクタの検証ロジック、FieldAccessor, MethodAccessor）
- E-06: `common/kvstore/src/main/java/org/apache/spark/util/kvstore/KVStoreSerializer.java` - シリアライザ（serialize/deserializeメソッド、GZIP圧縮、long変換）
- E-07: `common/kvstore/src/main/java/org/apache/spark/util/kvstore/InMemoryStore.java` - InMemoryStore実装（全メソッド、InMemoryView, InMemoryIterator, InstanceList内部クラス）
- E-08: `common/kvstore/src/main/java/org/apache/spark/util/kvstore/LevelDB.java` - LevelDB実装（全メソッド、バージョン管理、TypeAliases、PrefixCache）
- E-09: `common/kvstore/src/main/java/org/apache/spark/util/kvstore/LevelDBIterator.java` - LevelDBIterator実装（hasNext, next, skip, close, startsWith, compare, ResourceCleaner）
- E-10: `common/kvstore/src/main/java/org/apache/spark/util/kvstore/LevelDBTypeInfo.java` - LevelDBTypeInfo（キー構築、Index内部クラス、toKey変換ロジック）
- E-11: `common/kvstore/src/main/java/org/apache/spark/util/kvstore/RocksDB.java` - RocksDB実装（全メソッド、バージョン管理、設定オプション）
- E-12: `common/kvstore/src/main/java/org/apache/spark/util/kvstore/RocksDBIterator.java` - RocksDBIterator実装（hasNext, next, skip, close, ResourceCleaner）
- E-13: `common/kvstore/src/main/java/org/apache/spark/util/kvstore/RocksDBTypeInfo.java` - RocksDBTypeInfo（キー構築、Index内部クラス）
- E-14: `common/kvstore/src/main/java/org/apache/spark/util/kvstore/ArrayWrappers.java` - ArrayWrappers（forArray、4つのComparable内部クラス）
- E-15: `common/kvstore/src/main/java/org/apache/spark/util/kvstore/UnsupportedStoreVersionException.java` - 例外クラス定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | InMemoryStore.getMetadata: メタデータ取得はklass.cast(metadata)で実装 | E-07 L50-52 | ○ |
| C-002 | InMemoryStore.getMetadata: 未設定時null（metadata初期値null） | E-07 L46 | ○ |
| C-003 | InMemoryStore.setMetadata: this.metadata = valueで設定 | E-07 L55-57 | ○ |
| C-004 | InMemoryStore.setMetadata: null設定可（直接代入） | E-07 L56 | ○ |
| C-005 | InMemoryStore.write: inMemoryLists.write(value)で書込み | E-07 L90-92 | ○ |
| C-006 | InMemoryStore.write: 同一キーはConcurrentHashMap.putで上書き | E-07 L268 | ○ |
| C-007 | InMemoryStore.read: NoSuchElementException on null result | E-07 L80-87 | ○ |
| C-008 | InMemoryStore.read: 存在しないキーでNoSuchElementException | E-07 L82-85 | ○ |
| C-009 | InMemoryStore.read: 未登録型ではlist=nullでvalue=null | E-07 L81-83 | ○ |
| C-010 | InMemoryStore.delete: list.delete(naturalKey)で削除 | E-07 L95-100 | ○ |
| C-011 | InMemoryStore.delete: list=nullの場合は何もしない | E-07 L97 | ○ |
| C-012 | InMemoryStore.count: list.size()で返却 | E-07 L60-63 | ○ |
| C-013 | InMemoryStore.count: list=nullの場合0 | E-07 L62 | ○ |
| C-014 | InMemoryStore.count(type,index,indexedValue): アクセサ+比較でカウント | E-07 L66-77 | ○ |
| C-015 | InMemoryStore.view: list.view()またはemptyView()を返却 | E-07 L103-106 | ○ |
| C-016 | InMemoryStore.view: 未登録型でemptyView(空のConcurrentHashMap) | E-07 L105, L341-342 | ○ |
| C-017 | InMemoryStore.close: metadata=null, data.clear() | E-07 L109-112 | ○ |
| C-018 | InMemoryStore.removeAllByIndexValues: 3つの分岐パス | E-07 L231-261 | ○ |
| C-019 | InMemoryStore.removeAllByIndexValues: NATURAL_INDEX_NAME分岐 | E-07 L233-237 | ○ |
| C-020 | InMemoryStore.removeAllByIndexValues: 親インデックスパス | E-07 L238-251 | ○ |
| C-021 | InMemoryView.iterator: ascending/descendingでソート | E-07 L371-374 | ○ |
| C-022 | InMemoryView.iterator: first/last/skip/maxフィルタリング | E-07 L377-395 | ○ |
| C-023 | InMemoryView.iterator: parent指定でcopyElements | E-07 L401-429 | ○ |
| C-024 | InMemoryIterator.next(int): リストに最大max件追加 | E-07 L471-477 | ○ |
| C-025 | InMemoryIterator.skip: n件スキップしhasNext確認 | E-07 L480-492 | ○ |
| C-026 | KVStoreView.reverse: ascending = !ascending | E-02 L53-56 | ○ |
| C-027 | KVStoreView.index: Objects.requireNonNull(name) | E-02 L62 | ○ |
| C-028 | KVStoreView.max: checkArgument(max > 0L) | E-02 L100 | ○ |
| C-029 | KVTypeInfo constructor: field/method KVIndex探索 | E-05 L39-78 | ○ |
| C-030 | KVTypeInfo constructor: NATURAL_INDEX必須チェック | E-05 L66-67 | ○ |
| C-031 | KVTypeInfo.checkIndex: 重複/命名/自己参照検証 | E-05 L80-90 | ○ |
| C-032 | KVTypeInfo.checkIndex: パラメータ付きメソッド拒否 | E-05 L58-59 | ○ |
| C-033 | KVTypeInfo.getIndexValue: accessor.get(instance) | E-05 L96-98 | ○ |
| C-034 | KVTypeInfo.getAccessor: 存在しない場合checkArgument | E-05 L104-108 | ○ |
| C-035 | KVTypeInfo.getParentAccessor: 親なしならnull | E-05 L110-113 | ○ |
| C-036 | KVStoreSerializer.serialize(String): getBytes(UTF_8) | E-06 L53-54 | ○ |
| C-037 | KVStoreSerializer.serialize(Object): GZIP + Jackson | E-06 L56-61 | ○ |
| C-038 | KVStoreSerializer.deserialize(String): new String(data, UTF_8) | E-06 L66-67 | ○ |
| C-039 | KVStoreSerializer.deserialize(Object): GZIP + Jackson | E-06 L69-72 | ○ |
| C-040 | KVStoreSerializer.serialize(long): String.valueOf(value).getBytes | E-06 L75-77 | ○ |
| C-041 | KVStoreSerializer.deserializeLong: Long.parseLong | E-06 L79-81 | ○ |
| C-042 | ArrayWrappers.forArray: int/long/byte/Object配列分岐 | E-14 L40-54 | ○ |
| C-043 | ArrayWrappers.forArray: 非配列でIllegalArgumentException | E-14 L41 | ○ |
| C-044 | ArrayWrappers.forArray: プリミティブ非対応でIllegalArgumentException | E-14 L50-51 | ○ |
| C-045 | ComparableIntArray: equals/hashCode/compareTo実装 | E-14 L57-94 | ○ |
| C-046 | ComparableLongArray: equals/hashCode/compareTo実装 | E-14 L96-133 | ○ |
| C-047 | ComparableByteArray: equals/hashCode/compareTo実装 | E-14 L135-172 | ○ |
| C-048 | ComparableObjectArray: equals/hashCode/compareTo実装 | E-14 L174-212 | ○ |
| C-049 | LevelDB constructor: バージョンチェックとUnsupportedStoreVersionException | E-08 L90-96 | ○ |
| C-050 | LevelDB.write: null検証 + WriteBatch使用 | E-08 L151-162 | ○ |
| C-051 | LevelDB.writeAll: null/空リスト検証 | E-08 L165-166 | ○ |
| C-052 | LevelDB.read: null key検証 + NoSuchElementException | E-08 L144-148 | ○ |
| C-053 | LevelDB.delete: null key検証 + NoSuchElementException無視 | E-08 L226-246 | ○ |
| C-054 | LevelDB.close: _db.getAndSet(null) + イテレータクローズ | E-08 L302-325 | ○ |
| C-055 | LevelDB.db(): null時IllegalStateException | E-08 L370-376 | ○ |
| C-056 | LevelDBIterator.hasNext: loadNext() + auto-close | E-09 L120-133 | ○ |
| C-057 | LevelDBIterator.next: NoSuchElementException when !hasNext | E-09 L136-139 | ○ |
| C-058 | LevelDBIterator.skip: closed時false | E-09 L169 | ○ |
| C-059 | LevelDBIterator.close: 冪等(closedフラグ) | E-09 L196-207 | ○ |
| C-060 | LevelDBIterator.startsWith: 長さ+バイト比較 | E-09 L272-284 | ○ |
| C-061 | LevelDBIterator.compare: バイト配列辞書順比較 | E-09 L292-303 | ○ |
| C-062 | ResourceCleaner(LevelDB): compareAndSetで冪等 | E-09 L320-328 | ○ |
| C-063 | LevelDBTypeInfo: toKeyでString/Boolean/整数/配列の変換 | E-10 L457-506 | ○ |
| C-064 | LevelDBTypeInfo.Index.toKey: 未対応型でIllegalArgumentException | E-10 L486-488 | ○ |
| C-065 | LevelDBTypeInfo.Index.entityKey: nullでNPE | E-10 L304-306 | ○ |
| C-066 | LevelDBTypeInfo.Index.childPrefix: 子からはIllegalStateException | E-10 L250 | ○ |
| C-067 | LevelDBTypeInfo.Index.getCount: null時0 | E-10 L433-436 | ○ |
| C-068 | RocksDB: LevelDBと同等のAPI | E-11 全体 | ○ |
| C-069 | RocksDBIterator: LevelDBIteratorと同等の実装 | E-12 全体 | ○ |
| C-070 | RocksDBTypeInfo: LevelDBTypeInfoと同等の実装 | E-13 全体 | ○ |
| C-071 | UnsupportedStoreVersionException: IOException継承 | E-15 L28 | ○ |
| C-072 | InMemoryStore.removeAllByIndexValues の parentToChildrenMap 経由パスの前提条件 | **根拠不足** | △ |
| C-073 | LevelDBTypeInfo.Index.toKey の整数hexエンコード辞書順保存性 | **根拠不足** | △ |
| C-074 | RocksDBIterator コンストラクタの降順isValid()失敗時の動作 | **根拠不足** | △ |
| C-075 | KVStoreSerializer の空データ・不正GZIPデータのエラーハンドリング | **根拠不足** | △ |
| C-076 | InMemoryView の同値ソート時の自然キーによる二次ソート安定性 | **根拠不足** | △ |
| C-077 | LevelDB/RocksDB のスレッドセーフティ（synchronized(ti)ブロックの網羅性） | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- **C-072**: InMemoryStore の parentToChildrenMap は内部実装の詳細であり、テスト前提条件として親子インデックスを持つ型の定義が必要。テスト用型の定義は既存テストコード(CustomType1, CustomType2)を参照する必要がある。
  - 候補：既存テストの CustomType1 / CustomType2 の定義確認
- **C-073**: 整数のhexエンコーディングが辞書順を保存する仕組みはコード解析に基づくが、負数から正数への境界（NEGATIVE_MARKER < POSITIVE_MARKER）の保証は実動作テストで確認すべき。
  - 候補：LevelDBTypeInfoSuite / RocksDBTypeInfoSuiteの既存テスト
- **C-074**: RocksDBIteratorのコンストラクタで降順指定かつデータが空の場合にNoSuchElementExceptionをスローする動作は、LevelDBIteratorとは異なる振る舞い。
  - 候補：RocksDBIteratorSuite の既存テスト
- **C-075**: KVStoreSerializerに対して空バイト配列やGZIP以外のデータを渡した場合のエラーハンドリングはコード上明示されていない（Java標準例外に依存）。
  - 候補：Javaの GZIPInputStream / ObjectMapper の仕様
- **C-076**: InMemoryViewのsorted.sort()で同値の場合にnatural keyで二次ソートする動作（L434-436）の安定性はJavaのList.sort()の安定ソート保証に依存。
  - 候補：Java仕様（List.sort は安定ソート）
- **C-077**: LevelDB/RocksDBのwrite/delete操作ではsynchronized(ti)で排他制御しているが、read操作はsynchronized外であり、read-write競合時の動作は要確認。
  - 候補：既存テストスイートの並行テスト

## 5) リスクフラグ（レビュー観点）
- 0: InMemoryStore テストケース（C-001〜C-029）- ソースコードから直接導出可能で低リスク
- 0: KVStoreView テストケース（C-030〜C-040）- 単純なフィールド操作で低リスク
- 0: KVTypeInfo テストケース（C-041〜C-058）- リフレクション処理だがロジックは明確で低リスク
- 0: KVStoreSerializer テストケース（C-059〜C-068）- シリアライズ基本機能で低リスク
- 0: ArrayWrappers テストケース（C-069〜C-088）- 単純な比較ロジックで低リスク
- 1: LevelDB/RocksDB テストケース（C-088〜C-174）- ディスクI/Oとネイティブライブラリ依存のため中リスク。テスト実行時にファイルシステム状態に依存する可能性がある
- 1: LevelDBTypeInfo/RocksDBTypeInfo のキー変換テスト（C-133〜C-199）- hexエンコードの辞書順保存性は実際のDB操作と合わせて検証が必要
- 2: スレッドセーフティに関するテストケース - 本テストケース一覧にはスレッドセーフティの明示的なテストが含まれていないが、KVStoreのJavadocには「thread-safe for both reads and writes」と記載されている

## 6) レビュアーチェックリスト（最小）
- [ ] InMemoryStoreのCRUD操作テストケース（UT-KVS-001〜020）が主要メソッドを網羅しているか
- [ ] KVTypeInfoのコンストラクタ検証テスト（UT-KVS-041〜047）が全てのcheckIndex条件分岐をカバーしているか
- [ ] KVStoreSerializerのシリアライズ/デシリアライズのラウンドトリップテストが含まれているか
- [ ] LevelDB/RocksDBの初期化・バージョンチェックテストが含まれているか
- [ ] LevelDBTypeInfo.Index.toKeyの各型（String, Boolean, Integer, Long, Short, Byte, Array）のテストが網羅されているか
- [ ] イテレータ（LevelDBIterator, RocksDBIterator）のclose後の操作テストが含まれているか
- [ ] ResourceCleanerの冪等性テストが含まれているか
- [ ] 既存テストスイート（InMemoryStoreSuite, LevelDBSuite, RocksDBSuite等）との整合性を確認したか
