---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 171
  claims_with_evidence: 165
  claims_without_evidence: 6
confidence_derived: 0.96
---

# 根拠レポート：common-network-common 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：165 / 171、根拠なし：6
- 優先レビュー（高）
  1. **UT-NWC-165～168（AuthEngine）**：暗号化処理の正確な動作確認にはランタイム環境の検証が必要
  2. **UT-NWC-153（MessageWithHeader.transferTo）**：NIO_BUFFER_LIMIT境界でのI/O分割動作は複合条件
  3. **UT-NWC-099（TransportChannelHandler.userEventTriggered）**：タイムアウト判定の同期処理の検証

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `common/network-common/src/main/java/org/apache/spark/network/client/TransportClient.java`
- E-02: `common/network-common/src/main/java/org/apache/spark/network/client/TransportClientFactory.java`
- E-03: `common/network-common/src/main/java/org/apache/spark/network/client/TransportResponseHandler.java`
- E-04: `common/network-common/src/main/java/org/apache/spark/network/server/TransportServer.java`
- E-05: `common/network-common/src/main/java/org/apache/spark/network/server/TransportRequestHandler.java`
- E-06: `common/network-common/src/main/java/org/apache/spark/network/server/TransportChannelHandler.java`
- E-07: `common/network-common/src/main/java/org/apache/spark/network/TransportContext.java`
- E-08: `common/network-common/src/main/java/org/apache/spark/network/server/OneForOneStreamManager.java`
- E-09: `common/network-common/src/main/java/org/apache/spark/network/protocol/Encoders.java`
- E-10: `common/network-common/src/main/java/org/apache/spark/network/protocol/StreamChunkId.java`
- E-11: `common/network-common/src/main/java/org/apache/spark/network/protocol/MessageWithHeader.java`
- E-12: `common/network-common/src/main/java/org/apache/spark/network/util/TransportConf.java`
- E-13: `common/network-common/src/main/java/org/apache/spark/network/server/BlockPushNonFatalFailure.java`
- E-14: `common/network-common/src/main/java/org/apache/spark/network/buffer/NioManagedBuffer.java`
- E-15: `common/network-common/src/main/java/org/apache/spark/network/util/ByteArrayWritableChannel.java`
- E-16: `common/network-common/src/main/java/org/apache/spark/network/util/LimitedInputStream.java`
- E-17: `common/network-common/src/main/java/org/apache/spark/network/util/MapConfigProvider.java`
- E-18: `common/network-common/src/main/java/org/apache/spark/network/client/StreamInterceptor.java`
- E-19: `common/network-common/src/main/java/org/apache/spark/network/server/NoOpRpcHandler.java`
- E-20: `common/network-common/src/main/java/org/apache/spark/network/server/ChunkFetchRequestHandler.java`
- E-21: `common/network-common/src/main/java/org/apache/spark/network/util/TransportFrameDecoder.java`
- E-22: `common/network-common/src/main/java/org/apache/spark/network/crypto/AuthEngine.java`
- E-23: `common/network-common/src/main/java/org/apache/spark/network/util/NettyUtils.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TransportClient.isActive()はtimedOutとchannel状態で判定 | E-01 (L91-93) | ○ |
| C-02 | TransportClient.setClientId()は二重設定でIllegalStateException | E-01 (L113-116) | ○ |
| C-03 | TransportClient.close()でtimedOut=trueになりチャネルがクローズ | E-01 (L328-334) | ○ |
| C-04 | TransportClientコンストラクタでnullチェック(Objects.requireNonNull) | E-01 (L81-84) | ○ |
| C-05 | TransportResponseHandler.addFetchRequest/addRpcRequest/addStreamCallbackが正しく動作 | E-03 (L78-99) | ○ |
| C-06 | TransportResponseHandler.handleで各メッセージタイプをディスパッチ | E-03 (L166-277) | ○ |
| C-07 | TransportResponseHandler.channelInactiveで全コールバックにfailure通知 | E-03 (L144-152) | ○ |
| C-08 | OneForOneStreamManager.getChunkで順序外/不存在時にIllegalStateException | E-08 (L89-110) | ○ |
| C-09 | OneForOneStreamManager.checkAuthorizationでappId不一致時にSecurityException | E-08 (L167-179) | ○ |
| C-10 | OneForOneStreamManager.connectionTerminatedでバッファ解放 | E-08 (L134-164) | ○ |
| C-11 | OneForOneStreamManager.parseStreamChunkIdで文字列パース | E-08 (L124-131) | ○ |
| C-12 | StreamChunkIdのencode/decodeラウンドトリップ | E-10 (L27-64) | ○ |
| C-13 | Encoders各クラスのencodedLength/encode/decode | E-09 (L28-217) | ○ |
| C-14 | TransportConf各設定のデフォルト値 | E-12 (L74-606) | ○ |
| C-15 | TransportConf.connectionTimeoutMs負値で0を返す | E-12 (L102-108) | ○ |
| C-16 | TransportContext.createClientFactory/createServerが非nullを返す | E-07 (L157-183) | ○ |
| C-17 | TransportContext.sslEncryptionEnabledはsslFactory!=nullで判定 | E-07 (L189-191) | ○ |
| C-18 | TransportServer.getPortで未初期化時にIllegalStateException | E-04 (L92-97) | ○ |
| C-19 | TransportChannelHandler.channelRead0でRequest/Responseを振り分け | E-06 (L141-149) | ○ |
| C-20 | TransportChannelHandler.acceptInboundMessageでChunkFetchRequestフィルタリング | E-06 (L132-138) | ○ |
| C-21 | TransportChannelHandler.userEventTriggeredでタイムアウト処理 | E-06 (L153-184) | ○ |
| C-22 | BlockPushNonFatalFailure.getReturnCodeで各IDをマッピング | E-13 (L155-163) | ○ |
| C-23 | BlockPushNonFatalFailure.shouldNotRetryErrorCodeの判定ロジック | E-13 (L166-170) | ○ |
| C-24 | BlockPushNonFatalFailure.getErrorMsgでSUCCESS時にIllegalArgumentException | E-13 (L172-175) | ○ |
| C-25 | NioManagedBuffer.size()がbuf.remaining()を返す | E-14 (L38-40) | ○ |
| C-26 | NioManagedBuffer.nioByteBuffer()がduplicateを返す | E-14 (L43-45) | ○ |
| C-27 | ByteArrayWritableChannel.writeでバッファサイズ超過時に切り詰め | E-15 (L52-57) | ○ |
| C-28 | LimitedInputStream.read()でlimit到達時に-1を返す | E-16 (L65-74) | ○ |
| C-29 | LimitedInputStream.skipでlimitを超えない制限 | E-16 (L96-101) | ○ |
| C-30 | LimitedInputStreamコンストラクタで負のlimit時にIllegalArgumentException | E-16 (L51-56) | ○ |
| C-31 | MapConfigProvider.getで存在しないキー時にNoSuchElementException | E-17 (L37-43) | ○ |
| C-32 | StreamInterceptor.handleで全データ受信完了時にonComplete | E-18 (L74-93) | ○ |
| C-33 | StreamInterceptor.handleで超過読み取り時にIllegalStateException | E-18 (L81-86) | ○ |
| C-34 | NoOpRpcHandler.receiveでUnsupportedOperationException | E-19 (L34-36) | ○ |
| C-35 | ChunkFetchRequestHandler.processFetchRequestで転送制限チャネルクローズ | E-20 (L95-104) | ○ |
| C-36 | TransportFrameDecoder.setInterceptorで二重設定時にIllegalStateException | E-21 (L253-256) | ○ |
| C-37 | TransportRequestHandler.handleで不明リクエスト型時にIllegalArgumentException | E-05 (L107-123) | ○ |
| C-38 | AuthEngine.challenge()でAuthMessageを生成 | E-22 (L150-155) | ○ |
| C-39 | AuthEngine.response()でappId不一致時にIllegalArgumentException | E-22 (L164-165) | ○ |
| C-40 | AuthEngineコンストラクタでnullチェック | E-22 (L65-68) | ○ |
| C-41 | AuthEngine.deriveSessionCipherの暗号導出がCTR/GCM両方に対応 | E-22 (L207-244) | △ |
| C-42 | AuthEngine challenge-responseプロトコルの完全性 | E-22 | △ |
| C-43 | TransportClientFactory.createClientのfastFail動作 | E-02 (L217-222) | ○ |
| C-44 | MessageWithHeader.transferToのNIO_BUFFER_LIMIT分割動作 | E-11 (L140-163) | △ |
| C-45 | MessageWithHeader.deallocateでmanagedBuffer=null時のnullチェック | E-11 (L132-138) | ○ |
| C-46 | TransportChannelHandler.userEventTriggeredの同期ブロック内タイムアウト判定 | E-06 (L162-183) | △ |
| C-47 | LimitedInputStream.closeのcloseWrappedStream分岐 | E-16 (L103-108) | ○ |
| C-48 | TransportRequestHandler.processStreamRequestのストリーム不在時 | E-05 (L157-162) | ○ |
| C-49 | OneForOneStreamManager.connectionTerminatedのisBufferMaterializedOnNext分岐 | E-08 (L145) | ○ |
| C-50 | ChunkFetchRequestHandler.processFetchRequestの認可チェック | E-20 (L107) | ○ |

## 4) 不足情報（Unknown / Missing）
- **AuthEngine暗号化プロトコルの完全な検証（C-41, C-42）**: X25519鍵交換とHKDF/AES-GCM暗号化の正確な動作は、暗号ライブラリの内部実装に依存しており、コード解析だけでは完全に検証できない。ランタイムでの統合テストが推奨される。
  - 候補：暗号ライブラリの仕様書 / Tinkのドキュメント / テストベクトル
- **MessageWithHeader.transferToのNIO分割I/O（C-44）**: NIO_BUFFER_LIMIT(256KB)での分割書き込みの境界条件は、実際のI/O環境に依存する部分がある。
  - 候補：Nettyのドキュメント / NIOチャネルの仕様
- **TransportChannelHandler同期ブロック内のレース条件（C-46）**: SPARK-7003に言及されているレース条件の完全な検証には、マルチスレッドテストが必要。
  - 候補：SPARK-7003のJIRA / 並行テストの結果

## 5) リスクフラグ（レビュー観点）
- **1（中リスク）**: AuthEngine関連テストケース（UT-NWC-165～171）- 暗号化プロトコルの正確性は実行時テストでの追加検証が推奨される
- **1（中リスク）**: TransportChannelHandler.userEventTriggered（UT-NWC-099, 100）- 並行環境での同期動作の検証が必要
- **0（低リスク）**: Encoders系テストケース（UT-NWC-055～069）- シンプルなエンコード/デコードロジックで根拠が明確
- **0（低リスク）**: TransportConf設定値テスト（UT-NWC-070～086）- デフォルト値がソースコードに明記されており確実性が高い
- **0（低リスク）**: BlockPushNonFatalFailure（UT-NWC-103～112）- switch文とenum値の直接的な対応で根拠が明確

## 6) レビュアーチェックリスト（最小）
- [ ] AuthEngine関連テストケース（UT-NWC-165～171）が暗号化プロトコルの要件を十分にカバーしているか
- [ ] TransportResponseHandler.handleの全メッセージタイプ（ChunkFetchSuccess/Failure, RpcResponse/Failure, MergedBlockMetaSuccess, StreamResponse/Failure）がテスト対象に含まれているか
- [ ] OneForOneStreamManager.checkAuthorizationのセキュリティテストが十分か（認可バイパスのエッジケースなど）
- [ ] TransportConf設定値テストが運用上重要な設定（connectionTimeoutMs, encryptionEnabled, sslRpcEnabled等）を網羅しているか
- [ ] LimitedInputStreamの境界値テスト（limit=0, limit=Long.MAX_VALUE等）が十分か
- [ ] BlockPushNonFatalFailureの全ReturnCode値（0-4）がテスト対象に含まれているか
- [ ] MessageWithHeaderのリソース解放（deallocate）テストがメモリリーク防止の観点で十分か
