---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 81
  claims_with_evidence: 78
  claims_without_evidence: 3
confidence_derived: 0.96
---

# 根拠レポート：common-network-yarn 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：78 / 81、根拠なし：3
- 優先レビュー（高）
  1. **C-17 (UT-NYR-017)**: spark-shuffle-site.xmlオーバーレイの適用テスト -- 外部リソースの挙動はコードからの推論
  2. **C-19 (UT-NYR-019)**: メトリクスのHadoop MetricsSystem登録テスト -- MetricsSystemImplの内部動作に依存
  3. **C-22 (UT-NYR-022)**: INTEGRATION_TESTINGモード時の一時ディレクトリ生成 -- テスト環境固有の動作

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `common/network-yarn/src/main/java/org/apache/spark/network/yarn/util/HadoopConfigProvider.java` -- ConfigProvider実装（get, get(default), getAll）
- E-02: `common/network-yarn/src/main/java/org/apache/spark/network/yarn/YarnShuffleService.java` -- YARNシャッフルサービス本体（620行）
- E-03: `common/network-yarn/src/main/java/org/apache/spark/network/yarn/YarnShuffleServiceMetrics.java` -- メトリクス転送（155行）
- E-04: `YarnShuffleService.java` 内定数定義（L107-L153）-- 設定キー、デフォルト値、リカバリファイル名
- E-05: `YarnShuffleService.java` L36-L42 `HadoopConfigProvider.get(String)` -- null時にNoSuchElementExceptionをスロー
- E-06: `YarnShuffleService.java` L45-L48 `HadoopConfigProvider.get(String, String)` -- null時にdefaultValueを返却
- E-07: `YarnShuffleService.java` L234-L343 `serviceInit()` -- 初期化フロー全体
- E-08: `YarnShuffleService.java` L502-L519 `serviceStop()` -- nullチェック付きリソース解放
- E-09: `YarnShuffleService.java` L419-L459 `initializeApplication()` -- アプリ初期化とシークレット管理
- E-10: `YarnShuffleService.java` L462-L484 `stopApplication()` -- アプリ停止とfinally保証
- E-11: `YarnShuffleService.java` L547-L586 `initRecoveryDb()` -- リカバリDB初期化とファイル移動
- E-12: `YarnShuffleService.java` L355-L372 `newMergedShuffleFileManagerInstance()` -- 動的インスタンス生成
- E-13: `YarnShuffleService.java` L402-L409 `parseDbAppKey()` -- プレフィックス検証とJSON解析
- E-14: `YarnShuffleService.java` L411-L416 `dbAppKey()` -- キー生成ロジック
- E-15: `YarnShuffleService.java` L591-L617 内部クラス `AppId` -- equals, hashCode, toString
- E-16: `YarnShuffleServiceMetrics.java` L50-L56 `getMetrics()` -- メトリクスレコード追加
- E-17: `YarnShuffleServiceMetrics.java` L63-L135 `collectMetric()` -- Timer/Meter/Gauge/Counter分岐
- E-18: `YarnShuffleServiceMetrics.java` L152-L153 `ShuffleServiceMetricsInfo` -- recordクラス定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HadoopConfigProviderコンストラクタでインスタンスが生成される | E-01 (L28-L33) | ○ |
| C-02 | get(String)で存在するキーの値が返却される | E-05 (L36-L42) | ○ |
| C-03 | get(String)で存在しないキーにNoSuchElementExceptionがスローされる | E-05 (L38-L39) | ○ |
| C-04 | get(String)でnull値に対してNoSuchElementExceptionがスローされる | E-05 (L38-L39) | ○ |
| C-05 | get(String, String)で存在するキーの値が返却される | E-06 (L45-L48) | ○ |
| C-06 | get(String, String)で存在しないキーにデフォルト値が返却される | E-06 (L47) | ○ |
| C-07 | get(String, String)で空文字列デフォルト値が返却される | E-06 (L47) | ○ |
| C-08 | get(String, String)でnullデフォルト値が返却される | E-06 (L47) | ○ |
| C-09 | getAllでConfiguration全エントリが返却される | E-01 (L51-L53) | ○ |
| C-10 | getAllで空Configurationでも正常にIterableが返却される | E-01 (L52) | ○ |
| C-11 | YarnShuffleServiceコンストラクタでインスタンスが生成される | E-02 (L208-L219) | ○ |
| C-12 | serviceInitで基本的な初期化が行われる | E-07 (L234-L343) | ○ |
| C-13 | serviceInitで認証有効時にSecretManagerが初期化される | E-07 (L294-L301) | ○ |
| C-14 | serviceInitで認証無効時にSecretManagerが初期化されない | E-07 (L294) | ○ |
| C-15 | serviceInitでカスタムポートが設定される | E-07 (L303-L304), E-04 (L107-L108) | ○ |
| C-16 | serviceInitでデフォルトポート7337が使用される | E-04 (L108) | ○ |
| C-17 | serviceInitでspark-shuffle-site.xmlオーバーレイが適用される | E-07 (L236-L242) | △ |
| C-18 | serviceInitでログ名前空間がカスタム設定される | E-07 (L244-L248) | ○ |
| C-19 | serviceInitでメトリクスがHadoop MetricsSystemに登録される | E-07 (L313-L328) | △ |
| C-20 | serviceInitでstopOnFailure=true時に例外がスローされる | E-07 (L337-L338) | ○ |
| C-21 | serviceInitでstopOnFailure=false時にnoteFailureが呼ばれる | E-07 (L339-L341) | ○ |
| C-22 | serviceInitでINTEGRATION_TESTING=true時に一時ディレクトリが作成される | E-07 (L254-L258) | △ |
| C-23 | serviceStopで全リソースが正常にクローズされる | E-08 (L502-L519) | ○ |
| C-24 | serviceStopで例外発生時も安全に停止する | E-08 (L516-L518) | ○ |
| C-25 | serviceStopでnullリソースにNPEが発生しない | E-08 (L504, L507, L510, L513) | ○ |
| C-26 | initializeApplicationで認証無効時に正常初期化される | E-09 (L439) | ○ |
| C-27 | initializeApplicationで認証有効時にシークレットが登録される | E-09 (L439-L453) | ○ |
| C-28 | initializeApplicationでDB有効時にシークレットが永続化される | E-09 (L445-L452) | ○ |
| C-29 | initializeApplicationでrecoveryDisabledフラグが処理される | E-09 (L429-L434) | ○ |
| C-30 | initializeApplicationで不正JSONにフォールバック処理される | E-09 (L435-L438) | ○ |
| C-31 | initializeApplicationで例外発生時にログ記録される | E-09 (L455-L458) | ○ |
| C-32 | stopApplicationで認証有効時にシークレットが解除される | E-10 (L465-L475) | ○ |
| C-33 | stopApplicationでblockHandlerからアプリが削除される | E-10 (L477) | ○ |
| C-34 | stopApplicationでDB有効時にシークレットがDBから削除される | E-10 (L467-L474) | ○ |
| C-35 | stopApplicationでfinallyでremoveAppが呼ばれる | E-10 (L481-L483) | ○ |
| C-36 | stopApplicationでDB削除IOException時に処理継続される | E-10 (L470-L473) | ○ |
| C-37 | stopApplicationで例外時もfinallyが実行される | E-10 (L478-L483) | ○ |
| C-38 | initializeContainerでログが記録される | E-02 (L487-L490) | ○ |
| C-39 | stopContainerでログが記録される | E-02 (L493-L496) | ○ |
| C-40 | getMetaDataで空ByteBufferが返却される | E-02 (L523-L525) | ○ |
| C-41 | setRecoveryPathでパスが設定される | E-02 (L532-L534) | ○ |
| C-42 | setRecoveryPathでnullが設定可能 | E-02 (L533) | ○ |
| C-43 | getRecoveryPathで_recoveryPathが返却される | E-02 (L539-L541) | ○ |
| C-44 | initRecoveryDbで既存ファイルが返却される | E-11 (L551-L554) | ○ |
| C-45 | initRecoveryDbでローカルDirからリカバリパスへ移動される | E-11 (L557-L581) | ○ |
| C-46 | initRecoveryDbで新規Fileが返却される | E-11 (L585) | ○ |
| C-47 | initRecoveryDbでnull recoveryPathにNPEがスローされる | E-11 (L548-L549) | ○ |
| C-48 | initRecoveryDbでファイル移動失敗時にフォールバックされる | E-11 (L574-L579) | ○ |
| C-49 | newMergedShuffleFileManagerInstanceで有効クラスのインスタンスが生成される | E-12 (L358-L366) | ○ |
| C-50 | newMergedShuffleFileManagerInstanceで無効クラスにNoOpが返却される | E-12 (L367-L371) | ○ |
| C-51 | AppIdコンストラクタでappIdが設定される | E-15 (L594-L597) | ○ |
| C-52 | AppId.equalsで同一appIdにtrueが返却される | E-15 (L600-L606) | ○ |
| C-53 | AppId.equalsで異なるappIdにfalseが返却される | E-15 (L600-L606) | ○ |
| C-54 | AppId.equalsで同一インスタンスにtrueが返却される | E-15 (L601) | ○ |
| C-55 | AppId.equalsでnullにfalseが返却される | E-15 (L602) | ○ |
| C-56 | AppId.equalsで異なる型にfalseが返却される | E-15 (L602) | ○ |
| C-57 | AppId.hashCodeで同一appIdに同一ハッシュが返却される | E-15 (L609-L611) | ○ |
| C-58 | AppId.hashCodeでnull appIdに正常ハッシュが返却される | E-15 (L610) | ○ |
| C-59 | AppId.toStringで期待形式が返却される | E-15 (L614-L616) | ○ |
| C-60 | isAuthenticationEnabledでsecretManager!=nullにtrueが返却される | E-02 (L226-L228) | ○ |
| C-61 | isAuthenticationEnabledでsecretManager==nullにfalseが返却される | E-02 (L227) | ○ |
| C-62 | parseDbAppKeyで有効キーからappIdが解析される | E-13 (L402-L409) | ○ |
| C-63 | parseDbAppKeyで不正プレフィックスにIllegalArgumentExceptionがスローされる | E-13 (L403-L405) | ○ |
| C-64 | parseDbAppKeyで不正JSONにIOExceptionがスローされる | E-13 (L407) | ○ |
| C-65 | dbAppKeyでキーバイト配列が正常生成される | E-14 (L411-L416) | ○ |
| C-66 | setShuffleMergeManagerでマネージャが設定される | E-02 (L350-L352) | ○ |
| C-67 | YarnShuffleServiceMetricsコンストラクタで正常初期化される | E-03 (L38-L41) | ○ |
| C-68 | getMetricsでメトリクスレコードが追加される | E-16 (L50-L56) | ○ |
| C-69 | getMetricsで空MetricSetが正常処理される | E-16 (L53) | ○ |
| C-70 | collectMetricでTimer型が正しく収集される | E-17 (L66-L101) | ○ |
| C-71 | collectMetricでTimerパーセンタイルが正しく追加される | E-17 (L92-L101) | ○ |
| C-72 | collectMetricでMeter型が正しく収集される | E-17 (L102-L116) | ○ |
| C-73 | collectMetricでGauge<Integer>が正しく収集される | E-17 (L119-L120) | ○ |
| C-74 | collectMetricでGauge<Long>が正しく収集される | E-17 (L121-L122) | ○ |
| C-75 | collectMetricでGauge<Float>が正しく収集される | E-17 (L123-L124) | ○ |
| C-76 | collectMetricでGauge<Double>が正しく収集される | E-17 (L125-L126) | ○ |
| C-77 | collectMetricで未サポートGauge型にIllegalStateExceptionがスローされる | E-17 (L128-L129) | ○ |
| C-78 | collectMetricでCounter型が正しく収集される | E-17 (L131-L134) | ○ |
| C-79 | collectMetricで未対応Metric型が無視される | E-17 (L66-L134) | ○ |
| C-80 | ShuffleServiceMetricsInfo.nameで名前が返却される | E-18 (L152) | ○ |
| C-81 | ShuffleServiceMetricsInfo.descriptionで説明が返却される | E-18 (L152) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-17**: spark-shuffle-site.xmlオーバーレイの挙動はクラスパスにリソースが存在するかどうかに依存するため、テスト実行環境のセットアップが別途必要
  - 候補：テスト用のspark-shuffle-site.xmlリソース / クラスローダーのモック
- **C-19**: MetricsSystemImplはHadoopの内部クラスであり、その詳細な動作はHadoopバージョンに依存
  - 候補：Hadoop公式ドキュメント / MetricsSystemImplのソースコード
- **C-22**: INTEGRATION_TESTINGモード時の一時ディレクトリ生成はOS環境（java.io.tmpdir）に依存
  - 候補：JavaUtils.createDirectoryの実装 / OS環境変数

## 5) リスクフラグ（レビュー観点）
- 0: **HadoopConfigProvider** -- シンプルなラッパークラスのため低リスク
- 0: **AppId内部クラス** -- 標準的なequals/hashCode/toStringパターンのため低リスク
- 1: **YarnShuffleService.serviceInit** -- 多数の外部依存（TransportContext, ExternalBlockHandler, MetricsSystem等）があり、モック設定が複雑
- 1: **YarnShuffleService.initializeApplication/stopApplication** -- 認証フローとDB操作の組み合わせで中程度のリスク
- 1: **YarnShuffleServiceMetrics.collectMetric** -- 4種類のメトリクス型ごとの分岐テストが必要
- 0: **initRecoveryDb** -- ファイルシステム操作のテストはモックで対応可能

## 6) レビュアーチェックリスト（最小）
- [ ] HadoopConfigProviderのget()メソッドにおけるnull/NoSuchElementExceptionの挙動がソースコードと一致しているか
- [ ] YarnShuffleService.serviceInit()の認証有効/無効の分岐テストケースが網羅的か
- [ ] YarnShuffleService.serviceStop()のnullチェック分岐が正しくカバーされているか
- [ ] initializeApplication/stopApplicationの認証有効・DB有効の組み合わせパターンが十分か
- [ ] initRecoveryDbのファイル存在/不存在/移動失敗のパターンが網羅的か
- [ ] YarnShuffleServiceMetrics.collectMetricの4種類のメトリクス型（Timer, Meter, Gauge, Counter）の分岐が網羅的か
- [ ] Gauge型の4種類のサブタイプ（Integer, Long, Float, Double）と未サポート型のテストケースが十分か
- [ ] privateメソッド（parseDbAppKey, dbAppKey, loadSecretsFromDb, isAuthenticationEnabled）のテスト可能性について確認したか
