---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 173
  claims_with_evidence: 170
  claims_without_evidence: 3
confidence_derived: 0.98
---

# 根拠レポート：common-sketch 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：170 / 173、根拠なし：3
- 優先レビュー（高）
  1. **C-040 (BloomFilter.cardinality デフォルト実装)**: BloomFilter抽象クラスのcardinalityメソッドのデフォルト実装がUnsupportedOperationExceptionをスローする点は、BloomFilterBase で overrideされているため、直接テストは抽象クラスのサブクラスモック等が必要
  2. **C-064 (intersectInPlace 共通要素判定)**: 確率的データ構造であるため、「共通要素のみmightContainでtrue」は厳密には偽陽性の可能性がある
  3. **C-054 (mightContain 偽陰性なし確認)**: 未追加要素に対するfalse判定は確率的であり、大きなフィルタでは高確率だが保証ではない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `common/sketch/src/main/java/org/apache/spark/util/sketch/BitArray.java` - BitArray クラスのソースコード
- E-02: `common/sketch/src/main/java/org/apache/spark/util/sketch/BloomFilter.java` - BloomFilter 抽象クラスのソースコード
- E-03: `common/sketch/src/main/java/org/apache/spark/util/sketch/BloomFilterBase.java` - BloomFilterBase 抽象基底クラスのソースコード
- E-04: `common/sketch/src/main/java/org/apache/spark/util/sketch/BloomFilterImpl.java` - BloomFilterImpl (V1) 実装のソースコード
- E-05: `common/sketch/src/main/java/org/apache/spark/util/sketch/BloomFilterImplV2.java` - BloomFilterImplV2 (V2) 実装のソースコード
- E-06: `common/sketch/src/main/java/org/apache/spark/util/sketch/CountMinSketch.java` - CountMinSketch 抽象クラスのソースコード
- E-07: `common/sketch/src/main/java/org/apache/spark/util/sketch/CountMinSketchImpl.java` - CountMinSketchImpl 実装のソースコード
- E-08: `common/sketch/src/main/java/org/apache/spark/util/sketch/IncompatibleMergeException.java` - IncompatibleMergeException のソースコード
- E-09: `common/sketch/src/main/java/org/apache/spark/util/sketch/Murmur3_x86_32.java` - Murmur3 ハッシュ関数のソースコード
- E-10: `common/sketch/src/main/java/org/apache/spark/util/sketch/Platform.java` - Platform (Unsafe wrapper) のソースコード
- E-11: `common/sketch/src/main/java/org/apache/spark/util/sketch/Utils.java` - Utils ユーティリティクラスのソースコード

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | BitArray.numWords: numBits=64で1が返る | E-01 (L29-38: numWords計算ロジック, ceil(64/64.0)=1) | ○ |
| C-002 | BitArray.numWords: numBits=65で2が返る | E-01 (L33: ceil(65/64.0)=2) | ○ |
| C-003 | BitArray.numWords: numBits=1で1が返る | E-01 (L33: ceil(1/64.0)=1) | ○ |
| C-004 | BitArray.numWords: numBits=0でIllegalArgumentException | E-01 (L30-31: numBits<=0のガード) | ○ |
| C-005 | BitArray.numWords: numBits=-1でIllegalArgumentException | E-01 (L30-31: numBits<=0のガード) | ○ |
| C-006 | BitArray.numWords: 巨大numBitsでIllegalArgumentException | E-01 (L34-36: Integer.MAX_VALUE超過ガード) | ○ |
| C-007 | BitArray.set: 未設定ビットでtrueが返る | E-01 (L54-61: get(index)がfalseの場合true返却) | ○ |
| C-008 | BitArray.set: 既設定ビットでfalseが返る | E-01 (L59-60: get(index)がtrueの場合false返却) | ○ |
| C-009 | BitArray.set: bitCount増加 | E-01 (L57: bitCount++) | ○ |
| C-010 | BitArray.get: セット済みでtrue | E-01 (L63-65: ビット演算) | ○ |
| C-011 | BitArray.get: 未セットでfalse | E-01 (L63-65: 初期状態は全ゼロ) | ○ |
| C-012 | BitArray.bitSize: data.length*64 | E-01 (L68-70: data.length * Long.SIZE) | ○ |
| C-013 | BitArray.cardinality: 初期0 | E-01 (L44-51: コンストラクタでbitCount=0) | ○ |
| C-014 | BitArray.cardinality: 複数ビット後に正確 | E-01 (L54-61, L73-75: setでbitCount++、cardinalityでbitCount返却) | ○ |
| C-015 | BitArray.putAll: OR結合 | E-01 (L78-86: data[i] |= array.data[i]) | ○ |
| C-016 | BitArray.putAll: 重複OR | E-01 (L80-85: bitCountを再計算) | ○ |
| C-017 | BitArray.and: AND結合 | E-01 (L89-97: data[i] &= array.data[i]) | ○ |
| C-018 | BitArray.and: 空AND結果 | E-01 (L89-97: 排他的ビットのANDは全ゼロ) | ○ |
| C-019 | BitArray.writeTo/readFrom: ラウンドトリップ | E-01 (L99-113: writeTo/readFrom実装) | ○ |
| C-020 | BitArray.equals: 同一データでtrue | E-01 (L115-120: Arrays.equals(data, that.data)) | ○ |
| C-021 | BitArray.equals: 異なるデータでfalse | E-01 (L119: Arrays.equalsが不一致でfalse) | ○ |
| C-022 | BitArray.equals: 自身参照でtrue | E-01 (L117: this == other) | ○ |
| C-023 | BitArray.equals: 異なる型でfalse | E-01 (L118: instanceof チェック) | ○ |
| C-024 | BitArray.hashCode: 同一hashCode | E-01 (L122-125: Arrays.hashCode(data)) | ○ |
| C-025 | BloomFilter.create(long): デフォルトFPP生成 | E-02 (L263-265: DEFAULT_FPP=0.03使用) | ○ |
| C-026 | BloomFilter.create(long,double): カスタムFPP生成 | E-02 (L274-282: fppパラメータ使用) | ○ |
| C-027 | BloomFilter.create: fpp<=0でIllegalArgumentException | E-02 (L275-278: fpp<=0Dガード) | ○ |
| C-028 | BloomFilter.create: fpp>=1でIllegalArgumentException | E-02 (L275-278: fpp>=1Dガード) | ○ |
| C-029 | BloomFilter.create(long,long): ビット数指定生成 | E-02 (L288-289: V2デフォルト生成) | ○ |
| C-030 | BloomFilter.create: expectedNumItems<=0でIllegalArgumentException | E-02 (L302-304: 正値ガード) | ○ |
| C-031 | BloomFilter.create: numBits<=0でIllegalArgumentException | E-02 (L306-308: 正値ガード) | ○ |
| C-032 | BloomFilter.create: V1でBloomFilterImpl生成 | E-02 (L312-315: switch case V1) | ○ |
| C-033 | BloomFilter.create: V2でBloomFilterImplV2生成 | E-02 (L312-315: switch case V2) | ○ |
| C-034 | BloomFilter.optimalNumOfBits(long,double): 正値計算 | E-02 (L241-243: 数学的計算式) | ○ |
| C-035 | BloomFilter.optimalNumOfBits(long,long,long): 上限制約 | E-02 (L251-254: Math.min使用) | ○ |
| C-036 | BloomFilter.readFrom: V1ストリーム復元 | E-02 (L195-207: version==1でBloomFilterImpl.readFrom) | ○ |
| C-037 | BloomFilter.readFrom: V2ストリーム復元 | E-02 (L195-207: version==2でBloomFilterImplV2.readFrom) | ○ |
| C-038 | BloomFilter.readFrom: 未知バージョンでIllegalArgumentException | E-02 (L205: default -> throw) | ○ |
| C-039 | BloomFilter.readFrom(byte[]): バイト配列復元 | E-02 (L212-216: ByteArrayInputStream経由) | ○ |
| C-040 | BloomFilter.cardinality: UnsupportedOperationException | E-02 (L187-189: デフォルト実装) | △ |
| C-041 | BloomFilterBase.expectedFpp: FPP計算 | E-03 (L71-73: Math.pow式) | ○ |
| C-042 | BloomFilterBase.expectedFpp: 空フィルタで0.0 | E-03 (L72: cardinality()=0でpow(0/bitSize, n)=0) | ○ |
| C-043 | BloomFilterBase.bitSize: 正しいサイズ返却 | E-03 (L76-78: bits.bitSize()委譲) | ○ |
| C-044 | BloomFilterBase.put: String型対応 | E-03 (L81-89: instanceof String分岐) | ○ |
| C-045 | BloomFilterBase.put: Long型対応 | E-03 (L87: Utils.integralToLong経由) | ○ |
| C-046 | BloomFilterBase.put: Integer型対応 | E-03 (L87), E-11 (L32: Integer分岐) | ○ |
| C-047 | BloomFilterBase.put: byte[]型対応 | E-03 (L84-85: instanceof byte[]分岐) | ○ |
| C-048 | BloomFilterBase.putString: 文字列追加と検証 | E-03 (L113-115: putBinary(getBytesFromUTF8String)) | ○ |
| C-049 | BloomFilterBase.putLong: long追加と検証 | E-03 (L134-137: hashLongToIntPair + scatterHashAndSetAllBits) | ○ |
| C-050 | BloomFilterBase.putBinary: バイナリ追加と検証 | E-03 (L118-121: hashBytesToIntPair + scatterHashAndSetAllBits) | ○ |
| C-051 | BloomFilterBase.mightContain: String判定 | E-03 (L146-154: instanceof String分岐) | ○ |
| C-052 | BloomFilterBase.mightContain: Long判定 | E-03 (L151: integralToLong経由) | ○ |
| C-053 | BloomFilterBase.mightContain: byte[]判定 | E-03 (L149-150: instanceof byte[]分岐) | ○ |
| C-054 | BloomFilterBase.mightContain: 未追加でfalse(高確率) | E-03 (L146-154: 確率的データ構造) | △ |
| C-055 | BloomFilterBase.mightContainString: 未追加でfalse | E-03 (L124-126: mightContainBinary経由) | ○ |
| C-056 | BloomFilterBase.mightContainLong: 未追加でfalse | E-03 (L140-143: scatterHashAndGetAllBits経由) | ○ |
| C-057 | BloomFilterBase.isCompatible: 同一パラメータでtrue | E-03 (L157-171: 全条件一致) | ○ |
| C-058 | BloomFilterBase.isCompatible: 異なるbitSizeでfalse | E-03 (L168: bitSize()比較) | ○ |
| C-059 | BloomFilterBase.isCompatible: 異なるhash数でfalse | E-03 (L169: numHashFunctions比較) | ○ |
| C-060 | BloomFilterBase.isCompatible: nullでfalse | E-03 (L158-160: null チェック) | ○ |
| C-061 | BloomFilterBase.isCompatible: 異なるクラスでfalse | E-03 (L162-164, L167: getClass()比較) | ○ |
| C-062 | BloomFilterBase.mergeInPlace: OR結合 | E-03 (L174-179: bits.putAll) | ○ |
| C-063 | BloomFilterBase.mergeInPlace: 非互換例外 | E-03 (L175: checkCompatibilityForMerge呼出) | ○ |
| C-064 | BloomFilterBase.intersectInPlace: AND結合 | E-03 (L182-187: bits.and) | △ |
| C-065 | BloomFilterBase.intersectInPlace: 非互換例外 | E-03 (L183: checkCompatibilityForMerge呼出) | ○ |
| C-066 | BloomFilterBase.cardinality: セットビット数 | E-03 (L190-192: bits.cardinality()委譲) | ○ |
| C-067 | BloomFilterBase.equals: 同一でtrue | E-03 (L47-63: 全フィールド比較) | ○ |
| C-068 | BloomFilterBase.equals: 異なるでfalse | E-03 (L56-62: フィールド不一致) | ○ |
| C-069 | BloomFilterImpl.scatterHashAndSetAllBits: ビットセット | E-04 (L30-45: combinedHash計算とbits.set) | ○ |
| C-070 | BloomFilterImpl.scatterHashAndGetAllBits: セット済みtrue | E-04 (L47-63: bits.get判定) | ○ |
| C-071 | BloomFilterImpl.scatterHashAndGetAllBits: 未セットfalse | E-04 (L58-59: !bits.getでfalse返却) | ○ |
| C-072 | BloomFilterImpl.checkCompatibilityForMerge: null例外 | E-04 (L68-69: nullチェック) | ○ |
| C-073 | BloomFilterImpl.checkCompatibilityForMerge: クラス不一致例外 | E-04 (L72-76: instanceof チェック) | ○ |
| C-074 | BloomFilterImpl.checkCompatibilityForMerge: bitSize不一致例外 | E-04 (L78-79: bitSize比較) | ○ |
| C-075 | BloomFilterImpl.checkCompatibilityForMerge: hash数不一致例外 | E-04 (L82-86: numHashFunctions比較) | ○ |
| C-076 | BloomFilterImpl.writeTo/readFrom: ラウンドトリップ | E-04 (L91-117: V1シリアライズ/デシリアライズ) | ○ |
| C-077 | BloomFilterImpl.readFrom: 不正バージョン例外 | E-04 (L103-105: version != V1チェック) | ○ |
| C-078 | BloomFilterImplV2.scatterHashAndSetAllBits: longインデックス | E-05 (L50-68: long型combinedHash使用) | ○ |
| C-079 | BloomFilterImplV2.scatterHashAndGetAllBits: セット済みtrue | E-05 (L70-89: bits.get判定) | ○ |
| C-080 | BloomFilterImplV2.scatterHashAndGetAllBits: 未セットfalse | E-05 (L84-85: !bits.getでfalse返却) | ○ |
| C-081 | BloomFilterImplV2.checkCompatibilityForMerge: null例外 | E-05 (L94-95: nullチェック) | ○ |
| C-082 | BloomFilterImplV2.checkCompatibilityForMerge: クラス不一致例外 | E-05 (L98-101: instanceof チェック) | ○ |
| C-083 | BloomFilterImplV2.checkCompatibilityForMerge: bitSize不一致例外 | E-05 (L104-105: bitSize比較) | ○ |
| C-084 | BloomFilterImplV2.checkCompatibilityForMerge: seed不一致例外 | E-05 (L108-111: seed比較) | ○ |
| C-085 | BloomFilterImplV2.checkCompatibilityForMerge: hash数不一致例外 | E-05 (L114-117: numHashFunctions比較) | ○ |
| C-086 | BloomFilterImplV2.writeTo/readFrom: ラウンドトリップ | E-05 (L123-149: V2シリアライズ/デシリアライズ) | ○ |
| C-087 | BloomFilterImplV2.readFrom: 不正バージョン例外 | E-05 (L136-138: version != V2チェック) | ○ |
| C-088 | BloomFilterImplV2.equals: 同一でtrue | E-05 (L35-48: フィールド比較) | ○ |
| C-089 | BloomFilterImplV2.equals: 異なるseedでfalse | E-05 (L45: seed比較) | ○ |
| C-090 | BloomFilterImplV2.equals: 自身参照でtrue | E-05 (L36-37: this == other) | ○ |
| C-091 | BloomFilterImplV2.equals: 異なる型でfalse | E-05 (L40: instanceof チェック) | ○ |
| C-092 | CountMinSketch.create(int,int,int): 生成 | E-06 (L207-209: new CountMinSketchImpl) | ○ |
| C-093 | CountMinSketch.create(double,double,int): 生成 | E-06 (L219-221: new CountMinSketchImpl) | ○ |
| C-094 | CountMinSketch.readFrom(InputStream): 復元 | E-06 (L186-188: CountMinSketchImpl.readFrom) | ○ |
| C-095 | CountMinSketch.readFrom(byte[]): 復元 | E-06 (L193-197: ByteArrayInputStream経由) | ○ |
| C-096 | CountMinSketchImpl(int,int,int): 正常初期化 | E-07 (L37-47: フィールド初期化) | ○ |
| C-097 | CountMinSketchImpl(int,int,int): depth<=0で例外 | E-07 (L38-40: depth/widthガード) | ○ |
| C-098 | CountMinSketchImpl(int,int,int): width<=0で例外 | E-07 (L38-40: depth/widthガード) | ○ |
| C-099 | CountMinSketchImpl(double,double,int): 正常初期化 | E-07 (L49-65: eps/confidence計算) | ○ |
| C-100 | CountMinSketchImpl(double,double,int): eps<=0で例外 | E-07 (L50-52: epsガード) | ○ |
| C-101 | CountMinSketchImpl(double,double,int): confidence<=0で例外 | E-07 (L54-56: confidenceガード) | ○ |
| C-102 | CountMinSketchImpl(double,double,int): confidence>=1で例外 | E-07 (L54-56: confidence<1Dガード) | ○ |
| C-103 | CountMinSketchImpl.relativeError: eps返却 | E-07 (L113-115: return eps) | ○ |
| C-104 | CountMinSketchImpl.confidence: confidence返却 | E-07 (L118-120: return confidence) | ○ |
| C-105 | CountMinSketchImpl.depth: depth返却 | E-07 (L123-125: return depth) | ○ |
| C-106 | CountMinSketchImpl.width: width返却 | E-07 (L128-130: return width) | ○ |
| C-107 | CountMinSketchImpl.totalCount: 初期0 | E-07 (L132-135: フィールド初期値) | ○ |
| C-108 | CountMinSketchImpl.totalCount: 累計 | E-07 (L178: totalCount += count) | ○ |
| C-109 | CountMinSketchImpl.add(Object): String追加 | E-07 (L138-151: instanceof String分岐) | ○ |
| C-110 | CountMinSketchImpl.add(Object): Long追加 | E-07 (L148-149: integralToLong経由) | ○ |
| C-111 | CountMinSketchImpl.add(Object): byte[]追加 | E-07 (L146-147: instanceof byte[]分岐) | ○ |
| C-112 | CountMinSketchImpl.add(Object,long): カウント指定追加 | E-07 (L143-151: count付きadd) | ○ |
| C-113 | CountMinSketchImpl.addLong(long): 基本追加 | E-07 (L164-166: addLong(item, 1)) | ○ |
| C-114 | CountMinSketchImpl.addLong(long,long): カウント追加 | E-07 (L169-179: table更新) | ○ |
| C-115 | CountMinSketchImpl.addLong: 負countで例外 | E-07 (L170-172: count<0ガード) | ○ |
| C-116 | CountMinSketchImpl.addString(String): 基本追加 | E-07 (L154-156: addString(item, 1)) | ○ |
| C-117 | CountMinSketchImpl.addString(String,long): カウント追加 | E-07 (L159-161: addBinary経由) | ○ |
| C-118 | CountMinSketchImpl.addBinary(byte[]): 基本追加 | E-07 (L182-184: addBinary(item, 1)) | ○ |
| C-119 | CountMinSketchImpl.addBinary(byte[],long): カウント追加 | E-07 (L187-199: getHashBuckets+table更新) | ○ |
| C-120 | CountMinSketchImpl.addBinary: 負countで例外 | E-07 (L188-190: count<0ガード) | ○ |
| C-121 | CountMinSketchImpl.estimateCount: 正確な推定 | E-07 (L237-243: min across depth) | ○ |
| C-122 | CountMinSketchImpl.estimateCount: 未追加で0 | E-07 (L237-243: table初期値0) | ○ |
| C-123 | CountMinSketchImpl.estimateCount: String推定 | E-07 (L228-229, L245-252: estimateCountForStringItem) | ○ |
| C-124 | CountMinSketchImpl.estimateCount: byte[]推定 | E-07 (L230-231, L254-261: estimateCountForBinaryItem) | ○ |
| C-125 | CountMinSketchImpl.mergeInPlace: 正常マージ | E-07 (L264-296: table合算) | ○ |
| C-126 | CountMinSketchImpl.mergeInPlace: null例外 | E-07 (L265-267: nullチェック) | ○ |
| C-127 | CountMinSketchImpl.mergeInPlace: depth不一致例外 | E-07 (L275-277: depthチェック) | ○ |
| C-128 | CountMinSketchImpl.mergeInPlace: width不一致例外 | E-07 (L279-281: widthチェック) | ○ |
| C-129 | CountMinSketchImpl.mergeInPlace: seed不一致例外 | E-07 (L283-285: hashA比較) | ○ |
| C-130 | CountMinSketchImpl.writeTo/readFrom: ラウンドトリップ | E-07 (L299-358: シリアライズ/デシリアライズ) | ○ |
| C-131 | CountMinSketchImpl.readFrom: 不正バージョン例外 | E-07 (L337-339: version != V1チェック) | ○ |
| C-132 | CountMinSketchImpl.toByteArray: バイト配列化 | E-07 (L320-325: ByteArrayOutputStream経由) | ○ |
| C-133 | CountMinSketchImpl.toByteArray: ラウンドトリップ | E-07 (L320-325, L327-331: toByteArray+readFrom) | ○ |
| C-134 | CountMinSketchImpl.equals: 同一でtrue | E-07 (L68-83: 全フィールド比較) | ○ |
| C-135 | CountMinSketchImpl.equals: 異なるでfalse | E-07 (L68-83: フィールド不一致) | ○ |
| C-136 | CountMinSketchImpl.equals: 自身参照でtrue | E-07 (L69-70: this == other) | ○ |
| C-137 | CountMinSketchImpl.equals: 異なる型でfalse | E-07 (L73: instanceof チェック) | ○ |
| C-138 | CountMinSketchImpl.hashCode: 同一hashCode | E-07 (L86-95: hash計算式) | ○ |
| C-139 | Murmur3_x86_32.hashInt: 決定性 | E-09 (L48-53: 純粋関数) | ○ |
| C-140 | Murmur3_x86_32.hashInt: 分散性 | E-09 (L48-53: ハッシュ関数の性質) | ○ |
| C-141 | Murmur3_x86_32.hashInt: インスタンス整合性 | E-09 (L44-46: hashInt(input, seed)) | ○ |
| C-142 | Murmur3_x86_32.hashLong: 決定性 | E-09 (L111-122: 純粋関数) | ○ |
| C-143 | Murmur3_x86_32.hashLong: MAX_VALUE | E-09 (L111-122: long入力対応) | ○ |
| C-144 | Murmur3_x86_32.hashLong: MIN_VALUE | E-09 (L111-122: long入力対応) | ○ |
| C-145 | Murmur3_x86_32.hashLong: ゼロ値 | E-09 (L111-122: long入力対応) | ○ |
| C-146 | Murmur3_x86_32.hashLong: インスタンス整合性 | E-09 (L107-109: hashLong(input, seed)) | ○ |
| C-147 | Murmur3_x86_32.hashUnsafeWords: 決定性 | E-09 (L59-64: 純粋関数) | ○ |
| C-148 | Murmur3_x86_32.hashUnsafeBytes: 決定性 | E-09 (L66-78: 純粋関数) | ○ |
| C-149 | Murmur3_x86_32.hashUnsafeBytes: 空入力 | E-09 (L69: lengthInBytes>=0 assert) | ○ |
| C-150 | Murmur3_x86_32.hashUnsafeBytes2: 決定性 | E-09 (L80-92: 純粋関数) | ○ |
| C-151 | Murmur3_x86_32.hashUnsafeBytes2: 非アラインバイト長 | E-09 (L87-89: 端数バイト処理) | ○ |
| C-152 | Murmur3_x86_32.toString: 書式 | E-09 (L40-42: "Murmur3_32(seed=" + seed + ")") | ○ |
| C-153 | Utils.getBytesFromUTF8String: ASCII変換 | E-11 (L23-25: StandardCharsets.UTF_8) | ○ |
| C-154 | Utils.getBytesFromUTF8String: マルチバイト変換 | E-11 (L23-25: UTF-8エンコーディング) | ○ |
| C-155 | Utils.getBytesFromUTF8String: 空文字列 | E-11 (L23-25: getBytes("")) | ○ |
| C-156 | Utils.integralToLong: Long変換 | E-11 (L30-31: instanceof Long) | ○ |
| C-157 | Utils.integralToLong: Integer変換 | E-11 (L32-33: instanceof Integer) | ○ |
| C-158 | Utils.integralToLong: Short変換 | E-11 (L34-35: instanceof Short) | ○ |
| C-159 | Utils.integralToLong: Byte変換 | E-11 (L36-37: instanceof Byte) | ○ |
| C-160 | Utils.integralToLong: 非サポート型例外 | E-11 (L38-39: else IllegalArgumentException) | ○ |
| C-161 | Utils.integralToLong: String型例外 | E-11 (L38-39: Stringはelse分岐) | ○ |
| C-162 | IncompatibleMergeException: メッセージ付き生成 | E-08 (L20-24: super(message)) | ○ |
| C-163 | IncompatibleMergeException: Exception継承 | E-08 (L20: extends Exception) | ○ |
| C-164 | Platform.getInt/putInt: int読み書き | E-10 (L38-44: _UNSAFE.getInt/putInt) | ○ |
| C-165 | Platform.getByte/putByte: byte読み書き | E-10 (L54-60: _UNSAFE.getByte/putByte) | ○ |
| C-166 | Platform.getLong/putLong: long読み書き | E-10 (L70-76: _UNSAFE.getLong/putLong) | ○ |
| C-167 | Platform.getShort/putShort: short読み書き | E-10 (L62-68: _UNSAFE.getShort/putShort) | ○ |
| C-168 | Platform.getFloat/putFloat: float読み書き | E-10 (L78-84: _UNSAFE.getFloat/putFloat) | ○ |
| C-169 | Platform.getDouble/putDouble: double読み書き | E-10 (L86-92: _UNSAFE.getDouble/putDouble) | ○ |
| C-170 | Platform.getBoolean/putBoolean: boolean読み書き | E-10 (L46-52: _UNSAFE.getBoolean/putBoolean) | ○ |
| C-171 | Platform.copyMemory: 前方コピー | E-10 (L110-134: dstOffset < srcOffset分岐) | ○ |
| C-172 | Platform.copyMemory: 後方コピー | E-10 (L122-133: else分岐) | ○ |
| C-173 | Platform.BYTE_ARRAY_OFFSET: 正の値 | E-10 (L161: arrayBaseOffset) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-040: BloomFilter抽象クラスのcardinalityデフォルト実装をテストするには、BloomFilterBaseを経由しない直接のサブクラスが必要。実運用上はBloomFilterBaseがオーバーライドしているため、テスト対象としての優先度は低い。
  - 候補：モックサブクラスを作成してテスト / テスト対象外とする判断
- C-054: Bloom Filterは確率的データ構造であり、未追加要素に対するfalse返却は「高確率」であって「保証」ではない。十分大きなフィルタであれば事実上falseとなるが、テストケースではFPP率を考慮した許容範囲の記述が望ましい。
  - 候補：FPP率(0.03)に基づく統計的テスト / 十分大きなフィルタでの決定的テスト
- C-064: intersectInPlaceのAND結合後に「共通要素のみmightContainでtrue」という期待結果は、偽陽性の可能性があるため厳密には正確でない。
  - 候補：統計的許容範囲を設けたテスト / 小さなフィルタでの決定的テスト

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - BitArray, Utils, IncompatibleMergeException, Platform, Murmur3_x86_32 のテストケースはソースコードから直接導出しており信頼性が高い
- 0: 低リスク - ファクトリメソッドの入力バリデーション（BloomFilter.create, CountMinSketch.create）は明示的なガード節があり確実
- 1: 中リスク - BloomFilter/CountMinSketchの確率的動作に関するテストケース（mightContain, estimateCount）は、確率的性質のため期待結果に「以上」「高確率」等の表現を含む
- 0: 低リスク - シリアライズ/デシリアライズのラウンドトリップテストはequals実装に依存するが、equals実装もソースコード確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] BitArrayのset/getがワード境界(64ビット)をまたぐインデックスで正しく動作するテストケースが十分か確認
- [ ] 確率的データ構造（BloomFilter, CountMinSketch）のテストにおいて、統計的許容範囲が適切に設定されているか確認
- [ ] BloomFilterImplとBloomFilterImplV2の相互互換性（非互換性）のテストケースが網羅されているか確認
- [ ] Platformクラスのテストにおいて、Unsafe操作の安全性とJVM依存性を考慮しているか確認
- [ ] CountMinSketchImplのhash関数（PRIME_MODULUS使用）に関するエッジケースが十分か確認
- [ ] BloomFilterのV1/V2間の非互換性に関するテスト（V1で書いてV2で読む等）が考慮されているか確認
