---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 67
  claims_with_evidence: 64
  claims_without_evidence: 3
confidence_derived: 0.96
---

# 根拠レポート：common-tags 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧CSVの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：64 / 67、根拠なし：3
- 優先レビュー（高）
  1. **C-45（Since空文字列境界値テスト）**：Scalaのアノテーション引数に空文字列を渡した場合の挙動はソースコード上に明示的な制約がなく、推測に基づく
  2. **C-47（Sinceのprivate[spark]スコープ検証）**：リフレクションでのアクセス修飾子確認方法が言語仕様上複雑であり、テスト実現方法が要確認
  3. **C-49（ClassicOnlyのコンパイルエラー検証）**：コンパイルエラーの単体テストでの検証方法はフレームワーク依存であり、実現手段の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `common/tags/src/main/java/org/apache/spark/annotation/AlphaComponent.java` - AlphaComponentアノテーション定義（@Retention(RUNTIME), @Target 7要素, @Documentedなし）
- E-02: `common/tags/src/main/java/org/apache/spark/annotation/ClassicOnly.java` - ClassicOnlyアノテーション定義（@Retention(RUNTIME), @Target(METHOD), @Documented）
- E-03: `common/tags/src/main/java/org/apache/spark/annotation/Unstable.java` - Unstableアノテーション定義（@Retention(RUNTIME), @Target 7要素, @Documented）
- E-04: `common/tags/src/main/java/org/apache/spark/annotation/Evolving.java` - Evolvingアノテーション定義（@Retention(RUNTIME), @Target 7要素, @Documented）
- E-05: `common/tags/src/main/java/org/apache/spark/annotation/DeveloperApi.java` - DeveloperApiアノテーション定義（@Retention(RUNTIME), @Target 7要素, @Documented）
- E-06: `common/tags/src/main/java/org/apache/spark/annotation/Experimental.java` - Experimentalアノテーション定義（@Retention(RUNTIME), @Target 7要素, @Documented）
- E-07: `common/tags/src/main/java/org/apache/spark/annotation/Private.java` - Privateアノテーション定義（@Retention(RUNTIME), @Target 7要素, @Documented）
- E-08: `common/tags/src/main/java/org/apache/spark/annotation/Stable.java` - Stableアノテーション定義（@Retention(RUNTIME), @Target 7要素, @Documented）
- E-09: `common/tags/src/main/scala/org/apache/spark/annotation/Since.scala` - Sinceアノテーション定義（private[spark], extends StaticAnnotation, version: String, メタアノテーション6種）
- E-10: `common/tags/src/main/scala/org/apache/spark/annotation/package.scala` - パッケージオブジェクト定義
- E-11: `common/tags/src/main/scala/org/apache/spark/annotation/package-info.java` - パッケージ情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AlphaComponentがRetentionPolicy.RUNTIMEであること | E-01（L30: @Retention(RetentionPolicy.RUNTIME)） | ○ |
| C-02 | AlphaComponentがTYPEに適用可能であること | E-01（L31: ElementType.TYPE） | ○ |
| C-03 | AlphaComponentがFIELDに適用可能であること | E-01（L31: ElementType.FIELD） | ○ |
| C-04 | AlphaComponentがMETHODに適用可能であること | E-01（L31: ElementType.METHOD） | ○ |
| C-05 | AlphaComponentがPARAMETERに適用可能であること | E-01（L31: ElementType.PARAMETER） | ○ |
| C-06 | AlphaComponentがCONSTRUCTORに適用可能であること | E-01（L32: ElementType.CONSTRUCTOR） | ○ |
| C-07 | AlphaComponentがLOCAL_VARIABLEに適用可能であること | E-01（L32: ElementType.LOCAL_VARIABLE） | ○ |
| C-08 | AlphaComponentがPACKAGEに適用可能であること | E-01（L32: ElementType.PACKAGE） | ○ |
| C-09 | AlphaComponentのターゲット数が7であること | E-01（L31-32: 7つのElementType列挙） | ○ |
| C-10 | AlphaComponentが@Documentedではないこと | E-01（@Documentedアノテーションが付与されていない） | ○ |
| C-11 | ClassicOnlyがRetentionPolicy.RUNTIMEであること | E-02（L26: @Retention(RetentionPolicy.RUNTIME)） | ○ |
| C-12 | ClassicOnlyがMETHODのみに適用可能であること | E-02（L27: @Target(ElementType.METHOD)） | ○ |
| C-13 | ClassicOnlyのターゲット数が1であること | E-02（L27: METHODのみ） | ○ |
| C-14 | ClassicOnlyが@Documentedであること | E-02（L25: @Documented） | ○ |
| C-15 | UnstableがRetentionPolicy.RUNTIMEであること | E-03（L27: @Retention(RetentionPolicy.RUNTIME)） | ○ |
| C-16 | Unstableが7つのターゲットに適用可能であること | E-03（L28-29: 7つのElementType列挙） | ○ |
| C-17 | Unstableが@Documentedであること | E-03（L26: @Documented） | ○ |
| C-18 | Unstableがクラスに付与可能であること（実動作） | E-03（L28: ElementType.TYPE含む） | ○ |
| C-19 | EvolvingがRetentionPolicy.RUNTIMEであること | E-04（L27: @Retention(RetentionPolicy.RUNTIME)） | ○ |
| C-20 | Evolvingが7つのターゲットに適用可能であること | E-04（L28-29: 7つのElementType列挙） | ○ |
| C-21 | Evolvingが@Documentedであること | E-04（L26: @Documented） | ○ |
| C-22 | Evolvingがメソッドに付与可能であること（実動作） | E-04（L28: ElementType.METHOD含む） | ○ |
| C-23 | DeveloperApiがRetentionPolicy.RUNTIMEであること | E-05（L33: @Retention(RetentionPolicy.RUNTIME)） | ○ |
| C-24 | DeveloperApiが7つのターゲットに適用可能であること | E-05（L34-35: 7つのElementType列挙） | ○ |
| C-25 | DeveloperApiが@Documentedであること | E-05（L32: @Documented） | ○ |
| C-26 | DeveloperApiがTYPEに適用可能であること | E-05（L34: ElementType.TYPE含む） | ○ |
| C-27 | ExperimentalがRetentionPolicy.RUNTIMEであること | E-06（L34: @Retention(RetentionPolicy.RUNTIME)） | ○ |
| C-28 | Experimentalが7つのターゲットに適用可能であること | E-06（L35-36: 7つのElementType列挙） | ○ |
| C-29 | Experimentalが@Documentedであること | E-06（L33: @Documented） | ○ |
| C-30 | Experimentalがフィールドに付与可能であること（実動作） | E-06（L35: ElementType.FIELD含む） | ○ |
| C-31 | PrivateがRetentionPolicy.RUNTIMEであること | E-07（L36: @Retention(RetentionPolicy.RUNTIME)） | ○ |
| C-32 | Privateが7つのターゲットに適用可能であること | E-07（L37-38: 7つのElementType列挙） | ○ |
| C-33 | Privateが@Documentedであること | E-07（L35: @Documented） | ○ |
| C-34 | Privateがコンストラクタに付与可能であること（実動作） | E-07（L38: ElementType.CONSTRUCTOR含む） | ○ |
| C-35 | StableがRetentionPolicy.RUNTIMEであること | E-08（L27: @Retention(RetentionPolicy.RUNTIME)） | ○ |
| C-36 | Stableが7つのターゲットに適用可能であること | E-08（L29-30: 7つのElementType列挙） | ○ |
| C-37 | Stableが@Documentedであること | E-08（L27: @Documented） | ○ |
| C-38 | StableがPACKAGEに適用可能であること | E-08（L30: ElementType.PACKAGE含む） | ○ |
| C-39 | Sinceアノテーションがバージョン文字列を保持して生成されること | E-09（L30: version: String パラメータ） | ○ |
| C-40 | Sinceがメソッドに付与可能であること | E-09（L29: @getter メタアノテーション含む） | ○ |
| C-41 | Sinceがフィールドに付与可能であること | E-09（L29: @field メタアノテーション） | ○ |
| C-42 | Sinceがgetterに付与可能であること | E-09（L29: @getter メタアノテーション） | ○ |
| C-43 | Sinceがsetterに付与可能であること | E-09（L29: @setter メタアノテーション） | ○ |
| C-44 | Sinceがコンストラクタパラメータに付与可能であること | E-09（L29: @param メタアノテーション） | ○ |
| C-45 | Sinceに空文字列を指定した場合のインスタンス生成 | **根拠なし** | △ |
| C-46 | SinceがStaticAnnotationを継承していること | E-09（L30: extends StaticAnnotation） | ○ |
| C-47 | Sinceがprivate[spark]スコープであること | E-09（L30: private[spark] class Since） | ○ |
| C-48 | AlphaComponentがリフレクションで実行時に取得可能であること | E-01（L30: RetentionPolicy.RUNTIME） | ○ |
| C-49 | ClassicOnlyがTYPEに適用された場合にコンパイルエラーとなること | **根拠なし** | △ |
| C-50 | Unstableがメソッドに付与された場合にリフレクションで取得可能であること | E-03（L27: RetentionPolicy.RUNTIME, L28: ElementType.METHOD含む） | ○ |
| C-51 | EvolvingがPARAMETERに適用可能であること | E-04（L28: ElementType.PARAMETER含む） | ○ |
| C-52 | DeveloperApiがフィールドに付与可能であること（実動作） | E-05（L34: ElementType.FIELD含む） | ○ |
| C-53 | ExperimentalがCONSTRUCTORに適用可能であること | E-06（L35: ElementType.CONSTRUCTOR含む） | ○ |
| C-54 | PrivateがLOCAL_VARIABLEに適用可能であること | E-07（L38: ElementType.LOCAL_VARIABLE含む） | ○ |
| C-55 | Stableがクラスに付与された場合にリフレクションで取得可能であること | E-08（L27: RetentionPolicy.RUNTIME, L29: ElementType.TYPE含む） | ○ |
| C-56 | SinceにSNAPSHOTバージョン文字列を指定した場合の生成 | E-09（L30: version: String - 文字列型のため任意の文字列を受け付ける） | ○ |
| C-57 | SinceがbeanGetterに付与可能であること | E-09（L29: @beanGetter メタアノテーション） | ○ |
| C-58 | SinceがbeanSetterに付与可能であること | E-09（L29: @beanSetter メタアノテーション） | ○ |
| C-59 | AlphaComponentがアノテーションインタフェースであること | E-01（L33: public @interface AlphaComponent） | ○ |
| C-60 | ClassicOnlyがアノテーションインタフェースであること | E-02（L28: public @interface ClassicOnly） | ○ |
| C-61 | Unstableがアノテーションインタフェースであること | E-03（L30: public @interface Unstable） | ○ |
| C-62 | Evolvingがアノテーションインタフェースであること | E-04（L30: public @interface Evolving） | ○ |
| C-63 | DeveloperApiがアノテーションインタフェースであること | E-05（L36: public @interface DeveloperApi） | ○ |
| C-64 | Experimentalがアノテーションインタフェースであること | E-06（L37: public @interface Experimental） | ○ |
| C-65 | Privateがアノテーションインタフェースであること | E-07（L39: public @interface Private） | ○ |
| C-66 | Stableがアノテーションインタフェースであること | E-08（L31: public @interface Stable） | ○ |
| C-67 | 全アノテーションがorg.apache.spark.annotationパッケージに属すること | E-01〜E-09（各ファイルのpackage宣言） | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-45（Since空文字列）**: Sinceアノテーションのversionパラメータに空文字列を渡した場合の挙動について、ソースコード上にバリデーションロジックがないため明示的な根拠がない。Scalaの型システム上、String型の引数として空文字列は受け入れられると推測されるが、実行時の挙動は確認が必要。
  - 候補：Sinceのテストコード / Scalaアノテーション仕様 / 実行結果の確認
- **C-49（ClassicOnlyコンパイルエラー）**: @Target(ElementType.METHOD)のみのアノテーションをTYPE（クラス）に適用した場合にコンパイルエラーとなることはJava言語仕様から推測されるが、テストフレームワーク上でのコンパイルエラー検証の実現方法は確認が必要。
  - 候補：Javaコンパイラ仕様 / テスティングフレームワーク（compile-testing等）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本モジュールはアノテーション定義のみで構成されており、ビジネスロジックやデータ処理を含まない。テストケースはメタデータ検証（RetentionPolicy, Target, Documented）が中心であり、ロジックの誤りによるリスクは低い。
- 1: 中リスク - Sinceアノテーション（Scala）はメタアノテーション（@param, @field, @getter, @setter, @beanGetter, @beanSetter）を利用しており、Scalaコンパイラのバージョンによる挙動差異の可能性がある。
- 0: 低リスク - Javaアノテーション定義は標準的なパターンであり、RetentionPolicyやTargetの設定はソースコードから直接確認可能。

## 6) レビュアーチェックリスト（最小）
- [ ] 各Javaアノテーションの@Retention, @Target, @Documentedの設定値がソースコードと一致しているか
- [ ] AlphaComponentのみ@Documentedが付与されていない点が意図的であるか確認
- [ ] ClassicOnlyのターゲットがMETHODのみに制限されている点が他のアノテーションと異なることが正しく反映されているか
- [ ] Sinceアノテーションの6つのメタアノテーション（@param, @field, @getter, @setter, @beanGetter, @beanSetter）が全て網羅されているか
- [ ] Sinceアノテーションのprivate[spark]スコープ制約がテストケースに反映されているか
- [ ] コンパイルエラー検証（C-49）の実現方法について技術的に妥当か確認
