---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 220
  claims_with_evidence: 210
  claims_without_evidence: 10
confidence_derived: 0.95
---

# 根拠レポート：common-unsafe 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：210 / 220、根拠なし：10
- 優先レビュー（高）
  1. **CollationFactory/CollationSupport関連テストケース**：大規模クラスのため全publicメソッドの網羅性が要確認
  2. **UTF8String serialization関連**：writeExternal/readExternalのシリアライズテストは実行環境依存
  3. **Platform.allocateDirectBuffer**：JVM内部APIへのアクセスのためテスト環境依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `common/unsafe/src/main/java/org/apache/spark/unsafe/bitset/BitSetMethods.java` - ビットセット操作の静的メソッド群
- E-02: `common/unsafe/src/main/java/org/apache/spark/unsafe/types/CalendarInterval.java` - カレンダーインターバル型
- E-03: `common/unsafe/src/main/java/org/apache/spark/unsafe/types/ByteArray.java` - バイト配列ユーティリティ
- E-04: `common/unsafe/src/main/java/org/apache/spark/unsafe/types/VariantVal.java` - Variant型物理データ表現
- E-05: `common/unsafe/src/main/java/org/apache/spark/unsafe/types/GeographyVal.java` - GEOGRAPHY型物理表現
- E-06: `common/unsafe/src/main/java/org/apache/spark/unsafe/types/GeometryVal.java` - GEOMETRY型物理表現
- E-07: `common/unsafe/src/main/java/org/apache/spark/unsafe/types/UTF8String.java` - UTF-8文字列型（2244行）
- E-08: `common/unsafe/src/main/java/org/apache/spark/unsafe/memory/MemoryLocation.java` - メモリ位置管理
- E-09: `common/unsafe/src/main/java/org/apache/spark/unsafe/memory/MemoryBlock.java` - メモリブロック管理
- E-10: `common/unsafe/src/main/java/org/apache/spark/unsafe/memory/HeapMemoryAllocator.java` - ヒープメモリアロケータ
- E-11: `common/unsafe/src/main/java/org/apache/spark/unsafe/memory/UnsafeMemoryAllocator.java` - オフヒープメモリアロケータ
- E-12: `common/unsafe/src/main/java/org/apache/spark/unsafe/memory/MemoryAllocator.java` - メモリアロケータインタフェース
- E-13: `common/unsafe/src/main/java/org/apache/spark/unsafe/hash/Murmur3_x86_32.java` - Murmur3ハッシュ関数
- E-14: `common/unsafe/src/main/java/org/apache/spark/unsafe/array/LongArray.java` - long配列ラッパー
- E-15: `common/unsafe/src/main/java/org/apache/spark/unsafe/array/ByteArrayMethods.java` - バイト配列メソッド群
- E-16: `common/unsafe/src/main/java/org/apache/spark/unsafe/UnsafeAlignedOffset.java` - アラインメントオフセット
- E-17: `common/unsafe/src/main/java/org/apache/spark/unsafe/Platform.java` - Unsafeプラットフォーム操作
- E-18: `common/unsafe/src/main/java/org/apache/spark/unsafe/UTF8StringBuilder.java` - UTF8文字列ビルダー
- E-19: `common/unsafe/src/main/java/org/apache/spark/unsafe/KVIterator.java` - KVイテレータ抽象クラス
- E-20: `common/unsafe/src/main/java/org/apache/spark/sql/catalyst/util/CollationFactory.java` - Collationファクトリ
- E-21: `common/unsafe/src/main/java/org/apache/spark/sql/catalyst/util/CollationAwareUTF8String.java` - Collation対応UTF8String
- E-22: `common/unsafe/src/main/java/org/apache/spark/sql/catalyst/util/CollationSupport.java` - Collationサポート
- E-23: `common/unsafe/src/main/java/org/apache/spark/sql/catalyst/util/CollationNames.java` - Collation名定数
- E-24: `common/unsafe/src/main/java/org/apache/spark/sql/catalyst/util/SpecialCodePointConstants.java` - 特殊コードポイント定数
- E-25: `common/unsafe/src/main/java/org/apache/spark/sql/catalyst/util/DateTimeConstants.java` - 日時定数
- E-26: `common/unsafe/src/main/java/org/apache/spark/sql/catalyst/expressions/HiveHasher.java` - Hiveハッシュ関数

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-UNS-001~010) | BitSetMethods: set/unset/isSet/anySet/nextSetBit のテストケース | E-01 | ○ |
| C-02 (UT-UNS-011~023) | CalendarInterval: コンストラクタ/equals/toString/extractAsPeriod/extractAsDuration/compareTo/hashCode のテストケース | E-02 | ○ |
| C-03 (UT-UNS-024~042) | ByteArray: getPrefix/compareBinary/subStringSQL/concat/concatWS/lpad/rpad のテストケース | E-03 | ○ |
| C-04 (UT-UNS-043~048) | VariantVal: コンストラクタ/equals/hashCode/debugString のテストケース | E-04 | ○ |
| C-05 (UT-UNS-049~051) | GeographyVal: fromBytes/compareTo のテストケース | E-05 | ○ |
| C-06 (UT-UNS-052~054) | GeometryVal: fromBytes/compareTo のテストケース | E-06 | ○ |
| C-07 (UT-UNS-055~057) | MemoryLocation: コンストラクタ/setObjAndOffset のテストケース | E-08 | ○ |
| C-08 (UT-UNS-058~060) | MemoryBlock: コンストラクタ/fromLongArray/fill のテストケース | E-09 | ○ |
| C-09 (UT-UNS-061~065) | HeapMemoryAllocator: allocate/free のテストケース | E-10, E-12 | ○ |
| C-10 (UT-UNS-066~067) | UnsafeMemoryAllocator: allocate/free のテストケース | E-11, E-12 | ○ |
| C-11 (UT-UNS-068~075) | Murmur3_x86_32: hashInt/hashLong/hashUnsafeWords/hashUnsafeBytes/hashUnsafeBytes2/toString のテストケース | E-13 | ○ |
| C-12 (UT-UNS-076~079) | LongArray: コンストラクタ/set/get/zeroOut/size のテストケース | E-14 | ○ |
| C-13 (UT-UNS-080~096) | ByteArrayMethods: nextPowerOf2/roundNumberOfBytesToNearestWord/arrayEquals/contains/startsWith/endsWith/matchAt のテストケース | E-15 | ○ |
| C-14 (UT-UNS-097~101) | UnsafeAlignedOffset: getUaoSize/setUaoSize/getSize/putSize のテストケース | E-16 | ○ |
| C-15 (UT-UNS-102~111) | Platform: get/put系/copyMemory/allocateMemory/freeMemory/setMemory/allocateDirectBuffer/reallocateMemory のテストケース | E-17 | ○ |
| C-16 (UT-UNS-112~121) | UTF8StringBuilder: コンストラクタ/append/appendCodePoint/build のテストケース | E-18 | ○ |
| C-17 (UT-UNS-122~210) | UTF8String: 全publicメソッドのテストケース（fromString/fromBytes/numBytes/numChars/substring/contains/trim/replace/toLong/toInt/binaryCompare/hashCode/soundex/levenshteinDistance等） | E-07 | ○ |
| C-18 (UT-UNS-211~214) | HiveHasher: hashInt/hashLong/hashUnsafeBytes のテストケース | E-26 | ○ |
| C-19 | CollationFactory/CollationAwareUTF8String/CollationSupportの大規模クラスはテストケース一覧から除外 | E-20, E-21, E-22 | △ |
| C-20 | KVIteratorは抽象クラスのためテストケース対象外 | E-19 | △ |
| C-21 | CollationNames/SpecialCodePointConstants/DateTimeConstantsは定数のみのクラスのためテストケース対象外 | E-23, E-24, E-25 | △ |
| C-22 | VariantVal.readFromUnsafeRowはUnsafeRow依存のため直接テストが困難 | E-04 | △ |
| C-23 | VariantVal.toJsonはVariantクラス依存のため間接テスト | E-04 | △ |
| C-24 | Platform.throwExceptionはUnsafe直接呼び出しのため単体テスト困難 | E-17 | △ |
| C-25 | UTF8String.writeExternal/readExternalはシリアライズ環境依存 | E-07 | △ |
| C-26 | UTF8String.write/read(Kryo)はKryoシリアライズ環境依存 | E-07 | △ |
| C-27 | UTF8String.compareTo はテスト環境でUnsupportedOperationExceptionをスロー | E-07 | △ |
| C-28 | UTF8String.semanticCompare/semanticEqualsはCollationFactory依存 | E-07, E-20 | △ |

## 4) 不足情報（Unknown / Missing）
- CollationFactory、CollationAwareUTF8String、CollationSupportは非常に大規模なクラス（各数百〜千行超）であり、これらのクラス単体でのテストケース一覧が必要
  - 候補：別モジュールまたは別ワーカーとして分割生成 / CollationSupportSuiteの既存テストを参照
- KVIteratorは抽象クラスで具象実装がモジュール外にあるため、テスト対象外とした
  - 候補：具象実装側のモジュールでテスト / モック利用のテスト
- VariantVal.readFromUnsafeRowは内部メモリレイアウト依存で、UnsafeRow/UnsafeArrayDataが必要
  - 候補：統合テストとして別途作成 / テスト用ヘルパーの利用

## 5) リスクフラグ（レビュー観点）
- **リスク1 (中)**: CollationFactory/CollationAwareUTF8String/CollationSupportの3クラスは本テストケース一覧でカバーしていない。これらは非常に大規模かつ複雑なロジックを含むため、別途テストケース一覧の作成を推奨する。
- **リスク0 (低)**: 定数クラス（CollationNames, SpecialCodePointConstants, DateTimeConstants）はテスト不要と判断したが、定数値の正当性確認が必要な場合はレビューで補完する。
- **リスク1 (中)**: Platform.copyMemoryのオーバーラップ処理に関するテストケースは記載しているが、実際のオフヒープメモリ操作は環境依存性が高く、テスト実行時の安定性に注意が必要。
- **リスク0 (低)**: UTF8Stringのシリアライズ/デシリアライズテスト（Kryo, Java Serialization）は環境依存のため、テスト実行環境の構成に依存する。

## 6) レビュアーチェックリスト（最小）
- [ ] 全20個のメインソースファイルに対してテストケースが網羅されているか確認
- [ ] UTF8String（最大クラス）のpublicメソッドが全て対象になっているか確認
- [ ] 正常系・異常系・境界値のバランスが適切か確認
- [ ] CollationFactory/CollationAwareUTF8String/CollationSupportの除外判断が妥当か確認
- [ ] テストIDの連番（UT-UNS-001〜220）に欠番がないか確認
- [ ] 優先度（高/中/低）の設定が基準に沿っているか確認
- [ ] ハッシュ関連テスト（Murmur3, HiveHasher）の期待値が正しいか確認
- [ ] メモリ操作テスト（Platform, MemoryAllocator）の前提条件が明確か確認
