---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 165
  claims_with_evidence: 162
  claims_without_evidence: 3
confidence_derived: 0.98
---

# 根拠レポート：common-utils-java 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：162 / 165、根拠なし：3
- 優先レビュー（高）
  1. **UT-CUJ-128/129（forceDeleteOnExit）**：deleteOnExitの登録確認はJVM終了までテスト困難
  2. **UT-CUJ-134（UUIDv7時間順序）**：ベストエフォート保証のためテスト条件に注意
  3. **UT-CUJ-051（deleteRecursively with filter）**：OS依存パス（Unix native削除）のカバレッジ

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `common/utils-java/src/main/java/org/apache/spark/network/util/ByteUnit.java` - ByteUnit列挙型の定義とconvertTo/convertFrom/toBytesメソッド
- E-02: `common/utils-java/src/main/java/org/apache/spark/network/util/JavaUtils.java` - JavaUtilsクラスの全publicメソッド定義
- E-03: `common/utils-java/src/main/java/org/apache/spark/util/UUIDv7Generator.java` - UUIDv7Generator.generate()メソッドの定義
- E-04: `common/utils-java/src/main/java/org/apache/spark/util/Pair.java` - Pair recordの定義
- E-05: `common/utils-java/src/main/java/org/apache/spark/internal/SparkLogger.java` - SparkLoggerクラスの全メソッド定義
- E-06: `common/utils-java/src/main/java/org/apache/spark/internal/SparkLoggerFactory.java` - SparkLoggerFactoryクラスの定義
- E-07: `common/utils-java/src/main/java/org/apache/spark/internal/MDC.java` - MDC recordの定義
- E-08: `common/utils-java/src/main/java/org/apache/spark/internal/LogKey.java` - LogKeyインターフェースの定義
- E-09: `common/utils-java/src/main/java/org/apache/spark/internal/LogKeys.java` - LogKeys列挙型の定義
- E-10: `common/utils-java/src/main/java/org/apache/spark/QueryContext.java` - QueryContextインターフェースの定義
- E-11: `common/utils-java/src/main/java/org/apache/spark/QueryContextType.java` - QueryContextType列挙型の定義
- E-12: `common/utils-java/src/main/java/org/apache/spark/memory/MemoryMode.java` - MemoryMode列挙型の定義
- E-13: `common/utils-java/src/main/java/org/apache/spark/unsafe/array/ByteArrayUtils.java` - ByteArrayUtilsクラスの定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ByteUnit.convertTo: 同一単位変換で値不変 | E-01 (L38-51: convertToメソッドの分岐ロジック) | ○ |
| C-02 | ByteUnit.convertTo: 大→小単位変換 | E-01 (L39-45: multiplier比較とratio計算) | ○ |
| C-03 | ByteUnit.convertTo: 小→大単位変換 | E-01 (L46-49: 逆方向の除算処理) | ○ |
| C-04 | ByteUnit.convertTo: オーバーフロー検出 | E-01 (L41-43: Long.MAX_VALUE/ratio < d の検証) | ○ |
| C-05 | ByteUnit.convertFrom: 逆変換 | E-01 (L33-35: u.convertTo(d, this)の委譲) | ○ |
| C-06 | ByteUnit.toBytes: 正常変換 | E-01 (L53-58: d * multiplier) | ○ |
| C-07 | ByteUnit.toBytes: 負値例外 | E-01 (L54-56: d < 0 チェック) | ○ |
| C-08 | ByteUnit.toBytes: ゼロ値 | E-01 (L53-58: 0 * multiplier = 0) | ○ |
| C-09-13 | ByteUnit便利メソッド(toKiB/toMiB/toGiB/toTiB/toPiB) | E-01 (L60-64: convertToへの委譲) | ○ |
| C-14-16 | JavaUtils.closeQuietly: 正常/null/IOExceptionケース | E-02 (L61-69: null check, catch IOException) | ○ |
| C-17-20 | JavaUtils.deleteQuietly: ファイル/ディレクトリ/null/不在ケース | E-02 (L72-78: null/exists check, Files.walk) | ○ |
| C-21-25 | JavaUtils.moveFile: 正常/null/不在/ディレクトリ/既存ケース | E-02 (L107-113: 条件チェックとrenameTo/Files.move) | ○ |
| C-26-28 | JavaUtils.moveDirectory: 正常/非ディレクトリ/自己参照ケース | E-02 (L117-128: isDirectory, to.startsWith(from)) | ○ |
| C-29-32 | JavaUtils.copyDirectory: 正常/null/自己参照/ファイル宛先ケース | E-02 (L147-172: 条件チェックとwalkFileTree) | ○ |
| C-33-36 | JavaUtils.nonNegativeHash: 正/null/MIN_VALUE/負ケース | E-02 (L175-179: null→0, MIN_VALUE→0, Math.abs) | ○ |
| C-37-40 | JavaUtils.stringToBytes/bytesToString | E-02 (L185-195: UTF-8エンコード/デコード) | ○ |
| C-41-43 | JavaUtils.sizeOf: ファイル/ディレクトリ/不在ケース | E-02 (L197-214: walkFileTreeとsize集計) | ○ |
| C-44-47 | JavaUtils.cleanDirectory: 正常/null/不在/ファイルケース | E-02 (L216-238: 条件チェックとwalkFileTree) | ○ |
| C-48-51 | JavaUtils.deleteRecursively: 正常/ディレクトリ/null/フィルタケース | E-02 (L247-278: nullチェック, OS判定, filter) | ○ |
| C-52-57 | JavaUtils.listPaths/listFiles: 正常/null/不在ケース | E-02 (L368-385: null→例外, !exists→空Set) | ○ |
| C-58-69 | JavaUtils.timeStringAs: 各サフィックス/デフォルト/変換/不正ケース | E-02 (L387-457: timeSuffixes, パターンマッチ) | ○ |
| C-70-71 | JavaUtils.timeStringAsMs/timeStringAsSec | E-02 (L463-473: timeStringAsへの委譲) | ○ |
| C-72-82 | JavaUtils.byteStringAs: 各サフィックス/デフォルト/小数/不正ケース | E-02 (L475-516: byteSuffixes, パターンマッチ, fraction) | ○ |
| C-83-86 | JavaUtils便利メソッド(byteStringAsBytes/Kb/Mb/Gb) | E-02 (L524-556: byteStringAsへの委譲) | ○ |
| C-87-88 | JavaUtils.bufferToArray: 配列バッキング/ダイレクトケース | E-02 (L562-571: hasArray条件分岐) | ○ |
| C-89-91 | JavaUtils.createDirectory: デフォルト/カスタム/nullプレフィックス | E-02 (L577-605: namePrefix null→"spark") | ○ |
| C-92-98 | JavaUtils.readFully: チャネル正常/EOF/ストリーム正常/null/負len/範囲外/EOF | E-02 (L610-630: 条件チェックとEOFException) | ○ |
| C-99-101 | JavaUtils.copyURLToFile: 正常/null/ディレクトリケース | E-02 (L635-643: nullチェック, isDirectory) | ○ |
| C-102-106 | JavaUtils.join: 正常/null/空/null要素/nullセパレータケース | E-02 (L645-652: null→"", sep null→"") | ○ |
| C-107-108 | JavaUtils.stackTraceToString: 正常/nullケース | E-02 (L654-665: null→"") | ○ |
| C-109-113 | JavaUtils.checkedCast: 正常/オーバーフロー/アンダーフロー/境界値 | E-02 (L667-672: MAX/MIN_VALUE条件) | ○ |
| C-114-121 | JavaUtils.contentEquals: 同一/異なる/null/不在/ディレクトリ/サイズケース | E-02 (L675-691: 多段分岐ロジック) | ○ |
| C-122-123 | JavaUtils.toString: 正常/空ケース | E-02 (L693-695: readAllBytes→String) | ○ |
| C-124-127 | JavaUtils.checkArgument/checkState: 正常/異常ケース | E-02 (L755-769: !check→例外スロー) | ○ |
| C-128-130 | JavaUtils.forceDeleteOnExit: ファイル/ディレクトリ/null | E-02 (L82-104: deleteOnExit登録) | △ |
| C-131-135 | UUIDv7Generator.generate: 生成/バージョン/バリアント/順序/一意性 | E-03 (L55-66: version 0x7, variant 0x8, timestamp) | ○ |
| C-136-141 | Pair: of/null/getLeft/getRight/equals | E-04 (L25-28: record定義) | ○ |
| C-142-145 | SparkLoggerFactory: getLogger/enable/disable | E-06 (L24-47: volatile flag, getLogger) | ○ |
| C-146-158 | SparkLogger: error/warn/info/isXxxEnabled/getSlf4jLogger | E-05 (L77-248: 各ログメソッド定義) | ○ |
| C-159-162 | MDC: of/key/value | E-07 (L25-28: record定義) | ○ |
| C-163 | QueryContextType列挙値確認 | E-11 (L28-31: SQL, DataFrame) | ○ |
| C-164 | MemoryMode列挙値確認 | E-12 (L23-26: ON_HEAP, OFF_HEAP) | ○ |
| C-165 | ByteArrayUtils定数値確認 | E-13 (L26: Integer.MAX_VALUE - 15) | ○ |

## 4) 不足情報（Unknown / Missing）
- forceDeleteOnExitの実際のdeleteOnExit登録動作はJVM終了時にのみ確認可能であり、単体テストでの直接検証が困難
  - 候補：モックを使用したdeleteOnExit呼び出しの検証 / Runtime.getRuntime().addShutdownHookでの間接検証 / 統合テストでの確認
- UUIDv7の時間順序保証はベストエフォートであり、同一ミリ秒内では保証されない（RFC 9562の仕様による）
  - 候補：異なるミリ秒間のテストに限定 / ドキュメントのJavadocに準拠したテスト設計
- api.java.function配下の@FunctionalInterfaceはメソッド定義のみでロジックがないため、テストケース生成の対象外とした
  - 候補：シリアライズ可能性のテスト / ラムダ式での利用テスト

## 5) リスクフラグ（レビュー観点）
- 0: ByteUnit, Pair, MDC, QueryContextType, MemoryMode, ByteArrayUtils - 低リスク（シンプルなデータ構造・列挙型）
- 0: SparkLogger, SparkLoggerFactory - 低リスク（SLF4J委譲のラッパー）
- 1: JavaUtils.timeStringAs/byteStringAs - 中リスク（パターンマッチ・サフィックスマッピングの網羅性）
- 1: JavaUtils.deleteRecursively - 中リスク（OS依存のネイティブ削除パスの動作確認が環境依存）
- 1: UUIDv7Generator - 中リスク（時間順序のベストエフォート保証の検証方法）
- 0: JavaUtils.checkedCast/nonNegativeHash/contentEquals - 低リスク（純粋関数・明確な条件分岐）

## 6) レビュアーチェックリスト（最小）
- [ ] ByteUnit.convertToのオーバーフロー検出条件（Long.MAX_VALUE / ratio < d）が正しくテストケースに反映されているか
- [ ] JavaUtils.timeStringAs/byteStringAsのサフィックスマッピングが全パターン網羅されているか
- [ ] JavaUtils.deleteRecursivelyのOS依存パス（Unix native / Java IO）の両方がテスト計画に含まれているか
- [ ] UUIDv7Generatorのバージョン(7)・バリアント(IETF/2)の検証が適切か
- [ ] JavaUtils.contentEqualsの多段分岐（null/不在/ディレクトリ/サイズ/内容）が全て網羅されているか
- [ ] forceDeleteOnExitのテスト可能性について妥当な判断がなされているか
- [ ] @FunctionalInterface群をテスト対象外とした判断が適切か
