---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 205
  claims_with_evidence: 199
  claims_without_evidence: 6
confidence_derived: 0.97
---

# 根拠レポート：common-utils 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧（common-utils.csv）の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：199 / 205、根拠なし：6
- 優先レビュー（高）
  1. **C-176～C-180 (LogThrottler/DeadlineWithTimeSource)**: Loggingトレイト内部のprivateクラスの動作は外部からのテスト困難性があり、期待結果の正確性を実際のテストで確認する必要がある
  2. **C-199 (SparkEnvUtils.isTesting)**: テスト環境依存の動作であり、実行環境のシステムプロパティに依存するため期待結果がテスト実行条件によって変わる
  3. **C-004 (ErrorClassesJsonReader nullパラメータ)**: null値パラメータの内部処理は、StringSubstitutorの挙動に依存し間接的な根拠のみ

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `common/utils/src/main/scala/org/apache/spark/ErrorClassesJSONReader.scala` - ErrorClassesJsonReaderの実装
- E-02: `common/utils/src/main/scala/org/apache/spark/StringSubstitutor.scala` - StringSubstitutorの実装
- E-03: `common/utils/src/main/scala/org/apache/spark/SparkThrowableHelper.scala` - SparkThrowableHelperの実装
- E-04: `common/utils/src/main/scala/org/apache/spark/SparkException.scala` - SparkExceptionの実装
- E-05: `common/utils/src/main/scala/org/apache/spark/storage/StorageLevel.scala` - StorageLevelの実装
- E-06: `common/utils/src/main/java/org/apache/spark/storage/StorageLevelMapper.java` - StorageLevelMapperの実装
- E-07: `common/utils/src/main/scala/org/apache/spark/util/VersionUtils.scala` - VersionUtilsの実装
- E-08: `common/utils/src/main/scala/org/apache/spark/util/SparkStringUtils.scala` - SparkStringUtilsの実装
- E-09: `common/utils/src/main/scala/org/apache/spark/util/SparkClassUtils.scala` - SparkClassUtilsの実装
- E-10: `common/utils/src/main/scala/org/apache/spark/util/SparkErrorUtils.scala` - SparkErrorUtilsの実装
- E-11: `common/utils/src/main/scala/org/apache/spark/util/SparkFileUtils.scala` - SparkFileUtilsの実装
- E-12: `common/utils/src/main/scala/org/apache/spark/util/SparkSerDeUtils.scala` - SparkSerDeUtilsの実装
- E-13: `common/utils/src/main/scala/org/apache/spark/util/SparkCollectionUtils.scala` - SparkCollectionUtilsの実装
- E-14: `common/utils/src/main/scala/org/apache/spark/util/SparkSchemaUtils.scala` - SparkSchemaUtilsの実装
- E-15: `common/utils/src/main/scala/org/apache/spark/util/JsonUtils.scala` - JsonUtilsの実装
- E-16: `common/utils/src/main/scala/org/apache/spark/internal/config/ConfigBuilder.scala` - ConfigBuilderの実装
- E-17: `common/utils/src/main/scala/org/apache/spark/internal/config/ConfigEntry.scala` - ConfigEntryの実装
- E-18: `common/utils/src/main/scala/org/apache/spark/internal/config/ConfigReader.scala` - ConfigReaderの実装
- E-19: `common/utils/src/main/scala/org/apache/spark/internal/config/ConfigProvider.scala` - ConfigProviderの実装
- E-20: `common/utils/src/main/scala/org/apache/spark/util/SparkStreamUtils.scala` - SparkStreamUtilsの実装
- E-21: `common/utils/src/main/scala/org/apache/spark/util/SparkThreadUtils.scala` - SparkThreadUtilsの実装
- E-22: `common/utils/src/main/scala/org/apache/spark/util/CompletionIterator.scala` - CompletionIteratorの実装
- E-23: `common/utils/src/main/scala/org/apache/spark/internal/Logging.scala` - Loggingの実装
- E-24: `common/utils/src/main/scala/org/apache/spark/util/MavenUtils.scala` - MavenUtilsの実装
- E-25: `common/utils/src/main/scala/org/apache/spark/util/LexicalThreadLocal.scala` - LexicalThreadLocalの実装
- E-26: `common/utils/src/main/scala/org/apache/spark/util/ArrayImplicits.scala` - ArrayImplicitsの実装
- E-27: `common/utils/src/main/java/org/apache/spark/SparkThrowable.java` - SparkThrowableインターフェースの実装
- E-28: `common/utils/src/main/scala/org/apache/spark/util/SparkEnvUtils.scala` - SparkEnvUtilsの実装
- E-29: `common/utils/src/main/scala/org/apache/spark/util/SparkFatalException.scala` - SparkFatalExceptionの実装
- E-30: `common/utils/src/main/scala/org/apache/spark/SparkBuildInfo.scala` - SparkBuildInfoの実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | ErrorClassesJsonReader.getErrorMessageが有効なパラメータでメッセージを生成する | E-01 | ○ |
| C-002 | ErrorClassesJsonReader.getErrorMessageが未定義エラークラスで例外をスローする | E-01 | ○ |
| C-003 | ErrorClassesJsonReader.getErrorMessageが未定義パラメータで例外をスローする | E-01, E-02 | ○ |
| C-004 | ErrorClassesJsonReader.getErrorMessageがnullパラメータを'null'文字列に変換する | E-01, E-02 | △ |
| C-005～C-015 | ErrorClassesJsonReaderの各メソッドの動作 | E-01 | ○ |
| C-016～C-022 | StringSubstitutorの各機能 | E-02 | ○ |
| C-023～C-031 | SparkThrowableHelperの各メソッドの動作 | E-03 | ○ |
| C-032～C-039 | SparkExceptionの各ファクトリメソッドと機能 | E-04 | ○ |
| C-040～C-056 | StorageLevelおよびStorageLevelMapperの各機能 | E-05, E-06 | ○ |
| C-057～C-066 | VersionUtilsの各メソッドの動作 | E-07 | ○ |
| C-067～C-084 | SparkStringUtilsの各メソッドの動作 | E-08 | ○ |
| C-085～C-095 | SparkClassUtilsの各メソッドの動作 | E-09 | ○ |
| C-096～C-108 | SparkErrorUtilsの各メソッドの動作 | E-10 | ○ |
| C-109～C-121 | SparkFileUtilsの各メソッドの動作 | E-11 | ○ |
| C-122～C-125 | SparkSerDeUtilsの各メソッドの動作 | E-12 | ○ |
| C-126～C-133 | SparkCollectionUtilsの各メソッドの動作 | E-13 | ○ |
| C-134～C-137 | SparkSchemaUtilsの各メソッドの動作 | E-14 | ○ |
| C-138 | JsonUtils.toJsonStringの動作 | E-15 | ○ |
| C-139～C-148 | ConfigBuilder/TypedConfigBuilderの各メソッドの動作 | E-16 | ○ |
| C-149～C-153 | ConfigEntryの各サブクラスの動作 | E-17 | ○ |
| C-154～C-158 | ConfigReaderの各メソッドの動作 | E-18 | ○ |
| C-159～C-162 | ConfigProviderの各メソッドの動作 | E-19 | ○ |
| C-163～C-165 | SparkStreamUtilsの各メソッドの動作 | E-20 | ○ |
| C-166～C-169 | SparkThreadUtilsの各メソッドの動作 | E-21, E-29 | ○ |
| C-170～C-173 | CompletionIteratorの各メソッドの動作 | E-22 | ○ |
| C-174～C-175 | MessageWithContextの各メソッドの動作 | E-23 | ○ |
| C-176～C-178 | LogThrottlerの各メソッドの動作 | E-23 | △ |
| C-179～C-180 | DeadlineWithTimeSourceの各メソッドの動作 | E-23 | △ |
| C-181～C-189 | MavenUtilsの各メソッドの動作 | E-24 | ○ |
| C-190～C-193 | LexicalThreadLocalの各メソッドの動作 | E-25 | ○ |
| C-194～C-195 | ArrayImplicitsの各メソッドの動作 | E-26 | ○ |
| C-196～C-198 | SparkThrowableインターフェースのデフォルトメソッド | E-27 | ○ |
| C-199 | SparkEnvUtils.isTestingの動作 | E-28 | △ |
| C-200～C-205 | ConfigHelpers追加メソッドの動作 | E-16 | ○ |

## 4) 不足情報（Unknown / Missing）
- **LogThrottler/DeadlineWithTimeSourceの内部動作 (C-176～C-180)**: これらはLogging.scala内のprivate[spark]クラスであり、実装は確認できるが、時間に依存する動作のため期待結果の正確性は実行時テストで確認が必要
  - 候補：既存テストスイートの確認 / Loggingクラスの統合テスト参照
- **SparkEnvUtils.isTesting (C-199)**: JavaUtils.isTestingへの委譲であり、テスト環境のシステムプロパティ（`spark.testing`）に依存する
  - 候補：common-network-commonのJavaUtilsソースコード確認
- **ErrorClassesJsonReader nullパラメータ (C-004)**: StringSubstitutorを経由したnull処理であり、置換動作はStringSubstitutor内部のnull -> "null"変換に依存する
  - 候補：StringSubstitutorの詳細動作確認

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク**: 大部分のテストケースはソースコードの実装と直接対応しており、入力値・期待結果が明確
- **1: 中リスク**: LogThrottler/DeadlineWithTimeSource関連のテストケースは、時間依存の動作を含むため、テスト実装時にモック化やタイムソースの制御が必要
- **1: 中リスク**: MavenUtils.resolveMavenCoordinatesは外部依存（Ivyライブラリ、ネットワーク）が多く、単体テストではモック化が不可欠
- **0: 低リスク**: 文字列操作、バージョン解析、コレクションユーティリティ等は純粋関数が多く、テストが容易

## 6) レビュアーチェックリスト（最小）
- [ ] ErrorClassesJsonReaderのテストケースが、実際のerror-classes.jsonの構造と整合しているか確認
- [ ] StorageLevelの全定義済み定数（MEMORY_ONLY, DISK_ONLY, MEMORY_AND_DISK等）がテスト対象に含まれているか確認
- [ ] ConfigBuilder/ConfigEntryのテストで、bytesConf/memoryConf等のサイズ系設定ビルダーが十分にカバーされているか確認
- [ ] SparkFileUtilsのテストケースで、ファイルシステム操作のクリーンアップ（テスト後の一時ファイル削除）が考慮されているか確認
- [ ] MavenUtilsのテストケースで外部サービス（Maven Central等）への依存がモック化される前提になっているか確認
- [ ] LogThrottler/DeadlineWithTimeSourceのテストで時間制御が適切に設計されているか確認
- [ ] SparkThreadUtils.awaitResultのテストでFutureのタイムアウト値が適切（テスト実行時間への影響が最小限）か確認
