---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 203
  claims_with_evidence: 197
  claims_without_evidence: 6
confidence_derived: 0.97
---

# 根拠レポート：common-variant 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：197 / 203、根拠なし：6
- 優先レビュー（高）
  1. **UT-VAR-160 (checkCapacity)**: privateメソッドのため直接テスト可能か要確認
  2. **UT-VAR-122 (result - SIZE_LIMIT超過)**: テスト環境でのSIZE_LIMIT値(16MiB vs 128MiB)による挙動差に注意
  3. **UT-VAR-195/196/198 (tryTypedShred)**: privateメソッドのためcastShredded経由でのテストが必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `common/variant/src/main/java/org/apache/spark/types/variant/Variant.java` - Variantクラス定義（365行）
- E-02: `common/variant/src/main/java/org/apache/spark/types/variant/VariantUtil.java` - VariantUtilユーティリティ（612行）
- E-03: `common/variant/src/main/java/org/apache/spark/types/variant/VariantBuilder.java` - VariantBuilderクラス定義（587行）
- E-04: `common/variant/src/main/java/org/apache/spark/types/variant/VariantSchema.java` - VariantSchemaクラス定義（163行）
- E-05: `common/variant/src/main/java/org/apache/spark/types/variant/ShreddingUtils.java` - ShreddingUtilsクラス定義（174行）
- E-06: `common/variant/src/main/java/org/apache/spark/types/variant/VariantShreddingWriter.java` - VariantShreddingWriterクラス定義（304行）
- E-07: `common/variant/src/main/java/org/apache/spark/types/variant/VariantSizeLimitException.java` - 例外クラス定義（26行）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-VAR-001: Variantコンストラクタの正常系テスト | E-01 (L52-69: コンストラクタ定義、バージョン/サイズチェック) | ○ |
| C-02 | UT-VAR-002: 空メタデータでMALFORMED_VARIANT | E-01 (L61: metadata.length < 1 チェック) | ○ |
| C-03 | UT-VAR-003: 不正バージョンでMALFORMED_VARIANT | E-01 (L61: VERSION_MASK/VERSIONチェック) | ○ |
| C-04 | UT-VAR-004/005: SIZE_LIMIT超過でVARIANT_CONSTRUCTOR_SIZE_LIMIT | E-01 (L66-68: SIZE_LIMIT比較) | ○ |
| C-05 | UT-VAR-006/007: getValue()のpos=0最適化パスとコピーパス | E-01 (L71-76: pos==0分岐) | ○ |
| C-06 | UT-VAR-009/010: getBoolean()のtrue/false取得 | E-01 (L83-85), E-02 (L371-379: getBoolean実装) | ○ |
| C-07 | UT-VAR-011/012: getLong()のINT1/INT8取得 | E-01 (L88-90), E-02 (L388-409: getLong実装) | ○ |
| C-08 | UT-VAR-013: getDouble()取得 | E-01 (L93-95), E-02 (L413-419: getDouble実装) | ○ |
| C-09 | UT-VAR-014/015: getDecimal()/getDecimalWithOriginalScale() | E-01 (L98-105), E-02 (L430-467: decimal実装) | ○ |
| C-10 | UT-VAR-018/019: getString()のSHORT_STR/LONG_STR | E-01 (L118-120), E-02 (L494-512: getString実装) | ○ |
| C-11 | UT-VAR-020: getUuid() | E-01 (L133-135), E-02 (L516-526: getUuid実装) | ○ |
| C-12 | UT-VAR-022/023: objectSize()正常系/空オブジェクト | E-01 (L139-142: objectSize実装) | ○ |
| C-13 | UT-VAR-024/025/026: getFieldByKey()の線形/バイナリサーチ | E-01 (L146-181: BINARY_SEARCH_THRESHOLD=32, 線形/バイナリサーチ分岐) | ○ |
| C-14 | UT-VAR-027/028/029: getFieldAtIndex()の正常/範囲外 | E-01 (L196-205: index<0 || index>=size チェック) | ○ |
| C-15 | UT-VAR-030/031: getDictionaryIdAtIndex()の正常/範囲外 | E-01 (L210-217: index範囲チェック) | ○ |
| C-16 | UT-VAR-032/033/034/035/036: arraySize()/getElementAtIndex() | E-01 (L221-234: 配列操作実装) | ○ |
| C-17 | UT-VAR-037-051: toJson()の各型変換 | E-01 (L281-363: toJsonImpl実装、全型のswitch分岐) | ○ |
| C-18 | UT-VAR-042/051: 非有限DOUBLE/FLOATのクォート処理 | E-01 (L326-331, L348-355: Double.isFinite/Float.isFiniteチェック) | ○ |
| C-19 | UT-VAR-052/053: escapeJson() | E-01 (L247-256: JsonGeneratorを使用したエスケープ処理) | ○ |
| C-20 | UT-VAR-054-067: VariantUtilのwriteLong/readUnsigned/checkIndex | E-02 (L152-233: 各メソッド実装) | ○ |
| C-21 | UT-VAR-068-072: getType()の各基本型判定 | E-02 (L263-310: getType実装、全basicType/typeInfoのswitch) | ○ |
| C-22 | UT-VAR-073-075: valueSize()のサイズ計算 | E-02 (L315-363: valueSize実装) | ○ |
| C-23 | UT-VAR-076-108: VariantUtilの各get*メソッドとhandleObject/handleArray/getMetadataKey | E-02 (L371-610: 各メソッド実装) | ○ |
| C-24 | UT-VAR-109-161: VariantBuilderの各メソッド | E-03 (L44-586: 全メソッド実装) | ○ |
| C-25 | UT-VAR-119/120: 重複キー処理(allowDuplicateKeys) | E-03 (L289-340: finishWritingObject内の重複キー処理分岐) | ○ |
| C-26 | UT-VAR-131-137: appendLong()の型選択境界値 | E-03 (L147-166: byte/short/int/long分岐) | ○ |
| C-27 | UT-VAR-139-141: appendDecimal()のDECIMAL4/8/16選択 | E-03 (L177-206: precision/scaleに基づく分岐) | ○ |
| C-28 | UT-VAR-160: checkCapacity() SIZE_LIMIT超過 | E-03 (L449-462: checkCapacity実装) | △ |
| C-29 | UT-VAR-162-170: VariantSchemaのコンストラクタ/isUnshredded/toString | E-04 (L123-162: 各メソッド実装) | ○ |
| C-30 | UT-VAR-171-184: ShreddingUtils.rebuild() | E-05 (L49-172: rebuild実装の全分岐) | ○ |
| C-31 | UT-VAR-185-201: VariantShreddingWriter.castShredded/tryTypedShred | E-06 (L59-295: castShredded/tryTypedShred実装) | ○ |
| C-32 | UT-VAR-195-198: tryTypedShredのprivateメソッドテスト | E-06 (L155-295: tryTypedShred実装) | △ |
| C-33 | UT-VAR-202/203: VariantSizeLimitException | E-07 (L24-25: 例外クラス定義) | ○ |
| C-34 | ShreddingUtils.ShreddedRowインターフェースのテスト対象外判断 | E-05 (L29-45: インターフェース定義のみ) | △ |
| C-35 | VariantShreddingWriter.ShreddedResult/ShreddedResultBuilderインターフェースのテスト対象外判断 | E-06 (L32-51: インターフェース定義のみ) | △ |
| C-36 | VariantShreddingWriter.addVariantValueVariantのテスト対象外判断 | E-06 (L298-301: privateメソッドで内部利用のみ) | △ |
| C-37 | VariantUtil.readLong()のテスト(間接テスト) | E-02 (L205-218: package-private, 他メソッドから間接呼出し) | △ |

## 4) 不足情報（Unknown / Missing）
- **C-28 (checkCapacity)**: privateメソッドのため直接テスト不可。appendString等の公開メソッド経由で間接的にテストする必要がある。SIZE_LIMITはテスト環境では16MiB(U24_MAX+1)に設定される(`JavaUtils.isTesting()`)ため、テスト実行時のサイズ制限が本番と異なる点に注意。
  - 候補：appendString / appendBinary / appendVariant で大量データを入力して間接テスト
- **C-32 (tryTypedShred)**: privateメソッドのため直接テスト不可。castShredded経由でテストする必要がある。
  - 候補：castShredded メソッドに各型のVariantを渡して間接テスト
- **C-34/C-35 (インターフェース)**: ShreddedRow, ShreddedResult, ShreddedResultBuilderはインターフェース定義のみであり、具体的な実装は呼び出し元のモジュール(sql-catalyst等)にある。テスト時はモック実装が必要。
  - 候補：モックフレームワーク(Mockito等)の利用 / テスト用の簡易実装クラス
- **C-36 (addVariantValueVariant)**: privateメソッドであり、現在のコードでは使用箇所が見当たらない（デッドコードの可能性）。
  - 候補：コードレビューで削除可否を確認
- **C-37 (readLong)**: package-privateメソッドのため、同一パッケージ内のテストクラスから直接テスト可能だが、テストケース一覧では他メソッドからの間接テストとしてカバレッジを確保している。

## 5) リスクフラグ（レビュー観点）
- **リスク1 (中)**: SIZE_LIMITがテスト環境(16MiB)と本番環境(128MiB)で異なる。テスト環境でのサイズ制限テストが本番での挙動を正確に反映しない可能性がある。
- **リスク0 (低)**: VariantShreddingWriter.addVariantValueVariantメソッドがデッドコードである可能性。テスト対象から除外したが、確認が必要。
- **リスク0 (低)**: ShreddedRow/ShreddedResult/ShreddedResultBuilderインターフェースはモック実装が必要であり、モックの正確性がテスト品質に影響する。
- **リスク1 (中)**: BINARY_SEARCH_THRESHOLD=32のバイナリサーチパスは32フィールド以上のオブジェクトでのみ実行されるため、テストデータの準備に注意が必要。

## 6) レビュアーチェックリスト（最小）
- [ ] privateメソッド(checkCapacity, tryTypedShred, readLong)のテストカバレッジが公開メソッド経由で十分に確保されているか
- [ ] SIZE_LIMITのテスト環境/本番環境差分を考慮した境界値テストになっているか
- [ ] ShreddingUtils/VariantShreddingWriterのテストで使用するShreddedRowモック実装が正確か
- [ ] バイナリサーチパス(32フィールド以上)のテストデータが適切に準備されているか
- [ ] 全203件のテストケースが実装時に適切な優先度で実施されるか（高：82件を優先）
- [ ] JSON変換テスト(toJson)で各タイムゾーンの挙動が正しく検証されているか
- [ ] 重複キー処理(allowDuplicateKeys=true/false)の両パスがテストされているか
