---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 121
  claims_with_evidence: 118
  claims_without_evidence: 3
confidence_derived: 0.98
---

# 根拠レポート：connector-kinesis-asl 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：118 / 121、根拠なし：3
- 優先レビュー（高）
  1. **C-010 (UT-KIN-010)**：BasicCredentials.providerのnull入力時のフォールバック動作 - IllegalArgumentExceptionの発生条件がSDKバージョンに依存
  2. **C-056 (UT-KIN-056)**：指数バックオフの待ち時間検証 - 実行時間に依存するテストのため実装詳細の確認が必要
  3. **C-120 (UT-KIN-120)**：KinesisExampleUtils.getRegionNameByEndpointの正常系 - AWS SDKのKinesisServiceMetadataの挙動に依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `connector/kinesis-asl/src/main/java/org/apache/spark/streaming/kinesis/KinesisInitialPositions.java` - KinesisInitialPosition, Latest, TrimHorizon, AtTimestamp, fromKinesisInitialPositionの定義
- E-02: `connector/kinesis-asl/src/main/scala/org/apache/spark/streaming/kinesis/SparkAWSCredentials.scala` - SparkAWSCredentials, DefaultCredentials, BasicCredentials, STSCredentials, Builder定義
- E-03: `connector/kinesis-asl/src/main/scala/org/apache/spark/streaming/kinesis/KinesisInputDStream.scala` - KinesisInputDStream, Builder, defaultMessageHandler, DEFAULT_*定数の定義
- E-04: `connector/kinesis-asl/src/main/scala/org/apache/spark/streaming/kinesis/KinesisBackedBlockRDD.scala` - SequenceNumberRange, SequenceNumberRanges, KinesisBackedBlockRDD, KinesisSequenceRangeIterator定義
- E-05: `connector/kinesis-asl/src/main/scala/org/apache/spark/streaming/kinesis/KinesisRecordProcessor.scala` - KinesisRecordProcessor, retryRandomの定義
- E-06: `connector/kinesis-asl/src/main/scala/org/apache/spark/streaming/kinesis/KinesisCheckpointer.scala` - KinesisCheckpointer, setCheckpointer, removeCheckpointer, checkpoint, checkpointAll, shutdown定義
- E-07: `connector/kinesis-asl/src/main/scala/org/apache/spark/streaming/kinesis/KinesisReceiver.scala` - KinesisReceiver, addRecords, getCurrentLimit, getLatestSeqNumToCheckpoint, setCheckpointer, removeCheckpointer定義
- E-08: `connector/kinesis-asl/src/main/scala/org/apache/spark/streaming/kinesis/KinesisReadConfigurations.scala` - KinesisReadConfigurations, apply(), apply(ssc), 定数定義
- E-09: `connector/kinesis-asl/src/main/scala/org/apache/spark/streaming/kinesis/KinesisUtilsPythonHelper.scala` - KinesisUtilsPythonHelper.createStreamの定義
- E-10: `connector/kinesis-asl/src/main/scala/org/apache/spark/examples/streaming/KinesisExampleUtils.scala` - KinesisExampleUtils.getRegionNameByEndpointの定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | UT-KIN-001: LatestがLATESTを返す | E-01 (L33-39) | ○ |
| C-002 | UT-KIN-002: TrimHorizonがTRIM_HORIZONを返す | E-01 (L42-48) | ○ |
| C-003 | UT-KIN-003: AtTimestampがAT_TIMESTAMPを返す | E-01 (L51-61) | ○ |
| C-004 | UT-KIN-004: AtTimestamp.getTimestampがコンストラクタ値を返す | E-01 (L53, L63-65) | ○ |
| C-005 | UT-KIN-005: fromKinesisInitialPosition LATEST->Latest | E-01 (L77-80) | ○ |
| C-006 | UT-KIN-006: fromKinesisInitialPosition TRIM_HORIZON->TrimHorizon | E-01 (L81-82) | ○ |
| C-007 | UT-KIN-007: fromKinesisInitialPosition AT_TIMESTAMP->UnsupportedOperationException | E-01 (L83-91) | ○ |
| C-008 | UT-KIN-008: DefaultCredentials.providerがDefaultCredentialsProvider返却 | E-02 (L40-43) | ○ |
| C-009 | UT-KIN-009: BasicCredentials.providerが有効キーペアでStaticCredentialsProvider返却 | E-02 (L54-55) | ○ |
| C-010 | UT-KIN-010: BasicCredentials.providerが無効キーペアでフォールバック | E-02 (L54-61) | △ |
| C-011 | UT-KIN-011: STSCredentials.providerがStsAssumeRoleCredentialsProvider返却 | E-02 (L75-93) | ○ |
| C-012 | UT-KIN-012: STSCredentials.providerがexternalId付きで返却 | E-02 (L83-87) | ○ |
| C-013 | UT-KIN-013: Builder.basicCredentialsが設定される | E-02 (L120-125) | ○ |
| C-014 | UT-KIN-014: Builder.stsCredentials(2引数)が設定される | E-02 (L136-139) | ○ |
| C-015 | UT-KIN-015: Builder.stsCredentials(3引数)が設定される | E-02 (L152-158) | ○ |
| C-016 | UT-KIN-016: Builder.buildがデフォルトでDefaultCredentials返却 | E-02 (L174-177) | ○ |
| C-017 | UT-KIN-017: Builder.buildがBasicCredentialsのみでBasicCredentials返却 | E-02 (L174-177) | ○ |
| C-018 | UT-KIN-018: Builder.buildがSTSのみでDefaultCredentialsをlongLivedCredsに | E-02 (L174-177) | ○ |
| C-019 | UT-KIN-019: Builder.buildがSTS+BasicでBasicCredentialsをlongLivedCredsに | E-02 (L174-177) | ○ |
| C-020 | UT-KIN-020: KinesisInputDStream.Builder.streamingContext(ssc)が設定 | E-03 (L119-122) | ○ |
| C-021 | UT-KIN-021: KinesisInputDStream.Builder.streamingContext(jssc)が設定 | E-03 (L131-134) | ○ |
| C-022 | UT-KIN-022: KinesisInputDStream.Builder.streamNameが設定 | E-03 (L143-146) | ○ |
| C-023 | UT-KIN-023: KinesisInputDStream.Builder.checkpointAppNameが設定 | E-03 (L156-159) | ○ |
| C-024 | UT-KIN-024: Builder.buildが必須パラメータでDStream生成 | E-03 (L313-331) | ○ |
| C-025 | UT-KIN-025: Builder.buildがstreamingContext未設定でIllegalArgumentException | E-03 (L341-343) | ○ |
| C-026 | UT-KIN-026: Builder.buildがstreamName未設定でIllegalArgumentException | E-03 (L341-343) | ○ |
| C-027 | UT-KIN-027: Builder.buildがcheckpointAppName未設定でIllegalArgumentException | E-03 (L341-343) | ○ |
| C-028 | UT-KIN-028: Builder.buildのデフォルト値が正しい | E-03 (L362-370) | ○ |
| C-029 | UT-KIN-029: buildWithMessageHandlerでカスタムハンドラDStream生成 | E-03 (L313-331) | ○ |
| C-030 | UT-KIN-030: initialPositionInStream(deprecated)が設定 | E-03 (L208-212) | ○ |
| C-031 | UT-KIN-031: defaultMessageHandlerでバイト配列抽出 | E-03 (L354-360) | ○ |
| C-032 | UT-KIN-032: defaultMessageHandlerでnullにnull返却 | E-03 (L355) | ○ |
| C-033 | UT-KIN-033: SequenceNumberRange生成 | E-04 (L45-50) | ○ |
| C-034 | UT-KIN-034: SequenceNumberRanges.isEmpty空でtrue | E-04 (L55) | ○ |
| C-035 | UT-KIN-035: SequenceNumberRanges.isEmpty非空でfalse | E-04 (L55) | ○ |
| C-036 | UT-KIN-036: SequenceNumberRanges.nonEmpty非空でtrue | E-04 (L57) | ○ |
| C-037 | UT-KIN-037: SequenceNumberRanges.nonEmpty空でfalse | E-04 (L57) | ○ |
| C-038 | UT-KIN-038: SequenceNumberRanges.toStringフォーマット | E-04 (L59) | ○ |
| C-039 | UT-KIN-039: SequenceNumberRanges.apply(range)ファクトリ | E-04 (L64-66) | ○ |
| C-040 | UT-KIN-040: KinesisBackedBlockRDD blockIds/seqRanges長さ不一致エラー | E-04 (L96-97) | ○ |
| C-041 | UT-KIN-041: KinesisBackedBlockRDD.isValid常にtrue | E-04 (L99) | ○ |
| C-042 | UT-KIN-042: getPartitionsの正しいパーティション数 | E-04 (L101-106) | ○ |
| C-043 | UT-KIN-043: getPartitions isBlockIdValid空で全true | E-04 (L103) | ○ |
| C-044 | UT-KIN-044: getPartitions isBlockIdValid反映 | E-04 (L103-104) | ○ |
| C-045 | UT-KIN-045: compute BM優先取得 | E-04 (L108-126) | ○ |
| C-046 | UT-KIN-046: compute BMなしでKinesisフォールバック | E-04 (L125-126) | ○ |
| C-047 | UT-KIN-047: compute isBlockIdValid=falseでKinesis直接取得 | E-04 (L127-129) | ○ |
| C-048 | UT-KIN-048: KinesisSequenceRangeIterator.getNextで範囲レコード返却 | E-04 (L164-205) | ○ |
| C-049 | UT-KIN-049: toSeqNumber到達後finished=true | E-04 (L199-201) | ○ |
| C-050 | UT-KIN-050: レコード取得不能でSparkException | E-04 (L184-190) | ○ |
| C-051 | UT-KIN-051: retryOrTimeout正常応答で結果返却 | E-04 (L270-313) | ○ |
| C-052 | UT-KIN-052: retryOrTimeout ProvisionedThroughputExceededでリトライ | E-04 (L294-296) | ○ |
| C-053 | UT-KIN-053: retryOrTimeoutタイムアウトでSparkException | E-04 (L303-307) | ○ |
| C-054 | UT-KIN-054: retryOrTimeout最大リトライ超過でSparkException | E-04 (L308-310) | ○ |
| C-055 | UT-KIN-055: retryOrTimeout非リトライ例外で即座SparkException | E-04 (L297-298) | ○ |
| C-056 | UT-KIN-056: リトライ待ち時間の指数的増加 | E-04 (L286) | △ |
| C-057 | UT-KIN-057: KinesisSequenceRangeIterator.close | E-04 (L207-209) | ○ |
| C-058 | UT-KIN-058: KinesisRecordProcessor.initializeでshardId設定 | E-05 (L52-56) | ○ |
| C-059 | UT-KIN-059: processRecords正常処理 | E-05 (L66-98) | ○ |
| C-060 | UT-KIN-060: processRecordsミニバッチ分割 | E-05 (L76-82) | ○ |
| C-061 | UT-KIN-061: processRecords receiver停止時スキップ | E-05 (L69, L99-104) | ○ |
| C-062 | UT-KIN-062: processRecords後checkpointer設定 | E-05 (L83) | ○ |
| C-063 | UT-KIN-063: processRecords例外リスロー | E-05 (L84-98) | ○ |
| C-064 | UT-KIN-064: leaseLost nullチェックポインタ | E-05 (L114-117) | ○ |
| C-065 | UT-KIN-065: shardEnded checkpointer付きremove | E-05 (L129-136) | ○ |
| C-066 | UT-KIN-066: shardEnded shardId null警告 | E-05 (L131-132) | ○ |
| C-067 | UT-KIN-067: shutdownRequested checkpointer付きremove | E-05 (L147-154) | ○ |
| C-068 | UT-KIN-068: shutdownRequested shardId null警告 | E-05 (L149-150) | ○ |
| C-069 | UT-KIN-069: retryRandom成功時結果返却 | E-05 (L171-174) | ○ |
| C-070 | UT-KIN-070: retryRandom ThrottlingExceptionリトライ成功 | E-05 (L178-184) | ○ |
| C-071 | UT-KIN-071: retryRandom KinesisClientLibDependencyExceptionリトライ | E-05 (L178-184) | ○ |
| C-072 | UT-KIN-072: retryRandom ShutdownException即座スロー | E-05 (L186-188) | ○ |
| C-073 | UT-KIN-073: retryRandom InvalidStateException即座スロー | E-05 (L190-192) | ○ |
| C-074 | UT-KIN-074: retryRandom未知例外即座スロー | E-05 (L194-196) | ○ |
| C-075 | UT-KIN-075: retryRandomリトライ回数1で例外スロー | E-05 (L179) | ○ |
| C-076 | UT-KIN-076: setCheckpointer登録 | E-06 (L53-55) | ○ |
| C-077 | UT-KIN-077: removeCheckpointer非null最終チェックポイント | E-06 (L63-81) | ○ |
| C-078 | UT-KIN-078: removeCheckpointer null時チェックポイントなし | E-06 (L67) | ○ |
| C-079 | UT-KIN-079: removeCheckpointer例外リスロー | E-06 (L73-79) | ○ |
| C-080 | UT-KIN-080: checkpoint新シーケンス番号でチェックポイント実行 | E-06 (L85-107) | ○ |
| C-081 | UT-KIN-081: checkpointシーケンス番号比較 | E-06 (L92) | ○ |
| C-082 | UT-KIN-082: checkpointシーケンス番号以下スキップ | E-06 (L92) | ○ |
| C-083 | UT-KIN-083: checkpoint checkpointer nullスキップ | E-06 (L87, L100-101) | ○ |
| C-084 | UT-KIN-084: checkpoint latestSeqNum Noneスキップ | E-06 (L88) | ○ |
| C-085 | UT-KIN-085: checkpoint例外キャッチログ出力 | E-06 (L103-106) | ○ |
| C-086 | UT-KIN-086: checkpointAll全シャードチェックポイント | E-06 (L110-122) | ○ |
| C-087 | UT-KIN-087: checkpointAll空シャード | E-06 (L110-122) | ○ |
| C-088 | UT-KIN-088: shutdown正常終了 | E-06 (L139-145) | ○ |
| C-089 | UT-KIN-089: addRecords正常追加 | E-07 (L258-266) | ○ |
| C-090 | UT-KIN-090: addRecords空リスト | E-07 (L259) | ○ |
| C-091 | UT-KIN-091: addRecords SequenceNumberRange生成 | E-07 (L261-263) | ○ |
| C-092 | UT-KIN-092: getCurrentLimit返却 | E-07 (L269-272) | ○ |
| C-093 | UT-KIN-093: getCurrentLimit上限クランプ | E-07 (L271) | ○ |
| C-094 | UT-KIN-094: getLatestSeqNumToCheckpoint登録済み | E-07 (L275-277) | ○ |
| C-095 | UT-KIN-095: getLatestSeqNumToCheckpoint未登録None | E-07 (L276) | ○ |
| C-096 | UT-KIN-096: setCheckpointer委譲 | E-07 (L283-286) | ○ |
| C-097 | UT-KIN-097: setCheckpointer未初期化AssertionError | E-07 (L284) | ○ |
| C-098 | UT-KIN-098: removeCheckpointer委譲 | E-07 (L293-296) | ○ |
| C-099 | UT-KIN-099: removeCheckpointer未初期化AssertionError | E-07 (L294) | ○ |
| C-100 | UT-KIN-100: KinesisReadConfigurations.apply()デフォルト | E-08 (L39-43) | ○ |
| C-101 | UT-KIN-101: KinesisReadConfigurations.apply(ssc) SparkConf読込 | E-08 (L45-51) | ○ |
| C-102 | UT-KIN-102: KinesisReadConfigurations.apply(ssc)デフォルトフォールバック | E-08 (L47-49) | ○ |
| C-103 | UT-KIN-103: createStreamデフォルト認証 | E-09 (L33-101) | ○ |
| C-104 | UT-KIN-104: createStream Basic認証 | E-09 (L97-98) | ○ |
| C-105 | UT-KIN-105: createStream STS認証 | E-09 (L87-93) | ○ |
| C-106 | UT-KIN-106: createStream STS部分設定エラー | E-09 (L49-53) | ○ |
| C-107 | UT-KIN-107: createStream awsAccessKeyIdのみエラー | E-09 (L56-57) | ○ |
| C-108 | UT-KIN-108: createStream awsSecretKeyのみエラー | E-09 (L54-55) | ○ |
| C-109 | UT-KIN-109: createStream initialPositionInStream=0 LATEST | E-09 (L62) | ○ |
| C-110 | UT-KIN-110: createStream initialPositionInStream=1 TRIM_HORIZON | E-09 (L63) | ○ |
| C-111 | UT-KIN-111: createStream initialPositionInStream=2 エラー | E-09 (L64-66) | ○ |
| C-112 | UT-KIN-112: createStream metricsLevel=0 DETAILED | E-09 (L70) | ○ |
| C-113 | UT-KIN-113: createStream metricsLevel=1 SUMMARY | E-09 (L71) | ○ |
| C-114 | UT-KIN-114: createStream metricsLevel=2 NONE | E-09 (L72) | ○ |
| C-115 | UT-KIN-115: createStream metricsLevel=99 DETAILEDフォールバック | E-09 (L73) | ○ |
| C-116 | UT-KIN-116: createBlockRDDメタデータありKinesisBackedBlockRDD | E-03 (L53-72) | ○ |
| C-117 | UT-KIN-117: createBlockRDDメタデータなしフォールバック | E-03 (L74-77) | ○ |
| C-118 | UT-KIN-118: createBlockRDD空blockInfos | E-03 (L56) | ○ |
| C-119 | UT-KIN-119: getReceiver正しいパラメータ | E-03 (L80-85) | ○ |
| C-120 | UT-KIN-120: getRegionNameByEndpoint正常系 | E-10 (L25-34) | △ |
| C-121 | UT-KIN-121: getRegionNameByEndpoint無効エンドポイントエラー | E-10 (L32-33) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-010**: BasicCredentialsのnull入力時にStaticCredentialsProvider.create()がIllegalArgumentExceptionをスローする条件は、AWS SDK v2の実装に依存しており、SDKバージョンによって挙動が異なる可能性がある
  - 候補：AWS SDK v2 JavaDocの確認 / StaticCredentialsProviderのソースコード確認
- **C-056**: retryOrTimeoutメソッドのwaitTimeInterval *= 2の動作はコード上明確だが、テストで時間経過を正確に検証するのは難しい
  - 候補：ManualClock等のテスト用ユーティリティの使用 / waitTimeIntervalの変化のみを検証
- **C-120**: KinesisExampleUtilsのgetRegionNameByEndpointは、AWS SDKのKinesisServiceMetadataが返すリージョン一覧に依存しており、テスト環境でのSDK利用可否の確認が必要
  - 候補：AWS SDKのKinesisServiceMetadataの振る舞いを確認 / モック化の検討

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - KinesisInitialPositions, SequenceNumberRange/Ranges, KinesisReadConfigurations等の純粋なデータクラス/ファクトリ (UT-KIN-001~007, 033~039, 100~102)
- 0: 低リスク - SparkAWSCredentials.Builder のビルダーパターン設定メソッド (UT-KIN-013~023)
- 1: 中リスク - KinesisRecordProcessor.retryRandom / KinesisSequenceRangeIterator.retryOrTimeout のリトライ/タイムアウト機構 (UT-KIN-051~056, 069~075) - 外部サービス依存の境界条件
- 1: 中リスク - KinesisCheckpointer のチェックポイント処理 (UT-KIN-076~088) - 並行処理/状態管理が関わる
- 1: 中リスク - KinesisRecordProcessor.processRecords のレコード処理 (UT-KIN-059~063) - レート制限やバッチ分割のロジック
- 2: 高リスク - KinesisBackedBlockRDD.compute のBlockManager/Kinesisフォールバック (UT-KIN-045~047) - 障害復旧パスの検証が重要
- 1: 中リスク - KinesisUtilsPythonHelper.createStream のパラメータバリデーション (UT-KIN-103~115) - Python API互換性

## 6) レビュアーチェックリスト（最小）
- [ ] KinesisInitialPositions.fromKinesisInitialPositionのAT_TIMESTAMP非サポート例外メッセージが適切か確認
- [ ] BasicCredentials.providerのフォールバック条件がAWS SDK v2で正しく動作するか確認
- [ ] STSCredentials.providerのexternalId有無による分岐が正しくテストされているか確認
- [ ] KinesisInputDStream.BuilderのgetRequiredParamの例外メッセージにパラメータ名が含まれるか確認
- [ ] KinesisInputDStream.defaultMessageHandlerのnullチェックがnullレコードを正しく処理するか確認
- [ ] KinesisBackedBlockRDD.computeのBlockManager->Kinesisフォールバックパスが網羅されているか確認
- [ ] KinesisSequenceRangeIterator.retryOrTimeoutの指数バックオフの実装が正しく動作するか確認
- [ ] KinesisRecordProcessor.processRecordsのミニバッチ分割ロジック(境界値含む)が正しいか確認
- [ ] KinesisCheckpointer.checkpointのシーケンス番号文字列比較が正しいか確認（数値的大小ではなく辞書順）
- [ ] KinesisCheckpointer.removeCheckpointerのretryRandom呼び出しが正しい引数で行われているか確認
- [ ] KinesisUtilsPythonHelper.createStreamのSTS/Basic認証パラメータバリデーションが全パターン網羅されているか確認
- [ ] KinesisExampleUtils.getRegionNameByEndpointがAWS SDKのKinesisServiceMetadataに正しく依存しているか確認
