---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 74
  claims_with_evidence: 72
  claims_without_evidence: 2
confidence_derived: 0.97
---

# 根拠レポート：connector-profiler 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：72 / 74、根拠なし：2
- 優先レビュー（高）
  1. **C-11（UT-PRF-011）**：fraction=0.5の確率的動作テスト - 乱数のモック化方法に依存するため実装戦略の確認が必要
  2. **C-50（UT-PRF-050）**：writeChunkのappId待機ループ - Thread.sleep(1000L)を含むループのテスト方法要検討

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `connector/profiler/src/main/scala/org/apache/spark/profiler/ProfilerPlugin.scala` - ProfilerPlugin, ProfilerDriverPlugin, ProfilerExecutorPlugin クラス定義（行32-97）
- E-02: `connector/profiler/src/main/scala/org/apache/spark/profiler/package.scala` - package object profiler 設定定義（行23-78）
- E-03: `connector/profiler/src/main/scala/org/apache/spark/profiler/SparkAsyncProfiler.scala` - SparkAsyncProfiler クラス定義（行36-218）
- E-04: `connector/profiler/src/main/scala/org/apache/spark/profiler/SparkAsyncProfiler.scala` 行48-52 - profileFileのパターンマッチ（DRIVER_IDENTIFIER判定）
- E-05: `connector/profiler/src/main/scala/org/apache/spark/profiler/SparkAsyncProfiler.scala` 行54-57 - startcmd/stopcmd/dumpcmd/resumecmd文字列構築
- E-06: `connector/profiler/src/main/scala/org/apache/spark/profiler/SparkAsyncProfiler.scala` 行59-61 - 定数値定義（PROFILER_FOLDER_PERMISSIONS, PROFILER_FILE_PERMISSIONS, UPLOAD_SIZE）
- E-07: `connector/profiler/src/main/scala/org/apache/spark/profiler/SparkAsyncProfiler.scala` 行71-78 - profiler lazyフィールド（AsyncProfilerLoader判定）
- E-08: `connector/profiler/src/main/scala/org/apache/spark/profiler/SparkAsyncProfiler.scala` 行80-95 - start()メソッド（例外ハンドリング含む）
- E-09: `connector/profiler/src/main/scala/org/apache/spark/profiler/SparkAsyncProfiler.scala` 行98-107 - stop()メソッド
- E-10: `connector/profiler/src/main/scala/org/apache/spark/profiler/SparkAsyncProfiler.scala` 行109-114 - requireProfilerBaseDirAsDirectory()メソッド
- E-11: `connector/profiler/src/main/scala/org/apache/spark/profiler/SparkAsyncProfiler.scala` 行116-143 - startWriting()メソッド
- E-12: `connector/profiler/src/main/scala/org/apache/spark/profiler/SparkAsyncProfiler.scala` 行146-197 - writeChunk()メソッド
- E-13: `connector/profiler/src/main/scala/org/apache/spark/profiler/SparkAsyncProfiler.scala` 行199-217 - finishWriting()メソッド
- E-14: `connector/profiler/src/main/scala/org/apache/spark/profiler/SparkAsyncProfiler.scala` 行45-46 - getAppId/getAttemptIdメソッド
- E-15: `connector/profiler/src/main/scala/org/apache/spark/profiler/package.scala` 行25-30 - PROFILER_DRIVER_ENABLED定義
- E-16: `connector/profiler/src/main/scala/org/apache/spark/profiler/package.scala` 行32-37 - PROFILER_EXECUTOR_ENABLED定義
- E-17: `connector/profiler/src/main/scala/org/apache/spark/profiler/package.scala` 行39-46 - PROFILER_EXECUTOR_FRACTION定義（checkValue含む）
- E-18: `connector/profiler/src/main/scala/org/apache/spark/profiler/package.scala` 行48-53 - PROFILER_DFS_DIR定義
- E-19: `connector/profiler/src/main/scala/org/apache/spark/profiler/package.scala` 行55-61 - PROFILER_LOCAL_DIR定義
- E-20: `connector/profiler/src/main/scala/org/apache/spark/profiler/package.scala` 行63-68 - PROFILER_ASYNC_PROFILER_OPTIONS定義
- E-21: `connector/profiler/src/main/scala/org/apache/spark/profiler/package.scala` 行70-76 - PROFILER_DFS_WRITE_INTERVAL定義（checkValue含む）
- E-22: `connector/profiler/src/main/scala/org/apache/spark/profiler/ProfilerPlugin.scala` 行45-56 - ProfilerDriverPlugin.init()メソッド
- E-23: `connector/profiler/src/main/scala/org/apache/spark/profiler/ProfilerPlugin.scala` 行58-63 - ProfilerDriverPlugin.shutdown()メソッド
- E-24: `connector/profiler/src/main/scala/org/apache/spark/profiler/ProfilerPlugin.scala` 行75-89 - ProfilerExecutorPlugin.init()メソッド
- E-25: `connector/profiler/src/main/scala/org/apache/spark/profiler/ProfilerPlugin.scala` 行91-96 - ProfilerExecutorPlugin.shutdown()メソッド
- E-26: `connector/profiler/src/main/scala/org/apache/spark/profiler/ProfilerPlugin.scala` 行81 - rand.nextInt(100) * 0.01 による抽選ロジック

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-PRF-001: driverPlugin()がProfilerDriverPluginインスタンスを返す | E-01 (行33) | ○ |
| C-02 | UT-PRF-002: executorPlugin()がProfilerExecutorPluginインスタンスを返す | E-01 (行35) | ○ |
| C-03 | UT-PRF-003: driver.enabled=trueでプロファイラーが起動する | E-22 (行49-53) | ○ |
| C-04 | UT-PRF-004: driver.enabled=falseでプロファイラーが起動しない | E-22 (行49) | ○ |
| C-05 | UT-PRF-005: init()が空のJava Mapを返す | E-22 (行55) | ○ |
| C-06 | UT-PRF-006: profiler非nullでshutdown時にstop()が呼ばれる | E-23 (行60-62) | ○ |
| C-07 | UT-PRF-007: profiler nullでshutdown時にNPEが起きない | E-23 (行60) | ○ |
| C-08 | UT-PRF-008: executor.enabled=true, fraction=1.0でプロファイラーが起動する | E-24 (行79-86), E-26 | ○ |
| C-09 | UT-PRF-009: executor.enabled=falseでプロファイラーが起動しない | E-24 (行78-79) | ○ |
| C-10 | UT-PRF-010: fraction=0.0でプロファイラーが起動しない | E-24 (行81), E-26 | ○ |
| C-11 | UT-PRF-011: fraction=0.5で確率的にプロファイラーが起動する | E-26 | △ |
| C-12 | UT-PRF-012: エグゼキュータprofiler非nullでshutdown時にstop()が呼ばれる | E-25 (行93-95) | ○ |
| C-13 | UT-PRF-013: エグゼキュータprofiler nullでshutdown時にNPEが起きない | E-25 (行93) | ○ |
| C-14 | UT-PRF-014: PROFILER_DRIVER_ENABLEDデフォルト値=false | E-15 (行30) | ○ |
| C-15 | UT-PRF-015: PROFILER_EXECUTOR_ENABLEDデフォルト値=false | E-16 (行37) | ○ |
| C-16 | UT-PRF-016: PROFILER_EXECUTOR_FRACTIONデフォルト値=0.1 | E-17 (行46) | ○ |
| C-17 | UT-PRF-017: fraction=0.0が受け入れられる | E-17 (行44: v >= 0.0) | ○ |
| C-18 | UT-PRF-018: fraction=1.0が受け入れられる | E-17 (行44: v <= 1.0) | ○ |
| C-19 | UT-PRF-019: fraction=-0.1が拒否される | E-17 (行44: v >= 0.0) | ○ |
| C-20 | UT-PRF-020: fraction=1.1が拒否される | E-17 (行44: v <= 1.0) | ○ |
| C-21 | UT-PRF-021: PROFILER_LOCAL_DIRデフォルト値="." | E-19 (行61) | ○ |
| C-22 | UT-PRF-022: PROFILER_ASYNC_PROFILER_OPTIONSデフォルト値 | E-20 (行68) | ○ |
| C-23 | UT-PRF-023: PROFILER_DFS_WRITE_INTERVALデフォルト値=30 | E-21 (行76) | ○ |
| C-24 | UT-PRF-024: writeInterval負値が拒否される | E-21 (行75: >= 0) | ○ |
| C-25 | UT-PRF-025: writeInterval=0が受け入れられる | E-21 (行75: >= 0) | ○ |
| C-26 | UT-PRF-026: PROFILER_DFS_DIRデフォルト=None | E-18 (行53: createOptional) | ○ |
| C-27 | UT-PRF-027: ドライバーのprofileFile名="profile-driver.jfr" | E-04 (行48-49) | ○ |
| C-28 | UT-PRF-028: エグゼキュータのprofileFile名="profile-exec-{id}.jfr" | E-04 (行50-51) | ○ |
| C-29 | UT-PRF-029: startcmdの構築フォーマット | E-05 (行54) | ○ |
| C-30 | UT-PRF-030: stopcmdの構築フォーマット | E-05 (行55) | ○ |
| C-31 | UT-PRF-031: dumpcmdの構築フォーマット | E-05 (行56) | ○ |
| C-32 | UT-PRF-032: resumecmdの構築フォーマット | E-05 (行57) | ○ |
| C-33 | UT-PRF-033: AsyncProfilerサポート時にSomeが返る | E-07 (行73-76) | ○ |
| C-34 | UT-PRF-034: AsyncProfiler非サポート時にNoneが返る | E-07 (行73, 76) | ○ |
| C-35 | UT-PRF-035: 未起動時のstart()でプロファイリング開始 | E-08 (行81-88) | ○ |
| C-36 | UT-PRF-036: 起動中のstart()は何もしない | E-08 (行81) | ○ |
| C-37 | UT-PRF-037: IllegalArgumentExceptionのキャッチ | E-08 (行90) | ○ |
| C-38 | UT-PRF-038: IllegalStateExceptionのキャッチ | E-08 (行90) | ○ |
| C-39 | UT-PRF-039: IOExceptionのキャッチ | E-08 (行90) | ○ |
| C-40 | UT-PRF-040: その他例外のlogWarning | E-08 (行92) | ○ |
| C-41 | UT-PRF-041: profiler=Noneでstart()が何もしない | E-08 (行83: profiler.foreach) | ○ |
| C-42 | UT-PRF-042: 起動中のstop()でプロファイリング停止 | E-09 (行99-106) | ○ |
| C-43 | UT-PRF-043: 未起動時のstop()は何もしない | E-09 (行99) | ○ |
| C-44 | UT-PRF-044: ディレクトリ判定で正常パス | E-10 (行110) | ○ |
| C-45 | UT-PRF-045: ディレクトリ判定で非ディレクトリ時のIAE | E-10 (行111-113) | ○ |
| C-46 | UT-PRF-046: DFS設定時にスレッドプール起動 | E-11 (行117-129) | ○ |
| C-47 | UT-PRF-047: DFS未設定時にスレッドプール非起動 | E-11 (行117: profilerDfsDirOpt.foreach) | ○ |
| C-48 | UT-PRF-048: startWritingの例外時リソースクリーンアップ | E-11 (行130-142) | ○ |
| C-49 | UT-PRF-049: writing=falseでwriteChunkが即座にreturn | E-12 (行147-149) | ○ |
| C-50 | UT-PRF-050: outputStream未初期化時のappId待機と初期化 | E-12 (行151-172) | △ |
| C-51 | UT-PRF-051: lastChunk=falseでstop/dump/resume/write実行 | E-12 (行179-183) | ○ |
| C-52 | UT-PRF-052: lastChunk=trueでresume未実行 | E-12 (行182-183) | ○ |
| C-53 | UT-PRF-053: writeChunkのIOExceptionハンドリング | E-12 (行191) | ○ |
| C-54 | UT-PRF-054: writeChunkのIllegalArgumentExceptionハンドリング | E-12 (行192) | ○ |
| C-55 | UT-PRF-055: writeChunkのIllegalStateExceptionハンドリング | E-12 (行192) | ○ |
| C-56 | UT-PRF-056: writeChunkの予期しない例外ハンドリング | E-12 (行195) | ○ |
| C-57 | UT-PRF-057: DFSディレクトリのPROFILER_FOLDER_PERMISSIONS(770)作成 | E-12 (行168), E-06 (行59) | ○ |
| C-58 | UT-PRF-058: 既存DFSディレクトリの非再作成 | E-12 (行166-169) | ○ |
| C-59 | UT-PRF-059: PROFILER_FILE_PERMISSIONS(660)でファイル作成 | E-12 (行172), E-06 (行60) | ○ |
| C-60 | UT-PRF-060: finishWritingの正常終了フロー | E-13 (行200-213) | ○ |
| C-61 | UT-PRF-061: DFS未設定時finishWritingスキップ | E-13 (行200) | ○ |
| C-62 | UT-PRF-062: writing=false時finishWritingスキップ | E-13 (行200) | ○ |
| C-63 | UT-PRF-063: InterruptedException時の割り込みフラグ設定 | E-13 (行210) | ○ |
| C-64 | UT-PRF-064: IOException時のlogWarningとwriting=false | E-13 (行211-213, 216) | ○ |
| C-65 | UT-PRF-065: getAppIdでspark.app.id設定時にSome返却 | E-14 (行45) | ○ |
| C-66 | UT-PRF-066: getAppIdでspark.app.id未設定時にNone返却 | E-14 (行45) | ○ |
| C-67 | UT-PRF-067: getAttemptIdでspark.app.attempt.id設定時にSome返却 | E-14 (行46) | ○ |
| C-68 | UT-PRF-068: getAttemptIdでspark.app.attempt.id未設定時にNone返却 | E-14 (行46) | ○ |
| C-69 | UT-PRF-069: UPLOAD_SIZE=8MB | E-06 (行61) | ○ |
| C-70 | UT-PRF-070: PROFILER_FOLDER_PERMISSIONS=770 | E-06 (行59) | ○ |
| C-71 | UT-PRF-071: PROFILER_FILE_PERMISSIONS=660 | E-06 (行60) | ○ |
| C-72 | UT-PRF-072: available()=0時のデータ書き込みスキップ | E-12 (行185-189) | ○ |
| C-73 | UT-PRF-073: UPLOAD_SIZE超過時の複数回read | E-12 (行185-189) | ○ |
| C-74 | UT-PRF-074: awaitTerminationの30秒タイムアウト | E-13 (行204) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-11（UT-PRF-011）**: fraction=0.5の確率的動作テストは、`rand.nextInt(100) * 0.01 < executorProfilerFraction`（行81）のロジックに基づくが、乱数生成器のモック化方法はテスト実装戦略に依存する。ソースコードの`rand`フィールドはprivateであるため、リフレクションや依存性注入による差し替えが必要。
  - 候補: Randomのモック化 / 固定シードのRandom注入 / リフレクションによるfieldの差し替え
- **C-50（UT-PRF-050）**: writeChunk内のappId待機ループ（行152-155）はThread.sleep(1000L)を含むため、テスト時のタイミング制御が複雑になる可能性がある。
  - 候補: SparkConfへの事前設定 / タイムアウト付きテスト / 非同期テストフレームワーク

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）: 設定値のデフォルト確認テスト（UT-PRF-014〜026）- ソースコードで明確に確認可能
- 0（低リスク）: コマンド文字列構築テスト（UT-PRF-029〜032）- 文字列補間で明確
- 0（低リスク）: null安全性テスト（UT-PRF-007, 013）- if文で明確にガードされている
- 1（中リスク）: 例外ハンドリングテスト（UT-PRF-037〜040, 053〜056）- catch句のパターンマッチが正しいか確認推奨
- 1（中リスク）: DFS書き込み関連テスト（UT-PRF-046〜059）- Hadoop FileSystemのモック化が必要
- 2（高リスク）: 確率的テスト（UT-PRF-011）- 乱数のモック化戦略が未確定

## 6) レビュアーチェックリスト（最小）
- [ ] 全74テストケースが正常系/異常系/境界値の観点を適切にカバーしているか
- [ ] ProfilerExecutorPluginのfraction抽選ロジック（行81: `rand.nextInt(100) * 0.01 < executorProfilerFraction`）のテストケースが十分か
- [ ] SparkAsyncProfilerのwriteChunk()メソッドの全条件分岐がカバーされているか
- [ ] 例外ハンドリングのテストケースが全catch句に対応しているか
- [ ] DFS関連のテスト（startWriting/writeChunk/finishWriting）でHadoop FileSystemのモック戦略が妥当か
- [ ] PROFILER_EXECUTOR_FRACTIONとPROFILER_DFS_WRITE_INTERVALのcheckValue境界値テストが十分か
- [ ] privateメソッド（getAppId, getAttemptId, requireProfilerBaseDirAsDirectory等）のテスト方法が妥当か（リフレクション or 間接テスト）
