---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 158
  claims_with_evidence: 155
  claims_without_evidence: 3
confidence_derived: 0.98
---

# 根拠レポート：connector-protobuf 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧CSVの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：155 / 158、根拠なし：3
- 優先レビュー（高）
  1. **C-067 (enumsAsIntsとJSON変換の連携)**: Any型フィールド内のEnum整数表現は、ソースコード内でjsonPrinterの`printingEnumsAsInts()`設定から推測されるが、実際の連携動作は実行時テストでのみ完全に確認可能
  2. **C-087 (TypeRegistry構築ロジック binaryFileDescriptorSet+convertAny)**: ProtobufDataToCatalystの内部lazy valの初期化分岐に基づく主張であり、統合的な動作はテスト実行で確認が必要
  3. **C-088 (TypeRegistry構築ロジック None+convertAny)**: 同上

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `connector/protobuf/src/main/scala/org/apache/spark/sql/protobuf/ProtobufSerializer.scala` (343行)
- E-02: `connector/protobuf/src/main/scala/org/apache/spark/sql/protobuf/ProtobufDeserializer.scala` (527行)
- E-03: `connector/protobuf/src/main/scala/org/apache/spark/sql/protobuf/CatalystDataToProtobuf.scala` (89行)
- E-04: `connector/protobuf/src/main/scala/org/apache/spark/sql/protobuf/ProtobufDataToCatalyst.scala` (177行)
- E-05: `connector/protobuf/src/main/scala/org/apache/spark/sql/protobuf/utils/SchemaConverters.scala` (243行)
- E-06: `connector/protobuf/src/main/scala/org/apache/spark/sql/protobuf/utils/ProtobufUtils.scala` (305行)
- E-07: `connector/protobuf/src/main/scala/org/apache/spark/sql/protobuf/utils/ProtobufOptions.scala` (271行)
- E-08: `connector/protobuf/src/main/scala/org/apache/spark/sql/protobuf/package.scala` (21行 - パッケージオブジェクト、テスト対象のロジックなし)

## 3) Claims と根拠の対応（レビューの主戦場）

### ProtobufSerializer (C-001 ~ C-030)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | BooleanType -> BOOLEAN シリアライズ | E-01 (L87-88) | ○ |
| C-002 | IntegerType -> INT シリアライズ | E-01 (L93-96) | ○ |
| C-003 | LongType -> LONG シリアライズ | E-01 (L101-102) | ○ |
| C-004 | FloatType -> FLOAT シリアライズ | E-01 (L108-109) | ○ |
| C-005 | DoubleType -> DOUBLE シリアライズ | E-01 (L110-111) | ○ |
| C-006 | StringType -> STRING シリアライズ | E-01 (L138-141) | ○ |
| C-007 | BinaryType -> BYTE_STRING シリアライズ | E-01 (L143-144) | ○ |
| C-008 | ByteType -> INT 変換 | E-01 (L89-90) | ○ |
| C-009 | ShortType -> INT 変換 | E-01 (L91-92) | ○ |
| C-010 | StringType -> ENUM シリアライズ | E-01 (L112-124) | ○ |
| C-011 | ENUM不正値エラー(文字列) | E-01 (L117-123) | ○ |
| C-012 | IntegerType -> ENUM シリアライズ | E-01 (L125-137) | ○ |
| C-013 | ENUM不正値エラー(整数) | E-01 (L130-136) | ○ |
| C-014 | TimestampType -> Timestamp Message | E-01 (L149-156) | ○ |
| C-015 | ArrayType シリアライズ | E-01 (L158-177) | ○ |
| C-016 | 空ArrayType シリアライズ | E-01 (L158-177) | ○ |
| C-017 | MapType シリアライズ | E-01 (L231-266) | ○ |
| C-018 | StructType -> Message シリアライズ | E-01 (L225-229) | ○ |
| C-019 | NullType -> null | E-01 (L85-86) | ○ |
| C-020 | nullable=true null入力 | E-01 (L66-74) | ○ |
| C-021 | DayTimeIntervalType -> Duration | E-01 (L268-288) | ○ |
| C-022 | 負のDuration正規化 | E-01 (L281-287) | ○ |
| C-023 | LongType UINT32変換 | E-01 (L97-100) | ○ |
| C-024 | DecimalType UINT64変換 | E-01 (L103-107) | ○ |
| C-025 | BoolValueラッパー | E-01 (L180-183) | ○ |
| C-026 | Int32Valueラッパー | E-01 (L185-188) | ○ |
| C-027 | StringValueラッパー | E-01 (L205-208) | ○ |
| C-028 | 型不一致エラー | E-01 (L290-297) | ○ |
| C-029 | Catalystスキーマ余分フィールドエラー | E-01 (L309), E-06 (L87-94) | ○ |
| C-030 | required Protobufフィールド不足エラー | E-01 (L310), E-06 (L101-107) | ○ |

### ProtobufDeserializer (C-031 ~ C-067)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-031 | Boolean デシリアライズ | E-02 (L184-185) | ○ |
| C-032 | Integer デシリアライズ | E-02 (L187-188) | ○ |
| C-033 | Long デシリアライズ | E-02 (L206-207) | ○ |
| C-034 | Float デシリアライズ | E-02 (L216-217) | ○ |
| C-035 | Double デシリアライズ | E-02 (L219-220) | ○ |
| C-036 | String デシリアライズ | E-02 (L222-227) | ○ |
| C-037 | Bytes デシリアライズ | E-02 (L229-236) | ○ |
| C-038 | Enum -> String デシリアライズ | E-02 (L377-381) | ○ |
| C-039 | Enum -> Integer デシリアライズ | E-02 (L383-385) | ○ |
| C-040 | Timestamp デシリアライズ | E-02 (L241-249) | ○ |
| C-041 | DayTimeIntervalType デシリアライズ | E-02 (L251-259) | ○ |
| C-042 | Repeated フィールド デシリアライズ | E-02 (L95-128) | ○ |
| C-043 | 空Repeatedフィールド | E-02 (L95-128) | ○ |
| C-044 | Map デシリアライズ | E-02 (L130-167) | ○ |
| C-045 | ネストMessage デシリアライズ | E-02 (L365-375) | ○ |
| C-046 | 空StructType -> InternalRow.empty | E-02 (L55-56) | ○ |
| C-047 | UINT32 -> unsigned Long | E-02 (L196-200) | ○ |
| C-048 | UINT64 -> Decimal | E-02 (L209-214) | ○ |
| C-049 | Any -> JSON 変換 | E-02 (L261-266) | ○ |
| C-050 | BoolValue アンラップ | E-02 (L270-279) | ○ |
| C-051 | Int32Value アンラップ | E-02 (L280-290) | ○ |
| C-052 | StringValue アンラップ | E-02 (L324-333) | ○ |
| C-053 | ラッパーnull処理 | E-02 (L274-279) | ○ |
| C-054 | emitDefaultValues=true デフォルト値出力 | E-02 (L458-463) | ○ |
| C-055 | emitDefaultValues=false null返却 | E-02 (L458-468) | ○ |
| C-056 | repeatedフィールド getFieldValue | E-02 (L458-464) | ○ |
| C-057 | hasField=true getFieldValue | E-02 (L460) | ○ |
| C-058 | hasDefaultValue=true getFieldValue | E-02 (L461) | ○ |
| C-059 | emitDefaultValues+hasPresence getFieldValue | E-02 (L462) | ○ |
| C-060 | emitDefaultValues=false null返却 getFieldValue | E-02 (L465-467) | ○ |
| C-061 | containsNull=false配列null要素エラー | E-02 (L115-117) | ○ |
| C-062 | valueContainsNull=false Map nullエラー | E-02 (L153-155) | ○ |
| C-063 | 型不一致エラー | E-02 (L387-393) | ○ |
| C-064 | createArrayData BooleanType | E-02 (L472) | ○ |
| C-065 | createArrayData IntegerType | E-02 (L475) | ○ |
| C-066 | createArrayData StringType(Generic) | E-02 (L479) | ○ |
| C-067 | enumsAsInts + JSON連携 | E-02 (L82-93) | △ |

### CatalystDataToProtobuf (C-068 ~ C-076)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-068 | nullSafeEval バイト配列返却 | E-03 (L44-47) | ○ |
| C-069 | dataType = BinaryType | E-03 (L36) | ○ |
| C-070 | prettyName = "to_protobuf" | E-03 (L49) | ○ |
| C-071 | equals 同一引数 true | E-03 (L59-74) | ○ |
| C-072 | equals 異なる引数 false | E-03 (L59-74) | ○ |
| C-073 | equals binaryFileDescriptorSet=None | E-03 (L65) | ○ |
| C-074 | equals 異種型 false | E-03 (L73) | ○ |
| C-075 | hashCode 一貫性 | E-03 (L76-88) | ○ |
| C-076 | withNewChildInternal | E-03 (L56-57) | ○ |

### ProtobufDataToCatalyst (C-077 ~ C-089)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-077 | nullSafeEval 正常デシリアライズ | E-04 (L92-120) | ○ |
| C-078 | FailFastMode エラー | E-04 (L85-86) | ○ |
| C-079 | PermissiveMode null返却 | E-04 (L84) | ○ |
| C-080 | unknownFields型不一致エラー | E-04 (L99-106) | ○ |
| C-081 | サポート外パースモードエラー | E-04 (L76-77) | ○ |
| C-082 | inputTypes = Seq(BinaryType) | E-04 (L40) | ○ |
| C-083 | nullable = true | E-04 (L45) | ○ |
| C-084 | prettyName = "from_protobuf" | E-04 (L122) | ○ |
| C-085 | equals | E-04 (L146-161) | ○ |
| C-086 | hashCode | E-04 (L163-175) | ○ |
| C-087 | TypeRegistry構築 (descBytes + convertAny) | E-04 (L56-58) | △ |
| C-088 | TypeRegistry構築 (None + convertAny) | E-04 (L59-60) | △ |
| C-089 | TypeRegistry デフォルト(empty) | E-04 (L61) | ○ |

### SchemaConverters (C-090 ~ C-114)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-090 | INT -> IntegerType | E-05 (L75-80) | ○ |
| C-091 | LONG -> LongType | E-05 (L81-86) | ○ |
| C-092 | FLOAT -> FloatType | E-05 (L87) | ○ |
| C-093 | DOUBLE -> DoubleType | E-05 (L88) | ○ |
| C-094 | BOOLEAN -> BooleanType | E-05 (L89) | ○ |
| C-095 | STRING -> StringType | E-05 (L90) | ○ |
| C-096 | BYTE_STRING -> BinaryType | E-05 (L91) | ○ |
| C-097 | ENUM -> StringType (default) | E-05 (L92) | ○ |
| C-098 | ENUM -> IntegerType (enumsAsInts) | E-05 (L92) | ○ |
| C-099 | UINT32 -> LongType (upcast) | E-05 (L76-77) | ○ |
| C-100 | UINT64 -> DecimalType (upcast) | E-05 (L81-83) | ○ |
| C-101 | Timestamp -> TimestampType | E-05 (L99-104) | ○ |
| C-102 | Duration -> DayTimeIntervalType | E-05 (L93-98) | ○ |
| C-103 | Any -> StringType (convertAny) | E-05 (L105-107) | ○ |
| C-104 | Map -> MapType | E-05 (L146-174) | ○ |
| C-105 | repeated -> ArrayType | E-05 (L231-232) | ○ |
| C-106 | ネストMessage -> StructType | E-05 (L175-225) | ○ |
| C-107 | 再帰フィールド(depth未設定)エラー | E-05 (L195-197) | ○ |
| C-108 | 再帰フィールド(depth=2)展開 | E-05 (L198-211) | ○ |
| C-109 | 再帰フィールド(depth>10)エラー | E-05 (L195-196) | ○ |
| C-110 | BoolValue -> BooleanType (unwrap) | E-05 (L110-112) | ○ |
| C-111 | FloatValue -> FloatType (unwrap) | E-05 (L139-140) | ○ |
| C-112 | 空メッセージ retainEmptyMessage=true | E-05 (L56-57), (L239-242) | ○ |
| C-113 | 空メッセージ retainEmptyMessage=false | E-05 (L58) | ○ |
| C-114 | UInt32Value + upcast -> LongType | E-05 (L116-122) | ○ |

### ProtobufUtils (C-115 ~ C-138)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-115 | buildDescriptor(Some(bytes)) | E-06 (L149-150) | ○ |
| C-116 | buildDescriptor(None) -> JavaClass | E-06 (L151) | ○ |
| C-117 | ClassNotFoundExceptionラップ | E-06 (L169-173) | ○ |
| C-118 | パッケージプレフィックスなしエラーメッセージ | E-06 (L171) | ○ |
| C-119 | Message未継承エラー | E-06 (L181-193) | ○ |
| C-120 | fullNameでメッセージ検索 | E-06 (L216) | ○ |
| C-121 | 短縮名でメッセージ検索 | E-06 (L215) | ○ |
| C-122 | メッセージ未検出エラー | E-06 (L222) | ○ |
| C-123 | InvalidProtocolBufferException | E-06 (L231-233) | ○ |
| C-124 | 依存関係未検出エラー | E-06 (L263) | ○ |
| C-125 | Any依存特殊処理 | E-06 (L252-257) | ○ |
| C-126 | toFieldStr 空Seq | E-06 (L285) | ○ |
| C-127 | toFieldStr 1要素 | E-06 (L286) | ○ |
| C-128 | toFieldStr 複数要素 | E-06 (L286) | ○ |
| C-129 | buildTypeRegistry(bytes) | E-06 (L290-296) | ○ |
| C-130 | buildTypeRegistry(descriptor) | E-06 (L299-303) | ○ |
| C-131 | matchedFields マッチング | E-06 (L76-79) | ○ |
| C-132 | case-insensitive マッチング | E-06 (L121-124) | ○ |
| C-133 | validateNoExtraCatalystFields エラー | E-06 (L87-94) | ○ |
| C-134 | validateNoExtraCatalystFields nullable無視 | E-06 (L89-90) | ○ |
| C-135 | validateNoExtraRequiredProtoFields エラー | E-06 (L101-107) | ○ |
| C-136 | validateNoExtraRequiredProtoFields optional無視 | E-06 (L103) | ○ |
| C-137 | getFieldByName 複数マッチエラー | E-06 (L127-133) | ○ |
| C-138 | コンストラクタ null名エラー | E-06 (L64-68) | ○ |

### ProtobufOptions (C-139 ~ C-158)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-139 | parseMode FAILFAST | E-07 (L74-75) | ○ |
| C-140 | parseMode PERMISSIVE | E-07 (L74-75) | ○ |
| C-141 | parseMode デフォルト | E-07 (L75) | ○ |
| C-142 | recursiveFieldMaxDepth=5 | E-07 (L92) | ○ |
| C-143 | recursiveFieldMaxDepth デフォルト-1 | E-07 (L92) | ○ |
| C-144 | convertAnyFieldsToJson=true | E-07 (L139-140) | ○ |
| C-145 | convertAnyFieldsToJson デフォルトfalse | E-07 (L140) | ○ |
| C-146 | emitDefaultValues=true | E-07 (L175) | ○ |
| C-147 | emitDefaultValues デフォルトfalse | E-07 (L175) | ○ |
| C-148 | enumsAsInts=true | E-07 (L201-202) | ○ |
| C-149 | enumsAsInts デフォルトfalse | E-07 (L202) | ○ |
| C-150 | upcastUnsignedInts=true | E-07 (L213-214) | ○ |
| C-151 | upcastUnsignedInts デフォルトfalse | E-07 (L214) | ○ |
| C-152 | unwrapWellKnownTypes=true | E-07 (L240-241) | ○ |
| C-153 | unwrapWellKnownTypes デフォルトfalse | E-07 (L241) | ○ |
| C-154 | retainEmptyMessage=true | E-07 (L257-258) | ○ |
| C-155 | retainEmptyMessage デフォルトfalse | E-07 (L258) | ○ |
| C-156 | Boolean不正値 AnalysisException | E-07 (L37-54) | ○ |
| C-157 | Int不正値 AnalysisException | E-07 (L37-54) | ○ |
| C-158 | apply ファクトリメソッド | E-07 (L262-267) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-067 (enumsAsInts + JSON連携)**: jsonPrinterの`printingEnumsAsInts()`設定はソースコードで確認できるが、Anyフィールド内のEnumが実際に整数出力されるかは統合テストでの確認が望ましい
  - 候補：既存テストスイート ProtobufFunctionsSuiteの確認 / 手動テスト実行
- **C-087, C-088 (TypeRegistry構築分岐)**: lazy valの初期化分岐ロジックはソースコード上で確認できるが、TypeRegistryの実際の内容(全メッセージ登録 vs 接続メッセージのみ)は実行時テストでの確認が必要
  - 候補：ProtobufFunctionsSuiteのAny関連テストケース / 手動テスト実行

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本型変換テストケース (C-001~C-009, C-031~C-037, C-090~C-096) はソースコードから直接特定可能
- 0: 低リスク - ProtobufOptionsの各オプション検証 (C-139~C-158) はコード上のデフォルト値から直接確認可能
- 1: 中リスク - TypeRegistry構築ロジック (C-087, C-088) は内部実装の分岐であり、実行時の動作確認が望ましい
- 1: 中リスク - enumsAsIntsとJSON変換の連携 (C-067) は複数機能の組み合わせであり、実行時確認が望ましい
- 0: 低リスク - equals/hashCodeのテスト (C-071~C-075, C-085~C-086) はコード上の実装から直接特定可能

## 6) レビュアーチェックリスト（最小）
- [ ] 全158件のテストケースがCSVに出力されていることを確認
- [ ] 各テストIDの連番(UT-PBF-001~UT-PBF-158)に欠番がないことを確認
- [ ] ProtobufSerializerの全型変換パターン(Boolean/Int/Long/Float/Double/String/Binary/Enum/Timestamp/Array/Map/Struct/Duration)がカバーされていることを確認
- [ ] ProtobufDeserializerの全型変換パターンが対称的にカバーされていることを確認
- [ ] SchemaConvertersの全型マッピング(基本型+特殊型+ラッパー型)がカバーされていることを確認
- [ ] ProtobufOptionsの全オプション(parseMode/recursiveFieldMaxDepth/convertAnyFieldsToJson/emitDefaultValues/enumsAsInts/upcastUnsignedInts/unwrapWellKnownTypes/retainEmptyMessage)がカバーされていることを確認
- [ ] 正常系/異常系/境界値の各テスト観点がバランスよく含まれていることを確認
- [ ] 根拠不足(△)の3件(C-067, C-087, C-088)について、既存テストスイートでの補完可否を確認
