---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 73
  claims_with_evidence: 71
  claims_without_evidence: 2
confidence_derived: 0.97
---

# 根拠レポート：connector-spark-ganglia-lgpl 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：71 / 73、根拠なし：2
- 優先レビュー（高）
  1. **C-48（detectType null入力）**：nullが渡された場合のinstanceof判定の挙動は実行時確認が必要
  2. **C-73（MetricsSystem.checkMinimalPollingPeriod呼び出し）**：外部クラスの振る舞い依存のため実行時確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `connector/spark-ganglia-lgpl/src/main/java/com/codahale/metrics/ganglia/GangliaReporter.java` （GangliaReporterクラス全体）
- E-02: `connector/spark-ganglia-lgpl/src/main/java/com/codahale/metrics/ganglia/GangliaReporter.java` L54-204（Builder内部クラス）
- E-03: `connector/spark-ganglia-lgpl/src/main/java/com/codahale/metrics/ganglia/GangliaReporter.java` L44-47（forRegistryファクトリメソッド）
- E-04: `connector/spark-ganglia-lgpl/src/main/java/com/codahale/metrics/ganglia/GangliaReporter.java` L236-260（reportメソッド）
- E-05: `connector/spark-ganglia-lgpl/src/main/java/com/codahale/metrics/ganglia/GangliaReporter.java` L262-300（reportTimerメソッド）
- E-06: `connector/spark-ganglia-lgpl/src/main/java/com/codahale/metrics/ganglia/GangliaReporter.java` L302-311（reportMeterメソッド）
- E-07: `connector/spark-ganglia-lgpl/src/main/java/com/codahale/metrics/ganglia/GangliaReporter.java` L313-320（reportMeteredメソッド）
- E-08: `connector/spark-ganglia-lgpl/src/main/java/com/codahale/metrics/ganglia/GangliaReporter.java` L322-343（reportHistogramメソッド）
- E-09: `connector/spark-ganglia-lgpl/src/main/java/com/codahale/metrics/ganglia/GangliaReporter.java` L345-354（reportCounterメソッド）
- E-10: `connector/spark-ganglia-lgpl/src/main/java/com/codahale/metrics/ganglia/GangliaReporter.java` L356-368（reportGaugeメソッド）
- E-11: `connector/spark-ganglia-lgpl/src/main/java/com/codahale/metrics/ganglia/GangliaReporter.java` L370-387（announceIfEnabledメソッド2種）
- E-12: `connector/spark-ganglia-lgpl/src/main/java/com/codahale/metrics/ganglia/GangliaReporter.java` L389-398（announceメソッド）
- E-13: `connector/spark-ganglia-lgpl/src/main/java/com/codahale/metrics/ganglia/GangliaReporter.java` L400-415（detectTypeメソッド）
- E-14: `connector/spark-ganglia-lgpl/src/main/java/com/codahale/metrics/ganglia/GangliaReporter.java` L417-423（groupメソッド）
- E-15: `connector/spark-ganglia-lgpl/src/main/java/com/codahale/metrics/ganglia/GangliaReporter.java` L425-427（prefixメソッド）
- E-16: `connector/spark-ganglia-lgpl/src/main/java/com/codahale/metrics/ganglia/GangliaReporter.java` L430-432（escapeSlashesメソッド）
- E-17: `connector/spark-ganglia-lgpl/src/main/scala/org/apache/spark/metrics/sink/GangliaSink.scala` （GangliaSinkクラス全体）
- E-18: `connector/spark-ganglia-lgpl/src/main/scala/org/apache/spark/metrics/sink/GangliaSink.scala` L53-58（host/portバリデーション）
- E-19: `connector/spark-ganglia-lgpl/src/main/scala/org/apache/spark/metrics/sink/GangliaSink.scala` L61-74（プロパティ解析とデフォルト値）
- E-20: `connector/spark-ganglia-lgpl/src/main/scala/org/apache/spark/metrics/sink/GangliaSink.scala` L76-81（GMetric/GangliaReporter初期化）
- E-21: `connector/spark-ganglia-lgpl/src/main/scala/org/apache/spark/metrics/sink/GangliaSink.scala` L83-93（start/stop/reportメソッド）
- E-22: `connector/spark-ganglia-lgpl/src/main/scala/org/apache/spark/metrics/sink/GangliaSink.scala` L51（propertyToOptionメソッド）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | forRegistryがBuilderを返却する | E-03 | ○ |
| C-02 | withTMaxがtMaxを設定しBuilderを返す | E-02 (L109-112) | ○ |
| C-03 | withDMaxがdMaxを設定しBuilderを返す | E-02 (L131-134) | ○ |
| C-04 | prefixedWithがprefixを設定しBuilderを返す | E-02 (L120-123) | ○ |
| C-05 | prefixedWithにnullを渡した場合の挙動 | E-02 (L120-123) | ○ |
| C-06 | prefixedWithに空文字を渡した場合の挙動 | E-02 (L120-123) | ○ |
| C-07 | convertRatesToがrateUnitを設定する | E-02 (L142-145) | ○ |
| C-08 | convertDurationsToがdurationUnitを設定する | E-02 (L153-156) | ○ |
| C-09 | filterがMetricFilterを設定する | E-02 (L164-167) | ○ |
| C-10 | disabledMetricAttributesが設定される | E-02 (L176-179) | ○ |
| C-11 | shutdownExecutorOnStopが設定される | E-02 (L85-88) | ○ |
| C-12 | scheduleOnがexecutorを設定する | E-02 (L98-101) | ○ |
| C-13 | build(GMetric)がGangliaReporterを返す | E-02 (L188-191) | ○ |
| C-14 | build(GMetric...)がGangliaReporterを返す | E-02 (L200-203) | ○ |
| C-15 | デフォルト値でビルドされること | E-02 (L66-75) | ○ |
| C-16 | reportが全メトリクスタイプを処理する | E-04 | ○ |
| C-17 | 空マップでもreportが正常完了する | E-04 | ○ |
| C-18 | reportGaugeがGauge値を送信する | E-10 | ○ |
| C-19 | String型GaugeがSTRINGタイプで送信される | E-10, E-13 | ○ |
| C-20 | reportGaugeのGangliaException処理 | E-10 (L363-367) | ○ |
| C-21 | reportCounterがCounter値を送信する | E-09 | ○ |
| C-22 | reportCounterのGangliaException処理 | E-09 (L350-353) | ○ |
| C-23 | reportHistogramが全統計量を送信する | E-08 | ○ |
| C-24 | reportHistogramのGangliaException処理 | E-08 (L339-342) | ○ |
| C-25 | reportMeterがレート値を送信する | E-06, E-07 | ○ |
| C-26 | reportMeterのGangliaException処理 | E-06 (L307-310) | ○ |
| C-27 | reportTimerが統計量とレートを送信する | E-05 | ○ |
| C-28 | reportTimerのGangliaException処理 | E-05 (L296-299) | ○ |
| C-29 | reportMeteredのunit生成ロジック | E-07 (L314) | ○ |
| C-30 | announceIfEnabled(double)が有効属性を送信する | E-11 (L372-378) | ○ |
| C-31 | announceIfEnabled(double)が無効属性をスキップする | E-11 (L374-376) | ○ |
| C-32 | 微小値（1E-300未満）で"0"が送信される | E-11 (L370, L377) | ○ |
| C-33 | 負の微小値で"0"が送信される | E-11 (L377: Math.abs使用) | ○ |
| C-34 | 1E-300ちょうどで数値文字列が送信される | E-11 (L377: < MIN_VAL) | ○ |
| C-35 | 0.0で"0"が送信される | E-11 (L377) | ○ |
| C-36 | announceIfEnabled(long)が有効属性を送信する | E-11 (L381-387) | ○ |
| C-37 | announceIfEnabled(long)が無効属性をスキップする | E-11 (L383-385) | ○ |
| C-38 | 単一GMetricでannounceが呼び出される | E-12 (L391-392) | ○ |
| C-39 | 複数GMetricで全てにannounceが呼び出される | E-12 (L393-396) | ○ |
| C-40 | tMax/dMaxがannounceに渡される | E-12 (L392) | ○ |
| C-41 | Float型でFLOATが返却される | E-13 (L401-402) | ○ |
| C-42 | Double型でDOUBLEが返却される | E-13 (L403-404) | ○ |
| C-43 | Byte型でINT8が返却される | E-13 (L405-406) | ○ |
| C-44 | Short型でINT16が返却される | E-13 (L407-408) | ○ |
| C-45 | Integer型でINT32が返却される | E-13 (L409-410) | ○ |
| C-46 | Long型でDOUBLEが返却される | E-13 (L411-412) | ○ |
| C-47 | 未知型でSTRINGが返却される | E-13 (L414) | ○ |
| C-48 | null入力でSTRINGが返却される | E-13 | △ |
| C-49 | ドット区切り名前からグループが抽出される | E-14 (L418-422) | ○ |
| C-50 | ドットなしで空文字が返却される | E-14 (L419-421) | ○ |
| C-51 | 先頭ドットで空文字が返却される | E-14 (L418-422) | ○ |
| C-52 | 末尾ドットでドット以前が返却される | E-14 (L418-422) | ○ |
| C-53 | バックスラッシュがアンダースコアに置換される | E-16 (L37, L431) | ○ |
| C-54 | バックスラッシュなしでそのまま返却される | E-16 | ○ |
| C-55 | 空文字でも正常動作する | E-16 | ○ |
| C-56 | prefix/name/nが正しく結合される | E-15 | ○ |
| C-57 | prefixがnullの場合の結合 | E-15 | ○ |
| C-58 | host/port設定で正常初期化 | E-17, E-18, E-19 | ○ |
| C-59 | hostなしでExceptionがスローされる | E-18 (L53-55) | ○ |
| C-60 | portなしでExceptionがスローされる | E-18 (L57-59) | ○ |
| C-61 | デフォルト値が正しく設定される | E-19 (L32-49) | ○ |
| C-62 | カスタムプロパティが反映される | E-19 (L61-72) | ○ |
| C-63 | 不正なport値でNumberFormatException | E-19 (L62: toInt) | ○ |
| C-64 | 不正なmode値でIllegalArgumentException | E-19 (L66: valueOf) | ○ |
| C-65 | 不正なunit値でIllegalArgumentException | E-19 (L71: valueOf) | ○ |
| C-66 | mode大文字小文字変換 | E-19 (L66: toUpperCase) | ○ |
| C-67 | 存在するプロパティでSome返却 | E-22 | ○ |
| C-68 | 存在しないプロパティでNone返却 | E-22 | ○ |
| C-69 | startでreporter.startが呼び出される | E-21 (L83-85) | ○ |
| C-70 | stopでreporter.stopが呼び出される | E-21 (L87-89) | ○ |
| C-71 | reportでreporter.reportが呼び出される | E-21 (L91-93) | ○ |
| C-72 | Reporterの変換設定 | E-20 (L77-81) | ○ |
| C-73 | checkMinimalPollingPeriod呼び出し | E-19 (L74) | △ |

## 4) 不足情報（Unknown / Missing）
- **C-48**: `detectType`にnullが渡された場合、Javaの`instanceof`はnullに対して常にfalseを返すため論理的にはSTRINGが返却されるが、コード上明示的なnullチェックがないため実行時確認が推奨される
  - 候補：JUnit等で実行時テスト / Java言語仕様（instanceof and null）の確認
- **C-73**: `MetricsSystem.checkMinimalPollingPeriod`の内部実装は本モジュール外にあり、ポーリング間隔が短すぎる場合にどのような例外がスローされるかの詳細はモジュール外の実装に依存する
  - 候補：`core`モジュールの`MetricsSystem`クラスの実装確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Builder パターンのテストケース（C-01 から C-15）は単純なセッター/ゲッターパターンであり信頼度が高い
- 0: 低リスク - detectType の各型マッピング（C-41 から C-47）はソースコードの条件分岐と1対1に対応
- 1: 中リスク - GangliaException 処理のテストケース（C-20, C-22, C-24, C-26, C-28）はモック化が必要であり、実際のGanglia接続障害時の挙動は結合テストで補完が必要
- 1: 中リスク - GangliaSinkの初期化テスト（C-58 から C-66）はGMetricコンストラクタの実際のネットワーク動作に依存するため、モック化またはテスト用設定が必要
- 0: 低リスク - announceIfEnabled の MIN_VAL 閾値テスト（C-32 から C-35）はコード上の定数値と数学関数から論理的に導出可能

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースが GangliaReporter.java と GangliaSink.scala の全publicメソッドをカバーしているか
- [ ] Builder パターンの各設定メソッドに対して正常系テストが存在するか
- [ ] 各 report メソッド（Gauge/Counter/Histogram/Meter/Timer）に対して正常系と例外系のテストが存在するか
- [ ] detectType の全条件分岐（Float/Double/Byte/Short/Integer/Long/その他）がカバーされているか
- [ ] announceIfEnabled の MIN_VAL 境界値テストが適切か（0.0, 1E-301, 1E-300, 負の微小値）
- [ ] GangliaSink の必須プロパティ（host/port）のバリデーションテストが存在するか
- [ ] GangliaSink のデフォルト値とカスタム値の両方のテストが存在するか
- [ ] 不正な入力値（不正なport, mode, unit）に対する異常系テストが存在するか
- [ ] C-48（detectType null入力）の期待結果が正しいか実行時に確認
- [ ] テストIDの連番（UT-GNG-001からUT-GNG-073）に欠番がないか
