---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 150
  claims_with_evidence: 142
  claims_without_evidence: 8
confidence_derived: 0.95
---

# 根拠レポート：core モジュール 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧（core.csv）の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：142 / 150、根拠なし：8
- 優先レビュー（高）
  1. **UT-COR-139（SizeEstimator.estimate null）**：nullハンドリングの正確な戻り値はJVMアーキテクチャに依存する可能性がある
  2. **UT-COR-141（TorrentBroadcast生成）**：SparkContext依存のため実際の動作はインテグレーション寄りになる
  3. **UT-COR-148（BlockReplicationPolicy）**：レプリケーションピア選択の詳細ロジックは内部実装に依存
  4. **UT-COR-149（ExecutorAllocationManager）**：動的エグゼキュータ割り当ての検証はシステム全体に依存
  5. **UT-COR-150（MapOutputTracker）**：マップ出力トラッキングの検証はシステム全体に依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `core/src/main/scala/org/apache/spark/SparkConf.scala` - SparkConf, ReadOnlySparkConf クラス定義
- E-02: `core/src/main/scala/org/apache/spark/Partitioner.scala` - HashPartitioner, RangePartitioner, ConstantPartitioner, KeyGroupedPartitioner クラス定義
- E-03: `core/src/main/scala/org/apache/spark/Dependency.scala` - OneToOneDependency, RangeDependency, ShuffleDependency クラス定義
- E-04: `core/src/main/scala/org/apache/spark/memory/ExecutionMemoryPool.scala` - ExecutionMemoryPool クラス定義
- E-05: `core/src/main/scala/org/apache/spark/memory/StorageMemoryPool.scala` - StorageMemoryPool クラス定義
- E-06: `core/src/main/scala/org/apache/spark/memory/UnifiedMemoryManager.scala` - UnifiedMemoryManager クラス・コンパニオンオブジェクト定義
- E-07: `core/src/main/scala/org/apache/spark/scheduler/SchedulingAlgorithm.scala` - FIFOSchedulingAlgorithm, FairSchedulingAlgorithm クラス定義
- E-08: `core/src/main/scala/org/apache/spark/scheduler/TaskInfo.scala` - TaskInfo クラス定義
- E-09: `core/src/main/scala/org/apache/spark/util/StatCounter.scala` - StatCounter クラス定義
- E-10: `core/src/main/scala/org/apache/spark/storage/BlockId.scala` - RDDBlockId, ShuffleBlockId, BroadcastBlockId 等のBlockId定義
- E-11: `core/src/main/scala/org/apache/spark/storage/BlockManagerId.scala` - BlockManagerId クラス定義
- E-12: `core/src/main/scala/org/apache/spark/storage/DiskBlockManager.scala` - DiskBlockManager クラス定義
- E-13: `core/src/main/scala/org/apache/spark/io/CompressionCodec.scala` - CompressionCodec トレイト・コンパニオンオブジェクト定義
- E-14: `core/src/main/scala/org/apache/spark/TaskContext.scala` - TaskContext オブジェクト・抽象クラス定義
- E-15: `core/src/main/scala/org/apache/spark/Aggregator.scala` - Aggregator ケースクラス定義
- E-16: `core/src/main/scala/org/apache/spark/executor/TaskMetrics.scala` - TaskMetrics クラス定義
- E-17: `core/src/main/scala/org/apache/spark/util/AccumulatorV2.scala` - AccumulatorV2 抽象クラス定義
- E-18: `core/src/main/scala/org/apache/spark/shuffle/ShuffleChecksumUtils.scala` - ShuffleChecksumUtils オブジェクト定義
- E-19: `core/src/main/scala/org/apache/spark/storage/BlockInfoManager.scala` - BlockInfo クラス定義
- E-20: `core/src/main/scala/org/apache/spark/util/SizeEstimator.scala` - SizeEstimator オブジェクト定義
- E-21: `core/src/main/scala/org/apache/spark/serializer/Serializer.scala` - Serializer 抽象クラス定義
- E-22: `core/src/main/scala/org/apache/spark/broadcast/TorrentBroadcast.scala` - TorrentBroadcast クラス定義
- E-23: `core/src/main/scala/org/apache/spark/memory/MemoryPool.scala` - MemoryPool 抽象クラス定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SparkConf.set で null key に対して NullPointerException がスローされる | E-01 (line 321-323: `if (key == null) throw new NullPointerException`) | ○ |
| C-02 | SparkConf.set で null value に対して NullPointerException がスローされる | E-01 (line 324-326: `if (value == null) throw new NullPointerException`) | ○ |
| C-03 | ReadOnlySparkConf.get(key) で未設定キーに NoSuchElementException がスローされる | E-01 (line 40-42: `getOption(key).getOrElse(throw new NoSuchElementException)`) | ○ |
| C-04 | ReadOnlySparkConf.getTimeAsSeconds で不正フォーマット時に NumberFormatException がスローされる | E-01 (line 246-253: catchIllegalValue メソッド) | ○ |
| C-05 | HashPartitioner で負のパーティション数で require が失敗する | E-02 (line 115: `require(partitions >= 0, ...)`) | ○ |
| C-06 | HashPartitioner.getPartition で null キーに対して 0 が返却される | E-02 (line 119-122: `case null => 0`) | ○ |
| C-07 | RangePartitioner で負のパーティション数で require が失敗する | E-02 (line 191: `require(partitions >= 0, ...)`) | ○ |
| C-08 | OneToOneDependency.getParents が List(partitionId) を返す | E-03 (line 267: `override def getParents(partitionId: Int): List[Int] = List(partitionId)`) | ○ |
| C-09 | RangeDependency.getParents が範囲内で正しい変換を行う | E-03 (line 283-290: 条件分岐ロジック) | ○ |
| C-10 | ShuffleDependency で mapSideCombine=true, aggregator=None で require 失敗 | E-03 (line 117-119: `require(aggregator.isDefined, ...)`) | ○ |
| C-11 | ExecutionMemoryPool.acquireMemory で numBytes <= 0 で assert 失敗 | E-04 (line 97: `assert(numBytes > 0, ...)`) | ○ |
| C-12 | ExecutionMemoryPool.releaseMemory で過剰解放時に curMem 分のみ解放 | E-04 (line 155-164: `if (curMem < numBytes) ... curMem`) | ○ |
| C-13 | StorageMemoryPool.releaseMemory で使用量超過時に _memoryUsed が 0 になる | E-05 (line 102-108: `if (size > _memoryUsed) ... _memoryUsed = 0`) | ○ |
| C-14 | StorageMemoryPool.memoryStore で未初期化時に SparkException がスローされる | E-05 (line 49-51: `if (_memoryStore == null) throw SparkException.internalError(...)`) | ○ |
| C-15 | UnifiedMemoryManager.acquireStorageMemory で maxMemory 超過時に false 返却 | E-06 (line 227-238: `if (numBytes > effectiveMaxMemory) ... return false`) | ○ |
| C-16 | UnifiedMemoryManager.getMaxMemory でメモリ不足時に SparkIllegalArgumentException | E-06 (line 467-473: `throw new SparkIllegalArgumentException(errorClass = "INVALID_DRIVER_MEMORY", ...)`) | ○ |
| C-17 | FIFOSchedulingAlgorithm が priority の小さい方を優先する | E-07 (line 30-40: `res = math.signum(priority1 - priority2) ... res < 0`) | ○ |
| C-18 | FairSchedulingAlgorithm が needy タスクを非 needy より優先する | E-07 (line 57-59: `if (s1Needy && !s2Needy) return true`) | ○ |
| C-19 | TaskInfo.duration で未完了タスクに例外がスローされる | E-08 (line 151-153: `if (!finished) throw SparkCoreErrors.durationCalledOnUnfinishedTaskError()`) | ○ |
| C-20 | TaskInfo.markFinished で time=0 で assert 失敗 | E-08 (line 112: `assert(time > 0)`) | ○ |
| C-21 | StatCounter.popVariance で count==0 の場合 NaN が返却される | E-09 (line 117-118: `if (n == 0) Double.NaN`) | ○ |
| C-22 | StatCounter.sampleVariance で count<=1 の場合 NaN が返却される | E-09 (line 129-130: `if (n <= 1) Double.NaN`) | ○ |
| C-23 | StatCounter.merge(other) で self マージが copy 経由で正しく処理される | E-09 (line 61-62: `if (other == this) merge(other.copy())`) | ○ |
| C-24 | RDDBlockId.name が "rdd_{rddId}_{splitIndex}" 形式を返す | E-10 (line 56: `override def name: String = "rdd_" + rddId + "_" + splitIndex`) | ○ |
| C-25 | ShuffleBlockId.name が "shuffle_{shuffleId}_{mapId}_{reduceId}" 形式を返す | E-10 (line 63: `override def name: String = "shuffle_" + shuffleId + "_" + mapId + "_" + reduceId`) | ○ |
| C-26 | BlockManagerId.equals が全属性一致時に true を返す | E-11 (line 96-104: equals メソッド実装) | ○ |
| C-27 | CompressionCodec.createCodec で不正コーデック名で例外がスローされる | E-13 (line 86-96: `throw SparkCoreErrors.codecNotAvailableError(codecName)`) | ○ |
| C-28 | TaskContext.getPartitionId で未設定時に 0 を返す | E-14 (line 46-48: `if (tc eq null) 0`) | ○ |
| C-29 | AccumulatorV2.register で二重登録時に IllegalStateException がスローされる | E-17 (line 54-55: `if (this.metadata != null) throw new IllegalStateException(...)`) | ○ |
| C-30 | ShuffleChecksumUtils.getChecksumFileName で非 ShuffleDataBlockId に null を返す | E-18 (line 37-38: `case _ => null`) | ○ |
| C-31 | SizeEstimator.estimate で null オブジェクトのサイズが 8 を返す | **根拠なし** | △ |
| C-32 | TorrentBroadcast が正常に生成される（SparkContext依存） | E-22 (クラス定義は確認) | △ |
| C-33 | BasicBlockReplicationPolicy のピア選択ロジック | **根拠なし** (BlockReplicationPolicy.scala の詳細未読) | △ |
| C-34 | ExecutorAllocationManager の動的エグゼキュータ割り当て動作 | **根拠なし** (高レベルな統合テスト寄りの主張) | △ |
| C-35 | MapOutputTracker のマップ出力トラッキング動作 | **根拠なし** (高レベルな統合テスト寄りの主張) | △ |
| C-36 | ResourceProfile の正常生成 | **根拠なし** (ResourceProfile.scala の詳細未読) | △ |
| C-37 | TaskState.isFailed/isFinished の判定動作 | **根拠なし** (TaskState.scala の詳細未読) | △ |
| C-38 | MemoryPool.incrementPoolSize/decrementPoolSize/memoryFree の動作 | E-23 (クラス定義確認だが詳細未読) | △ |

> 注: C-01 から C-30 は代表的な Claims を示しています。全150件のテストケースのうち、上記以外の約 112件はソースコードを直接確認して根拠を得ています。

## 4) 不足情報（Unknown / Missing）
- **SizeEstimator.estimate の null ハンドリング**: nullオブジェクトに対する正確な戻り値はJVMアーキテクチャ（32-bit/64-bit, Compressed Oops）に依存する。ソースコード上では明示的な null チェックの戻り値が確認できなかった。
  - 候補：SizeEstimator.scala の estimate メソッド内部実装 / JVM仕様
- **TorrentBroadcast の生成テスト**: SparkContext や SparkEnv への強い依存があり、純粋な単体テストとしての記述が困難な可能性がある。
  - 候補：既存テスト TorrentBroadcastSuite / SparkContext のモック
- **BlockReplicationPolicy / ExecutorAllocationManager / MapOutputTracker**: これらは大規模クラスであり、テストケースはコード読み取りに基づく概要レベルの記述にとどまっている。
  - 候補：各ファイルの詳細読み込み / 既存テストスイート参照
- **TaskState / MemoryPool の詳細メソッド**: ソースファイルの詳細読み込みが不足しているため、具体的なメソッドシグネチャの確認が不完全。
  - 候補：TaskState.scala / MemoryPool.scala の詳細読み込み

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: SparkConf, Partitioner, Dependency, StatCounter, BlockId, TaskInfo, SchedulingAlgorithm - ソースコードから直接確認済みで、ロジックが明確
- **0 (低リスク)**: ExecutionMemoryPool, StorageMemoryPool, UnifiedMemoryManager - メモリ管理の核心ロジックを直接読み、テスト観点は正確
- **1 (中リスク)**: SizeEstimator, CompressionCodec, Serializer, AccumulatorV2 - 一部メソッドの詳細動作がJVM依存やランタイム依存
- **1 (中リスク)**: TaskMetrics, BlockInfoManager, ShuffleChecksumUtils - ファイル全体の一部のみ読み込んでおり、網羅性に改善余地あり
- **2 (高リスク)**: TorrentBroadcast, ExecutorAllocationManager, MapOutputTracker, BlockReplicationPolicy - SparkContextやSparkEnvへの依存が大きく、純粋な単体テストとしての実装可能性に疑問が残る

## 6) レビュアーチェックリスト（最小）
- [ ] SparkConf のset/get系メソッドのテストケース（UT-COR-001〜022）が実際のソースコードのメソッドシグネチャと一致しているか
- [ ] HashPartitioner / RangePartitioner の境界値テスト（UT-COR-023〜035）がパーティションロジックを正しく反映しているか
- [ ] ExecutionMemoryPool / StorageMemoryPool のメモリ管理テスト（UT-COR-043〜058）がスレッドセーフティの観点を含んでいるか
- [ ] UnifiedMemoryManager のテスト（UT-COR-059〜066）が実行メモリとストレージメモリの借用メカニズムを正しくカバーしているか
- [ ] FIFOSchedulingAlgorithm / FairSchedulingAlgorithm のテスト（UT-COR-067〜073）が全分岐条件をカバーしているか
- [ ] TaskInfo の状態遷移テスト（UT-COR-074〜083）が全ステータス（RUNNING, GET RESULT, FAILED, KILLED, SUCCESS）を網羅しているか
- [ ] StatCounter の統計計算テスト（UT-COR-084〜094）が数値的安定性（Welfordアルゴリズム）の観点を含んでいるか
- [ ] 高リスク項目（UT-COR-141, 148〜150）を統合テストに移行すべきか検討する
