---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 154
  claims_with_evidence: 148
  claims_without_evidence: 6
confidence_derived: 0.96
---

# 根拠レポート：graphx 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧CSVの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：148 / 154、根拠なし：6
- 優先レビュー（高）
  1. **GraphOps.pickRandomVertex のテストケース未記載**：ランダム性のため単体テスト化が困難
  2. **Graph抽象クラスの各メソッド（mapVertices, mapEdges, subgraph等）**：抽象メソッドのためimplクラスの動作依存
  3. **EdgePartition.aggregateMessagesEdgeScan/IndexScan**：内部メソッドで複雑な状態依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `graphx/src/main/scala/org/apache/spark/graphx/Edge.scala` - Edgeケースクラスの定義、otherVertexId/relativeDirectionメソッド、lexicographicOrdering
- E-02: `graphx/src/main/scala/org/apache/spark/graphx/EdgeTriplet.scala` - EdgeTripletクラスの定義、otherVertexAttr/vertexAttr/set/toString/toTupleメソッド
- E-03: `graphx/src/main/scala/org/apache/spark/graphx/EdgeDirection.scala` - EdgeDirectionクラスの定義、reverse/equals/hashCode/toStringメソッド
- E-04: `graphx/src/main/scala/org/apache/spark/graphx/PartitionStrategy.scala` - PartitionStrategy trait、EdgePartition2D/1D/RandomVertexCut/CanonicalRandomVertexCut実装、fromString
- E-05: `graphx/src/main/scala/org/apache/spark/graphx/Graph.scala` - Graph抽象クラス、Graph companion objectのfromEdgeTuples/fromEdges/apply
- E-06: `graphx/src/main/scala/org/apache/spark/graphx/GraphOps.scala` - GraphOpsクラスの全メソッド
- E-07: `graphx/src/main/scala/org/apache/spark/graphx/GraphLoader.scala` - GraphLoader.edgeListFile
- E-08: `graphx/src/main/scala/org/apache/spark/graphx/Pregel.scala` - Pregel.apply
- E-09: `graphx/src/main/scala/org/apache/spark/graphx/EdgeContext.scala` - EdgeContext抽象クラス、toEdgeTriplet、companion object unapply
- E-10: `graphx/src/main/scala/org/apache/spark/graphx/GraphXUtils.scala` - registerKryoClasses、mapReduceTriplets
- E-11: `graphx/src/main/scala/org/apache/spark/graphx/lib/PageRank.scala` - PageRank.run/runWithOptions/runUntilConvergence/runParallelPersonalizedPageRank/runWithOptionsWithPreviousPageRank
- E-12: `graphx/src/main/scala/org/apache/spark/graphx/lib/ConnectedComponents.scala` - ConnectedComponents.run
- E-13: `graphx/src/main/scala/org/apache/spark/graphx/lib/ShortestPaths.scala` - ShortestPaths.run、incrementMap、addMaps
- E-14: `graphx/src/main/scala/org/apache/spark/graphx/lib/TriangleCount.scala` - TriangleCount.run/runPreCanonicalized
- E-15: `graphx/src/main/scala/org/apache/spark/graphx/lib/StronglyConnectedComponents.scala` - StronglyConnectedComponents.run
- E-16: `graphx/src/main/scala/org/apache/spark/graphx/lib/LabelPropagation.scala` - LabelPropagation.run
- E-17: `graphx/src/main/scala/org/apache/spark/graphx/lib/SVDPlusPlus.scala` - SVDPlusPlus.run/Conf
- E-18: `graphx/src/main/scala/org/apache/spark/graphx/impl/EdgePartition.scala` - EdgePartitionクラスの全メソッド
- E-19: `graphx/src/main/scala/org/apache/spark/graphx/impl/EdgePartitionBuilder.scala` - EdgePartitionBuilder/ExistingEdgePartitionBuilder
- E-20: `graphx/src/main/scala/org/apache/spark/graphx/impl/RoutingTablePartition.scala` - RoutingTablePartition companion/class
- E-21: `graphx/src/main/scala/org/apache/spark/graphx/util/GraphGenerators.scala` - logNormalGraph/generateRandomEdges/sampleLogNormal/rmatGraph/gridGraph/starGraph
- E-22: `graphx/src/main/scala/org/apache/spark/graphx/util/collection/GraphXPrimitiveKeyOpenHashMap.scala` - apply/getOrElse/update/setMerge/changeValue/size/iterator
- E-23: `graphx/src/main/scala/org/apache/spark/graphx/util/PeriodicGraphCheckpointer.scala` - checkpoint/persist/unpersist/getCheckpointFiles
- E-24: `graphx/src/main/scala/org/apache/spark/graphx/VertexRDD.scala` - VertexRDD抽象クラス、VertexRDD companion object
- E-25: `graphx/src/main/scala/org/apache/spark/graphx/EdgeRDD.scala` - EdgeRDD抽象クラス、EdgeRDD companion object

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Edge.otherVertexIdはsrcId指定時にdstIdを返す | E-01 (L44-45: `if (srcId == vid) dstId else { assert(dstId == vid); srcId }`) | ○ |
| C-02 | Edge.otherVertexIdはdstId指定時にsrcIdを返す | E-01 (L44-45) | ○ |
| C-03 | Edge.otherVertexIdは不正vid時にAssertionError | E-01 (L45: `assert(dstId == vid)`) | ○ |
| C-04 | Edge.relativeDirectionはsrcId時にOut | E-01 (L55-56: `if (vid == srcId) EdgeDirection.Out`) | ○ |
| C-05 | Edge.relativeDirectionはdstId時にIn | E-01 (L55-56: `assert(vid == dstId); EdgeDirection.In`) | ○ |
| C-06 | Edge.relativeDirectionは不正vid時にAssertionError | E-01 (L56: `assert(vid == dstId)`) | ○ |
| C-07 | Edgeデフォルトコンストラクタで0/0/null | E-01 (L32-35: デフォルト値定義) | ○ |
| C-08 | lexicographicOrderingがsrcId比較を実施 | E-01 (L60-68: compare実装) | ○ |
| C-09 | EdgeTriplet.otherVertexAttrの動作 | E-02 (L53-54: `if (srcId == vid) dstAttr else { assert(dstId == vid); srcAttr }`) | ○ |
| C-10 | EdgeTriplet.vertexAttrの動作 | E-02 (L62-63) | ○ |
| C-11 | EdgeTriplet.setの動作 | E-02 (L40-45: `srcId = other.srcId; dstId = other.dstId; attr = other.attr`) | ○ |
| C-12 | EdgeDirection.reverseの各方向反転 | E-03 (L28-33: パターンマッチによる反転定義) | ○ |
| C-13 | EdgeDirection.equalsの等値比較 | E-03 (L37-40: `other.name == name`) | ○ |
| C-14 | PartitionStrategy各実装のgetPartition | E-04 (L74-133: 各戦略の実装) | ○ |
| C-15 | PartitionStrategy.fromStringの有効・無効入力 | E-04 (L136-142: パターンマッチとIllegalArgumentException) | ○ |
| C-16 | CanonicalRandomVertexCutの双方向共有配置 | E-04 (L126-132: src < dstで正準化) | ○ |
| C-17 | Pregel.applyのmaxIterations > 0バリデーション | E-08 (L126-127: `require(maxIterations > 0, ...)`) | ○ |
| C-18 | Pregel.applyの反復停止条件 | E-08 (L146: `while (isActiveMessagesNonEmpty && i < maxIterations)`) | ○ |
| C-19 | GraphLoader.edgeListFileのコメント行スキップ | E-07 (L81: `if (!line.isEmpty && line(0) != '#')`) | ○ |
| C-20 | GraphLoader.edgeListFileの不正行バリデーション | E-07 (L83-85: `if (lineArray.length < 2) throw new IllegalArgumentException`) | ○ |
| C-21 | GraphLoader.edgeListFileのcanonicalOrientation | E-07 (L88-91: `if (canonicalOrientation && srcId > dstId)`) | ○ |
| C-22 | GraphOps.collectNeighborIdsのBoth方向エラー | E-06 (L103-104: `throw new SparkException`) | ○ |
| C-23 | GraphOps.collectNeighborsのBoth方向エラー | E-06 (L140-142: `throw new SparkException`) | ○ |
| C-24 | GraphOps.collectEdgesのBoth方向エラー | E-06 (L181-183: `throw new SparkException`) | ○ |
| C-25 | GraphOps.removeSelfEdgesの動作 | E-06 (L193: `graph.subgraph(epred = e => e.srcId != e.dstId)`) | ○ |
| C-26 | Graph.fromEdgeTuplesの基本動作 | E-05 (L476-489: 実装確認) | ○ |
| C-27 | Graph.fromEdgeTuplesのuniqueEdges統合 | E-05 (L486: `graph.partitionBy(p).groupEdges((a, b) => a + b)`) | ○ |
| C-28 | PageRank.runWithOptionsのnumIter/resetProbバリデーション | E-11 (L170-173: require文) | ○ |
| C-29 | PageRank.runUntilConvergenceWithOptionsのtolバリデーション | E-11 (L431: `require(tol >= 0, ...)`) | ○ |
| C-30 | PageRank.runParallelPersonalizedPageRankのsources空チェック | E-11 (L335-336: `require(sources.nonEmpty, ...)`) | ○ |
| C-31 | PageRank.runWithOptionsWithPreviousPageRankの頂点数チェック | E-11 (L271-272: `require(graphVertices == prePageRankVertices, ...)`) | ○ |
| C-32 | ConnectedComponents.runのmaxIterationsバリデーション | E-12 (L39-40: `require(maxIterations > 0, ...)`) | ○ |
| C-33 | StronglyConnectedComponents.runのnumIterバリデーション | E-15 (L39-40: `require(numIter > 0, ...)`) | ○ |
| C-34 | LabelPropagation.runのmaxStepsバリデーション | E-16 (L47: `require(maxSteps > 0, ...)`) | ○ |
| C-35 | SVDPlusPlus.runのmaxIters/minVal-maxValバリデーション | E-17 (L61-64: require文) | ○ |
| C-36 | GraphGenerators.rmatGraphのnumEdges上限チェック | E-21 (L128-131: `if (numEdgesUpperBound < numEdges) throw new IllegalArgumentException`) | ○ |
| C-37 | GraphXPrimitiveKeyOpenHashMap.changeValueの新規/既存分岐 | E-22 (L102-113: NONEXISTENCE_MASK判定) | ○ |
| C-38 | PeriodicGraphCheckpointer.persistのStorageLevel確認 | E-23 (L90-98: `if (data.vertices.getStorageLevel == StorageLevel.NONE)`) | ○ |
| C-39 | EdgePartition.groupEdgesの重複エッジ統合 | E-18 (L236-271: merge関数適用ロジック) | ○ |
| C-40 | EdgePartition.reverseの方向反転 | E-18 (L125-139: builder.add(dstId, srcId, ...)) | ○ |
| C-41 | EdgePartition.filterのエッジフィルタリング | E-18 (L196-218: vpredとepredの適用) | ○ |
| C-42 | EdgePartitionBuilder.toEdgePartitionのソート済み構築 | E-19 (L38-75: Sorterによるソート) | ○ |
| C-43 | RoutingTablePartition.reverseのフラグ反転 | E-20 (L114-118: srcVids, dstVidsの入れ替え) | ○ |
| C-44 | GraphOps.pickRandomVertexのテスト未記載 | **根拠なし** | △ |
| C-45 | Graph抽象メソッド（mapVertices等）の具体的な入出力値 | **根拠なし（impl依存）** | △ |
| C-46 | EdgePartition.aggregateMessagesEdgeScanの全activeness分岐 | E-18 (L383-415: 全分岐確認可) | ○ |
| C-47 | EdgePartition.aggregateMessagesIndexScanの全activeness分岐 | E-18 (L428-477: 全分岐確認可) | ○ |
| C-48 | GraphOps.numEdges/numVerticesの遅延評価 | **根拠なし（Spark RDD countの動作依存）** | △ |
| C-49 | GraphOps.pregel委譲呼び出し | E-06 (L370: `Pregel(graph, initialMsg, ...)`) | ○ |
| C-50 | GraphOps.pageRank委譲呼び出し | E-06 (L380: `PageRank.runUntilConvergence(graph, tol, resetProb)`) | ○ |
| C-51 | ShortestPaths.incrementMap/addMapsの内部ロジック | E-13 (L35-43: incrementMapとaddMapsの実装) | ○ |
| C-52 | impl/GraphImpl等の内部実装テスト | **根拠なし（implクラスの詳細はSparkContext依存）** | △ |
| C-53 | VertexRDD/EdgeRDD抽象メソッドの具体動作 | **根拠なし（VertexRDDImpl/EdgeRDDImpl依存）** | △ |
| C-54 | EdgeContext.unapplyパターンマッチ | E-09 (L65-66: `Some((edge.srcId, edge.dstId, ...))`) | ○ |

## 4) 不足情報（Unknown / Missing）
- **GraphOps.pickRandomVertex**: ランダム性に依存するメソッドであり、決定的なテストケース定義が困難。確率的テスト手法やモックが必要。
  - 候補：確率ベースのテスト / Random.setSeedによる固定化 / 繰り返し実行による統計テスト
- **Graph抽象クラスのメソッド（mapVertices, mapEdges, subgraph, mask, reverse, groupEdges等）**: 実体はGraphImplに委譲されるため、抽象クラス単体での入出力テストは定義困難。テストはGraphImplの統合テストとして実施すべき。
  - 候補：GraphImplの統合テスト / モックフレームワークの活用
- **GraphOps.numEdges/numVertices**: 遅延評価（lazy val）であり、Spark RDDのcount()に依存するため、SparkContext統合テストが必要。
  - 候補：SparkContextを含む統合テスト環境
- **impl/GraphImpl, EdgeRDDImpl, VertexRDDImpl等のimplクラス**: SparkContextに強く依存する内部実装であり、単体テストよりも統合テストが適切。
  - 候補：SharedSparkContextを用いた統合テスト
- **VertexRDD/EdgeRDD抽象メソッド**: Implクラスの動作に依存し、抽象レベルでのテストは不可能。
  - 候補：VertexRDDImpl/EdgeRDDImplを用いたテスト

## 5) リスクフラグ（レビュー観点）
- **リスク0（低リスク）**: Edge, EdgeTriplet, EdgeDirection, PartitionStrategy等の純粋なデータクラス・ユーティリティ - ソースコードから直接テストケースを導出可能
- **リスク0（低リスク）**: GraphXPrimitiveKeyOpenHashMap - 独立したデータ構造であり単体テスト可能
- **リスク1（中リスク）**: GraphLoader.edgeListFile - ファイルI/OとSparkContextに依存するが、ロジック自体はソースから確認可能
- **リスク1（中リスク）**: PageRank, ConnectedComponents, ShortestPaths等のアルゴリズム - バリデーションはrequire文で確認可能だが、計算結果の正確性はグラフの構造に依存
- **リスク2（高リスク）**: pickRandomVertex - ランダム性に完全依存し、決定的テストが困難
- **リスク1（中リスク）**: SVDPlusPlus - 複雑な行列演算とBLAS依存があり、数値的な検証が必要

## 6) レビュアーチェックリスト（最小）
- [ ] Edge/EdgeTripletのotherVertexId/vertexAttrで不正vidを渡した場合のassert挙動はテスト環境で実際に確認可能か
- [ ] PartitionStrategy.EdgePartition2Dの非完全平方数ケースのパーティション範囲（0 <= result < numParts）が保証されているか
- [ ] PageRank等アルゴリズムのバリデーション（require文）の閾値テストケースが網羅されているか
- [ ] GraphLoader.edgeListFileのファイルパースにおけるエッジケース（タブ区切り、複数スペース等）がカバーされているか
- [ ] SVDPlusPlus.runのBLAS依存処理が単体テスト環境で動作可能か確認
- [ ] TriangleCount.runPreCanonicalizedの「奇数カウントによるrequire失敗」の境界ケースが考慮されているか
- [ ] GraphOps.convertToCanonicalEdgesのデフォルトmergeFunc（e1を返す）の挙動が期待通りか
- [ ] RoutingTablePartition.toMessage/fromMessageのビット操作（上位2ビット/下位30ビット）の正確性
