---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 166
  claims_with_evidence: 162
  claims_without_evidence: 4
confidence_derived: 0.98
---

# 根拠レポート：mllib-local 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：162 / 166、根拠なし：4
- 優先レビュー（高）
  1. **UT-MLL-001 (EPSILON)**: 計算値の具体的な期待値は実行環境依存のため要確認
  2. **UT-MLL-018 (nativeBLAS)**: nativeBLASのフォールバック挙動は環境依存
  3. **UT-MLL-162 (特異共分散行列のlogpdf)**: 特異行列の処理は計算誤差の影響を受ける可能性
  4. **UT-MLL-106 (compressed)**: 圧縮判定の閾値が実装依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `mllib-local/src/main/scala/org/apache/spark/ml/impl/Utils.scala` -- Utils オブジェクト（EPSILON, unpackUpperTriangular, indexUpperTriangular, log1pExp, softmax）
- E-02: `mllib-local/src/main/scala/org/apache/spark/ml/linalg/BLAS.scala` -- BLAS オブジェクト（axpy, dot, copy, scal, spr, dspmv, syr, gemm, gemv）
- E-03: `mllib-local/src/main/scala/org/apache/spark/ml/linalg/Vectors.scala` -- Vector trait, DenseVector, SparseVector, Vectors ファクトリ
- E-04: `mllib-local/src/main/scala/org/apache/spark/ml/linalg/Matrices.scala` -- Matrix trait, DenseMatrix, SparseMatrix, Matrices ファクトリ
- E-05: `mllib-local/src/main/scala/org/apache/spark/ml/stat/distribution/MultivariateGaussian.scala` -- MultivariateGaussian クラス
- E-06: `mllib-local/src/main/scala/scala/collection/compat/package.scala` -- Scala互換パッケージオブジェクト（テスト対象外：型エイリアスのみ）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-MLL-001: EPSILONが正の微小値であること | E-01 (Utils.scala L24-30) | △ |
| C-02 | UT-MLL-002: 2x2上三角行列の展開 | E-01 (Utils.scala L41-58) | ○ |
| C-03 | UT-MLL-003: 3x3上三角行列の展開 | E-01 (Utils.scala L41-58) | ○ |
| C-04 | UT-MLL-004: 1x1行列の展開 | E-01 (Utils.scala L41-58) | ○ |
| C-05 | UT-MLL-005: indexUpperTriangular i<=j | E-01 (Utils.scala L70-81) | ○ |
| C-06 | UT-MLL-006: indexUpperTriangular i>j | E-01 (Utils.scala L70-81) | ○ |
| C-07 | UT-MLL-007: i範囲外エラー | E-01 (Utils.scala L74) | ○ |
| C-08 | UT-MLL-008: j範囲外エラー | E-01 (Utils.scala L75) | ○ |
| C-09 | UT-MLL-009: log1pExp正値 | E-01 (Utils.scala L91-97) | ○ |
| C-10 | UT-MLL-010: log1pExp負値 | E-01 (Utils.scala L91-97) | ○ |
| C-11 | UT-MLL-011: log1pExp境界値0 | E-01 (Utils.scala L91-97) | ○ |
| C-12 | UT-MLL-012: log1pExp大きな正値 | E-01 (Utils.scala L83-97) | ○ |
| C-13 | UT-MLL-013: softmax基本動作 | E-01 (Utils.scala L102-139) | ○ |
| C-14 | UT-MLL-014: softmax同一値 | E-01 (Utils.scala L102-139) | ○ |
| C-15 | UT-MLL-015: softmax PosInfinity | E-01 (Utils.scala L119-122) | ○ |
| C-16 | UT-MLL-016: softmax offset/step | E-01 (Utils.scala L108-139) | ○ |
| C-17 | UT-MLL-017: javaBLAS取得 | E-02 (BLAS.scala L32-37) | ○ |
| C-18 | UT-MLL-018: nativeBLASフォールバック | E-02 (BLAS.scala L40-46) | △ |
| C-19 | UT-MLL-019: getBLAS閾値未満 | E-02 (BLAS.scala L48-54) | ○ |
| C-20 | UT-MLL-020: getBLAS閾値以上 | E-02 (BLAS.scala L48-54) | ○ |
| C-21 | UT-MLL-021: axpy Dense-Dense | E-02 (BLAS.scala L59-84) | ○ |
| C-22 | UT-MLL-022: axpy Sparse-Dense | E-02 (BLAS.scala L89-108) | ○ |
| C-23 | UT-MLL-023: axpyサイズ不一致 | E-02 (BLAS.scala L60) | ○ |
| C-24 | UT-MLL-024: axpy DenseMatrix | E-02 (BLAS.scala L111-115) | ○ |
| C-25 | UT-MLL-025: axpy DenseMatrix次元不一致 | E-02 (BLAS.scala L112) | ○ |
| C-26 | UT-MLL-026: dot Dense-Dense | E-02 (BLAS.scala L120-144) | ○ |
| C-27 | UT-MLL-027: dot Sparse-Dense | E-02 (BLAS.scala L149-162) | ○ |
| C-28 | UT-MLL-028: dot Sparse-Sparse | E-02 (BLAS.scala L167-191) | ○ |
| C-29 | UT-MLL-029: dotサイズ不一致 | E-02 (BLAS.scala L121-123) | ○ |
| C-30 | UT-MLL-030: dotゼロベクトル | E-02 (BLAS.scala L120-144) | ○ |
| C-31 | UT-MLL-031: copy Dense-Dense | E-02 (BLAS.scala L196-230) | ○ |
| C-32 | UT-MLL-032: copy Sparse-Dense | E-02 (BLAS.scala L196-230) | ○ |
| C-33 | UT-MLL-033: copy不正出力型 | E-02 (BLAS.scala L227-229) | ○ |
| C-34 | UT-MLL-034: scal Dense | E-02 (BLAS.scala L235-244) | ○ |
| C-35 | UT-MLL-035: scal Sparse | E-02 (BLAS.scala L235-244) | ○ |
| C-36 | UT-MLL-036: scal a=0 | E-02 (BLAS.scala L235-244) | ○ |
| C-37 | UT-MLL-037: spr DenseVector | E-02 (BLAS.scala L251-253, L278-308) | ○ |
| C-38 | UT-MLL-038: spr SparseVector | E-02 (BLAS.scala L278-308) | ○ |
| C-39 | UT-MLL-039: dspmv | E-02 (BLAS.scala L263-271) | ○ |
| C-40 | UT-MLL-040: syr DenseVector | E-02 (BLAS.scala L316-346) | ○ |
| C-41 | UT-MLL-041: syr SparseVector | E-02 (BLAS.scala L348-366) | ○ |
| C-42 | UT-MLL-042: syr非正方行列 | E-02 (BLAS.scala L319) | ○ |
| C-43 | UT-MLL-043: syrサイズ不一致 | E-02 (BLAS.scala L320) | ○ |
| C-44 | UT-MLL-044: gemm Dense-Dense | E-02 (BLAS.scala L376-468) | ○ |
| C-45 | UT-MLL-045: gemm Sparse-Dense | E-02 (BLAS.scala L474-601) | ○ |
| C-46 | UT-MLL-046: gemm alpha=0 beta=1 | E-02 (BLAS.scala L384-385) | ○ |
| C-47 | UT-MLL-047: gemm alpha=0 beta!=1 | E-02 (BLAS.scala L386-387) | ○ |
| C-48 | UT-MLL-048: gemm C転置エラー | E-02 (BLAS.scala L382-383) | ○ |
| C-49 | UT-MLL-049: gemm CValues | E-02 (BLAS.scala L406-427) | ○ |
| C-50 | UT-MLL-050: gemv Dense-Dense | E-02 (BLAS.scala L636-695) | ○ |
| C-51 | UT-MLL-051: gemv Sparse-Dense | E-02 (BLAS.scala L814-868) | ○ |
| C-52 | UT-MLL-052: gemv Dense-Sparse | E-02 (BLAS.scala L701-742) | ○ |
| C-53 | UT-MLL-053: gemv Sparse-Sparse | E-02 (BLAS.scala L748-808) | ○ |
| C-54 | UT-MLL-054: gemv転置行列 | E-02 (BLAS.scala L717, L767, L840) | ○ |
| C-55 | UT-MLL-055: gemvサイズ不一致 | E-02 (BLAS.scala L642-643) | ○ |
| C-56 | UT-MLL-056: gemv配列ベース | E-02 (BLAS.scala L606-626) | ○ |
| C-57 | UT-MLL-057: DenseVector.size | E-03 (Vectors.scala L537) | ○ |
| C-58 | UT-MLL-058: DenseVector.toArray | E-03 (Vectors.scala L541) | ○ |
| C-59 | UT-MLL-059: DenseVector.apply | E-03 (Vectors.scala L545) | ○ |
| C-60 | UT-MLL-060: DenseVector.copy | E-03 (Vectors.scala L547-549) | ○ |
| C-61 | UT-MLL-061: DenseVector.equals同型 | E-03 (Vectors.scala L51-70) | ○ |
| C-62 | UT-MLL-062: DenseVector.equals異型 | E-03 (Vectors.scala L51-70) | ○ |
| C-63 | UT-MLL-063: DenseVector.hashCode | E-03 (Vectors.scala L553-569) | ○ |
| C-64 | UT-MLL-064: DenseVector.numActives | E-03 (Vectors.scala L571) | ○ |
| C-65 | UT-MLL-065: DenseVector.numNonzeros | E-03 (Vectors.scala L573-582) | ○ |
| C-66 | UT-MLL-066: DenseVector.toSparseWithSize | E-03 (Vectors.scala L584-594) | ○ |
| C-67 | UT-MLL-067: DenseVector.argmax | E-03 (Vectors.scala L596-612) | ○ |
| C-68 | UT-MLL-068: DenseVector.argmax空 | E-03 (Vectors.scala L597-599) | ○ |
| C-69 | UT-MLL-069: SparseVector正常生成 | E-03 (Vectors.scala L641-664) | ○ |
| C-70 | UT-MLL-070: SparseVector負サイズ | E-03 (Vectors.scala L648) | ○ |
| C-71 | UT-MLL-071: SparseVector長さ不一致 | E-03 (Vectors.scala L649-651) | ○ |
| C-72 | UT-MLL-072: SparseVector非昇順 | E-03 (Vectors.scala L659-661) | ○ |
| C-73 | UT-MLL-073: SparseVector負インデックス | E-03 (Vectors.scala L656) | ○ |
| C-74 | UT-MLL-074: SparseVector.apply存在 | E-03 (Vectors.scala L686-693) | ○ |
| C-75 | UT-MLL-075: SparseVector.apply非存在 | E-03 (Vectors.scala L691-692) | ○ |
| C-76 | UT-MLL-076: SparseVector.apply範囲外 | E-03 (Vectors.scala L687-689) | ○ |
| C-77 | UT-MLL-077: SparseVector.toArray | E-03 (Vectors.scala L669-678) | ○ |
| C-78 | UT-MLL-078: SparseVector.copy | E-03 (Vectors.scala L680-682) | ○ |
| C-79 | UT-MLL-079: SparseVector.numActives | E-03 (Vectors.scala L716) | ○ |
| C-80 | UT-MLL-080: SparseVector.numNonzeros | E-03 (Vectors.scala L718-726) | ○ |
| C-81 | UT-MLL-081: SparseVector.toSparseWithSizeゼロ除去 | E-03 (Vectors.scala L728-742) | ○ |
| C-82 | UT-MLL-082: SparseVector.toSparseWithSize同一 | E-03 (Vectors.scala L729-730) | ○ |
| C-83 | UT-MLL-083: SparseVector.argmax | E-03 (Vectors.scala L744-789) | ○ |
| C-84 | UT-MLL-084: SparseVector.argmax空 | E-03 (Vectors.scala L745-746) | ○ |
| C-85 | UT-MLL-085: SparseVector.argmax負値 | E-03 (Vectors.scala L766-785) | ○ |
| C-86 | UT-MLL-086: SparseVector.argmax非ゼロなし | E-03 (Vectors.scala L747-748) | ○ |
| C-87 | UT-MLL-087: SparseVector.slice未ソート | E-03 (Vectors.scala L801-840) | ○ |
| C-88 | UT-MLL-088: SparseVector.sliceソート済み | E-03 (Vectors.scala L808-824) | ○ |
| C-89 | UT-MLL-089: Vectors.dense(varargs) | E-03 (Vectors.scala L250-252) | ○ |
| C-90 | UT-MLL-090: Vectors.dense(Array) | E-03 (Vectors.scala L258-259) | ○ |
| C-91 | UT-MLL-091: Vectors.sparse(indices,values) | E-03 (Vectors.scala L268-270) | ○ |
| C-92 | UT-MLL-092: Vectors.sparse(Seq) | E-03 (Vectors.scala L278-282) | ○ |
| C-93 | UT-MLL-093: Vectors.zeros | E-03 (Vectors.scala L303-306) | ○ |
| C-94 | UT-MLL-094: norm L1 | E-03 (Vectors.scala L337-381) | ○ |
| C-95 | UT-MLL-095: norm L2 | E-03 (Vectors.scala L337-381) | ○ |
| C-96 | UT-MLL-096: norm Linf | E-03 (Vectors.scala L337-381) | ○ |
| C-97 | UT-MLL-097: norm一般p | E-03 (Vectors.scala L337-381) | ○ |
| C-98 | UT-MLL-098: norm p<1エラー | E-03 (Vectors.scala L338-339) | ○ |
| C-99 | UT-MLL-099: sqdist Dense-Dense | E-03 (Vectors.scala L397-448) | ○ |
| C-100 | UT-MLL-100: sqdist Sparse-Sparse | E-03 (Vectors.scala L402-427) | ○ |
| C-101 | UT-MLL-101: sqdist Sparse-Dense | E-03 (Vectors.scala L429-431, L453-477) | ○ |
| C-102 | UT-MLL-102: sqdistサイズ不一致 | E-03 (Vectors.scala L398-399) | ○ |
| C-103 | UT-MLL-103: sqdist同一ベクトル | E-03 (Vectors.scala L397-448) | ○ |
| C-104 | UT-MLL-104: toSparse | E-03 (Vectors.scala L164-165) | ○ |
| C-105 | UT-MLL-105: toDense | E-03 (Vectors.scala L185) | ○ |
| C-106 | UT-MLL-106: compressed | E-03 (Vectors.scala L191-199) | △ |
| C-107 | UT-MLL-107: Vector.dot | E-03 (Vectors.scala L214) | ○ |
| C-108 | UT-MLL-108: DenseMatrix正常生成 | E-04 (Matrices.scala L301-308) | ○ |
| C-109 | UT-MLL-109: DenseMatrixサイズ不一致 | E-04 (Matrices.scala L307-308) | ○ |
| C-110 | UT-MLL-110: DenseMatrix.apply | E-04 (Matrices.scala L349-354) | ○ |
| C-111 | UT-MLL-111: DenseMatrix.apply範囲外 | E-04 (Matrices.scala L352-353) | ○ |
| C-112 | UT-MLL-112: DenseMatrix.transpose | E-04 (Matrices.scala L376) | ○ |
| C-113 | UT-MLL-113: DenseMatrix.copy | E-04 (Matrices.scala L361) | ○ |
| C-114 | UT-MLL-114: DenseMatrix.toArray | E-04 (Matrices.scala L55-61) | ○ |
| C-115 | UT-MLL-115: DenseMatrix.numNonzeros | E-04 (Matrices.scala L406) | ○ |
| C-116 | UT-MLL-116: DenseMatrix.numActives | E-04 (Matrices.scala L408) | ○ |
| C-117 | UT-MLL-117: DenseMatrix.toSparseMatrix | E-04 (Matrices.scala L415-439) | ○ |
| C-118 | UT-MLL-118: DenseMatrix.toDenseMatrix | E-04 (Matrices.scala L446-454) | ○ |
| C-119 | UT-MLL-119: DenseMatrix.multiply(DenseMatrix) | E-04 (Matrices.scala L104-108) | ○ |
| C-120 | UT-MLL-120: DenseMatrix.multiply(Vector) | E-04 (Matrices.scala L122-126) | ○ |
| C-121 | UT-MLL-121: DenseMatrix.foreachActive | E-04 (Matrices.scala L378-404) | ○ |
| C-122 | UT-MLL-122: DenseMatrix.colIter | E-04 (Matrices.scala L456-468) | ○ |
| C-123 | UT-MLL-123: DenseMatrix.equals | E-04 (Matrices.scala L329-332) | ○ |
| C-124 | UT-MLL-124: DenseMatrix.zeros | E-04 (Matrices.scala L505-509) | ○ |
| C-125 | UT-MLL-125: DenseMatrix.ones | E-04 (Matrices.scala L518-522) | ○ |
| C-126 | UT-MLL-126: DenseMatrix.eye | E-04 (Matrices.scala L530-538) | ○ |
| C-127 | UT-MLL-127: DenseMatrix.diag | E-04 (Matrices.scala L575-585) | ○ |
| C-128 | UT-MLL-128: SparseMatrix正常生成 | E-04 (Matrices.scala L611-629) | ○ |
| C-129 | UT-MLL-129: SparseMatrixvalues/rowIndices不一致 | E-04 (Matrices.scala L619-620) | ○ |
| C-130 | UT-MLL-130: SparseMatrixcolPtrs不正 | E-04 (Matrices.scala L621-627) | ○ |
| C-131 | UT-MLL-131: SparseMatrix.apply非ゼロ | E-04 (Matrices.scala L674-677) | ○ |
| C-132 | UT-MLL-132: SparseMatrix.applyゼロ | E-04 (Matrices.scala L676) | ○ |
| C-133 | UT-MLL-133: SparseMatrix.update非ゼロ | E-04 (Matrices.scala L689-697) | ○ |
| C-134 | UT-MLL-134: SparseMatrix.updateゼロ位置 | E-04 (Matrices.scala L691-693) | ○ |
| C-135 | UT-MLL-135: SparseMatrix.transpose | E-04 (Matrices.scala L716-717) | ○ |
| C-136 | UT-MLL-136: SparseMatrix.toDenseMatrix | E-04 (Matrices.scala L803-806) | ○ |
| C-137 | UT-MLL-137: SparseMatrix.toSparseMatrix | E-04 (Matrices.scala L757-796) | ○ |
| C-138 | UT-MLL-138: SparseMatrix.fromCOO | E-04 (Matrices.scala L887-928) | ○ |
| C-139 | UT-MLL-139: fromCOO重複加算 | E-04 (Matrices.scala L908-909) | ○ |
| C-140 | UT-MLL-140: fromCOO空エントリ | E-04 (Matrices.scala L887-928) | ○ |
| C-141 | UT-MLL-141: SparseMatrix.speye | E-04 (Matrices.scala L936-938) | ○ |
| C-142 | UT-MLL-142: SparseMatrix.spdiag | E-04 (Matrices.scala L1032-1042) | ○ |
| C-143 | UT-MLL-143: Matrices.dense | E-04 (Matrices.scala L1074-1076) | ○ |
| C-144 | UT-MLL-144: Matrices.sparse | E-04 (Matrices.scala L1088-1095) | ○ |
| C-145 | UT-MLL-145: horzcat Dense | E-04 (Matrices.scala L1212-1261) | ○ |
| C-146 | UT-MLL-146: horzcat混合 | E-04 (Matrices.scala L1212-1261) | ○ |
| C-147 | UT-MLL-147: horzcat空 | E-04 (Matrices.scala L1213-1214) | ○ |
| C-148 | UT-MLL-148: horzcat行数不一致 | E-04 (Matrices.scala L1222-1223) | ○ |
| C-149 | UT-MLL-149: vertcat Dense | E-04 (Matrices.scala L1271-1330) | ○ |
| C-150 | UT-MLL-150: vertcat列数不一致 | E-04 (Matrices.scala L1281-1282) | ○ |
| C-151 | UT-MLL-151: vertcat空 | E-04 (Matrices.scala L1272-1273) | ○ |
| C-152 | UT-MLL-152: Matrix.compressed | E-04 (Matrices.scala L254-265) | ○ |
| C-153 | UT-MLL-153: Matrix.compressedColMajor | E-04 (Matrices.scala L228-234) | ○ |
| C-154 | UT-MLL-154: Matrix.compressedRowMajor | E-04 (Matrices.scala L240-246) | ○ |
| C-155 | UT-MLL-155: MultivariateGaussian正常生成 | E-05 (MultivariateGaussian.scala L39-44) | ○ |
| C-156 | UT-MLL-156: MultivariateGaussian非正方 | E-05 (MultivariateGaussian.scala L43) | ○ |
| C-157 | UT-MLL-157: MultivariateGaussianサイズ不一致 | E-05 (MultivariateGaussian.scala L44) | ○ |
| C-158 | UT-MLL-158: pdf平均点 | E-05 (MultivariateGaussian.scala L70-72) | ○ |
| C-159 | UT-MLL-159: pdf 1次元 | E-05 (MultivariateGaussian.scala L70-72) | ○ |
| C-160 | UT-MLL-160: pdf距離減少 | E-05 (MultivariateGaussian.scala L70-72) | ○ |
| C-161 | UT-MLL-161: logpdf | E-05 (MultivariateGaussian.scala L78-82) | ○ |
| C-162 | UT-MLL-162: logpdf特異行列 | E-05 (MultivariateGaussian.scala L112-132) | △ |
| C-163 | UT-MLL-163: getSparseSize | E-04 (Matrices.scala L1332-1341) | ○ |
| C-164 | UT-MLL-164: getDenseSize | E-04 (Matrices.scala L1343-1351) | ○ |
| C-165 | UT-MLL-165: Vectors.getSparseSize | E-03 (Vectors.scala L509-518) | ○ |
| C-166 | UT-MLL-166: Vectors.getDenseSize | E-03 (Vectors.scala L520-528) | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-MLL-001**: EPSILONの具体的な期待値は実行環境（JVM、CPU）に依存する。コード上はwhile条件でマシンイプシロンを計算しているが、具体的な数値の検証にはランタイム実行が必要。
  - 候補：IEEE 754倍精度浮動小数点の仕様書 / JVMのDouble精度仕様
- **UT-MLL-018**: nativeBLASのフォールバック挙動はNetlibの実装とOS環境に依存する。テスト環境によってnativeが利用可能かどうかが異なる。
  - 候補：Netlib-javaのドキュメント / CI環境仕様書
- **UT-MLL-106**: compressedの判定閾値はgetSparseSize/getDenseSizeに基づくが、具体的な判定境界は入力データに依存する。
  - 候補：getSparseSize/getDenseSizeの実装詳細
- **UT-MLL-162**: 特異共分散行列でのlogpdf計算はeigSymの分解結果とtol閾値に依存する。数値安定性は環境によって異なる可能性がある。
  - 候補：Breezeライブラリの固有値分解精度仕様

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク**: ファクトリメソッド系テストケース（UT-MLL-089〜093, UT-MLL-124〜127, UT-MLL-141〜144）は単純な委譲であり、リスクは低い
- **1: 中リスク**: BLAS演算のgemm/gemv系テストケース（UT-MLL-044〜056）は行列サイズ・転置フラグの組み合わせが多く、テストケースの網羅性を追加確認すべき
- **2: 高リスク**: MultivariateGaussian（UT-MLL-155〜162）は数値計算精度に依存するため、許容誤差の設定が適切かレビューが必要
- **1: 中リスク**: `scala/collection/compat/package.scala`（E-06）は型エイリアスのみのため、テスト対象外とした判断は妥当だが、互換性テストの要否は確認すべき

## 6) レビュアーチェックリスト（最小）
- [ ] BLAS系テストケース（UT-MLL-021〜056）の期待結果の数値が手計算と一致するか確認
- [ ] MultivariateGaussian（UT-MLL-158〜162）のPDF/logPDFの期待値が数学的に正しいか確認
- [ ] SparseVectorのargmax（UT-MLL-083〜086）における暗黙的ゼロの扱いが仕様と一致するか確認
- [ ] gemm/gemvの転置行列パターン（UT-MLL-054）のテストケースが十分か確認
- [ ] 各異常系テストケースのException型が実装と一致するか確認（require/IllegalArgumentException）
- [ ] `scala/collection/compat/package.scala`をテスト対象外とした判断の妥当性を確認
