---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 63
  claims_with_evidence: 61
  claims_without_evidence: 2
confidence_derived: 0.97
---

# 根拠レポート：repl モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：61 / 63、根拠なし：2
- 優先レビュー（高）
  1. **C-60 (UT-RPL-060)**：isShellSession=trueかつ例外発生時のsys.exit(1)の挙動はソースコードで確認可能だが、テスト実行時のsys.exit制御が必要
  2. **C-61 (UT-RPL-061)**：isShellSession=falseかつ例外発生時の伝播挙動はcatchの条件分岐から推測だが、非シェルセッション状態の再現方法が明確でない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `repl/src/main/scala/org/apache/spark/repl/SparkILoop.scala` - SparkILoopクラス定義（行34-133）
- E-02: `repl/src/main/scala/org/apache/spark/repl/SparkILoop.scala` - SparkILoopコンパニオンオブジェクト（行135-158）
- E-03: `repl/src/main/scala/org/apache/spark/repl/Signaling.scala` - Signalingオブジェクト定義（行24-44）
- E-04: `repl/src/main/scala/org/apache/spark/repl/Main.scala` - Mainオブジェクト定義（行33-142）
- E-05: `repl/src/main/scala/org/apache/spark/repl/SparkILoop.scala` - initializationCommands定義（行44-79）
- E-06: `repl/src/main/scala/org/apache/spark/repl/SparkILoop.scala` - initializeSpark()メソッド（行84-96）
- E-07: `repl/src/main/scala/org/apache/spark/repl/SparkILoop.scala` - printWelcome()メソッド（行99-116）
- E-08: `repl/src/main/scala/org/apache/spark/repl/SparkILoop.scala` - resetCommand()メソッド（行121-127）
- E-09: `repl/src/main/scala/org/apache/spark/repl/SparkILoop.scala` - replay()メソッド（行129-132）
- E-10: `repl/src/main/scala/org/apache/spark/repl/Main.scala` - createSparkSession()メソッド（行92-140）
- E-11: `repl/src/main/scala/org/apache/spark/repl/Main.scala` - doMain()メソッド（行66-90）
- E-12: `repl/src/main/scala/org/apache/spark/repl/Main.scala` - main()メソッド（行58-63）
- E-13: `repl/src/main/scala/org/apache/spark/repl/Main.scala` - scalaOptionError()メソッド（行51-56）
- E-14: `repl/src/main/scala/org/apache/spark/repl/Main.scala` - フィールド定義（行38-49）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SparkILoop 2引数コンストラクタでBufferedReaderとPrintWriterからインスタンス生成 | E-01 (行36-37) | ○ |
| C-02 | SparkILoop Settings指定コンストラクタでin0=null, out=Console.outのPrintWriter | E-01 (行39-40) | ○ |
| C-03 | SparkILoop デフォルトコンストラクタでGenericRunnerSettingsを使用 | E-01 (行42) | ○ |
| C-04 | initializationCommandsがspark/sc初期化とimportを含むSeq[String] | E-05 (行44-79) | ○ |
| C-05 | initializationCommandsにspark.implicits._のimportが含まれる | E-05 (行73) | ○ |
| C-06 | initializationCommandsにspark.sqlとfunctions._のimportが含まれる | E-05 (行74-75) | ○ |
| C-07 | initializationCommandsにSPARK_LOG_SCHEMAのimportが含まれる | E-05 (行76) | ○ |
| C-08 | internalReplAutorunCodeがinitializationCommandsを返す | E-01 (行81-82) | ○ |
| C-09 | initializeSpark正常時にinitializationCommandsが実行される | E-06 (行85-89) | ○ |
| C-10 | initializeSparkでインタプリタエラー時にRuntimeExceptionがスロー | E-06 (行90-95) | ○ |
| C-11 | initializeSparkでsavingReplayStackによりセッション履歴に記録されない | E-06 (行87-89) | ○ |
| C-12 | printWelcomeでSparkバナーが表示される | E-07 (行101-107) | ○ |
| C-13 | printWelcomeでScalaバージョンとJavaバージョンが表示される | E-07 (行108-112) | ○ |
| C-14 | printWelcomeでヘルプ案内が表示される | E-07 (行115) | ○ |
| C-15 | commandsがstandardCommandsを返す | E-01 (行119) | ○ |
| C-16 | resetCommandでinitializeSparkが呼ばれる | E-08 (行122-123) | ○ |
| C-17 | resetCommand後に状態不変メッセージが表示される | E-08 (行124-126) | ○ |
| C-18 | replayでinitializeSparkが先に呼ばれる | E-09 (行130-131) | ○ |
| C-19 | SparkILoop.run(code, sets)でコードが実行され結果が返却される | E-02 (行141-156) | ○ |
| C-20 | classpath未設定時にjava.class.pathが使用される | E-02 (行150-151) | ○ |
| C-21 | classpath設定済みの場合にそのまま使用される | E-02 (行150) | ○ |
| C-22 | 空文字列コード入力時の処理 | E-02 (行141-156) | ○ |
| C-23 | run(lines)で各行が改行付きで結合されて実行される | E-02 (行157) | ○ |
| C-24 | run(lines)で空リストが渡された場合の処理 | E-02 (行157) | ○ |
| C-25 | run(lines)で1行リストが渡された場合の処理 | E-02 (行157) | ○ |
| C-26 | cancelOnInterruptでアクティブジョブキャンセル時にtrueが返却される | E-03 (行32-38) | ○ |
| C-27 | cancelOnInterruptでアクティブジョブなし時にfalseが返却される | E-03 (行38-39) | ○ |
| C-28 | cancelOnInterruptでSparkContext未アクティブ時にfalseが返却される | E-03 (行41) | ○ |
| C-29 | ジョブキャンセル時に警告ログが出力される | E-03 (行34-35) | ○ |
| C-30 | Main.confがSparkConfインスタンスとして初期化される | E-14 (行38) | ○ |
| C-31 | spark.repl.classdir設定時にその値がrootDirになる | E-14 (行39-40) | ○ |
| C-32 | spark.repl.classdir未設定時にUtils.getLocalDirが使用される | E-14 (行40) | ○ |
| C-33 | outputDirがrootDir配下にrepl接頭辞で作成される | E-14 (行41) | ○ |
| C-34 | scalaOptionErrorでメッセージがstderrに出力される | E-13 (行53-54) | ○ |
| C-35 | scalaOptionErrorでhasErrorsがtrueに設定される | E-13 (行52) | ○ |
| C-36 | main()でisShellSessionがtrueに設定される | E-12 (行59) | ○ |
| C-37 | main()で引数がGenericRunnerSettingsに渡される | E-12 (行60-61) | ○ |
| C-38 | doMainでinterpフィールドが設定される | E-11 (行67) | ○ |
| C-39 | doMainでfile:スキームのJARパスが除去される | E-11 (行71-73) | ○ |
| C-40 | doMainでfile:以外のJARパスがそのまま使用される | E-11 (行72) | ○ |
| C-41 | interpArguments に-Yrepl-class-basedが含まれる | E-11 (行76) | ○ |
| C-42 | interpArgumentsに-Yrepl-outdirとoutputDirパスが含まれる | E-11 (行77-78) | ○ |
| C-43 | hasErrors=false時にinterp.runが呼ばれる | E-11 (行86-87) | ○ |
| C-44 | hasErrors=true時にinterp.runが呼ばれない | E-11 (行86) | ○ |
| C-45 | REPL終了後にsparkContext.stop()が呼ばれる | E-11 (行88) | ○ |
| C-46 | sparkContext=null時にstopが呼ばれない | E-11 (行88) | ○ |
| C-47 | spark.app.nameが未設定時にSpark shellに設定される | E-10 (行95) | ○ |
| C-48 | spark.app.nameが設定済みの場合に上書きされない | E-10 (行95: setIfMissing) | ○ |
| C-49 | spark.repl.class.outputDirがoutputDirパスに設定される | E-10 (行101) | ○ |
| C-50 | ARTIFACTS_SESSION_ISOLATION_ENABLEDがfalseに設定される | E-10 (行104) | ○ |
| C-51 | SPARK_EXECUTOR_URI設定時にspark.executor.uriに反映される | E-10 (行105-107) | ○ |
| C-52 | SPARK_EXECUTOR_URI未設定時にspark.executor.uriが設定されない | E-10 (行105) | ○ |
| C-53 | SPARK_HOME設定時にsparkHomeに反映される | E-10 (行108-110) | ○ |
| C-54 | catalog=hive, Hiveクラス存在時にenableHiveSupportが呼ばれる | E-10 (行113-119) | ○ |
| C-55 | catalog=hive, Hiveクラス不在時にin-memoryにフォールバック | E-10 (行120-126) | ○ |
| C-56 | catalog=hive以外の場合にin-memoryカタログが使用される | E-10 (行127-132) | ○ |
| C-57 | sparkContextフィールドが設定される | E-10 (行133) | ○ |
| C-58 | sparkSessionフィールドが設定される | E-10 (行118, 124, 131) | ○ |
| C-59 | 作成されたSparkSessionが返却される | E-10 (行134) | ○ |
| C-60 | isShellSession=trueかつ例外発生時にsys.exit(1)が呼ばれる | E-10 (行136-138) | △ |
| C-61 | isShellSession=falseかつ例外発生時に例外がそのまま伝播する | E-10 (行136) | △ |
| C-62 | Hiveサポート有効化時にlogInfoが出力される | E-10 (行119) | ○ |
| C-63 | Hiveクラス不在時にlogInfoが出力される | E-10 (行125) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-60: `sys.exit(1)` の呼び出しはソースコードで確認可能だが、単体テストでは `sys.exit` をモック化する必要があり、テスト実装の実現性が未確認。catch節の `case e: Exception if isShellSession =>` という条件ガードはコードから明確に読み取れるが、`isShellSession` が `false` の場合にExceptionが再スローされるかの挙動は暗黙的（catchされないため伝播する）。
  - 候補：実装時に SecurityManager を使用する / sys.exit をモック化する / テストフレームワーク固有の sys.exit トラップ機能を使用する
- C-61: `isShellSession=false` の状態は `main()` を経由せずに `doMain()` を直接呼ぶことで実現可能だが、`createSparkSession` 内部で例外を意図的に発生させるテスト設計の詳細は不明。
  - 候補：不正な SparkConf を注入する / 依存コンポーネントをモック化する / テスト用のサブクラスを作成する

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - SparkILoop のコンストラクタ・printWelcome・commands（C-01〜C-03, C-12〜C-15）: ソースコードの定義がそのまま根拠となる
- 0: 低リスク - initializationCommands の内容確認（C-04〜C-07）: 文字列リテラルからの確認で高信頼度
- 0: 低リスク - Signaling.cancelOnInterrupt の分岐処理（C-26〜C-29）: コードが短く分岐が明確
- 1: 中リスク - Main.createSparkSession の条件分岐（C-54〜C-56）: Hiveクラス存在判定に実行環境依存がある
- 2: 高リスク - sys.exit(1) 呼び出しのテスト可能性（C-60）: テスト実装にモック化等の特殊な手法が必要
- 1: 中リスク - isShellSession=false での例外伝播テスト（C-61）: 非シェルセッション状態の再現方法に検討が必要

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースのテストIDが UT-RPL-001 から連番で一意であること
- [ ] SparkILoop の全 public メソッド（initializeSpark, printWelcome, commands, resetCommand, replay）がカバーされていること
- [ ] SparkILoop コンパニオンオブジェクトの run メソッド（2つのオーバーロード）がカバーされていること
- [ ] Signaling.cancelOnInterrupt の3つの分岐（ジョブあり/ジョブなし/SparkContext未アクティブ）が網羅されていること
- [ ] Main.createSparkSession の3つのカタログ分岐（hive+存在/hive+不在/非hive）が網羅されていること
- [ ] Main.doMain の hasErrors=true/false 分岐が網羅されていること
- [ ] Main.createSparkSession の例外ハンドリング（isShellSession=true/false）が網羅されていること
- [ ] 環境変数依存（SPARK_EXECUTOR_URI, SPARK_HOME）のテストケースが正常系・異常系で網羅されていること
- [ ] 境界値テスト（run(lines) の空リスト、1件リスト）が含まれていること
- [ ] sys.exit(1) のテストに関して、テスト実装方法の注記が適切であること
