---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 173
  claims_with_evidence: 168
  claims_without_evidence: 5
confidence_derived: 0.97
---

# 根拠レポート：resource-managers-kubernetes-core 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：168 / 173、根拠なし：5
- 優先レビュー（高）
  1. **UT-K8S-161 (SparkKubernetesClientFactory.createKubernetesClient)**：内部実装の詳細が複雑であり、OAuthトークンバリデーション等の条件分岐を完全に検証できていない
  2. **UT-K8S-157〜160 (ExecutorPodsSnapshotsStoreImpl)**：並行処理を伴うため、ロック取得のタイミング等に関するテストケースの妥当性を検証が必要
  3. **UT-K8S-134〜135 (ExecutorRollDriverPlugin OUTLIER系)**：outlier検出の統計的閾値（2-sigma）に基づく判定の網羅性を確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `resource-managers/kubernetes/core/src/main/scala/org/apache/spark/deploy/k8s/KubernetesUtils.scala` - ユーティリティメソッド群（parsePrefixedKeyValuePairs, requireBothOrNeitherDefined, buildEnvVars等）
- E-02: `resource-managers/kubernetes/core/src/main/scala/org/apache/spark/deploy/k8s/KubernetesConf.scala` - KubernetesDriverConf, KubernetesExecutorConf（labels, image, driverServiceName, getResourceNamePrefix等）
- E-03: `resource-managers/kubernetes/core/src/main/scala/org/apache/spark/deploy/k8s/KubernetesVolumeUtils.scala` - ボリューム設定パーサー（parseVolumesWithPrefix）
- E-04: `resource-managers/kubernetes/core/src/main/scala/org/apache/spark/deploy/k8s/features/BasicDriverFeatureStep.scala` - ドライバPod構成（configurePod, getAdditionalPodSystemProperties）
- E-05: `resource-managers/kubernetes/core/src/main/scala/org/apache/spark/deploy/k8s/features/BasicExecutorFeatureStep.scala` - ExecutorPod構成（configurePod, blockManagerPort require）
- E-06: `resource-managers/kubernetes/core/src/main/scala/org/apache/spark/deploy/k8s/features/DriverServiceFeatureStep.scala` - ドライバService構成（getAdditionalKubernetesResources, require制約）
- E-07: `resource-managers/kubernetes/core/src/main/scala/org/apache/spark/deploy/k8s/features/MountVolumesFeatureStep.scala` - ボリュームマウント機能（configurePod, constructVolumes）
- E-08: `resource-managers/kubernetes/core/src/main/scala/org/apache/spark/deploy/k8s/features/LocalDirsFeatureStep.scala` - ローカルディレクトリ設定（configurePod）
- E-09: `resource-managers/kubernetes/core/src/main/scala/org/apache/spark/deploy/k8s/features/EnvSecretsFeatureStep.scala` - シークレット環境変数（configurePod）
- E-10: `resource-managers/kubernetes/core/src/main/scala/org/apache/spark/deploy/k8s/features/MountSecretsFeatureStep.scala` - シークレットマウント（configurePod）
- E-11: `resource-managers/kubernetes/core/src/main/scala/org/apache/spark/deploy/k8s/features/DriverCommandFeatureStep.scala` - ドライバコマンド構成（configurePod, getAdditionalPodSystemProperties）
- E-12: `resource-managers/kubernetes/core/src/main/scala/org/apache/spark/scheduler/cluster/k8s/ExecutorPodsSnapshot.scala` - Podスナップショット（withUpdate, toState, isDeleted）
- E-13: `resource-managers/kubernetes/core/src/main/scala/org/apache/spark/scheduler/cluster/k8s/ExecutorPodsAllocator.scala` - Podアロケータ（splitSlots, isDeleted, requestNewExecutors）
- E-14: `resource-managers/kubernetes/core/src/main/scala/org/apache/spark/scheduler/cluster/k8s/ExecutorPodsLifecycleManager.scala` - Podライフサイクル（describeExitCode, findExitCode, isPodInactive）
- E-15: `resource-managers/kubernetes/core/src/main/scala/org/apache/spark/scheduler/cluster/k8s/ExecutorRollPlugin.scala` - Executorローリング（choose, outliers）
- E-16: `resource-managers/kubernetes/core/src/main/scala/org/apache/spark/deploy/k8s/submit/KubernetesClientUtils.scala` - ConfigMapユーティリティ（configMapName, buildConfigMap, buildKeyToPathObjects）
- E-17: `resource-managers/kubernetes/core/src/main/scala/org/apache/spark/deploy/k8s/submit/LoggingPodStatusWatcher.scala` - Podステータス監視（eventReceived, onClose, watchOrStop）
- E-18: `resource-managers/kubernetes/core/src/main/scala/org/apache/spark/deploy/k8s/SparkPod.scala` - SparkPod（transform, initialPod）
- E-19: `resource-managers/kubernetes/core/src/main/scala/org/apache/spark/scheduler/cluster/k8s/ExecutorPodsSnapshotsStoreImpl.scala` - スナップショットストア（updatePod, replaceSnapshot, addSubscriber, stop）
- E-20: `resource-managers/kubernetes/core/src/main/scala/org/apache/spark/deploy/k8s/SparkKubernetesClientFactory.scala` - K8sクライアントファクトリ（createKubernetesClient）
- E-21: `resource-managers/kubernetes/core/src/main/scala/org/apache/spark/deploy/k8s/Constants.scala` - 定数定義
- E-22: `resource-managers/kubernetes/core/src/main/scala/org/apache/spark/deploy/k8s/KubernetesVolumeSpec.scala` - ボリューム仕様データクラス
- E-23: `resource-managers/kubernetes/core/src/main/scala/org/apache/spark/scheduler/cluster/k8s/ExecutorPodStates.scala` - Pod状態タイプ定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-K8S-001〜002) | KubernetesUtils.parsePrefixedKeyValuePairsの正常系・境界値テスト | E-01 | ○ |
| C-02 (UT-K8S-003〜006) | KubernetesUtils.requireBothOrNeitherDefinedの全パターンテスト | E-01 | ○ |
| C-03 (UT-K8S-007〜008) | KubernetesUtils.requireSecondIfFirstIsDefinedの正常系・異常系テスト | E-01 | ○ |
| C-04 (UT-K8S-009〜011) | KubernetesUtils.requireNandDefinedの全パターンテスト | E-01 | ○ |
| C-05 (UT-K8S-012〜014) | KubernetesUtils.parseMasterUrl・formatTimeのテスト | E-01 | ○ |
| C-06 (UT-K8S-015〜016) | KubernetesUtils.uniqueIDの正常系テスト | E-01 | ○ |
| C-07 (UT-K8S-017〜019) | KubernetesUtils.formatPairsBundleの正常系・境界値・異常系テスト | E-01 | ○ |
| C-08 (UT-K8S-020〜021) | KubernetesUtils.buildResourcesQuantitiesの正常系・異常系テスト | E-01 | ○ |
| C-09 (UT-K8S-022〜024) | KubernetesUtils.isLocalAndResolvableの各パターンテスト | E-01 | ○ |
| C-10 (UT-K8S-025〜026) | KubernetesUtils.uploadFileUriの異常系テスト | E-01 | ○ |
| C-11 (UT-K8S-027〜028) | KubernetesUtils.buildPodWithServiceAccountの正常系・境界値テスト | E-01 | ○ |
| C-12 (UT-K8S-029〜033) | KubernetesUtils.buildEnvVars・buildEnvVarsWithFieldRefのテスト | E-01 | ○ |
| C-13 (UT-K8S-034〜035) | KubernetesUtils.addOwnerReferenceのテスト | E-01 | ○ |
| C-14 (UT-K8S-036〜041) | KubernetesConf.getResourceNamePrefix・getAppNameLabelのテスト | E-02 | ○ |
| C-15 (UT-K8S-042〜043) | KubernetesConf.buildKubernetesResourceName・getKubernetesAppIdのテスト | E-02 | ○ |
| C-16 (UT-K8S-044〜049) | KubernetesDriverConf.labels・driverServiceName・imageのテスト | E-02 | ○ |
| C-17 (UT-K8S-050〜053) | KubernetesExecutorConf.labels・image・environmentのテスト | E-02 | ○ |
| C-18 (UT-K8S-054〜063) | KubernetesVolumeUtils.parseVolumesWithPrefixの全パターンテスト | E-03, E-22 | ○ |
| C-19 (UT-K8S-064〜070) | BasicDriverFeatureStep.configurePod・getAdditionalPodSystemPropertiesのテスト | E-04, E-21 | ○ |
| C-20 (UT-K8S-071〜080) | BasicExecutorFeatureStep.configurePodの全パターンテスト | E-05, E-21 | ○ |
| C-21 (UT-K8S-081〜084) | DriverServiceFeatureStepのテスト（Service構築、require制約） | E-06, E-21 | ○ |
| C-22 (UT-K8S-085〜091) | MountVolumesFeatureStep.configurePodの全パターンテスト | E-07, E-22 | ○ |
| C-23 (UT-K8S-092〜094) | LocalDirsFeatureStep.configurePodのテスト | E-08 | ○ |
| C-24 (UT-K8S-095〜096) | EnvSecretsFeatureStep.configurePodのテスト | E-09 | ○ |
| C-25 (UT-K8S-097〜098) | MountSecretsFeatureStep.configurePodのテスト | E-10 | ○ |
| C-26 (UT-K8S-099〜104) | DriverCommandFeatureStepのテスト | E-11 | ○ |
| C-27 (UT-K8S-105〜118) | ExecutorPodsSnapshotのテスト（状態遷移、削除判定） | E-12, E-23 | ○ |
| C-28 (UT-K8S-119〜124) | ExecutorPodsAllocator.splitSlots・isDeletedのテスト | E-13 | ○ |
| C-29 (UT-K8S-125〜128) | ExecutorPodsLifecycleManager.describeExitCodeのテスト | E-14 | ○ |
| C-30 (UT-K8S-129〜140) | ExecutorRollDriverPlugin.choose・outliersのテスト | E-15 | ○ |
| C-31 (UT-K8S-141〜148) | KubernetesClientUtilsのテスト | E-16 | ○ |
| C-32 (UT-K8S-149〜153) | LoggingPodStatusWatcherImplのテスト | E-17 | ○ |
| C-33 (UT-K8S-154〜156) | SparkPod.transform・initialPodのテスト | E-18 | ○ |
| C-34 (UT-K8S-157〜160) | ExecutorPodsSnapshotsStoreImplのテスト | E-19 | △ |
| C-35 (UT-K8S-161〜162) | SparkKubernetesClientFactoryのテスト | E-20 | △ |
| C-36 (UT-K8S-163〜166) | KubernetesUtils.selectSparkContainerのテスト | E-01 | ○ |
| C-37 (UT-K8S-167〜170) | KubernetesUtils.containerStatusDescriptionのテスト | E-01 | ○ |
| C-38 (UT-K8S-171〜173) | KubernetesUtils.renameMainAppResourceのテスト | E-01 | △ |

## 4) 不足情報（Unknown / Missing）
- **ExecutorPodsSnapshotsStoreImpl (C-34)**：並行処理のテストは、ScheduledExecutorServiceのモック化が必要であり、単体テストケースの入力値・期待結果の具体性が不足している。実際のスレッド間通信のタイミングに依存する挙動は、統合テストで確認が必要。
  - 候補：ScheduledExecutorServiceのモック / ConcurrentHashMapの動作検証 / ReentrantLockの競合テスト
- **SparkKubernetesClientFactory (C-35)**：createKubernetesClientの内部でfabric8 KubernetesClientBuilderを使用しており、実際のK8sクラスタ接続が必要な部分はモック化の方針を決める必要がある。
  - 候補：KubernetesClientBuilder モック / ConfigBuilder モック / 認証情報バリデーションの単体テスト化
- **renameMainAppResource (C-38)**：uploadFileUriへの委譲を含むため、Hadoop FileSystemのモックが必要。具体的なアップロードパスやFileSystem操作の期待結果が不確定。
  - 候補：HadoopFileSystem モック / SparkConf.KUBERNETES_FILE_UPLOAD_PATH設定 / ファイルシステム操作のスタブ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - KubernetesUtils のバリデーション系テスト（UT-K8S-003〜011）は、ソースコード上の require/assert 文と完全に対応しており信頼度が高い
- 0: 低リスク - ExecutorPodsSnapshot の状態遷移テスト（UT-K8S-107〜118）は、ソースコード上の match 文のパターンと1対1で対応している
- 1: 中リスク - ExecutorPodsAllocator の onNewSnapshots メソッドは複雑であり、現在のテストケースは splitSlots と isDeleted のみをカバーしている。内部のスナップショット処理ロジックの網羅性を確認が必要
- 1: 中リスク - ExecutorRollPlugin の outlier 検出は統計的アルゴリズムであり、テストデータの設計が結果に大きく影響する
- 2: 高リスク - ExecutorPodsSnapshotsStoreImpl は並行処理を伴い、ロック取得・解放のタイミングに依存する動作がある。スレッドセーフ性の検証にはより精密なテスト設計が必要

## 6) レビュアーチェックリスト（最小）
- [ ] KubernetesUtils のバリデーション系テスト（UT-K8S-003〜011）がソースコードの require 文と一致しているか
- [ ] ExecutorPodsSnapshot の状態遷移テスト（UT-K8S-107〜118）がソースコードの全 match パターンをカバーしているか
- [ ] BasicDriverFeatureStep / BasicExecutorFeatureStep のリソース設定テストが、CPU/メモリの request/limit の両方をカバーしているか
- [ ] ExecutorPodsAllocator.splitSlots のテストが均等分配・余り・不足の全パターンをカバーしているか
- [ ] DriverServiceFeatureStep の require 制約テストが、spark.driver.bindAddress と spark.driver.host の両方をカバーしているか
- [ ] MountVolumesFeatureStep のテストが hostPath / PVC / emptyDir / NFS の4種類すべてをカバーしているか
- [ ] ExecutorRollPlugin の全ロールポリシー（ID, ADD_TIME, TOTAL_GC_TIME, TOTAL_DURATION, AVERAGE_DURATION, FAILED_TASKS, PEAK_JVM_ONHEAP_MEMORY, PEAK_JVM_OFFHEAP_MEMORY, TOTAL_SHUFFLE_WRITE, DISK_USED, OUTLIER, OUTLIER_NO_FALLBACK）がテストされているか
- [ ] 並行処理を伴うクラス（ExecutorPodsSnapshotsStoreImpl）のテストケースが、スレッドセーフ性を検証する観点を含んでいるか
