---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 150
  claims_with_evidence: 142
  claims_without_evidence: 8
confidence_derived: 0.95
---

# 根拠レポート：resource-managers-yarn 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：142 / 150、根拠なし：8
- 優先レビュー（高）
  1. **UT-YRN-101 SparkRackResolver.resolve**：外部依存（Hadoop RackResolver）のため動作詳細が不透明
  2. **UT-YRN-125 YarnCommandBuilderUtils.findJarsDir**：例外型の詳細がScalaコードからのみの推測
  3. **UT-YRN-134 YarnCoarseGrainedExecutorBackend.extractLogUrls**：YARN環境変数依存のため実行環境による差異あり
  4. **UT-YRN-136 YarnClientSchedulerBackend.start**：内部でClient.submitApplication呼出しだが統合テスト寄り
  5. **UT-YRN-137 YarnClientSchedulerBackend.stop**：内部でClient.stop呼出しだが統合テスト寄り

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `resource-managers/yarn/src/main/java/org/apache/spark/deploy/yarn/AmIpFilter.java` - AmIpFilter クラスのソースコード
- E-02: `resource-managers/yarn/src/main/java/org/apache/spark/deploy/yarn/AmIpPrincipal.java` - AmIpPrincipal クラスのソースコード
- E-03: `resource-managers/yarn/src/main/java/org/apache/spark/deploy/yarn/AmIpServletRequestWrapper.java` - AmIpServletRequestWrapper クラスのソースコード
- E-04: `resource-managers/yarn/src/main/java/org/apache/spark/deploy/yarn/ProxyUtils.java` - ProxyUtils クラスのソースコード
- E-05: `resource-managers/yarn/src/main/scala/org/apache/spark/deploy/yarn/ApplicationMasterArguments.scala` - ApplicationMasterArguments クラスのソースコード
- E-06: `resource-managers/yarn/src/main/scala/org/apache/spark/deploy/yarn/ClientArguments.scala` - ClientArguments クラスのソースコード
- E-07: `resource-managers/yarn/src/main/scala/org/apache/spark/deploy/yarn/ClientDistributedCacheManager.scala` - ClientDistributedCacheManager クラスのソースコード
- E-08: `resource-managers/yarn/src/main/scala/org/apache/spark/deploy/yarn/ResourceRequestHelper.scala` - ResourceRequestHelper オブジェクトのソースコード
- E-09: `resource-managers/yarn/src/main/scala/org/apache/spark/deploy/yarn/YarnAllocator.scala` - YarnAllocator クラスのソースコード
- E-10: `resource-managers/yarn/src/main/scala/org/apache/spark/deploy/yarn/YarnAllocatorNodeHealthTracker.scala` - YarnAllocatorNodeHealthTracker クラスのソースコード
- E-11: `resource-managers/yarn/src/main/scala/org/apache/spark/deploy/yarn/Client.scala` - Client クラスおよびコンパニオンオブジェクトのソースコード
- E-12: `resource-managers/yarn/src/main/scala/org/apache/spark/deploy/yarn/ApplicationMaster.scala` - ApplicationMaster クラスおよびコンパニオンオブジェクトのソースコード
- E-13: `resource-managers/yarn/src/main/scala/org/apache/spark/deploy/yarn/SparkRackResolver.scala` - SparkRackResolver クラスのソースコード
- E-14: `resource-managers/yarn/src/main/scala/org/apache/spark/deploy/yarn/ExecutorRunnable.scala` - ExecutorRunnable クラスのソースコード
- E-15: `resource-managers/yarn/src/main/scala/org/apache/spark/deploy/yarn/YarnRMClient.scala` - YarnRMClient クラスのソースコード
- E-16: `resource-managers/yarn/src/main/scala/org/apache/spark/deploy/yarn/YarnSparkHadoopUtil.scala` - YarnSparkHadoopUtil オブジェクトのソースコード
- E-17: `resource-managers/yarn/src/main/scala/org/apache/spark/deploy/yarn/YarnProxyRedirectFilter.scala` - YarnProxyRedirectFilter クラスのソースコード
- E-18: `resource-managers/yarn/src/main/scala/org/apache/spark/deploy/yarn/LocalityPreferredContainerPlacementStrategy.scala` - コンテナ配置戦略クラスのソースコード
- E-19: `resource-managers/yarn/src/main/scala/org/apache/spark/util/YarnContainerInfoHelper.scala` - YarnContainerInfoHelper オブジェクトのソースコード
- E-20: `resource-managers/yarn/src/main/scala/org/apache/spark/launcher/YarnCommandBuilderUtils.scala` - YarnCommandBuilderUtils オブジェクトのソースコード
- E-21: `resource-managers/yarn/src/main/scala/org/apache/spark/scheduler/cluster/YarnClusterManager.scala` - YarnClusterManager クラスのソースコード
- E-22: `resource-managers/yarn/src/main/scala/org/apache/spark/scheduler/cluster/YarnSchedulerBackend.scala` - YarnSchedulerBackend クラスのソースコード
- E-23: `resource-managers/yarn/src/main/scala/org/apache/spark/deploy/yarn/config/package.scala` - YARN設定定義パッケージのソースコード
- E-24: `resource-managers/yarn/src/main/scala/org/apache/spark/deploy/yarn/ApplicationMasterSource.scala` - ApplicationMasterSource クラスのソースコード
- E-25: `resource-managers/yarn/src/main/scala/org/apache/spark/executor/YarnCoarseGrainedExecutorBackend.scala` - YarnCoarseGrainedExecutorBackend クラスのソースコード
- E-26: `resource-managers/yarn/src/main/scala/org/apache/spark/scheduler/cluster/YarnScheduler.scala` - YarnScheduler クラスのソースコード
- E-27: `resource-managers/yarn/src/main/scala/org/apache/spark/scheduler/cluster/YarnClientSchedulerBackend.scala` - YarnClientSchedulerBackend クラスのソースコード
- E-28: `resource-managers/yarn/src/main/scala/org/apache/spark/scheduler/cluster/YarnClusterSchedulerBackend.scala` - YarnClusterSchedulerBackend クラスのソースコード

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-YRN-001: AmIpFilter.init がプロキシホスト情報を初期化 | E-01 (L56-L88) | ○ |
| C-02 | UT-YRN-002: プロキシホストからのリクエストが通過 | E-01 (L93-L120) | ○ |
| C-03 | UT-YRN-003: 非プロキシホストからのリクエストが302リダイレクト | E-01 (L120-L160) | ○ |
| C-04 | UT-YRN-004: PROXY_URI_BASES未設定時に500エラー | E-01 (L140-L150) | ○ |
| C-05 | UT-YRN-005: ホスト名からIPアドレス解決 | E-01 (L170-L190) | ○ |
| C-06 | UT-YRN-006: DNS解決不可時に空セット | E-01 (L170-L190) | ○ |
| C-07 | UT-YRN-007: AmIpPrincipal.getName が名前を返却 | E-02 (全体) | ○ |
| C-08 | UT-YRN-008: AmIpServletRequestWrapper.getRemoteUser | E-03 (全体) | ○ |
| C-09 | UT-YRN-009: AmIpServletRequestWrapper.getUserPrincipal | E-03 (全体) | ○ |
| C-10 | UT-YRN-010: ProxyUtils.getContentType が正しいContent-Type返却 | E-04 (全体) | ○ |
| C-11 | UT-YRN-011: 拡張子なしでnull返却 | E-04 (全体) | ○ |
| C-12 | UT-YRN-012: ApplicationMasterArguments --class パース | E-05 (L36-L70) | ○ |
| C-13 | UT-YRN-013: ApplicationMasterArguments --jar パース | E-05 (L36-L70) | ○ |
| C-14 | UT-YRN-014: ApplicationMasterArguments 複数--arg パース | E-05 (L36-L70) | ○ |
| C-15 | UT-YRN-015: ApplicationMasterArguments --properties-file パース | E-05 (L36-L70) | ○ |
| C-16 | UT-YRN-016: 不明オプションでエラー | E-05 (L60-L75) | ○ |
| C-17 | UT-YRN-017: 空引数でデフォルト値 | E-05 (L25-L35) | ○ |
| C-18 | UT-YRN-018: ClientArguments --class パース | E-06 (全体) | ○ |
| C-19 | UT-YRN-019: ClientArguments --jar パース | E-06 (全体) | ○ |
| C-20 | UT-YRN-020: ClientArguments 複数--arg パース | E-06 (全体) | ○ |
| C-21 | UT-YRN-021: ClientDistributedCacheManager.addResource FILE追加 | E-07 (全体) | ○ |
| C-22 | UT-YRN-022: ClientDistributedCacheManager.addResource ARCHIVE追加 | E-07 (全体) | ○ |
| C-23 | UT-YRN-023: appMasterOnly=true でPRIVATE visibility | E-07 (全体) | ○ |
| C-24 | UT-YRN-024: ClientDistributedCacheManager.updateConfiguration | E-07 (全体) | ○ |
| C-25 | UT-YRN-025: リソース0件で空設定 | E-07 (全体) | ○ |
| C-26 | UT-YRN-026: ResourceRequestHelper.validateResources 正常バリデーション | E-08 (全体) | ○ |
| C-27 | UT-YRN-027: executorメモリ0以下でエラー | E-08 (全体) | ○ |
| C-28 | UT-YRN-028: setResourceRequests カスタムリソース設定 | E-08 (全体) | ○ |
| C-29 | UT-YRN-029: getYarnResourcesAndAmounts 正常取得 | E-08 (全体) | ○ |
| C-30 | UT-YRN-030: getYarnResourcesAndAmounts 設定なしで空Map | E-08 (全体) | ○ |
| C-31 | UT-YRN-031: getResourceNameMapping GPU/FPGAマッピング | E-08 (全体) | ○ |
| C-32 | UT-YRN-032: getNumExecutorsRunning 合計値返却 | E-09 (L231-L233) | ○ |
| C-33 | UT-YRN-033: getNumExecutorsRunning 0件で0 | E-09 (L231-L233) | ○ |
| C-34 | UT-YRN-034: getNumExecutorsStarting 合計値返却 | E-09 (L239-L241) | ○ |
| C-35 | UT-YRN-035: getNumReleasedContainers サイズ返却 | E-09 (L243-L245) | ○ |
| C-36 | UT-YRN-036: requestTotalExecutorsWithPreferredLocalities ターゲット更新 | E-09 (L385-L415) | ○ |
| C-37 | UT-YRN-037: requestTotalExecutorsWithPreferredLocalities 変更なしでfalse | E-09 (L401-L413) | ○ |
| C-38 | UT-YRN-038: requestTotalExecutorsWithPreferredLocalities 空で0設定 | E-09 (L393-L399) | ○ |
| C-39 | UT-YRN-039: excludedNodesがNodeHealthTrackerに設定 | E-09 (L398, L407) | ○ |
| C-40 | UT-YRN-040: killExecutor コンテナリリース | E-09 (L420-L429) | ○ |
| C-41 | UT-YRN-041: killExecutor 不明IDでログ警告 | E-09 (L426-L428) | ○ |
| C-42 | UT-YRN-042: handleAllocatedContainers ホストマッチ優先 | E-09 (L646-L712) | ○ |
| C-43 | UT-YRN-043: handleAllocatedContainers ラックマッチ | E-09 (L659-L690) | ○ |
| C-44 | UT-YRN-044: handleAllocatedContainers 不要コンテナリリース | E-09 (L699-L705) | ○ |
| C-45 | UT-YRN-045: processCompletedContainers 正常終了処理 | E-09 (L848-L981) | ○ |
| C-46 | UT-YRN-046: processCompletedContainers プリエンプション処理 | E-09 (L881-L886) | ○ |
| C-47 | UT-YRN-047: processCompletedContainers VMEM超過 | E-09 (L888-L898) | ○ |
| C-48 | UT-YRN-048: processCompletedContainers PMEM超過 | E-09 (L899-L906) | ○ |
| C-49 | UT-YRN-049: processCompletedContainers リリース済みコンテナ | E-09 (L937-L942) | ○ |
| C-50 | UT-YRN-050: processCompletedContainers シャットダウン中 | E-09 (L874-L876) | ○ |
| C-51 | UT-YRN-051: processCompletedContainers pendingLossReasonRequests応答 | E-09 (L960-L964) | ○ |
| C-52 | UT-YRN-052: enqueueGetLossReasonRequest キューイング | E-09 (L987-L1003) | ○ |
| C-53 | UT-YRN-053: enqueueGetLossReasonRequest リリース済み即応答 | E-09 (L993-L996) | ○ |
| C-54 | UT-YRN-054: enqueueGetLossReasonRequest 不明エグゼキュータ失敗 | E-09 (L997-L1002) | ○ |
| C-55 | UT-YRN-055: updateResourceRequests 不足分追加 | E-09 (L498-L609) | ○ |
| C-56 | UT-YRN-056: updateResourceRequests 余剰分キャンセル | E-09 (L598-L607) | ○ |
| C-57 | UT-YRN-057: splitPendingAllocationsByLocality 3グループ分類 | E-09 (L1028-L1049) | ○ |
| C-58 | UT-YRN-058: splitPendingAllocationsByLocality 空で全空 | E-09 (L1028-L1049) | ○ |
| C-59 | UT-YRN-059: handleResourceAllocationFailure 障害ノード記録 | E-10 (全体) | ○ |
| C-60 | UT-YRN-060: handleResourceAllocationFailure hostOpt=None スキップ | E-10 (全体) | ○ |
| C-61 | UT-YRN-061: isAllNodeExcluded 全除外でtrue | E-10 (全体) | ○ |
| C-62 | UT-YRN-062: isAllNodeExcluded 部分除外でfalse | E-10 (全体) | ○ |
| C-63 | UT-YRN-063: setSchedulerExcludedNodes 除外ノード設定 | E-10 (全体) | ○ |
| C-64 | UT-YRN-064: verifyClusterResources 正常バリデーション | E-11 (L406-L431) | ○ |
| C-65 | UT-YRN-065: verifyClusterResources executor超過エラー | E-11 (L412-L418) | ○ |
| C-66 | UT-YRN-066: verifyClusterResources AM超過エラー | E-11 (L419-L425) | ○ |
| C-67 | UT-YRN-067: compareUri 同一URI | E-11 (L1699-L1730) | ○ |
| C-68 | UT-YRN-068: compareUri 異スキーム | E-11 (L1701-L1703) | ○ |
| C-69 | UT-YRN-069: compareUri 異ポート | E-11 (L1728) | ○ |
| C-70 | UT-YRN-070: compareUri nullスキーム | E-11 (L1701) | ○ |
| C-71 | UT-YRN-071: compareUri 同一IP別名ホスト | E-11 (L1718-L1726) | ○ |
| C-72 | UT-YRN-072: compareUri DNS解決不可 | E-11 (L1722-L1725) | ○ |
| C-73 | UT-YRN-073: buildPath 複数コンポーネント結合 | E-11 (L1773-L1775) | ○ |
| C-74 | UT-YRN-074: buildPath 単一コンポーネント | E-11 (L1773-L1775) | ○ |
| C-75 | UT-YRN-075: getClusterPath ゲートウェイ置換 | E-11 (L1686-L1694) | ○ |
| C-76 | UT-YRN-076: getClusterPath 設定なしでパススルー | E-11 (L1686-L1694) | ○ |
| C-77 | UT-YRN-077: isUserClassPathFirst ドライバー | E-11 (L1762-L1768) | ○ |
| C-78 | UT-YRN-078: isUserClassPathFirst エグゼキュータ | E-11 (L1762-L1768) | ○ |
| C-79 | UT-YRN-079: populateClasspath 基本エントリ追加 | E-11 (L1511-L1583) | ○ |
| C-80 | UT-YRN-080: populateClasspath extraClassPath追加 | E-11 (L1517-L1519) | ○ |
| C-81 | UT-YRN-081: populateHadoopClasspath YARN CP追加 | E-11 (L1475-L1481) | ○ |
| C-82 | UT-YRN-082: getUserClasspath メイン+セカンダリJAR | E-11 (L1590-L1594) | ○ |
| C-83 | UT-YRN-083: confToProperties 設定変換 | E-11 (L1801-L1807) | ○ |
| C-84 | UT-YRN-084: createAppReport レポート生成 | E-11 (L1777-L1781) | ○ |
| C-85 | UT-YRN-085: createAppReport 診断メッセージ付き | E-11 (L1777-L1781) | ○ |
| C-86 | UT-YRN-086: createLibraryPathPrefix 生成 | E-11 (L1788-L1799) | ○ |
| C-87 | UT-YRN-087: directoriesToBePreloaded 閾値以上 | E-11 (L486-L496) | ○ |
| C-88 | UT-YRN-088: directoriesToBePreloaded 閾値未満フィルタ | E-11 (L495) | ○ |
| C-89 | UT-YRN-089: directoriesToBePreloaded ローカル/グロブ除外 | E-11 (L489) | ○ |
| C-90 | UT-YRN-090: getDefaultFinalStatus クラスタモード=FAILED | E-12 (L352-L358) | ○ |
| C-91 | UT-YRN-091: getDefaultFinalStatus クライアントモード=UNDEFINED | E-12 (L352-L358) | ○ |
| C-92 | UT-YRN-092: finish 正常終了記録 | E-12 (L377-L403) | ○ |
| C-93 | UT-YRN-093: finish 異常終了記録 | E-12 (L377-L403) | ○ |
| C-94 | UT-YRN-094: finish 未登録クラスタモードでFAILED | E-12 (L384-L387) | ○ |
| C-95 | UT-YRN-095: finish 二重呼出し防止 | E-12 (L379) | ○ |
| C-96 | UT-YRN-096: unregister 正常アンレジスト | E-12 (L365-L375) | ○ |
| C-97 | UT-YRN-097: unregister 未登録スキップ | E-12 (L367) | ○ |
| C-98 | UT-YRN-098: unregister 重複アンレジスト防止 | E-12 (L367) | ○ |
| C-99 | UT-YRN-099: getHistoryServerAddress URL生成 | E-12 (L954-L963) | ○ |
| C-100 | UT-YRN-100: getHistoryServerAddress 未設定で空文字 | E-12 (L959-L963) | ○ |
| C-101 | UT-YRN-101: SparkRackResolver.resolve ラック解決 | E-13 | △ |
| C-102 | UT-YRN-102: ExecutorRunnable.prepareCommand コマンド構築 | E-14 | ○ |
| C-103 | UT-YRN-103: ExecutorRunnable.prepareEnvironment 環境変数構築 | E-14 | ○ |
| C-104 | UT-YRN-104: YarnRMClient.register AM登録 | E-15 | ○ |
| C-105 | UT-YRN-105: YarnRMClient.unregister AM登録解除 | E-15 | ○ |
| C-106 | UT-YRN-106: YarnRMClient.createAllocator アロケータ生成 | E-15 | ○ |
| C-107 | UT-YRN-107: YarnRMClient.getAmIpFilterParams パラメータ生成 | E-15 | ○ |
| C-108 | UT-YRN-108: YarnRMClient.getMaxRegAttempts 最大リトライ | E-15 | ○ |
| C-109 | UT-YRN-109: addPathToEnvironment 新規パス追加 | E-16 | ○ |
| C-110 | UT-YRN-110: addPathToEnvironment 既存パス追記 | E-16 | ○ |
| C-111 | UT-YRN-111: escapeForShell シェルエスケープ | E-16 | ○ |
| C-112 | UT-YRN-112: escapeForShell 空文字 | E-16 | ○ |
| C-113 | UT-YRN-113: getContainerId 環境変数から取得 | E-16 | ○ |
| C-114 | UT-YRN-114: replaceEnvVars 環境変数展開 | E-16 | ○ |
| C-115 | UT-YRN-115: replaceEnvVars 変数なしパススルー | E-16 | ○ |
| C-116 | UT-YRN-116: getApplicationAclsForYarn ACL生成 | E-16 | ○ |
| C-117 | UT-YRN-117: YarnProxyRedirectFilter リダイレクトHTML | E-17 | ○ |
| C-118 | UT-YRN-118: YarnProxyRedirectFilter 非プロキシ通過 | E-17 | ○ |
| C-119 | UT-YRN-119: localityOfRequestedContainers ローカリティ配置 | E-18 | ○ |
| C-120 | UT-YRN-120: localityOfRequestedContainers ローカリティなし | E-18 | ○ |
| C-121 | UT-YRN-121: getLogUrls ログURL取得 | E-19 | ○ |
| C-122 | UT-YRN-122: getLogUrls コンテナ情報なしでNone | E-19 | ○ |
| C-123 | UT-YRN-123: getLogUrlsFromBaseUrl URL生成 | E-19 | ○ |
| C-124 | UT-YRN-124: findJarsDir JARディレクトリ探索 | E-20 | ○ |
| C-125 | UT-YRN-125: findJarsDir 未存在で例外 | E-20 | △ |
| C-126 | UT-YRN-126: canCreate yarn URL true | E-21 | ○ |
| C-127 | UT-YRN-127: canCreate 非yarn URL false | E-21 | ○ |
| C-128 | UT-YRN-128: getDriverLogUrls ログURL | E-22 | △ |
| C-129 | UT-YRN-129: QUEUE_NAME デフォルト値 | E-23 | ○ |
| C-130 | UT-YRN-130: AM_MEMORY デフォルト値 | E-23 | ○ |
| C-131 | UT-YRN-131: AM_CORES デフォルト値 | E-23 | ○ |
| C-132 | UT-YRN-132: ApplicationMasterSource numExecutorsRunning | E-24 | ○ |
| C-133 | UT-YRN-133: ApplicationMasterSource numExecutorsFailed | E-24 | ○ |
| C-134 | UT-YRN-134: YarnCoarseGrainedExecutorBackend extractLogUrls | E-25 | △ |
| C-135 | UT-YRN-135: YarnScheduler getRackForHost | E-26 | ○ |
| C-136 | UT-YRN-136: YarnClientSchedulerBackend start | E-27 | △ |
| C-137 | UT-YRN-137: YarnClientSchedulerBackend stop | E-27 | △ |
| C-138 | UT-YRN-138: YarnClusterSchedulerBackend start | E-28 | △ |
| C-139 | UT-YRN-139: YarnClusterSchedulerBackend getDriverLogUrls | E-28 | △ |
| C-140 | UT-YRN-140: copyFileToRemote 異FS間コピー | E-11 (L439-L475) | ○ |
| C-141 | UT-YRN-141: copyFileToRemote 同一FSスキップ | E-11 (L449, L463-L465) | ○ |
| C-142 | UT-YRN-142: copyFileToRemote レプリケーション設定 | E-11 (L460) | ○ |
| C-143 | UT-YRN-143: createApplicationSubmissionContext アプリ名 | E-11 (L286) | ○ |
| C-144 | UT-YRN-144: createApplicationSubmissionContext キュー名 | E-11 (L287) | ○ |
| C-145 | UT-YRN-145: createApplicationSubmissionContext AMリソース | E-11 (L304-L306) | ○ |
| C-146 | UT-YRN-146: createApplicationSubmissionContext 最大試行回数 | E-11 (L294-L298) | ○ |
| C-147 | UT-YRN-147: createApplicationSubmissionContext 優先度 | E-11 (L341-L343) | ○ |
| C-148 | UT-YRN-148: setupLaunchEnv STAGING_DIR | E-11 (L969) | ○ |
| C-149 | UT-YRN-149: setupLaunchEnv PYTHONPATH | E-11 (L987-L1009) | ○ |
| C-150 | UT-YRN-150: setupLaunchEnv SPARK_USER | E-11 (L979-L981) | ○ |

## 4) 不足情報（Unknown / Missing）
- **SparkRackResolver.resolve (C-101)**: Hadoop内部のDNSToSwitchMappingに依存しており、具体的な戻り値パターンがソースコードのみからは完全に確認できない
  - 候補：Hadoopドキュメント / YARN設定ファイル / ネットワークトポロジー設定
- **YarnCommandBuilderUtils.findJarsDir (C-125)**: 例外の種類がJava側のYarnCommandBuilderUtils実装に依存する可能性がある
  - 候補：launcher モジュールのソースコード
- **YarnCoarseGrainedExecutorBackend.extractLogUrls (C-134)**: YARN環境変数（NM_HOST, NM_HTTP_PORT等）への依存があり、実行環境によって動作が異なる
  - 候補：YARN NodeManager ドキュメント
- **YarnClientSchedulerBackend / YarnClusterSchedulerBackend (C-136, C-137, C-138, C-139)**: 内部でYARN Client APIや SparkContext依存の初期化フローを含むため、純粋な単体テストよりも統合テスト寄りの検証が必要
  - 候補：既存テストスイート / Spark統合テスト設計
- **YarnSchedulerBackend.getDriverLogUrls (C-128)**: 親クラスの実装とオーバーライドの組合せにより、動作がコンテキスト依存
  - 候補：YarnSchedulerBackendの親クラスソースコード

## 5) リスクフラグ（レビュー観点）
- 0: UT-YRN-007 (AmIpPrincipal.getName) - 低リスク、単純なgetterテスト
- 0: UT-YRN-073, UT-YRN-074 (buildPath) - 低リスク、文字列結合のみ
- 1: UT-YRN-101 (SparkRackResolver.resolve) - 中リスク、外部依存あり
- 1: UT-YRN-134 (YarnCoarseGrainedExecutorBackend.extractLogUrls) - 中リスク、YARN環境変数依存
- 1: UT-YRN-136, UT-YRN-137 (YarnClientSchedulerBackend) - 中リスク、統合テスト寄り
- 2: UT-YRN-040, UT-YRN-045-UT-YRN-056 (YarnAllocator コンテナ管理系) - 高リスク、並行処理とYARN RM通信を伴う
- 2: UT-YRN-064-UT-YRN-066 (verifyClusterResources) - 高リスク、リソース超過時のエラーハンドリング
- 2: UT-YRN-001-UT-YRN-004 (AmIpFilter) - 高リスク、セキュリティフィルタ

## 6) レビュアーチェックリスト（最小）
- [ ] YarnAllocator関連テスト(UT-YRN-032~058)が全ての主要publicメソッドをカバーしているか確認
- [ ] AmIpFilter関連テスト(UT-YRN-001~006)がセキュリティ要件を十分に検証しているか確認
- [ ] processCompletedContainersのexitStatus分岐(UT-YRN-045~051)が全コードパスをカバーしているか確認
- [ ] Client.compareUri(UT-YRN-067~072)の境界値テストが十分か確認（特にIPv6、HA構成のケース）
- [ ] ApplicationMaster.finish/unregister(UT-YRN-092~098)の並行性テストが必要かどうか検討
- [ ] 統合テスト寄りと判断されたテストケース(UT-YRN-136~139)の位置付けを確認
- [ ] ResourceRequestHelper.validateResources(UT-YRN-026~027)の異常系パターンが網羅されているか確認
- [ ] テストID略称「YRN」が他モジュールと重複していないか確認
