---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 200
  claims_with_evidence: 192
  claims_without_evidence: 8
confidence_derived: 0.96
---

# 根拠レポート：sql-api 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：192 / 200、根拠なし：8
- 優先レビュー（高）
  1. **UT-SQA-113 (Row.get 範囲外インデックス)**：GenericRowの内部実装を確認する必要あり。ArrayIndexOutOfBoundsExceptionではなくIndexOutOfBoundsExceptionの具体的な型要確認
  2. **UT-SQA-117 (Row.getBoolean null値)**：SparkRuntimeExceptionの具体的なエラークラス名を実行時に確認する必要あり
  3. **UT-SQA-122 (Row.getAs fieldName)**：スキーマ付きRowの具体的な生成方法（GenericRowWithSchemaなど）がsql-api外の実装に依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `sql/api/src/main/scala/org/apache/spark/sql/types/StructType.scala` - StructType本体、add/apply/fieldIndex/treeString/toDDL/merge/findMissingFieldsメソッド
- E-02: `sql/api/src/main/scala/org/apache/spark/sql/types/DataType.scala` - DataType基底クラス、fromJson/fromDDL/equalsIgnoreNullability/equalsStructurallyメソッド
- E-03: `sql/api/src/main/scala/org/apache/spark/sql/types/Decimal.scala` - Decimal型、set/toBigDecimal/compare/+/-/*/÷/%/changePrecision/fromStringメソッド
- E-04: `sql/api/src/main/scala/org/apache/spark/sql/types/DecimalType.scala` - DecimalType定義、isWiderThan/isTighterThan/bounded/adjustPrecisionScale
- E-05: `sql/api/src/main/scala/org/apache/spark/sql/types/Metadata.scala` - Metadata/MetadataBuilder、contains/get*/withKeyRemoved/fromJson/build
- E-06: `sql/api/src/main/scala/org/apache/spark/sql/Row.scala` - Row trait、get/isNullAt/getAs/fieldIndex/toSeq/equals/anyNull/json
- E-07: `sql/api/src/main/scala/org/apache/spark/sql/types/StructField.scala` - StructField、withComment/getComment/withCurrentDefaultValue/toDDL
- E-08: `sql/api/src/main/scala/org/apache/spark/sql/types/ArrayType.scala` - ArrayType、defaultSize/simpleString/toNullable
- E-09: `sql/api/src/main/scala/org/apache/spark/sql/types/MapType.scala` - MapType、defaultSize/simpleString/toNullable
- E-10: `sql/api/src/main/scala/org/apache/spark/sql/catalyst/util/CaseInsensitiveMap.scala` - CaseInsensitiveMap、get/contains/updated/removed
- E-11: `sql/api/src/main/scala/org/apache/spark/sql/catalyst/util/StringConcat.scala` - StringConcat、append/atLimit/toString
- E-12: `sql/api/src/main/scala/org/apache/spark/sql/catalyst/util/MathUtils.scala` - MathUtils、addExact/subtractExact/multiplyExact/negateExact/toIntExact
- E-13: `sql/api/src/main/scala/org/apache/spark/sql/catalyst/util/AttributeNameParser.scala` - AttributeNameParser、parseAttributeName
- E-14: `sql/api/src/main/java/org/apache/spark/sql/types/DataTypes.java` - DataTypesファクトリ、createArrayType/createMapType/createDecimalType/createStructField/createStructType
- E-15: `sql/api/src/main/java/org/apache/spark/sql/RowFactory.java` - RowFactory、create
- E-16: `sql/api/src/main/scala/org/apache/spark/sql/types/UDTRegistration.scala` - UDTRegistration、exists/register/getUDTFor
- E-17: `sql/api/src/main/java/org/apache/spark/sql/connector/catalog/IdentifierImpl.java` - IdentifierImpl、コンストラクタ/toString/equals/hashCode

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | StructType.addでフィールドが追加される (UT-SQA-001~006) | E-01 (L151-257) | ○ |
| C-02 | StructType.apply(name)でフィールド取得・例外 (UT-SQA-007~008) | E-01 (L265-273) | ○ |
| C-03 | StructType.apply(Set)で部分抽出・例外 (UT-SQA-009~010) | E-01 (L282-293) | ○ |
| C-04 | StructType.fieldIndexでインデックス取得・例外 (UT-SQA-011~012) | E-01 (L301-309) | ○ |
| C-05 | StructType.fieldNames/length (UT-SQA-013~016) | E-01 (L111-118, L408) | ○ |
| C-06 | StructType.treeString/toDDL/simpleString (UT-SQA-017~019,024) | E-01 (L380-471) | ○ |
| C-07 | StructType.defaultSize (UT-SQA-020) | E-01 (L415) | ○ |
| C-08 | StructType.equals/hashCode (UT-SQA-021~022) | E-01 (L126-140) | ○ |
| C-09 | StructType.toNullable (UT-SQA-023) | E-01 (L486-500) | ○ |
| C-10 | StructType.fromDDL (UT-SQA-025~026) | E-01 (L547) | ○ |
| C-11 | StructType.findMissingFields (UT-SQA-027~028) | E-01 (L705-736) | ○ |
| C-12 | DataType.fromJson/fromDDL (UT-SQA-029~031) | E-02 (L137-177, L179) | ○ |
| C-13 | DataType.typeName/json/sql (UT-SQA-032~034) | E-02 (L59-84) | ○ |
| C-14 | DataType.equalsIgnoreNullability (UT-SQA-035~036) | E-02 (L567-581) | ○ |
| C-15 | DataType.equalsIgnoreCaseAndNullability (UT-SQA-037) | E-02 (L587-605) | ○ |
| C-16 | DataType.equalsStructurally (UT-SQA-038~039) | E-02 (L510-535) | ○ |
| C-17 | DataType.parseTypeWithFallback (UT-SQA-040~041) | E-02 (L158-177) | ○ |
| C-18 | Decimal.set各種 (UT-SQA-042~048) | E-03 (L55-161) | ○ |
| C-19 | Decimal.toBigDecimal/toDouble/toLong (UT-SQA-049~052) | E-03 (L193-257) | ○ |
| C-20 | Decimal.compare/equals (UT-SQA-053~054) | E-03 (L480-493) | ○ |
| C-21 | Decimal演算 +/-/*/÷/% (UT-SQA-055~061) | E-03 (L504-541) | ○ |
| C-22 | Decimal.unary_-/abs/isZero (UT-SQA-062~065) | E-03 (L543-551, L497) | ○ |
| C-23 | Decimal.changePrecision (UT-SQA-066~067) | E-03 (L352-476) | ○ |
| C-24 | Decimal.floor/ceil (UT-SQA-068~069) | E-03 (L553-563) | ○ |
| C-25 | Decimal.fromString (UT-SQA-070~072) | E-03 (L635-650) | ○ |
| C-26 | Decimal.maxPrecisionForBytes (UT-SQA-073) | E-03 (L685-692) | ○ |
| C-27 | DecimalTypeコンストラクタ検証 (UT-SQA-074~076) | E-04 (L41-53) | ○ |
| C-28 | DecimalType.isWiderThan/isTighterThan (UT-SQA-077~079) | E-04 (L69-93) | ○ |
| C-29 | DecimalType.defaultSize (UT-SQA-080~081) | E-04 (L100) | ○ |
| C-30 | DecimalType.bounded/adjustPrecisionScale (UT-SQA-082~085) | E-04 (L144-201) | ○ |
| C-31 | DecimalType.is32/64BitDecimalType (UT-SQA-086~087) | E-04 (L218-246) | ○ |
| C-32 | Metadata.contains/isEmpty (UT-SQA-088~091) | E-05 (L54-61) | ○ |
| C-33 | Metadata.get* (UT-SQA-092~096) | E-05 (L64-91) | ○ |
| C-34 | Metadata.withKeyRemoved/withKeysRemoved (UT-SQA-097~099) | E-05 (L94-109) | ○ |
| C-35 | Metadata.json/equals (UT-SQA-100~102) | E-05 (L112-139) | ○ |
| C-36 | Metadata.fromJson (UT-SQA-103) | E-05 (L166-216) | ○ |
| C-37 | MetadataBuilder各種操作 (UT-SQA-104~108) | E-05 (L276-356) | ○ |
| C-38 | Row.apply/fromSeq/empty (UT-SQA-109~111) | E-06 (L60-84) | ○ |
| C-39 | Row.get/isNullAt (UT-SQA-112~115) | E-06 (L184-216) | ○ |
| C-40 | Row.get範囲外インデックス (UT-SQA-113) | E-06 | △ |
| C-41 | Row.getBoolean/getInt/getLong/getString (UT-SQA-116~121) | E-06 (L226-414) | ○ |
| C-42 | Row.getBoolean null値例外 (UT-SQA-117) | E-06 (L589-591) | △ |
| C-43 | Row.getAs(fieldName) (UT-SQA-122) | E-06 (L427) | △ |
| C-44 | Row.fieldIndex スキーマなし (UT-SQA-123) | E-06 (L437-439) | ○ |
| C-45 | Row.size/toSeq/mkString (UT-SQA-124~126) | E-06 (L147-577) | ○ |
| C-46 | Row.equals NaN/anyNull (UT-SQA-127~131) | E-06 (L477-475) | ○ |
| C-47 | StructField.withComment/getComment (UT-SQA-132~134) | E-07 (L154-167) | ○ |
| C-48 | StructField.withCurrentDefaultValue/getCurrentDefaultValue/clear (UT-SQA-135~137) | E-07 (L187-218) | ○ |
| C-49 | StructField.toDDL (UT-SQA-138~139) | E-07 (L271-274) | ○ |
| C-50 | ArrayType.defaultSize/simpleString/toNullable (UT-SQA-140~142) | E-08 (L66-121) | ○ |
| C-51 | MapType.defaultSize/simpleString/toNullable (UT-SQA-143~145) | E-09 (L39-103) | ○ |
| C-52 | CaseInsensitiveMap各種操作 (UT-SQA-146~152) | E-10 (L29-64) | ○ |
| C-53 | StringConcat.append/atLimit (UT-SQA-153~157) | E-11 (L25-62) | ○ |
| C-54 | MathUtils各種演算 (UT-SQA-158~170) | E-12 (L28-110) | ○ |
| C-55 | AttributeNameParser.parseAttributeName (UT-SQA-171~176) | E-13 (L28-65) | ○ |
| C-56 | DataTypes Java API (UT-SQA-177~189) | E-14 (L31-316) | ○ |
| C-57 | RowFactory.create (UT-SQA-190~191) | E-15 (L29-40) | ○ |
| C-58 | UDTRegistration.exists/register (UT-SQA-192~194) | E-16 (L35-95) | ○ |
| C-59 | IdentifierImpl各種操作 (UT-SQA-195~200) | E-17 (L31-74) | ○ |
| C-60 | Row.getAs(fieldName) スキーマ付きRowの具体実装 (UT-SQA-122) | **根拠不足** | △ |
| C-61 | StructType.merge 具体的な戻り値 (UT-SQA-027) | E-01 (L593-637) | ○ |
| C-62 | Decimal演算結果の精度 (UT-SQA-055~061) | E-03 | △ |
| C-63 | Row.json スキーマ付きJSON出力 | E-06 (L616-687) | △ |
| C-64 | DecimalType.forType マッピング正確性 | E-04 (L133-140) | ○ |
| C-65 | DataType.equalsIgnoreCompatibleCollation | E-02 (L468-501) | △ |
| C-66 | StructType.fromString (UT-SQA-025関連) | E-01 (L534-539) | ○ |

## 4) 不足情報（Unknown / Missing）
- **Row.getの範囲外アクセス時の例外型（C-40）**：GenericRow内部のArrayアクセスで発生する例外の正確な型はGenericRowの実装（sql-api外のcatalyst expressionsパッケージ）に依存する
  - 候補：ArrayIndexOutOfBoundsException / IndexOutOfBoundsException / SparkRuntimeException
- **Row.getBoolean null値の例外型（C-42）**：DataTypeErrors.valueIsNullErrorの返却する具体的な例外クラスはerrors/DataTypeErrors.scalaの実装に依存
  - 候補：SparkRuntimeException / SparkException
- **Row.getAs(fieldName)のスキーマ付きRow実装（C-60）**：GenericRowWithSchema等のスキーマ付きRow実装はsql-catalyst側にあり、sql-apiモジュール内には含まれない
  - 候補：sql-catalyst GenericRowWithSchema / ConnectRow
- **Decimal演算結果の精度詳細（C-62）**：compact形式同士の加算で返却されるDecimalの精度の具体的な値は入力に依存するため、テストケース内の期待値は簡略化している
  - 候補：DecimalPrecision / TypeCoercionルール
- **DataType.equalsIgnoreCompatibleCollation（C-65）**：CollationFactory依存のためCollation関連テストの完全な検証にはCollationFactoryの実装確認が必要
  - 候補：sql-catalyst CollationFactory
- **Row.json出力テスト（C-63）**：json出力はスキーマ必須であり、各データ型のJSON変換ロジックのテストには多様なデータ型のスキーマ付きRowが必要
  - 候補：テスト実装時に各DataType毎のJSON出力パターンを追加
- **StructType.findNestedFieldの網羅テスト**：privateメソッドのため直接テスト対象外としたが、findMissingFieldsやcatalyst経由で間接的にテストが必要
  - 候補：StructType.findNestedFieldテストの追加検討
- **streaming/TTLConfig等のシンプルcase classのテスト**：テストケース対象として含めていないが、case classのequals/hashCode/copy等の基本動作は言語仕様で保証されるため低優先度
  - 候補：TTLConfig / TimerValues / QueryInfo

## 5) リスクフラグ（レビュー観点）
- 0: StructType/DataType/Metadata/Row の主要publicメソッドは全てソースコードの実装と一致しており低リスク
- 0: DecimalType の検証ロジック（scale > precision, MAX_PRECISION超過）はコンストラクタで直接確認可能
- 1: Decimal演算の精度計算テストは、TypeCoercionルールとの組み合わせが必要なため中リスク
- 1: Row.jsonのテストケースはスキーマ付きRowが前提であり、sql-api外の実装に依存するため中リスク
- 0: MathUtils/AttributeNameParser/CaseInsensitiveMap はユーティリティであり実装が明確で低リスク
- 0: Java API（DataTypes/RowFactory/IdentifierImpl）は薄いラッパーであり低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] StructType のadd/apply/fieldIndexテスト（UT-SQA-001~012）が主要ユースケースをカバーしているか
- [ ] Decimal の四則演算テスト（UT-SQA-055~061）で精度・スケールの期待値が正しいか
- [ ] DecimalType のコンストラクタバリデーション（UT-SQA-074~076）が全エラーパスをカバーしているか
- [ ] Row.getBoolean等のnull値テスト（UT-SQA-117）で実際のSparkRuntimeExceptionクラス名を確認
- [ ] DataTypes Java APIのnull引数テスト（UT-SQA-178,181,182,186,188）が全てのnullチェック分岐をカバーしているか
- [ ] MathUtils のオーバーフローテスト（UT-SQA-159,161,163,165）で境界値の正確性を確認
- [ ] AttributeNameParser のパースエラーテスト（UT-SQA-174~176）で全てのエラーパスがカバーされているか
- [ ] DataType.equalsIgnoreCompatibleCollation のテストケースがCollation対応に十分か確認
