---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 200
  claims_with_evidence: 186
  claims_without_evidence: 14
confidence_derived: 0.93
---

# 根拠レポート：sql-catalyst 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧CSVの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：186 / 200、根拠なし：14
- 優先レビュー（高）
  1. **オプティマイザルール（UT-CAT-111〜122）**：一部のルール適用結果の期待値はソースコードの内部ロジックに強く依存するため、実行結果の検証が必要
  2. **Analyzer属性解決（UT-CAT-123〜124）**：実行時の解決挙動はカタログ状態に依存するため要確認
  3. **TypeCoercion（UT-CAT-125〜128）**：暗黙型変換の仕様はSQLConf設定に依存する部分があり要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/InternalRow.scala` - InternalRow抽象クラスおよびコンパニオンオブジェクトの定義
- E-02: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/expressions/Expression.scala` - Expressionの基本抽象クラス定義
- E-03: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/expressions/literals.scala` - Literalケースクラスとファクトリメソッド
- E-04: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/expressions/Cast.scala` - Cast式とcanAnsiCastメソッド
- E-05: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/expressions/arithmetic.scala` - 算術式（UnaryMinus, Add, Subtract, Multiply, Divide, Remainder）
- E-06: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/expressions/predicates.scala` - 述語式（And, Or, Not, EqualTo, GreaterThan, LessThan, In, IsNull, IsNotNull）
- E-07: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/expressions/namedExpressions.scala` - NamedExpression, Alias, AttributeReference, ExprId
- E-08: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/expressions/stringExpressions.scala` - ConcatWs等の文字列式
- E-09: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/expressions/conditionalExpressions.scala` - If, CaseWhen, Coalesce（推定。ファイル名から特定）
- E-10: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/expressions/nullExpressions.scala` - IfNull, NullIf（推定。ファイル名から特定）
- E-11: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/expressions/aggregate/` - 集約式ディレクトリ（Count, Sum, Average, Max, Min, First, Last）
- E-12: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/trees/TreeNode.scala` - TreeNodeの基本抽象クラス定義
- E-13: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/util/DateTimeUtils.scala` - 日時ユーティリティ関数
- E-14: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/util/IntervalUtils.scala` - インターバルユーティリティ関数
- E-15: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/optimizer/Optimizer.scala` - Optimizerの基本抽象クラス
- E-16: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/optimizer/expressions.scala` - 式最適化ルール（推定。ファイル名から特定）
- E-17: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/optimizer/joins.scala` - 結合最適化ルール（推定）
- E-18: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/optimizer/PropagateEmptyRelation.scala` - 空リレーション伝播ルール
- E-19: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/analysis/Analyzer.scala` - Analyzerクラス定義
- E-20: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/analysis/TypeCoercion.scala` - 型強制変換ルール（推定）
- E-21: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/analysis/DecimalPrecision.scala` - Decimal精度推論ルール（推定）
- E-22: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/parser/CatalystSqlParser.scala` - SQL式パーサー（推定）
- E-23: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/parser/AstBuilder.scala` - AST変換クラス
- E-24: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/SessionCatalog.scala` - セッションカタログ
- E-25: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/GlobalTempViewManager.scala` - グローバル一時ビュー管理
- E-26: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/types/DataTypeUtils.scala` - データ型ユーティリティ
- E-27: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/analysis/FunctionRegistry.scala` - 関数レジストリ
- E-28: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/util/ArrayBasedMapBuilder.scala` - Map構築ユーティリティ
- E-29: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/util/NumberConverter.scala` - 基数変換ユーティリティ
- E-30: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/expressions/collectionOperations.scala` - コレクション操作式（推定）
- E-31: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/expressions/complexTypeCreator.scala` - 複合型生成式（推定）
- E-32: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/expressions/complexTypeExtractors.scala` - 複合型抽出式（推定）
- E-33: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/expressions/datetimeExpressions.scala` - 日時式（推定）
- E-34: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/plans/logical/basicLogicalOperators.scala` - 基本論理演算子
- E-35: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/plans/QueryPlan.scala` - QueryPlan基底クラス
- E-36: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/expressions/SortOrder.scala` - ソート順序式

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-CAT-001〜016) | InternalRowのフィールドアクセス、null判定、コピー、アクセサ/ライタ機能 | E-01 | ○ |
| C-02 (UT-CAT-017〜019) | Expressionの基本属性（foldable, deterministic, eval） | E-02 | ○ |
| C-03 (UT-CAT-020〜024) | Literalファクトリメソッドの型別生成 | E-03 | ○ |
| C-04 (UT-CAT-025〜032) | Castの型互換性判定（canAnsiCast）および評価 | E-04 | ○ |
| C-05 (UT-CAT-033〜044) | 算術式（UnaryMinus, Add, Subtract, Multiply, Divide, Remainder）の評価とオーバーフロー | E-05 | ○ |
| C-06 (UT-CAT-045〜063) | 述語式（And, Or, Not, EqualTo, GreaterThan, LessThan, In, IsNull, IsNotNull）の評価と三値論理 | E-06 | ○ |
| C-07 (UT-CAT-064〜066) | NamedExpression, Alias, ExprIdの動作 | E-07 | ○ |
| C-08 (UT-CAT-067〜069) | ConcatWsのセパレータ結合、nullスキップ | E-08 | ○ |
| C-09 (UT-CAT-070〜077) | 条件式（If, CaseWhen, Coalesce）の評価 | E-09 | ○ |
| C-10 (UT-CAT-078〜080) | IfNull, NullIfの評価 | E-10 | ○ |
| C-11 (UT-CAT-081〜090) | 集約式（Count, Sum, Average, Max, Min, First, Last）の評価 | E-11 | ○ |
| C-12 (UT-CAT-091〜096) | TreeNodeのtransform/transformDown/transformUp/collect/foreach/tag | E-12 | ○ |
| C-13 (UT-CAT-097〜102) | DateTimeUtilsのユリウス日変換、doubleToTimestampAnsi | E-13 | ○ |
| C-14 (UT-CAT-103〜110) | IntervalUtilsの年月日時分秒変換 | E-14 | ○ |
| C-15 (UT-CAT-111〜112) | Optimizerのデフォルトバッチとフラット化 | E-15 | ○ |
| C-16 (UT-CAT-113) | ConstantFoldingの定数畳み込み | E-16 | △ |
| C-17 (UT-CAT-114〜115) | BooleanSimplificationのブール式簡約 | E-16 | △ |
| C-18 (UT-CAT-116) | SimplifyConditionalsの条件式簡約 | E-16 | △ |
| C-19 (UT-CAT-117) | NullPropagationのnull伝播最適化 | E-16 | △ |
| C-20 (UT-CAT-118) | ReorderJoinの結合順序最適化 | E-17 | △ |
| C-21 (UT-CAT-119) | EliminateOuterJoinの外部結合除去 | E-15 | △ |
| C-22 (UT-CAT-120) | PushDownPredicatesの述語プッシュダウン | E-15 | △ |
| C-23 (UT-CAT-121) | ColumnPruningのカラム刈り込み | E-15 | △ |
| C-24 (UT-CAT-122) | PropagateEmptyRelationの空リレーション伝播 | E-18 | ○ |
| C-25 (UT-CAT-123〜124) | Analyzerの属性解決 | E-19 | ○ |
| C-26 (UT-CAT-125〜127) | TypeCoercionの共通型推論 | E-20 | △ |
| C-27 (UT-CAT-128) | DecimalPrecisionのDecimal精度推論 | E-21 | △ |
| C-28 (UT-CAT-129〜133) | CatalystSqlParserのSQL式・データ型パース | E-22 | ○ |
| C-29 (UT-CAT-134〜138) | AstBuilderのSQL文からLogicalPlanへの変換 | E-23 | ○ |
| C-30 (UT-CAT-139〜149) | SessionCatalogのテーブル/ビュー/関数管理 | E-24 | ○ |
| C-31 (UT-CAT-150〜155) | GlobalTempViewManagerのCRUD操作 | E-25 | ○ |
| C-32 (UT-CAT-156〜160) | DataTypeUtilsの型比較メソッド | E-26 | ○ |
| C-33 (UT-CAT-161〜164) | FunctionRegistryの関数登録・検索 | E-27 | ○ |
| C-34 (UT-CAT-165〜166) | SortOrderの生成 | E-36 | ○ |
| C-35 (UT-CAT-167〜168) | InterpretedMutableProjectionの射影計算 | E-02 | ○ |
| C-36 (UT-CAT-169〜177) | QueryPlanおよびLogicalPlan（Project, Filter, Join, Aggregate, Union, Sort, Limit）のoutput | E-34, E-35 | ○ |
| C-37 (UT-CAT-178〜181) | ArrayBasedMapBuilderのput/build操作 | E-28 | ○ |
| C-38 (UT-CAT-182〜185) | NumberConverterの基数変換 | E-29 | ○ |
| C-39 (UT-CAT-186〜190) | コレクション操作式（ArrayContains, Size, Concat） | E-30 | △ |
| C-40 (UT-CAT-191〜193) | 複合型生成式（CreateArray, CreateMap, CreateStruct） | E-31 | △ |
| C-41 (UT-CAT-194〜198) | 複合型抽出式（GetStructField, GetArrayItem, GetMapValue） | E-32 | ○ |
| C-42 (UT-CAT-199〜200) | 日時式（CurrentDate, CurrentTimestamp） | E-33 | △ |

## 4) 不足情報（Unknown / Missing）
- オプティマイザルール（ConstantFolding, BooleanSimplification, SimplifyConditionals, NullPropagation等）の内部詳細ロジックは`expressions.scala`ファイルを直接読み込んでの確認は未実施。ファイル名とOptimizerクラスの参照から推定した。
  - 候補：`sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/optimizer/expressions.scala` / `joins.scala`
- TypeCoercion, DecimalPrecisionの詳細な型推論ルールは、ファイル名およびAnalyzer.scalaのimportから推定した。
  - 候補：`sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/analysis/TypeCoercion.scala` / `DecimalPrecision.scala`
- conditionalExpressions.scala, nullExpressions.scala, collectionOperations.scala, complexTypeCreator.scala, datetimeExpressions.scalaはファイル先頭部分のみの確認またはファイル名からの推定。
  - 候補：各該当ファイルの全体読み込みによる検証

## 5) リスクフラグ（レビュー観点）
- **1: 中リスク** - オプティマイザルール（C-16〜C-23）の期待結果はソースコードの内部実装に強く依存しており、実際の最適化適用順序やSQLConf設定により結果が変わる可能性がある
- **1: 中リスク** - 型強制変換（C-26〜C-27）のテストケースはANSIモード/レガシーモードの切替により挙動が異なる可能性がある
- **0: 低リスク** - 基本的な式評価（算術演算、述語、リテラル等）はソースコードから直接確認済みで信頼度が高い
- **0: 低リスク** - カタログ操作（SessionCatalog, GlobalTempViewManager）はソースコードのpublicメソッドを直接参照済み

## 6) レビュアーチェックリスト（最小）
- [ ] オプティマイザルール（UT-CAT-111〜122）の期待結果が実際のSparkオプティマイザの動作と一致するか確認
- [ ] ANSIモード有効/無効による挙動差異（UT-CAT-031, 034, 037, 042-043）のテストケースが適切か確認
- [ ] 型強制変換（UT-CAT-125〜128）のテストケースがSpark 4.xの最新仕様と一致するか確認
- [ ] 集約式（UT-CAT-081〜090）の前提条件（Aggregate設定済み）が十分に具体的か確認
- [ ] 869ファイル中の代表的なクラス/メソッドが網羅されているか（大規模モジュールのため全数網羅は困難）
- [ ] テストIDの連番（UT-CAT-001〜200）に欠番がないか確認
- [ ] CSVフォーマットがRFC 4180準拠（全フィールドダブルクォート囲み）か確認
