---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 250
  claims_with_evidence: 245
  claims_without_evidence: 5
confidence_derived: 0.98
---

# 根拠レポート：sql-connect-client-jdbc 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：245 / 250、根拠なし：5
- 優先レビュー（高）
  1. **UT-JDB-012（SparkConnectDriver静的初期化子）**：DriverManagerへの登録動作はJavaのクラスローディング機構に依存し、テストでの検証方法が間接的
  2. **UT-JDB-006（正常接続テスト）**：Spark Connectサーバへの実接続が必要であり、テスト環境の前提条件が重い
  3. **UT-JDB-049, 050（execute正常系）**：SparkSession.sqlの実行結果に依存し、モックまたは統合テスト環境が必要
  4. **UT-JDB-236～243（DatabaseMetaData系クエリ）**：サーバサイドのSQL実行結果に依存するテストケース

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `sql/connect/client/jdbc/src/main/java/org/apache/spark/sql/connect/client/jdbc/SparkConnectDriver.java`
- E-02: `sql/connect/client/jdbc/src/main/scala/org/apache/spark/sql/connect/client/jdbc/NonRegisteringSparkConnectDriver.scala`
- E-03: `sql/connect/client/jdbc/src/main/scala/org/apache/spark/sql/connect/client/jdbc/SparkConnectConnection.scala`
- E-04: `sql/connect/client/jdbc/src/main/scala/org/apache/spark/sql/connect/client/jdbc/SparkConnectStatement.scala`
- E-05: `sql/connect/client/jdbc/src/main/scala/org/apache/spark/sql/connect/client/jdbc/SparkConnectResultSet.scala`
- E-06: `sql/connect/client/jdbc/src/main/scala/org/apache/spark/sql/connect/client/jdbc/SparkConnectResultSetMetaData.scala`
- E-07: `sql/connect/client/jdbc/src/main/scala/org/apache/spark/sql/connect/client/jdbc/SparkConnectDatabaseMetaData.scala`
- E-08: `sql/connect/client/jdbc/src/main/scala/org/apache/spark/sql/connect/client/jdbc/util/JdbcTypeUtils.scala`
- E-09: `sql/connect/client/jdbc/src/main/scala/org/apache/spark/sql/connect/client/jdbc/util/JdbcErrorUtils.scala`

## 3) Claims と根拠の対応（レビューの主戦場）

### NonRegisteringSparkConnectDriver / SparkConnectDriver
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-JDB-001) | acceptsURLはjdbc:sc://で始まるURLでtrueを返す | E-02 (L29: `url.startsWith("jdbc:sc://")`) | ○ |
| C-02 (UT-JDB-002) | acceptsURLは非対象URLでfalseを返す | E-02 (L29) | ○ |
| C-03 (UT-JDB-003) | acceptsURLは空文字列でfalseを返す | E-02 (L29: startsWith判定) | ○ |
| C-04 (UT-JDB-004) | connectはurl=nullでSQLExceptionをスロー | E-02 (L32-33: `if (url == null) throw new SQLException`) | ○ |
| C-05 (UT-JDB-005) | connectは非対象URLでnullを返す | E-02 (L36: `if (this.acceptsURL(url)) ... else null`) | ○ |
| C-06 (UT-JDB-006) | connectは対象URLでSparkConnectConnectionを返す | E-02 (L36: `new SparkConnectConnection(url, info)`) | ○ |
| C-07 (UT-JDB-007) | getPropertyInfoは空配列を返す | E-02 (L40: `Array.empty`) | ○ |
| C-08 (UT-JDB-008) | getMajorVersionはSparkメジャーバージョンを返す | E-02 (L42: `VersionUtils.majorVersion(SPARK_VERSION)`) | ○ |
| C-09 (UT-JDB-009) | getMinorVersionはSparkマイナーバージョンを返す | E-02 (L44: `VersionUtils.minorVersion(SPARK_VERSION)`) | ○ |
| C-10 (UT-JDB-010) | jdbcCompliantはfalseを返す | E-02 (L46: `false`) | ○ |
| C-11 (UT-JDB-011) | getParentLoggerはSQLFeatureNotSupportedExceptionをスロー | E-02 (L48: `throw new SQLFeatureNotSupportedException`) | ○ |
| C-12 (UT-JDB-012) | SparkConnectDriverの静的初期化子でDriverManagerに登録 | E-01 (L24-29: `DriverManager.registerDriver`) | ○ |

### SparkConnectConnection
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 (UT-JDB-013) | isClosedは初期状態でfalseを返す | E-03 (L40: `private var closed: Boolean = false`) | ○ |
| C-14 (UT-JDB-014) | close後はisClosedがtrueを返す | E-03 (L44-49: `closed = true`) | ○ |
| C-15 (UT-JDB-015) | 二重クローズで例外が発生しない | E-03 (L44-49: `if (!closed)` ガード) | ○ |
| C-16 (UT-JDB-016) | クローズ後のcheckOpenでSQLExceptionをスロー | E-03 (L51-54: `if (closed) throw new SQLException`) | ○ |
| C-17 (UT-JDB-017) | isValidはオープン中かつセッション有効でtrueを返す | E-03 (L60: `!closed && client.isSessionValid`) | ○ |
| C-18 (UT-JDB-018) | isValidはクローズ後falseを返す | E-03 (L60: `!closed` 部分) | ○ |
| C-19 (UT-JDB-019) | createStatementはSparkConnectStatementを返す | E-03 (L87-89: `new SparkConnectStatement(this)`) | ○ |
| C-20 (UT-JDB-020) | クローズ後のcreateStatementでSQLExceptionをスロー | E-03 (L88: `checkOpen()`) | ○ |
| C-21 (UT-JDB-021) | getMetaDataはSparkConnectDatabaseMetaDataを返す | E-03 (L82-85) | ○ |
| C-22 (UT-JDB-022) | setAutoCommit(true)は例外なし | E-03 (L149-154: `if (!autoCommit)` のみスロー) | ○ |
| C-23 (UT-JDB-023) | setAutoCommit(false)はSQLFeatureNotSupportedExceptionをスロー | E-03 (L151-153) | ○ |
| C-24 (UT-JDB-024) | getAutoCommitはtrueを返す | E-03 (L156-159: `true`) | ○ |
| C-25 (UT-JDB-025) | commitはSQLExceptionをスロー | E-03 (L161-164: `throw new SQLException("Connection is in auto-commit mode")`) | ○ |
| C-26 (UT-JDB-026) | rollbackはSQLExceptionをスロー | E-03 (L166-169) | ○ |
| C-27 (UT-JDB-027) | setReadOnly(false)は例外なし | E-03 (L171-176: `if (readOnly)` のみスロー) | ○ |
| C-28 (UT-JDB-028) | setReadOnly(true)はSQLFeatureNotSupportedExceptionをスロー | E-03 (L173-175) | ○ |
| C-29 (UT-JDB-029) | isReadOnlyはfalseを返す | E-03 (L178-181: `false`) | ○ |
| C-30 (UT-JDB-030) | setTransactionIsolation(TRANSACTION_NONE)は例外なし | E-03 (L183-189: `if (level != Connection.TRANSACTION_NONE)` のみスロー) | ○ |
| C-31 (UT-JDB-031) | setTransactionIsolation(他の値)はSQLFeatureNotSupportedExceptionをスロー | E-03 (L185-189) | ○ |
| C-32 (UT-JDB-032) | getTransactionIsolationはTRANSACTION_NONEを返す | E-03 (L192-195: `Connection.TRANSACTION_NONE`) | ○ |
| C-33 (UT-JDB-033) | setHoldability(HOLD_CURSORS_OVER_COMMIT)は例外なし | E-03 (L207-212) | ○ |
| C-34 (UT-JDB-034) | setHoldability(他の値)はSQLFeatureNotSupportedExceptionをスロー | E-03 (L208-211) | ○ |
| C-35 (UT-JDB-035) | getHoldabilityはHOLD_CURSORS_OVER_COMMITを返す | E-03 (L214) | ○ |
| C-36 (UT-JDB-036) | abort(null)はSQLExceptionをスロー | E-03 (L258-261: `if (executor == null) throw new SQLException`) | ○ |
| C-37 (UT-JDB-037) | abort(executor)でコネクションクローズ | E-03 (L262-264: `executor.execute { () => this.close() }`) | ○ |
| C-38 (UT-JDB-038) | クローズ済みのabortはexecutorを実行しない | E-03 (L262: `if (!closed)` ガード) | ○ |
| C-39 (UT-JDB-039) | unwrapは正しいインタフェースで成功 | E-03 (L273-277) | ○ |
| C-40 (UT-JDB-040) | unwrapは不正なインタフェースでSQLExceptionをスロー | E-03 (L276) | ○ |
| C-41 (UT-JDB-041) | isWrapperForは正しいインタフェースでtrueを返す | E-03 (L279) | ○ |
| C-42 (UT-JDB-042) | isWrapperForは不正なインタフェースでfalseを返す | E-03 (L279: `iface.isInstance(this)`) | ○ |
| C-43 (UT-JDB-043) | prepareStatementはSQLFeatureNotSupportedExceptionをスロー | E-03 (L92-93) | ○ |
| C-44 (UT-JDB-044) | getWarningsはnullを返す | E-03 (L197: `null`) | ○ |

### SparkConnectStatement
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 (UT-JDB-045) | isClosedは初期状態でfalseを返す | E-04 (L31: `private var closed: Boolean = false`) | ○ |
| C-46 (UT-JDB-046) | close後はisClosedがtrueを返す | E-04 (L35-54: `closed = true`) | ○ |
| C-47 (UT-JDB-047) | 二重クローズで例外が発生しない | E-04 (L36: `if (!closed)` ガード) | ○ |
| C-48 (UT-JDB-048) | クローズ後のcheckOpenでSQLExceptionをスロー | E-04 (L56-60) | ○ |
| C-49 (UT-JDB-049) | executeはSELECT文でtrueを返す | E-04 (L90-111: hasResultSetでtrue/false判定) | △ |
| C-50 (UT-JDB-050) | executeはDDL文でfalseを返す | E-04 (L90-111) | △ |
| C-51 (UT-JDB-051) | クローズ後のexecuteでSQLExceptionをスロー | E-04 (L91: `checkOpen()`) | ○ |
| C-52 (UT-JDB-052) | executeQueryは結果セットを返す | E-04 (L62-70) | ○ |
| C-53 (UT-JDB-053) | executeQueryは非クエリでSQLExceptionをスロー | E-04 (L68: `throw new SQLException("The query does not produce a ResultSet.")`) | ○ |
| C-54 (UT-JDB-054) | executeUpdateは更新カウントを返す | E-04 (L72-83) | ○ |
| C-55 (UT-JDB-055) | executeUpdateはSELECT文でSQLExceptionをスロー | E-04 (L78: `throw new SQLException("The query produces a ResultSet.")`) | ○ |
| C-56 (UT-JDB-056) | setMaxRowsで正の値が設定可能 | E-04 (L129-136) | ○ |
| C-57 (UT-JDB-057) | setMaxRows(0)で制限解除 | E-04 (L132: `if (max < 0)` のみチェック) | ○ |
| C-58 (UT-JDB-058) | setMaxRows(負値)でSQLExceptionをスロー | E-04 (L132-134) | ○ |
| C-59 (UT-JDB-059) | getMaxRowsの初期値は0 | E-04 (L29: `private var maxRows: Int = 0`) | ○ |
| C-60 (UT-JDB-060) | execute(SELECT)後にgetResultSetでResultSetを返す | E-04 (L104-105, L113-116) | ○ |
| C-61 (UT-JDB-061) | execute(DDL)後にgetResultSetでnullを返す | E-04 (L108-109: `resultSet = null`は設定されない, L96: `resultSet = null`リセット) | ○ |
| C-62 (UT-JDB-062) | ResultSetがある場合getUpdateCountは-1を返す | E-04 (L164-171: `if (resultSet != null) -1`) | ○ |
| C-63 (UT-JDB-063) | ResultSetがない場合getUpdateCountは0を返す | E-04 (L170: `0`) | ○ |
| C-64 (UT-JDB-064) | cancelはinterruptOperationを呼ぶ | E-04 (L149-155: `conn.spark.interruptOperation(operationId)`) | ○ |
| C-65 (UT-JDB-065) | operationId=nullの場合cancelは何もしない | E-04 (L152: `if (operationId != null)` ガード) | ○ |
| C-66 (UT-JDB-066) | getQueryTimeoutは0を返す | E-04 (L141-144: `0`) | ○ |
| C-67 (UT-JDB-067) | getResultSetConcurrencyはCONCUR_READ_ONLYを返す | E-04 (L189-192) | ○ |
| C-68 (UT-JDB-068) | getConnectionは関連コネクションを返す | E-04 (L206-209: `conn`) | ○ |
| C-69 (UT-JDB-069) | setPoolable(false)は例外なし | E-04 (L238-244) | ○ |
| C-70 (UT-JDB-070) | setPoolable(true)はSQLFeatureNotSupportedExceptionをスロー | E-04 (L241-243) | ○ |
| C-71 (UT-JDB-071) | isPoolableはfalseを返す | E-04 (L246-249: `false`) | ○ |
| C-72 (UT-JDB-072) | isCloseOnCompletionはfalseを返す | E-04 (L255-258: `false`) | ○ |
| C-73 (UT-JDB-073) | getWarningsはnullを返す | E-04 (L157: `null`) | ○ |

### SparkConnectResultSet
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-74 (UT-JDB-074) | nextはデータありでtrue、カーソル進行 | E-05 (L54-68) | ○ |
| C-75 (UT-JDB-075) | nextはデータ末尾でfalse | E-05 (L57-67) | ○ |
| C-76 (UT-JDB-076) | クローズ後のnextでSQLExceptionをスロー | E-05 (L55: `checkOpen()`) | ○ |
| C-77 (UT-JDB-077) | close後isClosedはtrue | E-05 (L74-79) | ○ |
| C-78 (UT-JDB-078) | 二重クローズで例外なし | E-05 (L74: `if (!closed)`) | ○ |
| C-79 (UT-JDB-079) | getStringで文字列取得 | E-05 (L116-124) | ○ |
| C-80 (UT-JDB-080) | getStringでバイト配列をUTF-8変換 | E-05 (L119-120: `new String(bytes, StandardCharsets.UTF_8)`) | ○ |
| C-81 (UT-JDB-081) | 範囲外インデックス(下限)でSQLException | E-05 (L92-94: `if (index < 0 || index >= currentRow.length)`) | ○ |
| C-82 (UT-JDB-082) | 範囲外インデックス(上限)でSQLException | E-05 (L92-94) | ○ |
| C-83 (UT-JDB-083) | null値でnull返却、wasNull=true | E-05 (L97-99: `if (currentRow.isNullAt(index)) { _wasNull = true; defaultVal }`) | ○ |
| C-84 (UT-JDB-084) | getBooleanでboolean取得 | E-05 (L126-128) | ○ |
| C-85 (UT-JDB-085) | null BooleanでfalseかつwasNull=true | E-05 (L127: `getColumnValue(columnIndex, false)`) | ○ |
| C-86 (UT-JDB-086) | getByteでbyte取得 | E-05 (L130-132) | ○ |
| C-87 (UT-JDB-087) | getShortでshort取得 | E-05 (L134-136) | ○ |
| C-88 (UT-JDB-088) | getIntでint取得 | E-05 (L138-140) | ○ |
| C-89 (UT-JDB-089) | null Intで0かつwasNull=true | E-05 (L139: `getColumnValue(columnIndex, 0)`) | ○ |
| C-90 (UT-JDB-090) | getLongでlong取得 | E-05 (L142-144) | ○ |
| C-91 (UT-JDB-091) | getFloatでfloat取得 | E-05 (L146-148) | ○ |
| C-92 (UT-JDB-092) | getDoubleでdouble取得 | E-05 (L150-152) | ○ |
| C-93 (UT-JDB-093) | null Doubleで0.0かつwasNull=true | E-05 (L151: `getColumnValue(columnIndex, 0.toDouble)`) | ○ |
| C-94 (UT-JDB-094) | getBigDecimalでBigDecimal取得 | E-05 (L285-289) | ○ |
| C-95 (UT-JDB-095) | getBytesでbyte[]取得 | E-05 (L157-161) | ○ |
| C-96 (UT-JDB-096) | getDateでDate取得 | E-05 (L163-165) | ○ |
| C-97 (UT-JDB-097) | getTimeでLocalTimeからTime変換 | E-05 (L167-178: `ChronoUnit.MILLIS.between(LocalTime.MIDNIGHT, localTime)`) | ○ |
| C-98 (UT-JDB-098) | getTimestamp(TimestampType)でTimestamp取得 | E-05 (L190-192) | ○ |
| C-99 (UT-JDB-099) | getTimestamp(TimestampNTZ)でLocalDateTime変換 | E-05 (L188-189: `Timestamp.valueOf(value.asInstanceOf[LocalDateTime])`) | ○ |
| C-100 (UT-JDB-100) | 非Timestamp型でSQLException | E-05 (L193-196) | ○ |
| C-101 (UT-JDB-101) | findColumnで1始まりインデックス返却 | E-05 (L106-114: `i + 1`) | ○ |
| C-102 (UT-JDB-102) | 存在しないカラムでSQLException | E-05 (L112: `throw new SQLException(s"Invalid column label: $columnLabel")`) | ○ |
| C-103 (UT-JDB-103) | ラベルでgetString | E-05 (L211-212: `getString(findColumn(columnLabel))`) | ○ |
| C-104 (UT-JDB-104) | getObjectでAnyRef取得 | E-05 (L270-274) | ○ |
| C-105 (UT-JDB-105) | null getObjectでnull | E-05 (L271: `getColumnValue(columnIndex, null: AnyRef)`) | ○ |
| C-106 (UT-JDB-106) | 非null後wasNull=false | E-05 (L101: `_wasNull = false`) | ○ |
| C-107 (UT-JDB-107) | null後wasNull=true | E-05 (L98: `_wasNull = true`) | ○ |
| C-108 (UT-JDB-108) | isBeforeFirstは先頭前でtrue | E-05 (L294-297: `cursor < 1 && sparkResult.length > 0`) | ○ |
| C-109 (UT-JDB-109) | isBeforeFirstは移動後false | E-05 (L294-297) | ○ |
| C-110 (UT-JDB-110) | isFirstは最初の行でtrue | E-05 (L299-302: `cursor == 1`) | ○ |
| C-111 (UT-JDB-111) | isLastは最後の行でtrue | E-05 (L304-307: `cursor > 0 && cursor == sparkResult.length`) | ○ |
| C-112 (UT-JDB-112) | isAfterLastは全行後true | E-05 (L309-312: `cursor > 0 && cursor > sparkResult.length`) | ○ |
| C-113 (UT-JDB-113) | getRowは現在行番号を返す | E-05 (L322-330) | ○ |
| C-114 (UT-JDB-114) | getRowは先頭前で0を返す | E-05 (L325: `if (cursor < 1 ...`) | ○ |
| C-115 (UT-JDB-115) | getRowは全行後0を返す | E-05 (L325: `... || cursor > sparkResult.length)`) | ○ |
| C-116 (UT-JDB-116) | setFetchDirection(FETCH_FORWARD)は例外なし | E-05 (L338-347) | ○ |
| C-117 (UT-JDB-117) | setFetchDirection(他)はSQLException | E-05 (L342-346) | ○ |
| C-118 (UT-JDB-118) | getFetchDirectionはFETCH_FORWARD | E-05 (L349-352: `ResultSet.FETCH_FORWARD`) | ○ |
| C-119 (UT-JDB-119) | getTypeはTYPE_FORWARD_ONLY | E-05 (L360-363: `ResultSet.TYPE_FORWARD_ONLY`) | ○ |
| C-120 (UT-JDB-120) | getConcurrencyはCONCUR_READ_ONLY | E-05 (L365-368: `ResultSet.CONCUR_READ_ONLY`) | ○ |
| C-121 (UT-JDB-121) | getHoldabilityはHOLD_CURSORS_OVER_COMMIT | E-05 (L648: `ResultSet.HOLD_CURSORS_OVER_COMMIT`) | ○ |
| C-122 (UT-JDB-122) | getMetaDataはResultSetMetaDataを返す | E-05 (L265-268: `new SparkConnectResultSetMetaData(sparkResult.schema)`) | ○ |
| C-123 (UT-JDB-123) | getStatementはStatementを返す | E-05 (L514-517: `stmt`) | ○ |
| C-124 (UT-JDB-124) | getDate(idx, cal)はCalendarを無視 | E-05 (L555-557: `getDate(columnIndex)`) | ○ |
| C-125 (UT-JDB-125) | getTime(idx, cal)はCalendarを無視 | E-05 (L574-576: `getTime(columnIndex)`) | ○ |
| C-126 (UT-JDB-126) | getTimestamp(idx, cal)はCalendarを無視 | E-05 (L593-595: `getTimestamp(columnIndex)`) | ○ |

### SparkConnectResultSetMetaData
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-127 (UT-JDB-127) | getColumnCountはschema.lengthを返す | E-06 (L28: `schema.length`) | ○ |
| C-128 (UT-JDB-128) | 空スキーマで0 | E-06 (L28) | ○ |
| C-129 (UT-JDB-129) | nullable=trueでcolumnNullable | E-06 (L38-39: `if (schema(column - 1).nullable) columnNullable`) | ○ |
| C-130 (UT-JDB-130) | nullable=falseでcolumnNoNulls | E-06 (L39: `else columnNoNulls`) | ○ |
| C-131 (UT-JDB-131) | getColumnNameはカラム名を返す | E-06 (L49: `schema(column - 1).name`) | ○ |
| C-132 (UT-JDB-132) | getColumnLabelはgetColumnNameと同じ | E-06 (L47: `getColumnName(column)`) | ○ |
| C-133 (UT-JDB-133) | getColumnTypeは型に対応するJDBC型を返す | E-06 (L51-52), E-08 | ○ |
| C-134 (UT-JDB-134) | getColumnTypeNameはSQL型名を返す | E-06 (L54: `schema(column - 1).dataType.sql`) | ○ |
| C-135 (UT-JDB-135) | isAutoIncrementはfalse | E-06 (L30: `false`) | ○ |
| C-136 (UT-JDB-136) | isReadOnlyはtrue | E-06 (L71: `true`) | ○ |
| C-137 (UT-JDB-137) | isWritableはfalse | E-06 (L73: `false`) | ○ |
| C-138 (UT-JDB-138) | isSigned(数値型)はtrue | E-08 (L68-70) | ○ |
| C-139 (UT-JDB-139) | isSigned(非数値型)はfalse | E-08 (L71-72) | ○ |
| C-140 (UT-JDB-140) | getPrecisionは型に応じた精度を返す | E-08 (L77-99) | ○ |
| C-141 (UT-JDB-141) | getScaleは型に応じたスケールを返す | E-08 (L101-111) | ○ |
| C-142 (UT-JDB-142) | getColumnDisplaySizeは型に応じた表示サイズを返す | E-08 (L113-136) | ○ |
| C-143 (UT-JDB-143) | getColumnClassNameはJavaクラス名を返す | E-08 (L48-66) | ○ |
| C-144 (UT-JDB-144) | getCatalogNameは空文字 | E-06 (L65: `""`) | ○ |
| C-145 (UT-JDB-145) | getSchemaNameは空文字 | E-06 (L67: `""`) | ○ |
| C-146 (UT-JDB-146) | getTableNameは空文字 | E-06 (L69: `""`) | ○ |

### JdbcTypeUtils
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-147~C-162 | getColumnTypeの各型マッピング | E-08 (L28-46) | ○ |
| C-163~C-166 | getColumnTypeClassNameの各型マッピング | E-08 (L48-66) | ○ |
| C-167~C-171 | isSignedの各型判定 | E-08 (L68-75) | ○ |
| C-172~C-180 | getPrecisionの各型精度 | E-08 (L77-99) | ○ |
| C-181~C-185 | getScaleの各型スケール | E-08 (L101-111) | ○ |
| C-186~C-195 | getDisplaySizeの各型表示サイズ | E-08 (L113-136) | ○ |
| C-196~C-199 | getDecimalDigitsの各型小数桁 | E-08 (L138-146) | ○ |
| C-200~C-201 | getNumPrecRadixの基数判定 | E-08 (L148-151) | ○ |

### JdbcErrorUtils
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-202~C-207 | stringifyTransactionIsolationLevelの各レベル文字列化 | E-09 (L24-32) | ○ |
| C-208~C-210 | stringifyHoldabilityの各値文字列化 | E-09 (L34-39) | ○ |
| C-211~C-213 | stringifyResultSetTypeの各タイプ文字列化 | E-09 (L41-47) | ○ |
| C-214~C-217 | stringifyFetchDirectionの各方向文字列化 | E-09 (L49-55) | ○ |

### SparkConnectDatabaseMetaData
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-218 (UT-JDB-218) | getURLはコネクションURLを返す | E-07 (L42: `conn.url`) | ○ |
| C-219 (UT-JDB-219) | getDatabaseProductNameは定数文字列を返す | E-07 (L55: `"Apache Spark Connect Server"`) | ○ |
| C-220 (UT-JDB-220) | getDriverNameは定数文字列を返す | E-07 (L59: `"Apache Spark Connect JDBC Driver"`) | ○ |
| C-221 (UT-JDB-221) | getIdentifierQuoteStringはバッククォートを返す | E-07 (L87: `` "`" ``) | ○ |
| C-222 (UT-JDB-222) | getSearchStringEscapeはバックスラッシュを返す | E-07 (L107: `"\\"`) | ○ |
| C-223 (UT-JDB-223) | supportsTransactionsはfalse | E-07 (L273: `false`) | ○ |
| C-224 (UT-JDB-224) | supportsTransactionIsolationLevel(NONE)はtrue | E-07 (L275-276: `level == Connection.TRANSACTION_NONE`) | ○ |
| C-225 (UT-JDB-225) | supportsTransactionIsolationLevel(他)はfalse | E-07 (L275-276) | ○ |
| C-226 (UT-JDB-226) | getDefaultTransactionIsolationはTRANSACTION_NONE | E-07 (L271: `Connection.TRANSACTION_NONE`) | ○ |
| C-227 (UT-JDB-227) | getJDBCMajorVersionは4 | E-07 (L705: `4`) | ○ |
| C-228 (UT-JDB-228) | getJDBCMinorVersionは3 | E-07 (L707: `3`) | ○ |
| C-229 (UT-JDB-229) | supportsResultSetType(FORWARD_ONLY)はtrue | E-07 (L630-631: `type == ResultSet.TYPE_FORWARD_ONLY`) | ○ |
| C-230 (UT-JDB-230) | supportsResultSetType(他)はfalse | E-07 (L630-631) | ○ |
| C-231 (UT-JDB-231) | supportsResultSetConcurrency(FORWARD+READ_ONLY)はtrue | E-07 (L633-634) | ○ |
| C-232 (UT-JDB-232) | supportsResultSetConcurrency(他)はfalse | E-07 (L633-634) | ○ |
| C-233 (UT-JDB-233) | supportsResultSetHoldability(CLOSE_CURSORS)はtrue | E-07 (L693-694: `holdability == ResultSet.CLOSE_CURSORS_AT_COMMIT`) | ○ |
| C-234 (UT-JDB-234) | supportsResultSetHoldability(HOLD_CURSORS)はfalse | E-07 (L693-694) | ○ |
| C-235 (UT-JDB-235) | getResultSetHoldabilityはCLOSE_CURSORS_AT_COMMIT | E-07 (L696: `ResultSet.CLOSE_CURSORS_AT_COMMIT`) | ○ |
| C-236 (UT-JDB-236) | getCatalogsはカタログ一覧を返す | E-07 (L302-309) | △ |
| C-237 (UT-JDB-237) | getSchemasはスキーマ一覧を返す | E-07 (L311-315, L320-362, L364-369) | △ |
| C-238 (UT-JDB-238) | getSchemas(catalog, pattern)はフィルタされたスキーマを返す | E-07 (L364-369) | △ |
| C-239 (UT-JDB-239) | getTableTypesはTABLEとVIEWを返す | E-07 (L372-378, L818: `val TABLE_TYPES = Seq("TABLE", "VIEW")`) | ○ |
| C-240 (UT-JDB-240) | getTablesはテーブル一覧を返す | E-07 (L460-484) | ○ |
| C-241 (UT-JDB-241) | 未サポートタイプでSQLException | E-07 (L467-474) | ○ |
| C-242 (UT-JDB-242) | types指定でフィルタ | E-07 (L480-481) | ○ |
| C-243 (UT-JDB-243) | getColumnsはカラム一覧を返す | E-07 (L486-574) | ○ |
| C-244 (UT-JDB-244) | getConnectionはconnを返す | E-07 (L663: `conn`) | ○ |
| C-245 (UT-JDB-245) | getSQLKeywordsはSparkキーワードを返す | E-07 (L89-93) | ○ |
| C-246 (UT-JDB-246) | getSQLStateTypeはsqlStateSQLを返す | E-07 (L709: `DatabaseMetaData.sqlStateSQL`) | ○ |
| C-247 (UT-JDB-247) | getRowIdLifetimeはROWID_UNSUPPORTED | E-07 (L715: `RowIdLifetime.ROWID_UNSUPPORTED`) | ○ |
| C-248 (UT-JDB-248) | supportsGroupByはtrue | E-07 (L133: `true`) | ○ |
| C-249 (UT-JDB-249) | supportsOuterJoinsはtrue | E-07 (L161: `true`) | ○ |
| C-250 (UT-JDB-250) | supportsUnionAllはtrue | E-07 (L219: `true`) | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-JDB-049, 050**: execute()メソッドの正常系テストケースは、SparkSession.sql()の実行結果（SparkResult）の動作に依存するため、モックまたは統合テスト環境が必要。hasResultSet()の判定ロジック（schema.length > 0）はコードから確認できるが、実際のSQL実行結果の挙動は外部依存。
  - 候補：既存のテストスイート `SparkConnectStatementSuite` / 統合テスト環境
- **UT-JDB-236, 237, 238**: getCatalogs, getSchemas等のDatabaseMetaData系メソッドは、サーバサイドでSHOW CATALOGS / SHOW SCHEMAS等のSQLを実行するため、実行結果の正確な検証にはサーバ接続が必要。
  - 候補：既存のテストスイート `SparkConnectDatabaseMetaDataSuite` / モック化されたSparkSession

## 5) リスクフラグ（レビュー観点）
- 0 (低リスク): JdbcTypeUtils, JdbcErrorUtils -- 純粋な変換ロジックでありテスト容易
- 0 (低リスク): SparkConnectResultSetMetaData -- スキーマ情報の読み取りのみで外部依存なし
- 1 (中リスク): SparkConnectConnection, SparkConnectStatement, SparkConnectResultSet -- SparkConnectClientとSparkSessionへの依存があるが、状態管理ロジックはコードから確認可能
- 2 (高リスク): SparkConnectDatabaseMetaData -- サーバサイドSQL実行に依存するメソッド群（getCatalogs, getSchemas, getTables, getColumns, getSQLKeywords）は統合テスト環境が必要

## 6) レビュアーチェックリスト（最小）
- [ ] JdbcTypeUtilsの全データ型マッピングが網羅されているか確認（特にTimeType, TimestampNTZTypeなどの新しい型）
- [ ] SparkConnectResultSetの各getXxx系メソッドのnull値ハンドリングテストケースが十分か確認
- [ ] SparkConnectConnectionのcheckOpen()が呼ばれるべきメソッドすべてでクローズ後テストが存在するか確認
- [ ] SparkConnectDatabaseMetaDataのgetSchemas内部ロジック（catalog=null/空文字/特定値の3パターン）がテストケースでカバーされているか確認
- [ ] SQLFeatureNotSupportedExceptionをスローする多数のメソッドについて、代表的なものがテストケースに含まれているか確認（すべてを列挙する必要はないが、主要なものは網羅すべき）
