---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 35
  claims_with_evidence: 33
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：sql-connect-client-jvm 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：33 / 35、根拠なし：2
- 優先レビュー（高）
  1. **C-17 (UT-SCJ-017)**: doMainの正常起動フロー - 統合テスト的な性質が強く、単体テストでの完全な検証は困難
  2. **C-31 (UT-SCJ-031)**: withLocalConnectServerコンテキスト - withLocalConnectServerの内部動作はモジュール外の実装に依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `sql/connect/client/jvm/src/main/scala/org/apache/spark/sql/connect/client/AmmoniteClassFinder.scala` - AmmoniteClassFinderクラスのソースコード（47行）
- E-02: `sql/connect/client/jvm/src/main/scala/org/apache/spark/sql/application/ConnectRepl.scala` - ConnectReplオブジェクト・ExtendedCodeClassWrapperオブジェクトのソースコード（194行）
- E-03: `sql/connect/common/src/main/scala/org/apache/spark/sql/connect/client/ClassFinder.scala` - ClassFinderトレイト・REPLClassDirMonitorの定義
- E-04: `sql/api/src/main/scala/org/apache/spark/sql/Artifact.scala` - Artifact.newClassArtifact、Artifact.InMemoryの定義
- E-05: `docs/code-to-docs/単体テストケース一覧/plan.md` - プロジェクト構造とモジュール対応情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AmmoniteClassFinder.findClassesが正常にArtifactを返却する | E-01 (L34-46), E-03 (L26-28) | ○ |
| C-02 | 複数フレームから複数クラスが返却される | E-01 (L35: session.frames.iterator.flatMap) | ○ |
| C-03 | Right(URL)がcollectでスキップされる | E-01 (L38: collect { case (Left(name), _) => }) | ○ |
| C-04 | framesが空の場合に空Iteratorが返る | E-01 (L35: session.frames.iterator.flatMap) | ○ |
| C-05 | classpathSignatureが空の場合に空Iteratorが返る | E-01 (L37-38: signatures.iterator.collect) | ○ |
| C-06 | ドット区切りのクラス名がパスに変換される | E-01 (L39-41: name.split('.'), Paths.get) | ○ |
| C-07 | パッケージなしクラスが正しく変換される | E-01 (L39-41: split結果が1要素の場合) | ○ |
| C-08 | InMemoryアーティファクトが正しいバイト配列で生成される | E-01 (L42-43: classloader.newFileDict, Artifact.InMemory), E-04 (InMemory定義) | ○ |
| C-09 | コンストラクタでsessionを受け取る | E-01 (L32: class AmmoniteClassFinder(session: Session)) | ○ |
| C-10 | SpecialClassLoaderへのキャストが失敗する場合 | E-01 (L36: frame.classloader.asInstanceOf[SpecialClassLoader]) | ○ |
| C-11 | ExtendedCodeClassWrapper.wrapperPathがCodeClassWrapperに委譲される | E-02 (L178: override def wrapperPath = CodeClassWrapper.wrapperPath) | ○ |
| C-12 | apply()でOuterScopes.addOuterScope(this)がtopに追加される | E-02 (L189-191: augmentedTop = top + "\norg.apache.spark...addOuterScope(this)\n") | ○ |
| C-13 | apply()でbottomとlevelは変更されない | E-02 (L186-191: val (top, bottom, level) = CodeClassWrapper(...); return (augmentedTop, bottom, level)) | ○ |
| C-14 | 空コードでもOuterScopes登録が追加される | E-02 (L186-191: topへの文字列結合は無条件) | ○ |
| C-15 | extraCodeが指定された場合も正常にラップされる | E-02 (L187: CodeClassWrapperにextraCodeが渡される) | ○ |
| C-16 | imports付きのコードが正しくラップされる | E-02 (L187: CodeClassWrapperにimportsが渡される) | ○ |
| C-17 | doMainで有効な引数でSparkConnectClientが構築される | E-02 (L69-87: client構築ロジック) | △ |
| C-18 | 不正引数でsys.exit(1)が呼ばれる | E-02 (L77-87: catch NonFatal, sys.exit(1)) | ○ |
| C-19 | semaphore指定時にmain.runに2引数渡される | E-02 (L164-166: if (semaphore.nonEmpty) main.run(sparkBind, semaphoreBind)) | ○ |
| C-20 | semaphoreがNone時にmain.runに1引数渡される | E-02 (L167-169: else main.run(sparkBind)) | ○ |
| C-21 | predefCodeにspark関連import文が含まれる | E-02 (L94-102: predefCodeの文字列リテラル) | ○ |
| C-22 | welcomeBannerにSpark versionが含まれる | E-02 (L106: splash.format(spark_version, spark.version)) | ○ |
| C-23 | replCodeWrapper/scriptCodeWrapperにExtendedCodeClassWrapperが設定される | E-02 (L108-109: replCodeWrapper = ExtendedCodeClassWrapper, scriptCodeWrapper = ExtendedCodeClassWrapper) | ○ |
| C-24 | カスタムストリームが正しく渡される | E-02 (L110-112: inputStream, outputStream, errorStream) | ○ |
| C-25 | main関数がdoMainに委譲する | E-02 (L57: def main(args) = doMain(args)) | ○ |
| C-26 | カスタムpromptが"scala> "に設定される | E-02 (L158: override val prompt = Ref("scala> ")) | ○ |
| C-27 | defaultPredef=trueでreplImportsとpredefImportsが結合される | E-02 (L117-119: if (defaultPredef) Defaults.replImports ++ Interpreter.predefImports) | ○ |
| C-28 | defaultPredef=falseで空Importsが使用される | E-02 (L119: else Imports()) | ○ |
| C-29 | replArgsがargStringに変換される | E-02 (L121-134: replArgs.zipWithIndex.map) | ○ |
| C-30 | replArgsが空の場合argStringが空になる | E-02 (L121: replArgs.zipWithIndex.map -> mkString) | ○ |
| C-31 | doMainがwithLocalConnectServerコンテキスト内で実行される | E-02 (L67: def doMain(...) = withLocalConnectServer {) | △ |
| C-32 | userAgentとして"Spark Connect REPL"が設定される | E-02 (L43: name = "Spark Connect REPL", L74: .userAgent(name)) | ○ |
| C-33 | loadFromEnvironment()が呼ばれる | E-02 (L73: .loadFromEnvironment()) | ○ |
| C-34 | Right(URL)のみのclasspathSignatureで空Iteratorが返る | E-01 (L38: collect { case (Left(name), _) => }) | ○ |
| C-35 | ネストクラス名（$を含む）が正しくパスに変換される | E-01 (L39-41: split('.')はドットのみで分割、$はそのまま保持) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-17: doMainの正常起動フロー全体の検証には、SparkConnectClient.builder()、SparkSession.builder()、withLocalConnectServerなどモジュール外の依存が多い。単体テストとしてはモック化が必要であり、実際の統合動作はE2Eテストで補完すべき。
  - 候補：SparkConnectClient.builder()のモック / SparkSession.builder()のモック / withLocalConnectServerのスタブ
- C-31: withLocalConnectServerの内部実装はsql-connect-common等の別モジュールにあり、doMainがそのコンテキスト内で実行される具体的な副作用（サーバーの起動/停止等）はモジュール外のコードに依存する。
  - 候補：SparkSession.withLocalConnectServerのソースコード / 統合テストでの検証

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - AmmoniteClassFinder関連テストケース（C-01〜C-10, C-34, C-35）はソースコードから直接根拠が確認でき、ロジックが明確
- 0: 低リスク - ExtendedCodeClassWrapper関連テストケース（C-11〜C-16）は小規模なオブジェクトで根拠が明確
- 1: 中リスク - ConnectRepl.doMain関連テストケース（C-17〜C-25, C-31〜C-33）はモジュール外の依存が多く、モック設計が必要。テストの実現可能性はモックフレームワークの選定に依存する
- 0: 低リスク - instantiateRepl関連テストケース（C-26〜C-30）はAmmoniteの内部構造に依存するが、ソースコードから根拠は確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] AmmoniteClassFinder.findClasses()のパス変換ロジック（split → Paths.get）のテストケースが、パッケージ階層の深いクラス名や特殊文字（$など）を十分にカバーしているか
- [ ] ConnectRepl.doMain()のテストケースが、モック化可能な形で記述されているか（SparkConnectClient, SparkSession, withLocalConnectServerのモック化方針）
- [ ] ExtendedCodeClassWrapper.apply()のテストケースで、CodeClassWrapperの戻り値に対する拡張（augmentedTop）が正確に検証されているか
- [ ] 異常系テストケース（C-10: ClassCastException, C-18: sys.exit(1)）のテスト実装時に適切な例外捕捉・モック手法が検討されているか
- [ ] テスト優先度が適切か（特に高優先度に分類されたケースが本当にビジネスクリティカルか）
