---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 170
  claims_with_evidence: 164
  claims_without_evidence: 6
confidence_derived: 0.96
---

# 根拠レポート：sql-connect-common 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：164 / 170、根拠なし：6
- 優先レビュー（高）
  1. **C-097～C-099 (UdfPacket シリアライゼーション)**：実際にシリアライズ可能なUdfPacketの構築に必要なfunction/encoder等の詳細が不透明
  2. **C-125～C-126 (RetryPolicy jitter/minJitterThreshold)**：ジッターはランダム値のため期待結果の検証が困難
  3. **C-153～C-154 (REPLClassDirMonitor findClasses)**：テスト用に一時ディレクトリを準備するセットアップが必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `sql/connect/common/src/main/scala/org/apache/spark/sql/connect/common/DataTypeProtoConverter.scala`
- E-02: `sql/connect/common/src/main/scala/org/apache/spark/sql/connect/common/LiteralValueProtoConverter.scala`
- E-03: `sql/connect/common/src/main/scala/org/apache/spark/sql/connect/common/StorageLevelProtoConverter.scala`
- E-04: `sql/connect/common/src/main/scala/org/apache/spark/sql/connect/common/ProtoUtils.scala`
- E-05: `sql/connect/common/src/main/scala/org/apache/spark/sql/connect/common/InvalidPlanInput.scala`
- E-06: `sql/connect/common/src/main/scala/org/apache/spark/sql/connect/common/Abbreviator.scala`
- E-07: `sql/connect/common/src/main/scala/org/apache/spark/sql/connect/common/ProtoSpecializedArray.scala`
- E-08: `sql/connect/common/src/main/scala/org/apache/spark/sql/connect/common/UdfPacket.scala`
- E-09: `sql/connect/common/src/main/scala/org/apache/spark/sql/connect/common/UdfUtils.scala`
- E-10: `sql/connect/common/src/main/scala/org/apache/spark/sql/connect/client/GrpcRetryHandler.scala`
- E-11: `sql/connect/common/src/main/scala/org/apache/spark/sql/connect/client/RetryPolicy.scala`
- E-12: `sql/connect/common/src/main/scala/org/apache/spark/sql/connect/client/GrpcExceptionConverter.scala`
- E-13: `sql/connect/common/src/main/scala/org/apache/spark/sql/connect/client/ResponseValidator.scala`
- E-14: `sql/connect/common/src/main/scala/org/apache/spark/sql/connect/client/SparkConnectClientParser.scala`
- E-15: `sql/connect/common/src/main/scala/org/apache/spark/sql/connect/client/ClassFinder.scala`
- E-16: `sql/connect/common/src/main/scala/org/apache/spark/sql/connect/ConnectProtoUtils.scala`
- E-17: `sql/connect/common/src/main/scala/org/apache/spark/sql/connect/common/config/ConnectCommon.scala`
- E-18: `sql/connect/common/src/main/scala/org/apache/spark/sql/connect/common/ProtoDataTypes.scala`
- E-19: `sql/connect/common/src/main/scala/org/apache/spark/sql/connect/client/arrow/ArrowEncoderUtils.scala`
- E-20: `sql/connect/common/src/main/scala/org/apache/spark/sql/connect/client/arrow/ScalaCollectionUtils.scala`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001〜C-024 | DataTypeProtoConverter.toCatalystType の各型変換・異常系テスト | E-01 | ○ |
| C-025〜C-030 | DataTypeProtoConverter.toConnectProtoType の各型変換・異常系テスト | E-01 | ○ |
| C-031〜C-044 | LiteralValueProtoConverter.toLiteralProtoBuilder の各リテラル変換テスト | E-02 | ○ |
| C-045〜C-048 | LiteralValueProtoConverter.toLiteralProtoBuilder (dataType版) テスト | E-02 | ○ |
| C-049〜C-054 | LiteralValueProtoConverter.toScalaValue の逆変換テスト | E-02 | ○ |
| C-055〜C-058 | LiteralValueProtoConverter.toDataType の型マッピングテスト | E-02 | ○ |
| C-059〜C-061 | LiteralValueProtoConverter.getProtoDataType テスト | E-02 | ○ |
| C-062〜C-064 | StorageLevelProtoConverter 変換テスト | E-03 | ○ |
| C-065〜C-068 | ProtoUtils.abbreviate テスト | E-04, E-06 | ○ |
| C-069〜C-072 | ProtoUtils.throwIfInvalidTag テスト | E-04 | ○ |
| C-073〜C-074 | ProtoUtils.parseWithRecursionLimit テスト | E-04 | ○ |
| C-075〜C-079 | InvalidPlanInput テスト | E-05 | ○ |
| C-080〜C-085 | Abbreviator テスト | E-06 | ○ |
| C-086〜C-096 | ProtoSpecializedArray テスト | E-07 | ○ |
| C-097〜C-099 | UdfPacket シリアライゼーション/デシリアライゼーションテスト | E-08 | △ |
| C-100〜C-112 | UdfUtils 関数アダプタ/ラッパーテスト | E-09 | ○ |
| C-113〜C-120 | GrpcRetryHandler リトライテスト | E-10 | ○ |
| C-121〜C-130 | RetryPolicy/RetryPolicyState テスト | E-11 | ○ |
| C-131〜C-137 | GrpcExceptionConverter 例外変換テスト | E-12 | ○ |
| C-138〜C-144 | ResponseValidator テスト | E-13 | ○ |
| C-145〜C-152 | SparkConnectClientParser テスト | E-14 | ○ |
| C-153〜C-156 | REPLClassDirMonitor テスト | E-15 | △ |
| C-157〜C-161 | ConnectProtoUtils テスト | E-16 | ○ |
| C-162〜C-164 | ConnectCommon 定数テスト | E-17 | ○ |
| C-165〜C-167 | ArrowEncoderUtils テスト | E-19 | ○ |
| C-168 | ScalaCollectionUtils.wrap テスト | E-20 | ○ |
| C-169〜C-170 | ProtoDataTypes 定数テスト | E-18 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-097〜C-099 (UdfPacket)**: UdfPacketのシリアライゼーションテストでは、テスト用にシリアライズ可能なfunction及びAgnosticEncoderの具体的なインスタンスが必要。テスト環境におけるクラスパスの依存関係は未確認。
  - 候補：既存テストコードの参照 / AgnosticEncoderの具体的な実装例 / テスト用ヘルパークラス
- **C-125〜C-126 (RetryPolicy jitter)**: ジッターがRandomベースのため、期待結果の範囲チェックとなる。正確な値の検証は不可能。
  - 候補：シード固定でのテスト / 範囲ベースのアサーション
- **C-153〜C-154 (REPLClassDirMonitor)**: テスト用の一時ディレクトリとクラスファイルの準備が必要。テストインフラの準備が前提。
  - 候補：JUnit TemporaryFolder / Files.createTempDirectory

## 5) リスクフラグ（レビュー観点）
- **リスク1 [中]**: DataTypeProtoConverterのtoCatalystType/toConnectProtoType は型変換の中核であり、テストの入力値の正確さが重要。プロトコルバッファの構築方法がテスト実装の品質に直結する。
- **リスク0 [低]**: ProtoDataTypesの定数検証テスト(C-169〜C-170)は、定数の内部構造が変わる可能性が低いため、低リスク。
- **リスク1 [中]**: GrpcExceptionConverterのerrorFactory/errorsToThrowable(C-134〜C-137)は、FetchErrorDetailsResponseのプロトコルバッファ構築が複雑であり、テスト実装の手間が大きい。
- **リスク0 [低]**: ConnectCommon定数(C-162〜C-164)は変更頻度が低く、テストの優先度は低い。

## 6) レビュアーチェックリスト（最小）
- [ ] DataTypeProtoConverter のテストケースが全KindCase（NULL, BINARY, BOOLEAN, BYTE, SHORT, INTEGER, LONG, FLOAT, DOUBLE, DECIMAL, STRING, CHAR, VAR_CHAR, DATE, TIMESTAMP, TIMESTAMP_NTZ, TIME, CALENDAR_INTERVAL, YEAR_MONTH_INTERVAL, DAY_TIME_INTERVAL, ARRAY, STRUCT, MAP, VARIANT, GEOMETRY, GEOGRAPHY, UDT）を網羅しているか
- [ ] LiteralValueProtoConverter のテストケースが全リテラル型（Boolean, Byte, Short, Int, Long, Float, Double, BigDecimal, String, Array[Byte], LocalDate, Instant, Timestamp, LocalDateTime, Duration, Period, CalendarInterval, null, Array）を網羅しているか
- [ ] ProtoUtils.throwIfInvalidTag の全3パターン（null, 空文字, カンマ含む）がカバーされているか
- [ ] RetryPolicy のバックオフ計算テストで、initialBackoff, maxBackoff, backoffMultiplier, jitter, minJitterThreshold が検証されているか
- [ ] ResponseValidator のセッションID変更検知テストが含まれているか
- [ ] SparkConnectClientParser の全コマンドラインオプション(--remote, --host, --port, --token, --use_ssl, --user_id, --user_name, --user_agent, --session_id, --option, --grpc_max_message_size)が網羅されているか
- [ ] UdfPacketのシリアライゼーション/デシリアライゼーションテストの前提条件が実現可能か確認
