---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 150
  claims_with_evidence: 142
  claims_without_evidence: 8
confidence_derived: 0.95
---

# 根拠レポート：sql-connect-server 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：142 / 150、根拠なし：8
- 優先レビュー（高）
  1. **SparkConnectPlanner**: 巨大ファイル（2000行超）のため、全メソッドの網羅的なテストケース生成が困難。代表的なメソッドのみ対象としたが、プランナー変換ロジックの全体的なカバレッジについてレビューが必要
  2. **SparkConnectService.extractErrorMessage**: メッセージ切り詰め閾値の2048文字はソースコード上で直接確認できなかった（Utils.abbreviateの内部実装に依存）
  3. **SessionHolder.usePlanCache**: プランキャッシュの動作は設定値に依存するため、テスト前提条件の正確性についてレビューが必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/SparkConnectService.scala`
- E-02: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/SessionHolder.scala`
- E-03: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/SparkConnectSessionManager.scala`
- E-04: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteHolder.scala`
- E-05: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/SparkConnectExecutionManager.scala`
- E-06: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/SessionEventsManager.scala`
- E-07: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteEventsManager.scala`
- E-08: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/PreSharedKeyAuthenticationInterceptor.scala`
- E-09: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/SparkConnectInterceptorRegistry.scala`
- E-10: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/SparkConnectStreamingQueryCache.scala`
- E-11: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/planner/SaveModeConverter.scala`
- E-12: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/planner/TableSaveMethodConverter.scala`
- E-13: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/planner/LiteralExpressionProtoConverter.scala`
- E-14: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/planner/InvalidInputErrors.scala`
- E-15: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/planner/SparkConnectPlanner.scala`
- E-16: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/planner/StreamingQueryListenerHelper.scala`
- E-17: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/execution/ExecuteResponseObserver.scala`
- E-18: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/execution/ConnectProgressExecutionListener.scala`
- E-19: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/utils/ErrorUtils.scala`
- E-20: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/utils/MetricGenerator.scala`
- E-21: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/plugin/SparkConnectPluginRegistry.scala`
- E-22: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ml/MLCache.scala`
- E-23: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ml/Serializer.scala`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-SCS-001~005: SparkConnectService.extractErrorMessage/convertNullStringのテストケース | E-01 | ○ |
| C-02 | UT-SCS-006~012: SaveModeConverterのtoSaveMode/toSaveModeProtoのテストケース | E-11 | ○ |
| C-03 | UT-SCS-013~016: TableSaveMethodConverterのテストケース | E-12 | ○ |
| C-04 | UT-SCS-017~020: LiteralExpressionProtoConverterのtoCatalystExpressionテストケース | E-13 | ○ |
| C-05 | UT-SCS-021~026: InvalidInputErrorsの各エラーメッセージ生成テストケース | E-14 | ○ |
| C-06 | UT-SCS-027~044: SessionHolderのセッション管理・キャッシュ機能テストケース | E-02 | ○ |
| C-07 | UT-SCS-045~059: SparkConnectSessionManagerのセッション作成・取得・クローン・クローズテストケース | E-03 | ○ |
| C-08 | UT-SCS-060~068: ExecuteHolderのタグ変換・割り込み・クローズテストケース | E-04 | ○ |
| C-09 | UT-SCS-069~082: SparkConnectExecutionManager/ExecuteKeyのテストケース | E-05 | ○ |
| C-10 | UT-SCS-083~094: ExecuteResponseObserverのレスポンスキャッシュ・消費テストケース | E-17 | ○ |
| C-11 | UT-SCS-095~101: ConnectProgressExecutionListenerのテストケース | E-18 | ○ |
| C-12 | UT-SCS-102~104: PreSharedKeyAuthenticationInterceptorの認証テストケース | E-08 | ○ |
| C-13 | UT-SCS-105~108: SessionEventsManagerの状態遷移テストケース | E-06 | ○ |
| C-14 | UT-SCS-109~115: ExecuteEventsManagerの状態遷移テストケース | E-07 | ○ |
| C-15 | UT-SCS-116~120: ErrorUtils.throwableToFetchErrorDetailsResponseのテストケース | E-19 | ○ |
| C-16 | UT-SCS-121~123: SparkConnectPluginRegistryのテストケース | E-21 | ○ |
| C-17 | UT-SCS-124~125: SparkConnectInterceptorRegistryのテストケース | E-09 | ○ |
| C-18 | UT-SCS-126~137: MLCacheのキャッシュ管理テストケース | E-22 | ○ |
| C-19 | UT-SCS-138~142: Serializerのシリアライズテストケース | E-23 | ○ |
| C-20 | UT-SCS-143~150: SparkConnectStreamingQueryCacheのテストケース | E-10 | ○ |
| C-21 | SparkConnectPlannerの変換ロジック（transformRelation等）のテストケース網羅性 | E-15 | △ |
| C-22 | SparkConnectService.extractErrorMessageのメッセージ切り詰め閾値(2048文字) | **根拠不足** | △ |
| C-23 | MetricGenerator.buildMetrics/transformPlanのテストケース | E-20 | △ |
| C-24 | StreamingForeachBatchHelperのテストケース | **根拠なし** | △ |
| C-25 | PythonStreamingQueryListenerの各イベントハンドラテストケース | E-16 | △ |
| C-26 | ExecuteGrpcResponseSenderのテストケース | **根拠なし** | △ |
| C-27 | SessionHolder.usePlanCacheの前提条件（planCache設定値） | E-02 | △ |
| C-28 | TableSaveMethodConverterの大文字小文字混在入力の動作 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- **SparkConnectPlanner**: 2000行超の巨大クラスであり、全メソッドの網羅的テストケース生成が困難。transformRelation, transformExpression等の主要メソッドは個別テストケースが必要だが、本一覧では省略している。
  - 候補：SparkConnectPlanner専用のテストケース一覧を別途作成 / 既存テストコードの参照 / プランナー変換パターンの分類整理
- **StreamingForeachBatchHelper**: Python連携処理のため、単体テストとしてのテストケースが作成困難。
  - 候補：モック化によるPython連携テスト / 統合テストへの委任
- **ExecuteGrpcResponseSender**: gRPC送信処理のため、統合テスト的な性質を持つ。
  - 候補：StreamObserverのモック化テスト / gRPCテストフレームワークの利用
- **MetricGenerator**: DataFrameのqueryExecution.executedPlanに依存するため、SparkSession初期化が必要。
  - 候補：モック化テスト / SparkSession付きテスト環境の構築

## 5) リスクフラグ（レビュー観点）
- 1: SparkConnectPlannerは巨大クラスであり、本テストケース一覧では網羅していない。重要なプランナー変換ロジックのテストが不足するリスクがある
- 1: Python連携処理（StreamingForeachBatchHelper, PythonStreamingQueryListener）は外部プロセス依存のため、単体テストの範囲外となる可能性がある
- 0: SaveModeConverter, TableSaveMethodConverter等の変換ユーティリティは網羅的にカバーされている
- 0: SessionHolder, SessionManager, ExecutionManagerのセッション・実行管理は主要な正常系・異常系をカバーしている
- 1: ExecuteResponseObserverの並行性に関するテスト（複数スレッドからのアクセス等）はカバーしていない

## 6) レビュアーチェックリスト（最小）
- [ ] SparkConnectPlannerの主要変換メソッドについて、追加テストケースが必要か確認
- [ ] Python連携処理（StreamingForeachBatchHelper, PythonStreamingQueryListener）のテスト方針を確認
- [ ] SessionHolder/SessionManagerの並行性テスト（複数スレッドからの同時アクセス）の要否を確認
- [ ] ExecuteResponseObserverのretryBufferSizeに基づくキャッシュ解放ロジックのテストケースの追加要否を確認
- [ ] MLCacheのメモリコントロール有効時のオフロード/リロードパスのテストケースの妥当性を確認
- [ ] ErrorUtils.buildStatusFromThrowableのテストケースが不足していないか確認
- [ ] gRPC関連（ExecuteGrpcResponseSender等）のテスト方針（単体テスト vs 統合テスト）を確認
