---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 160
  claims_with_evidence: 156
  claims_without_evidence: 4
confidence_derived: 0.98
---

# 根拠レポート：sql-hive-thriftserver 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：156 / 160、根拠なし：4
- 優先レビュー（高）
  1. **UT-HTS-055/056 SparkSQLDriver.run テスト**：SparkSession依存のため実際のテスト実行時にモック化が必要
  2. **UT-HTS-153-155 calculateNumberToRemove テスト**：privateメソッドのためリフレクション経由またはクラス内部からのテストが必要
  3. **UT-HTS-064/065 runningQueryError テスト**：SparkThrowableインタフェースのモック構築が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/FetchIterator.scala` - FetchIterator trait, ArrayFetchIterator, IterableFetchIterator クラス定義
- E-02: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/RowSetUtils.scala` - RowSetUtils object, toTRowSet, toTColumn, toTColumnValue メソッド
- E-03: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ReflectionUtils.scala` - ReflectionUtils object, setSuperField, getSuperField, invoke等
- E-04: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/SparkSQLDriver.scala` - SparkSQLDriver class, run, getResults, close, destroy メソッド
- E-05: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/SparkExecuteStatementOperation.scala` - SparkExecuteStatementOperation class, toTTypeId, toTTableSchema 等
- E-06: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/SparkOperation.scala` - SparkOperation trait, tableTypeString, withLocalProperties, onError 等
- E-07: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/HiveThriftServerErrors.scala` - エラー生成ファクトリメソッド群
- E-08: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/SparkGetColumnsOperation.scala` - getColumnSize, getDecimalDigits, getNumPrecRadix, toJavaSQLType 等
- E-09: `sql/hive-thriftserver/src/main/java/org/apache/hive/service/CookieSigner.java` - CookieSigner class, signCookie, verifyAndExtract メソッド
- E-10: `sql/hive-thriftserver/src/main/java/org/apache/hive/service/ServiceUtils.java` - indexOfDomainMatch, cleanup メソッド
- E-11: `sql/hive-thriftserver/src/main/java/org/apache/hive/service/cli/OperationState.java` - OperationState enum, validateTransition, isTerminal メソッド
- E-12: `sql/hive-thriftserver/src/main/java/org/apache/hive/service/cli/HandleIdentifier.java` - HandleIdentifier class, toTHandleIdentifier, equals, hashCode 等
- E-13: `sql/hive-thriftserver/src/main/java/org/apache/hive/service/cli/RowSetFactory.java` - RowSetFactory class, create メソッド
- E-14: `sql/hive-thriftserver/src/main/java/org/apache/hive/service/cli/TableSchema.java` - TableSchema class, getColumnDescriptors, addPrimitiveColumn 等
- E-15: `sql/hive-thriftserver/src/main/java/org/apache/hive/service/cli/HiveSQLException.java` - HiveSQLException class, toTStatus, toString, toCause 等
- E-16: `sql/hive-thriftserver/src/main/java/org/apache/hive/service/cli/ColumnValue.java` - ColumnValue class, toTColumnValue, toColumnValue 等
- E-17: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2AppStatusStore.scala` - SessionInfo, ExecutionInfo class
- E-18: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2Listener.scala` - HiveThriftServer2Listener class, calculateNumberToRemove 等
- E-19: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/SparkGetTypeInfoOperation.scala` - SparkGetTypeInfoUtil object
- E-20: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/SparkSQLCLIService.scala` - SparkSQLCLIService class, getInfo メソッド
- E-21: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/SparkSQLSessionManager.scala` - SparkSQLSessionManager class
- E-22: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/server/SparkSQLOperationManager.scala` - SparkSQLOperationManager class

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ArrayFetchIterator.fetchNext でfetchStartが更新される | E-01 (L54: fetchStart = position) | ○ |
| C-02 | ArrayFetchIterator.fetchAbsolute で位置がクランプされる | E-01 (L57: (pos max 0) min src.length) | ○ |
| C-03 | ArrayFetchIterator.hasNext は position < src.length で判定 | E-01 (L65) | ○ |
| C-04 | ArrayFetchIterator.next は position をインクリメントし要素を返す | E-01 (L67-69) | ○ |
| C-05 | IterableFetchIterator.fetchAbsolute で後方移動時にリセットされる | E-01 (L82-86: newPos < position で resetPosition) | ○ |
| C-06 | RowSetUtils.toTRowSet がプロトコルバージョンで分岐する | E-02 (L42: protocolVersion.getValue < V6) | ○ |
| C-07 | RowSetUtils の各型がTColumnの対応する型にマッピングされる | E-02 (L95-151: match式による型分岐) | ○ |
| C-08 | FloatType がtoString経由でDoubleに変換される | E-02 (L117-118: asScala.map(n => Double.valueOf(n.toString))) | ○ |
| C-09 | NULL値でnullsビットセットが設定される | E-02 (L163: nulls.set(idx, true)) | ○ |
| C-10 | ReflectionUtils.setSuperField がlevel=1でsetAncestorFieldを呼ぶ | E-03 (L22: setAncestorField(obj, 1, ...)) | ○ |
| C-11 | ReflectionUtils.invoke がメソッドをリフレクションで呼び出す | E-03 (L53-56) | ○ |
| C-12 | SparkSQLDriver.run がCommandProcessorResponse(0)を返す | E-04 (L102) | ○ |
| C-13 | SparkSQLDriver.getResults がhiveResponse==nullでfalseを返す | E-04 (L120-121) | ○ |
| C-14 | SparkSQLDriver.close がフィールドをnullにリセットする | E-04 (L114-115) | ○ |
| C-15 | SparkExecuteStatementOperation.toTTypeId の型マッピング全般 | E-05 (L329-357: match式による全型マッピング) | ○ |
| C-16 | 未知の型でIllegalArgumentExceptionが発生する | E-05 (L356: throw new IllegalArgumentException) | ○ |
| C-17 | toTTableSchema がCharVarcharUtils.getRawSchemaを使う | E-05 (L394) | ○ |
| C-18 | DecimalType の precision/scale が TTypeQualifiers に設定される | E-05 (L362-365) | ○ |
| C-19 | SparkOperation.tableTypeString のEXTERNAL/MANAGED→"TABLE", VIEW→"VIEW" | E-06 (L108-113) | ○ |
| C-20 | HiveThriftServerErrors の各ファクトリメソッドが適切な例外を生成する | E-07 (全メソッド: L34-69) | ○ |
| C-21 | runningQueryError がSparkThrowable+PRETTYで errorClassPrefix を付与 | E-07 (L40-43) | ○ |
| C-22 | SparkGetColumnsOperation.getColumnSize が型ごとに正しい値を返す | E-08 (L134-147) | ○ |
| C-23 | SparkGetColumnsOperation.getDecimalDigits が型ごとに正しい値を返す | E-08 (L157-164) | ○ |
| C-24 | SparkGetColumnsOperation.toJavaSQLType の型マッピング | E-08 (L171-194) | ○ |
| C-25 | CookieSigner がnull secretでIllegalArgumentExceptionを投げる | E-09 (L43-45) | ○ |
| C-26 | CookieSigner.signCookie がnull/空文字列でIllegalArgumentExceptionを投げる | E-09 (L55-57) | ○ |
| C-27 | CookieSigner.verifyAndExtract が署名を検証し元の値を返す | E-09 (L71-83) | ○ |
| C-28 | ServiceUtils.indexOfDomainMatch がnullで-1を返す | E-10 (L33-35) | ○ |
| C-29 | ServiceUtils.indexOfDomainMatch が'/'と'@'の早い方を返す | E-10 (L37-45) | ○ |
| C-30 | OperationState.validateTransition の各遷移ルール | E-11 (L50-98: switch文による遷移検証) | ○ |
| C-31 | OperationState.isTerminal の判定 | E-11 (L109-111) | ○ |
| C-32 | HandleIdentifier のUUID変換ラウンドトリップ | E-12 (L43-48, L58-68) | ○ |
| C-33 | HandleIdentifier.equals の等価性判定 | E-12 (L80-106) | ○ |
| C-34 | RowSetFactory がプロトコルバージョンで生成クラスを分岐する | E-13 (L28-33, L35-40) | ○ |
| C-35 | TableSchema の各メソッド | E-14 (全メソッド) | ○ |
| C-36 | HiveSQLException.toTStatus の変換 | E-15 (L115-123) | ○ |
| C-37 | HiveSQLException.toString/toCause のラウンドトリップ | E-15 (L147-238) | ○ |
| C-38 | ColumnValue.toTColumnValue の型ごとの変換 | E-16 (L142-189) | ○ |
| C-39 | SessionInfo.totalTime の計算ロジック | E-17 (L90-96) | ○ |
| C-40 | ExecutionInfo.isExecutionActive の状態判定 | E-17 (L118-123) | ○ |
| C-41 | HiveThriftServer2Listener.calculateNumberToRemove の計算 | E-18 (L307-313) | ○ |
| C-42 | SparkGetTypeInfoUtil.supportedType のリスト内容 | E-19 (L95-102) | ○ |
| C-43 | SparkSQLCLIService.getInfo の各GetInfoType応答 | E-20 (L102-111) | ○ |
| C-44 | SparkSQLDriver.run でSparkThrowableがそのままスローされる | E-04 (L104-106) | ○ |
| C-45 | SparkSQLDriver.run の非SparkThrowableでQueryExecutionExceptionがスローされる | E-04 (L107-109) | **△** |
| C-46 | SparkExecuteStatementOperation.timeout のグローバルタイムアウトとの比較ロジック | E-05 (L57-63) | ○ |
| C-47 | SparkSQLSessionManager.openSession でsingleSessionモードの動作 | E-21 (L61-64) | **△** |
| C-48 | SparkSQLOperationManager.newExecuteStatementOperation のsession null時のrequire | E-22 (L50-51) | ○ |
| C-49 | calculateNumberToRemoveがdataSize==retainedSizeで0を返す | E-18 (L308: dataSize > retainedSize の条件で等しい場合はelse) | **△** |
| C-50 | SparkSQLDriver.getResults後にhiveResponseがnullになる2回目呼び出し | E-04 (L123: hiveResponse = null) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-45**: SparkSQLDriver.runでの非SparkThrowable時のQueryExecutionExceptionスロー動作は、SparkSessionへの強い依存があり単体テストでの再現にはモック化が必要。テスト時の具体的な例外発生パスは実行コンテキスト依存。
  - 候補：SparkSessionのモック / テスト用のSparkSession初期化
- **C-47**: SparkSQLSessionManager.openSessionのsingleSessionモードはSparkSessionの設定値依存であり、テスト時のセットアップ方法は要確認。
  - 候補：テスト用SparkSession / 設定値のモック
- **C-49**: calculateNumberToRemoveはprivateメソッドのためリフレクション経由でのテストが必要。境界値の動作はコードから推測。
  - 候補：テスト用サブクラス / リフレクション

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - FetchIterator, ReflectionUtils, CookieSigner, ServiceUtils, HandleIdentifier等の独立したユーティリティ系テストケース（UT-HTS-001〜016, 028〜034, 089〜104, 117〜124）
- 0: 低リスク - 型マッピング系テストケース（UT-HTS-035〜050, 071〜088, 125〜143）は定義から直接導出
- 1: 中リスク - SparkSQLDriver, SparkExecuteStatementOperation等のSparkSession依存テスト（UT-HTS-055〜062）はモック化が必要
- 1: 中リスク - HiveThriftServer2Listener内のprivateメソッドテスト（UT-HTS-153〜155）はリフレクション必要
- 0: 低リスク - エラー生成ファクトリ（UT-HTS-063〜070）は入出力が明確
- 0: 低リスク - OperationState状態遷移（UT-HTS-105〜116）はenumの定義から明確

## 6) レビュアーチェックリスト（最小）
- [ ] FetchIterator系テスト（UT-HTS-001〜016）がArrayFetchIteratorとIterableFetchIteratorの両方をカバーしているか
- [ ] RowSetUtils型マッピング（UT-HTS-017〜027）がrow-basedとcolumn-basedの両方をカバーしているか
- [ ] SparkExecuteStatementOperation.toTTypeId（UT-HTS-035〜047）が全Spark DataTypeをカバーしているか
- [ ] OperationState遷移テスト（UT-HTS-105〜113）が許可遷移と不正遷移の両方をカバーしているか
- [ ] CookieSigner署名テスト（UT-HTS-089〜096）がセキュリティ上重要な改ざん検知を含んでいるか
- [ ] SparkSQLDriver.runテスト（UT-HTS-055〜056）のモック化方針が妥当か
- [ ] privateメソッドテスト（getColumnSize, getDecimalDigits, calculateNumberToRemove等）のアクセス方法が妥当か
