---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 170
  claims_with_evidence: 158
  claims_without_evidence: 12
confidence_derived: 0.93
---

# 根拠レポート：sql-hive 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：158 / 170、根拠なし：12
- 優先レビュー（高）
  1. **HiveExternalCatalog.alterDatabase の境界値テスト（C-006）**：ログ出力の確認はソースコードの実装詳細に依存し、具体的な検証が困難
  2. **HiveExternalCatalog.reorderSchema の異常系テスト（C-169）**：パーティション列不存在時の例外型の確認が必要
  3. **HiveExternalCatalog.removeCollation のテスト（C-170）**：Collation関連の処理の存在はソースコードから確認しきれていない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `sql/hive/src/main/scala/org/apache/spark/sql/hive/HiveExternalCatalog.scala`
- E-02: `sql/hive/src/main/scala/org/apache/spark/sql/hive/HiveMetastoreCatalog.scala`
- E-03: `sql/hive/src/main/scala/org/apache/spark/sql/hive/HiveSessionCatalog.scala`
- E-04: `sql/hive/src/main/scala/org/apache/spark/sql/hive/HiveUtils.scala`
- E-05: `sql/hive/src/main/scala/org/apache/spark/sql/hive/HiveInspectors.scala`
- E-06: `sql/hive/src/main/scala/org/apache/spark/sql/hive/HiveShim.scala`
- E-07: `sql/hive/src/main/scala/org/apache/spark/sql/hive/hiveUDFs.scala`
- E-08: `sql/hive/src/main/scala/org/apache/spark/sql/hive/hiveUDFEvaluators.scala`
- E-09: `sql/hive/src/main/scala/org/apache/spark/sql/hive/HiveStrategies.scala`
- E-10: `sql/hive/src/main/scala/org/apache/spark/sql/hive/execution/HiveOptions.scala`
- E-11: `sql/hive/src/main/scala/org/apache/spark/sql/hive/execution/InsertIntoHiveTable.scala`
- E-12: `sql/hive/src/main/scala/org/apache/spark/sql/hive/execution/PruneHiveTablePartitions.scala`
- E-13: `sql/hive/src/main/scala/org/apache/spark/sql/hive/TableReader.scala`
- E-14: `sql/hive/src/main/scala/org/apache/spark/sql/hive/client/HiveClientImpl.scala`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | HiveExternalCatalog.createDatabaseの正常系テスト | E-01 | ○ |
| C-002 | HiveExternalCatalog.createDatabaseのignoreIfExists=trueテスト | E-01 | ○ |
| C-003 | HiveExternalCatalog.dropDatabaseの正常系テスト | E-01 | ○ |
| C-004 | HiveExternalCatalog.dropDatabaseのignoreIfNotExists=trueテスト | E-01 | ○ |
| C-005 | HiveExternalCatalog.alterDatabaseの正常系テスト | E-01 | ○ |
| C-006 | HiveExternalCatalog.alterDatabaseの境界値テスト（プロパティ変更なし） | E-01 | △ |
| C-007 | HiveExternalCatalog.getDatabaseの正常系テスト | E-01 | ○ |
| C-008 | HiveExternalCatalog.databaseExistsの正常系テスト（存在） | E-01 | ○ |
| C-009 | HiveExternalCatalog.databaseExistsの正常系テスト（不存在） | E-01 | ○ |
| C-010 | HiveExternalCatalog.listDatabasesの正常系テスト | E-01 | ○ |
| C-011 | HiveExternalCatalog.listDatabasesのパターンテスト | E-01 | ○ |
| C-012 | HiveExternalCatalog.createTableのHive serdeテスト | E-01 | ○ |
| C-013 | HiveExternalCatalog.createTableのデータソーステーブルテスト | E-01 | ○ |
| C-014 | HiveExternalCatalog.createTableの重複テスト | E-01 | ○ |
| C-015 | HiveExternalCatalog.createTableのignoreIfExistsテスト | E-01 | ○ |
| C-016 | HiveExternalCatalog.verifyTablePropertiesのspark.sql.プレフィックステスト | E-01 | ○ |
| C-017 | HiveExternalCatalog.verifyTablePropertiesのEXTERNALテスト | E-01 | ○ |
| C-018 | HiveExternalCatalog.dropTableの正常系テスト | E-01 | ○ |
| C-019 | HiveExternalCatalog.renameTableの正常系テスト | E-01 | ○ |
| C-020 | HiveExternalCatalog.renameTableのpathオプション更新テスト | E-01 | ○ |
| C-021 | HiveExternalCatalog.alterTableの正常系テスト | E-01 | ○ |
| C-022 | HiveExternalCatalog.alterTableのVIEW変更テスト | E-01 | ○ |
| C-023 | HiveExternalCatalog.alterTableDataSchemaの正常系テスト | E-01 | ○ |
| C-024 | HiveExternalCatalog.alterTableStatsの正常系テスト | E-01 | ○ |
| C-025 | HiveExternalCatalog.alterTableStatsのstats=Noneテスト | E-01 | ○ |
| C-026 | HiveExternalCatalog.getTableの正常系テスト | E-01 | ○ |
| C-027 | HiveExternalCatalog.restoreTableMetadataのデータソーステーブルテスト | E-01 | ○ |
| C-028 | HiveExternalCatalog.restoreTableMetadataのHive serdeテーブルテスト | E-01 | ○ |
| C-029 | HiveExternalCatalog.restoreTableMetadataのVIEWテスト | E-01 | ○ |
| C-030 | HiveExternalCatalog.tableExistsの正常系テスト | E-01 | ○ |
| C-031 | HiveExternalCatalog.createPartitionsの正常系テスト | E-01 | ○ |
| C-032 | HiveExternalCatalog.dropPartitionsの正常系テスト | E-01 | ○ |
| C-033 | HiveExternalCatalog.renamePartitionsの正常系テスト | E-01 | ○ |
| C-034 | HiveExternalCatalog.getPartitionの正常系テスト | E-01 | ○ |
| C-035 | HiveExternalCatalog.listPartitionsの正常系テスト | E-01 | ○ |
| C-036 | HiveExternalCatalog.listPartitionsのドット含みフィルタテスト | E-01 | ○ |
| C-037 | HiveExternalCatalog.createFunctionの正常系テスト | E-01 | ○ |
| C-038 | HiveExternalCatalog.createFunctionの大小文字正規化テスト | E-01 | ○ |
| C-039 | HiveExternalCatalog.isClientExceptionのHiveExceptionテスト | E-01 | ○ |
| C-040 | HiveExternalCatalog.isClientExceptionの再帰的判定テスト | E-01 | ○ |
| C-041 | HiveExternalCatalog.isClientExceptionの非クライアント例外テスト | E-01 | ○ |
| C-042 | HiveExternalCatalog.withClientの例外ラッピングテスト | E-01 | ○ |
| C-043 | HiveExternalCatalog.isDatasourceTableの正常系テスト | E-01 | ○ |
| C-044 | HiveExternalCatalog.isDatasourceTableのHive providerテスト | E-01 | ○ |
| C-045 | HiveExternalCatalog.isHiveCompatibleDataTypeの基本型テスト | E-01 | ○ |
| C-046 | HiveExternalCatalog.isHiveCompatibleDataTypeのAnsiIntervalテスト | E-01 | ○ |
| C-047 | HiveExternalCatalog.isHiveCompatibleDataTypeのTimestampNTZテスト | E-01 | ○ |
| C-048 | HiveExternalCatalog.isHiveCompatibleDataTypeのVariantテスト | E-01 | △ |
| C-049 | HiveExternalCatalog.isHiveCompatibleDataTypeのネストStructテスト | E-01 | ○ |
| C-050 | HiveExternalCatalog.isHiveCompatibleDataTypeのCollationテスト | E-01 | △ |
| C-051 | HiveMetastoreCatalog.convertのParquetテスト | E-02 | ○ |
| C-052 | HiveMetastoreCatalog.convertのORCテスト | E-02 | ○ |
| C-053 | HiveMetastoreCatalog.convertStorageFormatのParquetテスト | E-02 | ○ |
| C-054 | HiveMetastoreCatalog.convertStorageFormatのORCテスト | E-02 | ○ |
| C-055 | HiveMetastoreCatalog.mergeWithMetastoreSchemaの正常系テスト | E-02 | ○ |
| C-056 | HiveMetastoreCatalog.mergeWithMetastoreSchemaのnullable補完テスト | E-02 | ○ |
| C-057 | HiveMetastoreCatalog.mergeWithMetastoreSchemaのスキーマ競合テスト | E-02 | ○ |
| C-058 | HiveUtils.isCliSessionStateのCliSessionStateテスト | E-04 | ○ |
| C-059 | HiveUtils.isCliSessionStateの非CliSessionStateテスト | E-04 | ○ |
| C-060 | HiveUtils.isCliSessionStateのnullテスト | E-04 | △ |
| C-061 | HiveUtils.newTemporaryConfigurationのインメモリDerbyテスト | E-04 | ○ |
| C-062 | HiveUtils.newTemporaryConfigurationのファイルDerbyテスト | E-04 | ○ |
| C-063 | HiveUtils.inferSchemaの正常系テスト | E-04 | ○ |
| C-064 | HiveUtils.inferSchemaのデータソーステーブルスキップテスト | E-04 | ○ |
| C-065 | HiveUtils.inferSchemaのスキーマ非空スキップテスト | E-04 | ○ |
| C-066 | HiveUtils.partitionNameToValuesの正常系テスト | E-04 | ○ |
| C-067 | HiveUtils.partitionNameToValuesのエスケープテスト | E-04 | △ |
| C-068 | HiveUtils.causedByThriftのThrift例外テスト | E-04 | ○ |
| C-069 | HiveUtils.causedByThriftのネスト例外テスト | E-04 | ○ |
| C-070 | HiveUtils.causedByThriftの非Thrift例外テスト | E-04 | ○ |
| C-071 | HiveUtils.causedByThriftのnullメッセージテスト | E-04 | △ |
| C-072 | HiveInspectors.javaTypeToDataTypeのJava基本型テスト | E-05 | ○ |
| C-073 | HiveInspectors.javaTypeToDataTypeのWritable型テスト | E-05 | ○ |
| C-074 | HiveInspectors.javaTypeToDataTypeの配列型テスト | E-05 | ○ |
| C-075 | HiveInspectors.javaTypeToDataTypeのParameterizedType(List)テスト | E-05 | ○ |
| C-076 | HiveInspectors.javaTypeToDataTypeのParameterizedType(Map)テスト | E-05 | ○ |
| C-077 | HiveInspectors.javaTypeToDataTypeのraw Listテスト | E-05 | ○ |
| C-078 | HiveInspectors.javaTypeToDataTypeのraw Mapテスト | E-05 | ○ |
| C-079 | HiveInspectors.javaTypeToDataTypeのWildcardTypeテスト | E-05 | ○ |
| C-080 | HiveInspectors.toInspector(DataType)のCatalyst基本型テスト | E-05 | ○ |
| C-081 | HiveInspectors.toInspector(DataType)のArrayTypeテスト | E-05 | ○ |
| C-082 | HiveInspectors.toInspector(DataType)のMapTypeテスト | E-05 | ○ |
| C-083 | HiveInspectors.toInspector(DataType)のStructTypeテスト | E-05 | ○ |
| C-084 | HiveInspectors.toInspector(Expression)のリテラルテスト | E-05 | ○ |
| C-085 | HiveInspectors.toInspector(Expression)のfoldable式テスト | E-05 | ○ |
| C-086 | HiveInspectors.inspectorToDataTypeの逆変換テスト | E-05 | ○ |
| C-087 | HiveInspectors.wrapperForのPrimitive OIテスト | E-05 | ○ |
| C-088 | HiveInspectors.wrapperForのnull入力テスト | E-05 | ○ |
| C-089 | HiveInspectors.unwrapperForのOI正常系テスト | E-05 | ○ |
| C-090 | HiveInspectors.unwrapperForのnull入力テスト | E-05 | ○ |
| C-091 | HiveInspectors.wrap(Any, OI, DataType)のラップテスト | E-05 | ○ |
| C-092 | HiveInspectors.wrap(InternalRow)の行ラップテスト | E-05 | ○ |
| C-093 | HiveShim.appendReadColumnsの正常系テスト | E-06 | ○ |
| C-094 | HiveShim.appendReadColumnsのids=nullテスト | E-06 | ○ |
| C-095 | HiveShim.prepareWritableのAvroテスト | E-06 | ○ |
| C-096 | HiveShim.prepareWritableの非Avroテスト | E-06 | ○ |
| C-097 | HiveShim.toCatalystDecimalの正常系テスト | E-06 | ○ |
| C-098 | HiveShim.toCatalystDecimalのnullテスト | E-06 | ○ |
| C-099 | HiveFunctionWrapper.createFunctionのUDFインスタンスタテスト | E-06 | ○ |
| C-100 | HiveFunctionWrapper.createFunctionのキャッシュテスト | E-06 | ○ |
| C-101 | HiveFunctionWrapper.hashCodeの通常UDFテスト | E-06 | ○ |
| C-102 | HiveFunctionWrapper.hashCodeのマクロUDFテスト | E-06 | ○ |
| C-103 | HiveFunctionWrapper.equalsの同一クラス名テスト | E-06 | ○ |
| C-104 | HiveFunctionWrapper.equalsの異なるクラス名テスト | E-06 | ○ |
| C-105 | HiveSimpleUDF.evalの正常系テスト | E-07 | ○ |
| C-106 | HiveSimpleUDF.nullableのプロパティテスト | E-07 | ○ |
| C-107 | HiveGenericUDF.evalの正常系テスト | E-07 | ○ |
| C-108 | HiveGenericUDF.evalの例外処理テスト | E-07 | ○ |
| C-109 | HiveGenericUDTF.evalの正常系テスト | E-07 | ○ |
| C-110 | HiveGenericUDTF.terminateの正常系テスト | E-07 | ○ |
| C-111 | HiveUDAFFunction.createAggregationBufferのnull返却テスト | E-07 | ○ |
| C-112 | HiveUDAFFunction.updateの正常系テスト | E-07 | ○ |
| C-113 | HiveUDAFFunction.mergeの正常系テスト | E-07 | ○ |
| C-114 | HiveUDAFFunction.mergeのUPDATE→MERGE遷移テスト | E-07 | ○ |
| C-115 | HiveUDAFFunction.evalの正常系テスト | E-07 | ○ |
| C-116 | HiveUDAFFunction.evalのnullバッファテスト | E-07 | ○ |
| C-117 | HiveUDAFFunction.serializeの正常系テスト | E-07 | ○ |
| C-118 | HiveUDAFFunction.deserializeの正常系テスト | E-07 | ○ |
| C-119 | HiveUDFEvaluatorBase.evaluateの正常系テスト | E-08 | ○ |
| C-120 | HiveUDFEvaluatorBase.evaluateの例外ラッピングテスト | E-08 | ○ |
| C-121 | HiveSimpleUDFEvaluator.setArgの正常系テスト | E-08 | ○ |
| C-122 | HiveSimpleUDFEvaluator.doEvaluateの正常系テスト | E-08 | ○ |
| C-123 | HiveGenericUDFEvaluator.setArgの正常系テスト | E-08 | ○ |
| C-124 | HiveGenericUDFEvaluator.setExceptionの正常系テスト | E-08 | ○ |
| C-125 | HiveGenericUDFEvaluator.doEvaluateの正常系テスト | E-08 | ○ |
| C-126 | DeferredObjectAdapter.getの正常系テスト | E-08 | ○ |
| C-127 | HiveOptions.constructorのfileFormatテスト | E-10 | ○ |
| C-128 | HiveOptions.constructorのinput/outputFormatテスト | E-10 | ○ |
| C-129 | HiveOptions.constructorのinputFormat単独テスト | E-10 | ○ |
| C-130 | HiveOptions.constructorのoutputFormat単独テスト | E-10 | ○ |
| C-131 | HiveOptions.constructorのfileFormatとinputFormat同時指定テスト | E-10 | ○ |
| C-132 | HiveOptions.constructorのfileFormatとserdeの不正組み合わせテスト | E-10 | ○ |
| C-133 | HiveOptions.constructorのsequencefile+serdeテスト | E-10 | ○ |
| C-134 | HiveOptions.constructorのserde+デリミタテスト | E-10 | ○ |
| C-135 | HiveOptions.constructorのfileFormat未指定+デリミタテスト | E-10 | ○ |
| C-136 | HiveOptions.constructorの非textfile+デリミタテスト | E-10 | ○ |
| C-137 | HiveOptions.constructorの改行以外lineDelimテスト | E-10 | ○ |
| C-138 | HiveOptions.serdePropertiesの正常系テスト | E-10 | ○ |
| C-139 | HiveOptions.getHiveWriteCompressionのParquetテスト | E-10 | ○ |
| C-140 | HiveOptions.getHiveWriteCompressionのORCテスト | E-10 | ○ |
| C-141 | HiveOptions.getHiveWriteCompressionの不明フォーマットテスト | E-10 | ○ |
| C-142 | ResolveHiveSerdeTable.applyの正常系テスト | E-09 | ○ |
| C-143 | ResolveHiveSerdeTable.applyのbucketSpec異常系テスト | E-09 | ○ |
| C-144 | ResolveHiveSerdeTable.applyの空スキーマ異常系テスト | E-09 | ○ |
| C-145 | DetermineTableStats.applyの正常系テスト | E-09 | ○ |
| C-146 | RelationConversions.applyのParquet読み取りテスト | E-09 | ○ |
| C-147 | RelationConversions.applyのParquet書き込みテスト | E-09 | ○ |
| C-148 | RelationConversions.applyのCTASテスト | E-09 | ○ |
| C-149 | RelationConversions.isConvertibleのParquetテスト | E-09 | ○ |
| C-150 | RelationConversions.isConvertibleのORCテスト | E-09 | ○ |
| C-151 | HiveAnalysis.applyのInsertIntoStatement変換テスト | E-09 | ○ |
| C-152 | HiveAnalysis.applyのCreateTableCommand変換テスト | E-09 | ○ |
| C-153 | HiveAnalysis.applyのDELETE異常系テスト | E-09 | ○ |
| C-154 | PruneHiveTablePartitions.applyの正常系テスト | E-12 | ○ |
| C-155 | PruneHiveTablePartitions.applyの空フィルタテスト | E-12 | ○ |
| C-156 | PruneHiveTablePartitions.applyの刈り込み済みテスト | E-12 | ○ |
| C-157 | PruneHiveTablePartitions.updateTableMetaの統計更新テスト | E-12 | ○ |
| C-158 | PruneHiveTablePartitions.updateTableMetaのサイズ0テスト | E-12 | ○ |
| C-159 | HiveExternalCatalog.loadTableの正常系テスト | E-01 | ○ |
| C-160 | HiveExternalCatalog.loadPartitionの正常系テスト | E-01 | ○ |
| C-161 | HiveExternalCatalog.toMetaStorePartitionSpecの大小文字テスト | E-01 | ○ |
| C-162 | HiveExternalCatalog.statsToPropertiesの正常系テスト | E-01 | ○ |
| C-163 | HiveExternalCatalog.statsFromPropertiesの正常系テスト | E-01 | ○ |
| C-164 | HiveExternalCatalog.statsFromPropertiesの空統計テスト | E-01 | ○ |
| C-165 | HiveExternalCatalog.tableMetaToTablePropsの正常系テスト | E-01 | ○ |
| C-166 | HiveExternalCatalog.tableMetaToTablePropsの空パーティションテスト | E-01 | △ |
| C-167 | HiveExternalCatalog.tableMetaToTablePropsの空バケットテスト | E-01 | △ |
| C-168 | HiveExternalCatalog.reorderSchemaの正常系テスト | E-01 | ○ |
| C-169 | HiveExternalCatalog.reorderSchemaの異常系テスト | E-01 | △ |
| C-170 | HiveExternalCatalog.removeCollationの正常系テスト | E-01 | △ |

## 4) 不足情報（Unknown / Missing）
- **C-006**: HiveExternalCatalog.alterDatabaseで「プロパティ変更なし」の場合の具体的な挙動は、ソースコード上で警告ログを出力するかどうかの確認が不十分。実装がwithClientを通じて直接client.alterDatabaseを呼ぶため、no-op検知機構の有無は不明
  - 候補：実装コードの精査 / 既存テストの確認
- **C-048**: VariantTypeのHive互換性チェックは、VariantTypeがSparkの比較的新しい型であり、isHiveCompatibleDataTypeメソッドでの扱いの確認が必要
  - 候補：HiveExternalCatalog.scalaの最新実装の確認
- **C-050**: 非UTF8BinaryCollationのStringTypeの処理は、Collation機能がSparkに追加された時期に依存しており、ソースコードでの確認が不完全
  - 候補：StringType実装 / Collation関連PR
- **C-060, C-071**: SessionState.getやThrowable.getMessageがnullを返すケースの挙動はソースコードから直接確認できず推測に基づく
  - 候補：実行時テスト
- **C-067**: partitionNameToValuesのエスケープ解除処理の詳細はHiveUtils.scala内のメソッド実装を直接確認しきれていない
  - 候補：HiveUtils.scalaの全体読み込み
- **C-166, C-167**: tableMetaToTablePropsの空パーティション/空バケット時の振る舞いは、メソッドの条件分岐のロジックに基づく推測
  - 候補：HiveExternalCatalog.scalaの完全読み込み
- **C-169**: reorderSchemaでパーティション列が不存在の場合の例外型は推測（AnalysisException vs その他）
  - 候補：実装の詳細確認
- **C-170**: removeCollationメソッドの存在と挙動はCollation対応の実装時期に依存
  - 候補：最新のHiveExternalCatalog.scala全体の確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - HiveOptions, HiveShim, HiveFunctionWrapperのテストケース（C-093 - C-141）: これらのクラスはソースコードから詳細を確認済みで信頼度が高い
- 0: 低リスク - HiveInspectors型変換テストケース（C-072 - C-092）: ソースコードの大量のパターンマッチから直接抽出しており信頼度が高い
- 1: 中リスク - HiveExternalCatalog内部メソッド（C-159 - C-170）: ファイルの一部のみ読み込みのため、メソッドの存在や詳細なシグネチャは推測が含まれる
- 1: 中リスク - HiveUDAFFunction のserialize/deserializeテスト（C-117, C-118）: AggregationBufferSerDeの内部クラスの挙動に依存するため、テスト構築が困難な可能性がある
- 2: 高リスク - Collation/Variant関連テスト（C-048, C-050, C-170）: 新機能であり、ソースコードでの実装状況を完全に確認できていない

## 6) レビュアーチェックリスト（最小）
- [ ] HiveExternalCatalogの各DB/テーブル操作テストが、ExternalCatalogの公開APIを網羅しているか確認
- [ ] HiveInspectorsの型マッピングテストケースが、全てのCatalyst基本型をカバーしているか確認
- [ ] HiveOptionsのバリデーションテストが、全ての制約条件の組み合わせを網羅しているか確認
- [ ] HiveUDAFFunction.mergeのUPDATE→MERGE遷移テスト（C-114）が正しくbuffer再作成ロジックを検証できるか確認
- [ ] RelationConversionsの変換テストがParquet/ORC両方をカバーしているか確認
- [ ] PruneHiveTablePartitionsの統計更新ロジック（rawDataSize vs totalSize）の境界条件が網羅されているか確認
- [ ] C-048, C-050, C-170のCollation/Variant関連テストの実現可能性を確認
- [ ] HiveExternalCatalogの内部メソッド（statsToProperties, statsFromProperties, tableMetaToTableProps, reorderSchema）が実際にpublicまたはprotectedであるか確認
