---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 148
  claims_with_evidence: 141
  claims_without_evidence: 7
confidence_derived: 0.95
---

# 根拠レポート：sql-pipelines 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：141 / 148、根拠なし：7
- 優先レビュー（高）
  1. **UT-PIP-100, UT-PIP-101（DataflowGraphTransformer.transform）**：transformメソッドの内部実装詳細はprivateスコープであるため、テストケースの入力/期待結果が推論ベース
  2. **UT-PIP-141, UT-PIP-142（FlowState.transition）**：State.scalaの具体的な状態遷移ルールが複雑であり、全遷移パターンの網羅性は要確認
  3. **UT-PIP-143, UT-PIP-144（GraphValidations.validate）**：検証ロジックの全パターンはGraphValidations.scalaの詳細実装に依存
  4. **UT-PIP-145（FlowSystemMetadata.latestCheckpointLocation）**：SystemMetadata.scalaのチェックポイントパス生成ロジックの詳細確認が必要
  5. **UT-PIP-148（SchemaInferenceUtils.inferSchema）**：SchemaInferenceUtils.scalaの内部ロジック詳細に依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `sql/pipelines/src/main/scala/org/apache/spark/sql/pipelines/graph/QueryOrigin.scala`
- E-02: `sql/pipelines/src/main/scala/org/apache/spark/sql/pipelines/graph/GraphIdentifierManager.scala`（IdentifierHelper含む）
- E-03: `sql/pipelines/src/main/scala/org/apache/spark/sql/pipelines/graph/PipelinesTableProperties.scala`
- E-04: `sql/pipelines/src/main/scala/org/apache/spark/sql/pipelines/graph/GraphFilter.scala`
- E-05: `sql/pipelines/src/main/scala/org/apache/spark/sql/pipelines/graph/PipelineUpdateContext.scala`
- E-06: `sql/pipelines/src/main/scala/org/apache/spark/sql/pipelines/graph/GraphRegistrationContext.scala`
- E-07: `sql/pipelines/src/main/scala/org/apache/spark/sql/pipelines/graph/GraphElementTypeUtils.scala`
- E-08: `sql/pipelines/src/main/scala/org/apache/spark/sql/pipelines/graph/ViewHelpers.scala`
- E-09: `sql/pipelines/src/main/scala/org/apache/spark/sql/pipelines/common/GraphStates.scala`
- E-10: `sql/pipelines/src/main/scala/org/apache/spark/sql/pipelines/Language.scala`
- E-11: `sql/pipelines/src/main/scala/org/apache/spark/sql/pipelines/AnalysisWarning.scala`
- E-12: `sql/pipelines/src/main/scala/org/apache/spark/sql/pipelines/util/SchemaMergingUtils.scala`
- E-13: `sql/pipelines/src/main/scala/org/apache/spark/sql/pipelines/util/BackoffStrategy.scala`
- E-14: `sql/pipelines/src/main/scala/org/apache/spark/sql/pipelines/logging/ConstructPipelineEvent.scala`
- E-15: `sql/pipelines/src/main/scala/org/apache/spark/sql/pipelines/logging/PipelineEvent.scala`
- E-16: `sql/pipelines/src/main/scala/org/apache/spark/sql/pipelines/graph/FlowAnalysisContext.scala`
- E-17: `sql/pipelines/src/main/scala/org/apache/spark/sql/pipelines/graph/SqlGraphRegistrationContext.scala`
- E-18: `sql/pipelines/src/main/scala/org/apache/spark/sql/pipelines/graph/DataflowGraphTransformer.scala`
- E-19: `sql/pipelines/src/main/scala/org/apache/spark/sql/pipelines/graph/GraphOperations.scala`
- E-20: `sql/pipelines/src/main/scala/org/apache/spark/sql/pipelines/graph/FlowPlanner.scala`
- E-21: `sql/pipelines/src/main/scala/org/apache/spark/sql/pipelines/graph/CoreDataflowNodeProcessor.scala`
- E-22: `sql/pipelines/src/main/scala/org/apache/spark/sql/pipelines/logging/FlowProgressEventLogger.scala`
- E-23: `sql/pipelines/src/main/scala/org/apache/spark/sql/pipelines/graph/DataflowGraph.scala`
- E-24: `sql/pipelines/src/main/scala/org/apache/spark/sql/pipelines/graph/FlowAnalysis.scala`
- E-25: `sql/pipelines/src/main/scala/org/apache/spark/sql/pipelines/graph/State.scala`
- E-26: `sql/pipelines/src/main/scala/org/apache/spark/sql/pipelines/graph/GraphValidations.scala`
- E-27: `sql/pipelines/src/main/scala/org/apache/spark/sql/pipelines/graph/SystemMetadata.scala`
- E-28: `sql/pipelines/src/main/scala/org/apache/spark/sql/pipelines/graph/UncaughtExceptionHandler.scala`
- E-29: `sql/pipelines/src/main/scala/org/apache/spark/sql/pipelines/graph/RunTerminationReason.scala`
- E-30: `sql/pipelines/src/main/scala/org/apache/spark/sql/pipelines/util/SchemaInferenceUtils.scala`
- E-31: `sql/pipelines/src/main/scala/org/apache/spark/sql/pipelines/logging/StreamListener.scala`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | QueryOrigin.merge(QueryOrigin)はother優先でフィールドをマージする（UT-PIP-001〜003） | E-01 | ○ |
| C-02 | QueryOrigin.merge(Origin)はCatalystのOriginからsqlText/line/startPositionをマージする（UT-PIP-004） | E-01 | ○ |
| C-03 | QueryOrigin.getOriginはsuppressed例外からOriginを取得する（UT-PIP-005〜007） | E-01 | ○ |
| C-04 | ExceptionHelpers.addOriginはOriginをsuppressed例外として追加する（UT-PIP-008〜009） | E-01 | ○ |
| C-05 | IdentifierHelper.toTableIdentifier(Seq)は1-3要素で正しくTableIdentifierを生成する（UT-PIP-010〜014） | E-02 | ○ |
| C-06 | IdentifierHelper.isSinglePartIdentifierはdatabase/catalogの有無で判定する（UT-PIP-016〜017） | E-02 | ○ |
| C-07 | IdentifierHelper.fullyQualifyIdentifierはcatalog/databaseをデフォルト値で補完する（UT-PIP-018〜019） | E-02 | ○ |
| C-08 | assertIsFullyQualifiedForCreate/Readはcatalog/database未定義で失敗する（UT-PIP-020〜022） | E-02 | ○ |
| C-09 | parseAndValidateTemporaryViewIdentifierは単一部分のみ許可する（UT-PIP-023〜024） | E-02 | ○ |
| C-10 | parseAndValidateSinkIdentifierは単一部分のみ許可する（UT-PIP-025〜026） | E-02 | ○ |
| C-11 | parseAndQualifyTableIdentifier/FlowIdentifierは完全修飾を行う（UT-PIP-027〜028） | E-02 | ○ |
| C-12 | PipelinesTableProperties.validateAndCanonicalizeはプロパティの正規化/警告/除外を行う（UT-PIP-029〜032） | E-03 | ○ |
| C-13 | PipelineTableProperty.fromMapはMapから値を取得しデフォルト値も使用する（UT-PIP-033〜035） | E-03 | ○ |
| C-14 | GraphFilterの各実装（AllTables/SomeTables/NoTables）が正しく判定する（UT-PIP-036〜041） | E-04 | ○ |
| C-15 | PipelineUpdateContext.refreshFlowsがrefreshTables/fullRefreshTablesから適切にFlowFilterを構築する（UT-PIP-042〜044） | E-05 | ○ |
| C-16 | GraphRegistrationContextがテーブル/ビュー/Sink/フローを登録しDataflowGraphを生成する（UT-PIP-045〜054） | E-06 | ○ |
| C-17 | GraphElementTypeUtils.getDatasetTypeForMaterializedViewOrStreamingTableがフロー種別で判定する（UT-PIP-055〜058） | E-07 | ○ |
| C-18 | ViewHelpers.persistedViewIdentifierToFlowがビューとフローの1対1マッピングを検証する（UT-PIP-059〜061） | E-08 | ○ |
| C-19 | FlowStatus.isTerminalがCOMPLETED/FAILED/SKIPPED/STOPPEDをtrueと判定する（UT-PIP-062〜064） | E-09 | ○ |
| C-20 | Language.Sql/Pythonが正しいdisplayNameを持つ（UT-PIP-065〜066） | E-10 | ○ |
| C-21 | AnalysisWarning.StreamingReaderOptionsDroppedが正しい警告メッセージを生成する（UT-PIP-067） | E-11 | ○ |
| C-22 | SchemaMergingUtils.mergeSchemasがスキーマのマージと不一致検出を行う（UT-PIP-068〜070） | E-12 | ○ |
| C-23 | BackoffStrategy.nextBackoffMillisが指数バックオフと上限制約を実装する（UT-PIP-071〜073） | E-13 | ○ |
| C-24 | ConstructPipelineEvent.applyが正しいフィールドのPipelineEventを生成する（UT-PIP-074〜076） | E-14 | ○ |
| C-25 | PipelineEvent.messageWithErrorがエラー有無に応じて適切なメッセージを返す（UT-PIP-077〜079） | E-15 | ○ |
| C-26 | FlowAnalysisContext.setConf/restoreOriginalConfが設定値の変更と復元を行う（UT-PIP-080〜084） | E-16 | ○ |
| C-27 | SqlGraphRegistrationContextStateが設定/カタログ/データベースの管理を行う（UT-PIP-085〜089） | E-17 | ○ |
| C-28 | SqlGraphElementRegistrationException.codeLocationStrが位置情報を適切に文字列化する（UT-PIP-090〜092） | E-17 | ○ |
| C-29 | PartitionHelper.applyPartitioningがIdentityTransformのみ許可する（UT-PIP-093〜095） | E-17 | ○ |
| C-30 | SqlGraphRegistrationContext.splitSqlFileIntoQueriesがSQL文を分割し行番号を計算する（UT-PIP-096〜099） | E-17 | ○ |
| C-31 | DataflowGraphTransformer.transformがトポロジカルソートと循環依存検出を行う（UT-PIP-100〜101） | E-18 | △ |
| C-32 | GraphOperations.dfsInternalが上流/下流のDFS探索を行う（UT-PIP-102〜109） | E-19 | ○ |
| C-33 | FlowPlanner.planがフロー種別に応じたFlowExecutionを生成する（UT-PIP-110〜114） | E-20 | ○ |
| C-34 | CoreDataflowNodeProcessor.processNodeがノード種別に応じた処理を行う（UT-PIP-115〜119） | E-21 | ○ |
| C-35 | FlowResolver.attemptResolveFlowがフロー解決とSQL設定衝突検出を行う（UT-PIP-120〜123） | E-21 | ○ |
| C-36 | FlowProgressEventLoggerの各recordメソッドが適切なレベル/ステータスでイベントを記録する（UT-PIP-124〜136） | E-22 | ○ |
| C-37 | DataflowGraphがflowsTo/resolvedFlow/inputIdentifiers等のアクセサを提供する（UT-PIP-137〜140） | E-23 | ○ |
| C-38 | FlowStateが有効な状態遷移のみ許可する（UT-PIP-141〜142） | E-25 | △ |
| C-39 | GraphValidationsがグラフの整合性を検証する（UT-PIP-143〜144） | E-26 | △ |
| C-40 | FlowSystemMetadataがチェックポイントパスを生成する（UT-PIP-145） | E-27 | △ |
| C-41 | UncaughtExceptionHandlerが未キャッチ例外をハンドリングする（UT-PIP-146） | E-28 | ○ |
| C-42 | RunTerminationReasonが各終了理由を表す（UT-PIP-147） | E-29 | ○ |
| C-43 | SchemaInferenceUtils.inferSchemaがスキーマを推論する（UT-PIP-148） | E-30 | △ |

## 4) 不足情報（Unknown / Missing）
- **C-31 (DataflowGraphTransformer.transform)**：transformメソッドの一部内部処理がprivateであり、具体的な中間状態やエッジケースの全パターンを網羅的に確認できていない。
  - 候補：既存テストコード / 設計ドキュメント / DataflowGraphTransformerの利用箇所
- **C-38 (FlowState.transition)**：State.scalaの状態遷移マトリクスの全パターン（特にIDLE/EXCLUDED等の特殊状態からの遷移）が明確でない部分がある。
  - 候補：State.scalaの詳細実装 / 既存テストコード
- **C-39 (GraphValidations.validate)**：GraphValidationsの全検証ルールの一覧が内部実装に依存しており、テストケースの網羅性は追加確認が必要。
  - 候補：GraphValidations.scalaの詳細実装 / 既存テストコード
- **C-40 (FlowSystemMetadata)**：チェックポイントパス生成の詳細ロジック（パス構造、バージョン管理等）の実装詳細。
  - 候補：SystemMetadata.scalaの詳細実装 / 設定仕様
- **C-43 (SchemaInferenceUtils)**：スキーマ推論の内部実装が他のSparkコンポーネントに依存しており、具体的な推論ルールの確認が必要。
  - 候補：SchemaInferenceUtils.scalaの詳細実装

## 5) リスクフラグ（レビュー観点）
- **リスク1（中リスク）**：DataflowGraphTransformer.transformのトポロジカルソートロジック -- テストケースUT-PIP-100〜101の入力/期待結果は実装の概要に基づく推論。実際の内部処理フローとの整合性を確認すべき。
- **リスク0（低リスク）**：FlowProgressEventLoggerの各recordメソッド -- 全ステータス遷移に対するイベント記録のテストは網羅的だが、並行実行時のsynchronizedブロックの動作は統合テストで確認が望ましい。
- **リスク1（中リスク）**：GraphOperations.dfsInternalの停止条件（stopAtMaterializationPoints） -- テーブル/ビューの混在グラフでの探索範囲が正しいか、境界条件の追加テストを検討すべき。
- **リスク1（中リスク）**：FlowResolver.attemptResolveFlowのSQL設定衝突検出 -- 3つ以上の上流ビューが同一キーに異なる値を設定するケースの網羅性を確認すべき。

## 6) レビュアーチェックリスト（最小）
- [ ] UT-PIP-100〜101（DataflowGraphTransformer.transform）のテストケースが実装の実際の動作と整合しているか
- [ ] UT-PIP-141〜142（FlowState.transition）で全ての状態遷移パターンが網羅されているか
- [ ] UT-PIP-143〜144（GraphValidations.validate）で全ての検証ルールがカバーされているか
- [ ] UT-PIP-068〜070（SchemaMergingUtils.mergeSchemas）のスキーマ不一致ケースが実際のmergeロジックと整合しているか
- [ ] UT-PIP-102〜105（dfsInternal）の停止条件に関するテストケースの境界値が適切か
- [ ] UT-PIP-120〜123（FlowResolver.attemptResolveFlow）のリトライ可能/不可能の判定ロジックが正確か
- [ ] 全テストケースの対象ファイルパスが正しいか（モジュール名 sql-pipelines に対応する実パス）
