---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 32
  claims_with_evidence: 30
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：tools.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：30 / 32、根拠なし：2
- 優先レビュー（高）
  1. **C-11（UT-TOL-011）**：shouldExcludeに空文字列を渡した場合の挙動は実装から推測したものであり、明示的な仕様根拠なし
  2. **C-32（UT-TOL-032）**：標準出力へのメッセージ確認はコードから確認できるが、テスト実装の実行可能性は環境依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `tools/src/main/scala/org/apache/spark/tools/GenerateMIMAIgnore.scala` - GenerateMIMAIgnoreオブジェクト全体のソースコード（169行）
- E-02: `tools/src/main/scala/org/apache/spark/tools/GenerateMIMAIgnore.scala` L108-L121 - `getInnerFunctions`メソッド定義
- E-03: `tools/src/main/scala/org/apache/spark/tools/GenerateMIMAIgnore.scala` L146-L153 - `shouldExclude`メソッド定義
- E-04: `tools/src/main/scala/org/apache/spark/tools/GenerateMIMAIgnore.scala` L44-L45 - `isPackagePrivate`メソッド定義
- E-05: `tools/src/main/scala/org/apache/spark/tools/GenerateMIMAIgnore.scala` L47-L55 - `isPackagePrivateModule`メソッド定義
- E-06: `tools/src/main/scala/org/apache/spark/tools/GenerateMIMAIgnore.scala` L159-L167 - `getClasses`メソッド定義
- E-07: `tools/src/main/scala/org/apache/spark/tools/GenerateMIMAIgnore.scala` L123-L127 - `getAnnotatedOrPackagePrivateMembers`メソッド定義
- E-08: `tools/src/main/scala/org/apache/spark/tools/GenerateMIMAIgnore.scala` L62-L101 - `privateWithin`メソッド定義
- E-09: `tools/src/main/scala/org/apache/spark/tools/GenerateMIMAIgnore.scala` L129-L144 - `main`メソッド定義
- E-10: `tools/src/main/scala/org/apache/spark/tools/GenerateMIMAIgnore.scala` L29-L39 - クラスのScaladocコメント（ツールの目的説明）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | getInnerFunctionsが$$を含むメソッド名を返すこと | E-02 (L112: `.filter(_.contains("$$"))`) | ○ |
| C-02 | $$を含まないクラスで空Seqが返ること | E-02 (L112: filterにより該当なしなら空) | ○ |
| C-03 | Class.forName例外時に空Seqが返ること | E-02 (L114-L120: catch節でSeq.emptyを返却) | ○ |
| C-04 | メソッド0件クラスで空Seqが返ること | E-02 (L111: getMethodsが空配列ならfilter後も空) | ○ |
| C-05 | 'anon'を含む名前でtrueが返ること | E-03 (L148: `name.contains("anon")`) | ○ |
| C-06 | '$class'で終わる名前でtrueが返ること | E-03 (L149: `name.endsWith("$class")`) | ○ |
| C-07 | '$sp'を含む名前でtrueが返ること | E-03 (L150: `name.contains("$sp")`) | ○ |
| C-08 | 'hive'を含む名前でtrueが返ること | E-03 (L151: `name.contains("hive")`) | ○ |
| C-09 | 'Hive'を含む名前でtrueが返ること | E-03 (L152: `name.contains("Hive")`) | ○ |
| C-10 | 除外条件に該当しない名前でfalseが返ること | E-03 (L147-L153: いずれの条件にも該当しなければfalse) | ○ |
| C-11 | 空文字列でfalseが返ること | **根拠なし** | △ |
| C-12 | package-privateシンボルでtrueが返ること | E-04 (L45: `!sym.privateWithin.fullName.startsWith("<none>")`) | ○ |
| C-13 | publicシンボルでfalseが返ること | E-04 (L45: fullNameが"<none>"で始まればfalse) | ○ |
| C-14 | package-privateモジュールでtrueが返ること | E-05 (L48: `!moduleSymbol.privateWithin.fullName.startsWith("<none>")`) | ○ |
| C-15 | publicモジュールでfalseが返ること | E-05 (L48: fullNameが"<none>"で始まればfalse) | ○ |
| C-16 | isPackagePrivateModule例外時にfalseが返ること | E-05 (L49-L55: catch Throwable => false) | ○ |
| C-17 | 指定パッケージのクラスが取得されること | E-06 (L163: `.filter(_.startsWith(packageName))`) | ○ |
| C-18 | shouldExclude対象クラスが除外されること | E-06 (L165: `.filterNot(shouldExclude)`) | ○ |
| C-19 | 存在しないパッケージで空Setが返ること | E-06 (L163: filterにより該当なしなら空Set) | ○ |
| C-20 | package-privateメンバーが取得されること | E-07 (L124-L126: members.filter(isPackagePrivate)) | ○ |
| C-21 | java/scalaパッケージのメンバーが除外されること | E-07 (L125: `filterNot(x => x.fullName.startsWith("java") || x.fullName.startsWith("scala"))`) | ○ |
| C-22 | メンバー0件で空コレクションが返ること | E-07 (L124: filterNot/filterの結果が空なら空コレクション) | ○ |
| C-23 | privateWithinがpackage-privateクラスとメンバーのタプルを返すこと | E-08 (L62, L100: 戻り値の型`(Set[String], Set[String])`) | ○ |
| C-24 | クラス名の$が#に置換されたエントリも含まれること | E-08 (L100: `flatMap(c => Seq(c, c.replace("$", "#")))`) | ○ |
| C-25 | インナークラスが外部クラスのpackage-private判定を継承すること | E-08 (L79-L87: `indirectlyPrivateSpark`ロジック) | ○ |
| C-26 | Class.forName例外時にクラスがスキップされること | E-08 (L94-L98: catch Throwable => printlnしてループ継続) | ○ |
| C-27 | 該当クラス0件で空タプルが返ること | E-08 (L65-L66: 初期値が空のmutable.HashSet) | ○ |
| C-28 | .generated-mima-class-excludesファイルが生成されること | E-09 (L134-L135: `File(".generated-mima-class-excludes").writeAll(...)`) | ○ |
| C-29 | .generated-mima-member-excludesファイルが生成されること | E-09 (L140-L141: `File(".generated-mima-member-excludes").writeAll(...)`) | ○ |
| C-30 | 既存ファイルの内容に追記されること | E-09 (L132-L135: `previousContents + privateClasses.mkString(...)`) | ○ |
| C-31 | 既存ファイルがない場合でもTry/getOrElseで正常動作すること | E-09 (L132-L133: `Try(...).getOrElse(Iterator.empty)`) | ○ |
| C-32 | 完了メッセージが標準出力に出力されること | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-11（空文字列のshouldExclude）：実装コードの論理的推測によるもの。空文字列に対するcontains/endsWithはいずれもfalseを返すことはScala/Javaの仕様から明らかだが、GenerateMIMAIgnoreの設計意図として空文字列入力を想定しているかの明示的な記述がない
  - 候補：設計ドキュメント / テスト仕様書 / 要件定義書
- C-32（標準出力メッセージ）：コード上のprintln文（L137, L142）から確認できるが、テストとしてキャプチャする実装方法が環境依存であり、テストの実行可能性に関する根拠が不足
  - 候補：テスト戦略書 / CI環境設定 / 標準出力キャプチャライブラリの有無確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - toolsモジュールは開発用ユーティリティ（MIMA互換性チェック用のexclusion生成ツール）であり、本番ランタイムには影響しない
- 0: 低リスク - 単一ファイル（1クラス）のモジュールであり、コード範囲が限定的で全メソッドをカバー可能
- 1: 中リスク - privateメソッドのテストにはリフレクションまたはテスト用アクセスパターンが必要。Scalaではコンパニオンオブジェクト経由でのテストが一般的だが、objectのprivateメソッドはテスト設計上の工夫が必要
- 1: 中リスク - scala reflectionおよびClassFinderライブラリへの依存があり、テスト時のクラスパス設定が重要

## 6) レビュアーチェックリスト（最小）
- [ ] shouldExcludeの各条件（anon, $class, $sp, hive, Hive）に対するテストケースが網羅されているか
- [ ] privateメソッド（isPackagePrivate, shouldExclude, getClasses等）のテスト実現方法が適切か（リフレクション or テストアクセスパターン）
- [ ] mainメソッドのファイル出力テストにおける一時ディレクトリの使用・クリーンアップが考慮されているか
- [ ] scala reflectionに依存するテストケース（isPackagePrivate, privateWithin等）のモック戦略が適切か
- [ ] ClassFinderライブラリ依存のgetClassesメソッドのテストにおけるクラスパス設定が明確か
