---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 50
  claims_with_evidence: 44
  claims_without_evidence: 6
confidence_derived: 0.88
---

# 根拠レポート：受入テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：44 / 50、根拠なし：6
- 優先レビュー（高）
  1. **UAT-043（大規模データ処理性能）**：具体的な性能基準値の根拠不足
  2. **UAT-041（Spark Pipelines）**：Spark Pipelinesは比較的新しい機能で詳細仕様の確認が必要
  3. **UAT-050（マルチ言語サポート）**：R言語はREADMEでDeprecatedと記載あり。テストケースの適切性要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `README.md` - プロジェクト概要、対応言語（Scala, Java, Python, R（Deprecated））、主要モジュール（Spark SQL, MLlib, GraphX, Structured Streaming）
- E-02: `bin/spark-submit` - spark-submitスクリプトの存在確認
- E-03: `bin/spark-shell` - spark-shellスクリプトの存在確認
- E-04: `bin/pyspark` - pysparkスクリプトの存在確認
- E-05: `bin/spark-sql` - spark-sqlスクリプトの存在確認
- E-06: `bin/beeline` - beelineスクリプトの存在確認
- E-07: `bin/spark-connect-shell` - spark-connect-shellスクリプトの存在確認
- E-08: `bin/spark-pipelines` - spark-pipelinesスクリプトの存在確認
- E-09: `bin/docker-image-tool.sh` - Dockerイメージ作成スクリプトの存在確認
- E-10: `core/src/main/scala/org/apache/spark/SparkContext.scala` - SparkContext主クラス（broadcastメソッド、accumulatorメソッド等を含む）
- E-11: `core/src/main/scala/org/apache/spark/deploy/SparkSubmit.scala` - SparkSubmitAction列挙（SUBMIT, KILL, REQUEST_STATUS, PRINT_VERSION）
- E-12: `core/src/main/scala/org/apache/spark/deploy/master/Master.scala` - Master、Worker管理、アプリケーションスケジューリング
- E-13: `core/src/main/scala/org/apache/spark/ui/SparkUI.scala` - SparkUI（WebUI、killEnabled設定、タブ構成：JobsTab, StagesTab, StorageTab, EnvironmentTab, ExecutorsTab）
- E-14: `core/src/main/scala/org/apache/spark/ui/jobs/AllJobsPage.scala` - ジョブ一覧ページ（618行）
- E-15: `core/src/main/scala/org/apache/spark/ui/jobs/StagePage.scala` - ステージ詳細ページ
- E-16: `core/src/main/scala/org/apache/spark/ui/storage/StoragePage.scala` - ストレージページ
- E-17: `core/src/main/scala/org/apache/spark/ui/env/EnvironmentPage.scala` - 環境情報ページ
- E-18: `core/src/main/scala/org/apache/spark/ui/exec/ExecutorsTab.scala` - Executorタブ
- E-19: `core/src/main/scala/org/apache/spark/deploy/master/ui/MasterPage.scala` - MasterWebUIページ
- E-20: `core/src/main/scala/org/apache/spark/deploy/master/ui/ApplicationPage.scala` - アプリケーション詳細ページ
- E-21: `core/src/main/scala/org/apache/spark/deploy/history/HistoryServer.scala` - History Server
- E-22: `core/src/main/scala/org/apache/spark/deploy/history/FsHistoryProvider.scala` - ファイルシステムベースHistory Provider
- E-23: `core/src/main/scala/org/apache/spark/SecurityManager.scala` - 認証・ACL（authOn, aclsOn, viewAcls, modifyAcls, adminAcls）
- E-24: `core/src/main/scala/org/apache/spark/ExecutorAllocationManager.scala` - 動的リソース割当
- E-25: `sql/core/` - Spark SQL コアモジュール
- E-26: `sql/core/src/main/scala/org/apache/spark/sql/sources/` - データソースAPI
- E-27: `sql/core/src/main/scala/org/apache/spark/sql/jdbc/` - JDBCデータソース
- E-28: `sql/core/src/main/scala/org/apache/spark/sql/streaming/` - Structured Streaming
- E-29: `sql/hive-thriftserver/` - Hive ThriftServer（HiveThriftServer2.scala等）
- E-30: `sql/connect/` - Spark Connect（server, client, common, shims）
- E-31: `mllib/src/main/scala/org/apache/spark/ml/Pipeline.scala` - ML Pipeline（Estimator, Transformer, Model）
- E-32: `graphx/` - GraphXモジュール
- E-33: `streaming/src/main/scala/org/apache/spark/streaming/` - Spark Streaming（StreamingContext, Checkpoint等）
- E-34: `connector/kafka-0-10-sql/` - Kafkaコネクタ
- E-35: `resource-managers/yarn/` - YARN対応
- E-36: `resource-managers/kubernetes/` - Kubernetes対応
- E-37: `core/src/main/scala/org/apache/spark/deploy/master/ZooKeeperLeaderElectionAgent.scala` - ZooKeeperベースMaster HA
- E-38: `core/src/main/scala/org/apache/spark/deploy/master/RecoveryModeFactory.scala` - リカバリモード
- E-39: `core/src/main/scala/org/apache/spark/deploy/history/EventLogFileWriters.scala` - イベントログ書き込み
- E-40: `core/src/main/scala/org/apache/spark/deploy/SparkSubmitArguments.scala` - spark-submit引数パース
- E-41: `sql/pipelines/` - Spark Pipelinesモジュール
- E-42: `core/src/main/scala/org/apache/spark/deploy/SparkPipelines.scala` - Spark Pipelinesエントリーポイント
- E-43: `python/pyspark/` - PySpark
- E-44: `python/pyspark/pandas/` - PySpark pandas API

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ローカルモードでアプリケーション実行可能（UAT-001） | E-02, E-11 | ○ |
| C-02 | Standaloneクラスタモードでアプリケーション投入可能（UAT-002） | E-02, E-11, E-12 | ○ |
| C-03 | 不正クラス名指定時のエラー処理（UAT-003） | E-11 | ○ |
| C-04 | spark-shellでScalaコード対話実行可能（UAT-004） | E-03, E-10 | ○ |
| C-05 | spark-shellでDataFrame操作可能（UAT-005） | E-03, E-25 | ○ |
| C-06 | pysparkシェルでPythonコード実行可能（UAT-006） | E-04, E-43 | ○ |
| C-07 | PySpark pandas APIが利用可能（UAT-007） | E-43, E-44 | ○ |
| C-08 | spark-sqlでSQLクエリ実行可能（UAT-008） | E-05, E-25 | ○ |
| C-09 | 不正SQLクエリのエラー処理（UAT-009） | E-05, E-25 | ○ |
| C-10 | Web UIでジョブ一覧表示（UAT-010） | E-13, E-14 | ○ |
| C-11 | Web UIでステージ詳細表示（UAT-011） | E-13, E-15 | ○ |
| C-12 | Web UIでストレージ情報表示（UAT-012） | E-13, E-16 | ○ |
| C-13 | Web UIで環境情報表示（UAT-013） | E-13, E-17 | ○ |
| C-14 | Web UIでExecutor情報表示（UAT-014） | E-13, E-18 | ○ |
| C-15 | Master Web UIでクラスタ状態確認（UAT-015） | E-19 | ○ |
| C-16 | Master Web UIでアプリケーション詳細表示（UAT-016） | E-20 | ○ |
| C-17 | History Serverで完了済みアプリケーションUI確認（UAT-017） | E-21, E-22 | ○ |
| C-18 | CSV/JSON/Parquetファイル読み込み（UAT-018） | E-26 | ○ |
| C-19 | CSV/JSON/Parquet形式書き出し（UAT-019） | E-25 | ○ |
| C-20 | JDBCデータソース読み込み（UAT-020） | E-27 | ○ |
| C-21 | ファイルソースのストリーミング処理（UAT-021） | E-28 | ○ |
| C-22 | ストリーミングクエリの停止・再開（UAT-022） | E-28 | ○ |
| C-23 | ML Pipeline構築と学習・予測（UAT-023） | E-31 | ○ |
| C-24 | 学習済みモデルの保存・読み込み（UAT-024） | E-31 | ○ |
| C-25 | Kafkaストリーミングデータ読み込み（UAT-025） | E-34 | ○ |
| C-26 | Worker登録とリソース割当（UAT-026） | E-12 | ○ |
| C-27 | Executor割当の適切性（UAT-027） | E-12 | ○ |
| C-28 | Dynamic AllocationによるExecutor自動調整（UAT-028） | E-24 | ○ |
| C-29 | ACL有効時のアクセス制御（UAT-029） | E-23 | ○ |
| C-30 | ジョブkillの権限制御（UAT-030） | E-23 | ○ |
| C-31 | アプリケーションkill操作（UAT-031） | E-13, E-11 | ○ |
| C-32 | spark-submit設定オプション反映（UAT-032） | E-40 | ○ |
| C-33 | ThriftServer経由JDBC接続（UAT-033） | E-29 | ○ |
| C-34 | Spark Connect接続（UAT-034） | E-30 | ○ |
| C-35 | YARN上でのアプリケーション実行（UAT-035） | E-35 | ○ |
| C-36 | Kubernetes上でのアプリケーション実行（UAT-036） | E-36 | ○ |
| C-37 | ブロードキャスト変数配信（UAT-037） | E-10 | ○ |
| C-38 | アキュムレータ集計（UAT-038） | E-10 | ○ |
| C-39 | チェックポイント保存（UAT-039） | E-33 | ○ |
| C-40 | GraphXグラフ処理（UAT-040） | E-32 | ○ |
| C-41 | Spark Pipelines実行（UAT-041） | E-41, E-42 | △ |
| C-42 | イベントログ記録（UAT-042） | E-39 | ○ |
| C-43 | 大規模データ処理性能（UAT-043） | **根拠なし** | △ |
| C-44 | Worker障害時タスク再実行（UAT-044） | E-12 | ○ |
| C-45 | Master HA構成の障害復旧（UAT-045） | E-37, E-38 | ○ |
| C-46 | テーブル作成・挿入・クエリ・削除（UAT-046） | E-25 | ○ |
| C-47 | ウィンドウ関数の動作（UAT-047） | E-25 | ○ |
| C-48 | Docker イメージ作成（UAT-048） | E-09 | ○ |
| C-49 | Spark Connect Shell操作（UAT-049） | E-07, E-30 | △ |
| C-50 | マルチ言語サポート（UAT-050） | E-01, E-43 | △ |

## 4) 不足情報（Unknown / Missing）
- **UAT-041（Spark Pipelines）**: Spark Pipelinesは比較的新しい機能であり、`sql/pipelines/`配下のコードおよび`deploy/SparkPipelines.scala`の存在は確認済みだが、詳細な仕様書・テストケース定義の根拠が不十分
  - 候補：Spark Pipelines公式ドキュメント / JIRA / 設計仕様書
- **UAT-043（大規模データ処理性能）**: 具体的なパフォーマンス基準値（処理時間閾値等）がソースコードからは導出できない。性能要件はクラスタ構成に依存する
  - 候補：性能要件定義書 / ベンチマーク結果 / SLA定義
- **UAT-049（Spark Connect Shell）**: `bin/spark-connect-shell`スクリプトの存在は確認済みだが、Spark Connect Shellの詳細な操作仕様の確認が不十分
  - 候補：Spark Connect Shell公式ドキュメント / テストコード
- **UAT-050（マルチ言語サポート）**: R言語がREADME.mdで「Deprecated」と記載されているため、R言語のテストケースの適切性に要注意。Java APIのテスト手順も詳細化が必要
  - 候補：R言語廃止スケジュール / Java API サンプルコード
- **UAT-007（PySpark pandas API）**: pandas APIディレクトリは確認済みだが、pandasバージョン互換性の詳細確認が不十分
  - 候補：pandas互換性マトリクス / pyproject.toml依存関係
- **UAT-024（モデル保存・読み込み）**: Pipeline.scalaの存在は確認済みだが、ReadWrite.scalaの個別確認は未実施
  - 候補：ml/util/ReadWrite.scala

## 5) リスクフラグ（レビュー観点）
- **リスク2（高）**: UAT-043 - 性能基準値が未定義。受入テストとして合否判定基準が曖昧
- **リスク1（中）**: UAT-050 - R言語Deprecated表記との整合性。テストケースからR言語を除外するか要検討
- **リスク1（中）**: UAT-041 - Spark Pipelinesの成熟度が不明。テスト実施可否の事前確認が必要
- **リスク1（中）**: UAT-045 - Master HA構成テストはインフラ構築を伴うため、テスト環境の準備コストが高い
- **リスク0（低）**: UAT-048 - Docker環境への依存。CI/CD環境では実行できない可能性

## 6) レビュアーチェックリスト（最小）
- [ ] UAT-043の性能基準値を定義し、合否判定基準を明確化する
- [ ] UAT-050のR言語テストケースについて、Deprecated表記との整合性を確認し、除外するか判断する
- [ ] UAT-041のSpark Pipelinesについて、対象バージョンで利用可能か確認する
- [ ] 各テストケースの前提条件が実際のテスト環境で満たせるか確認する（特にYARN/Kubernetes/ZooKeeper等の外部依存）
- [ ] テスト手順の具体的なコマンド・パラメータがプロジェクトのバージョンと整合しているか確認する
- [ ] セキュリティ関連テスト（UAT-029, UAT-030）の認証方式がプロジェクトの要件と合致しているか確認する
- [ ] ストリーミング関連テスト（UAT-021, UAT-022, UAT-025）のタイムアウト設定・テスト終了条件を明確化する
