# 帳票設計書 14-AllStagesPage

## 概要

本ドキュメントは、Apache Spark Web UI の「Stages」タブにおける全ステージ一覧ページ（AllStagesPage）の帳票設計書である。全ジョブにわたるステージの状態（Active/Pending/Complete/Skipped/Failed）を一覧表示し、Fair Scheduler 使用時にはプール情報も表示するレポートページを定義する。

### 本帳票の処理概要

**業務上の目的・背景**：Spark アプリケーション全体のステージ実行状況を横断的に把握するために必要な帳票である。ジョブ単位ではなくステージ単位で進捗を確認でき、特に Fair Scheduler を使用している環境では、スケジューリングプールごとのリソース配分状況を確認できる。パフォーマンス問題が発生している際に、どのステージに時間がかかっているかを全体俯瞰で把握する場面で利用される。

**帳票の利用シーン**：アプリケーション実行中にステージレベルでの進捗を監視する場面、Fair Scheduler のプール構成を確認する場面、失敗したステージを特定する場面、History Server で過去の実行結果を確認する場面で利用される。

**主要な出力内容**：
1. ステージ状態サマリー（Active/Pending/Complete/Skipped/Failed の件数）
2. Fair Scheduler Pools テーブル（Fair Scheduler 使用時のみ）
3. Active Stages テーブル
4. Pending Stages テーブル
5. Completed Stages テーブル
6. Skipped Stages テーブル
7. Failed Stages テーブル

**帳票の出力タイミング**：Spark Web UI の「Stages」タブにアクセスした際に動的にレンダリングされる。

**帳票の利用者**：アプリケーション開発者、データエンジニア、クラスタ管理者

## 帳票種別

Web UI レポートページ（HTML形式一覧表）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| 14 | Stages for All Jobs | `http://{host}:4040/stages/` | ブラウザからアクセス |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | HTML（動的レンダリング） |
| 用紙サイズ | 該当なし（ブラウザ表示） |
| 向き | 該当なし |
| ファイル名 | 該当なし（HTTP レスポンス） |
| 出力方法 | Spark Web UI からのブラウザ表示 |
| 文字コード | UTF-8 |

### PDF固有設定

該当なし

### Excel固有設定

該当なし

## 帳票レイアウト

### レイアウト概要

ページ上部にステージ状態サマリー、Fair Scheduler 使用時にはプールテーブル、その下に各状態別のステージテーブルを表示する。

```
┌─────────────────────────────────────┐
│  ページヘッダー (Stages for All Jobs) │
├─────────────────────────────────────┤
│  ステージ状態サマリー                  │
│  - Active / Pending / Complete / ... │
├─────────────────────────────────────┤
│  Fair Scheduler Pools テーブル        │
│  （Fair Scheduler 使用時のみ）         │
├─────────────────────────────────────┤
│  Active Stages テーブル               │
├─────────────────────────────────────┤
│  Pending Stages テーブル              │
├─────────────────────────────────────┤
│  Completed Stages テーブル            │
├─────────────────────────────────────┤
│  Skipped Stages テーブル              │
├─────────────────────────────────────┤
│  Failed Stages テーブル               │
└─────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Active Stages | アクティブステージ数 | ACTIVE ステータスのステージ数 | 整数（リンク付き） |
| 2 | Pending Stages | 保留中ステージ数 | PENDING ステータスのステージ数 | 整数（リンク付き） |
| 3 | Completed Stages | 完了ステージ数 | COMPLETE ステータスのステージ数 | 整数（リンク付き） |
| 4 | Skipped Stages | スキップステージ数 | SKIPPED ステータスのステージ数 | 整数（リンク付き） |
| 5 | Failed Stages | 失敗ステージ数 | FAILED ステータスのステージ数 | 整数（リンク付き） |

### 明細部

StageTableBase を使用したステージテーブル。

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Stage Id | ステージ識別子 | stageData.stageId | 整数 | 自動 |
| 2 | Description | ステージ説明 | stageData.description | テキスト | 自動 |
| 3 | Submitted | 送信日時 | stageData.submissionTime | 日時 | 自動 |
| 4 | Duration | 実行時間 | completionTime - submissionTime | 時間 | 自動 |
| 5 | Tasks | タスク進捗 | numCompleteTasks / numTasks | プログレスバー | 自動 |
| 6 | Input | 入力サイズ | inputBytes | バイト表示 | 自動 |
| 7 | Output | 出力サイズ | outputBytes | バイト表示 | 自動 |
| 8 | Shuffle Read | シャッフル読み取り | shuffleReadBytes | バイト表示 | 自動 |
| 9 | Shuffle Write | シャッフル書き込み | shuffleWriteBytes | バイト表示 | 自動 |

### フッター部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| - | 該当なし | ページフッターはSparkUI共通フッター | - | - |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| ステージ状態フィルタ | ACTIVE/PENDING/COMPLETE/SKIPPED/FAILED の5状態で分類 | Yes（自動） |
| Fair Scheduler 判定 | parent.isFairScheduler でプール情報表示を判定 | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | Failed Stages のみ逆順（最新の失敗が先頭） | 降順 |
| 2 | その他のステータスは store.stageList の返却順 | 昇順 |

### 改ページ条件

StageTableBase のページネーション機能を使用。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| AppStatusStore (KVStore) | ステージ情報の取得 | ステータスフィルタ |

### テーブル別参照項目詳細

#### AppStatusStore

| 参照項目（メソッド） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| stageList(null) | 全ステージデータ | ステータスフィルタなし | StageData のリスト |
| appSummary() | 完了ステージ数 | なし | numCompletedStages |
| pool(poolName) | プール情報 | プール名指定 | PoolData |
| sc.getAllPools | スケジューリングプール一覧 | なし | Schedulable のリスト（Live UIのみ） |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| 完了ステージ表示文字列 | numCompletedStages != size の場合 "X, only showing Y" | なし | 表示制限時のメッセージ |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[HTTP GET /stages/] --> B[AllStagesPage.render]
    B --> C[store.stageList で全ステージ取得]
    C --> D[store.appSummary 取得]
    D --> E{Fair Scheduler?}
    E -->|Yes| F[getAllPools でプール一覧取得]
    E -->|No| G[プール情報スキップ]
    F --> H[PoolTable 生成]
    G --> I[5ステータス分の summaryAndTableForStatus 実行]
    H --> I
    I --> J[各状態別テーブルとサマリー生成]
    J --> K[HTML レスポンス構成]
    K --> L[UIUtils.headerSparkPage]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | 特定ステータスのステージが0件 | テーブルとサマリーが非表示 | 正常動作（該当セクションを表示しない） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数百〜数千ステージ |
| 目標出力時間 | 1秒以内 |
| 同時出力数上限 | Web UI 同時接続数に依存 |

## セキュリティ考慮事項

- Active ステージのキル機能は killEnabled フラグと securityManager で制御される
- ステージ名はHTMLエスケープ処理される

## 備考

- プール情報は Live UI でのみ利用可能（sc.map(_.getAllPools) が Some の場合のみ）
- Failed Stages は逆順で表示される（最新の失敗が先頭、行85-86）
- 完了ステージ数が appSummary.numCompletedStages と異なる場合、"only showing" メッセージが表示される（行118-120）

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ステージデータとプールデータの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | v1/api.scala | `core/src/main/scala/org/apache/spark/status/api/v1/api.scala` | StageData, StageStatus の定義 |
| 1-2 | PoolData.scala | `core/src/main/scala/org/apache/spark/status/PoolData.scala` | PoolData の定義（poolName, stageIds） |

#### Step 2: エントリーポイントを理解する

AllStagesPage.render メソッドの処理フローを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AllStagesPage.scala | `core/src/main/scala/org/apache/spark/ui/jobs/AllStagesPage.scala` | render メソッド（行34-77）全体の流れ |

**主要処理フロー**:
1. **行36-40**: プール情報取得（Live UIのみ、getAllPools + store.pool）
2. **行43-44**: 全ステータス定義（ACTIVE, PENDING, COMPLETE, SKIPPED, FAILED）
3. **行46-47**: store.stageList(null) で全ステージ取得、store.appSummary() でサマリー取得
4. **行49-50**: 各ステータスに対して summaryAndTableForStatus を実行
5. **行59-72**: Fair Scheduler 判定とプールテーブル表示

#### Step 3: ステータス別テーブル生成を理解する

summaryAndTableForStatus メソッドによるステータス別テーブル生成ロジック。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AllStagesPage.scala | `core/src/main/scala/org/apache/spark/ui/jobs/AllStagesPage.scala` | summaryAndTableForStatus（行79-103）、Failed のみ reverse 処理（行85） |

### プログラム呼び出し階層図

```
HttpServletRequest
    |
    +-- AllStagesPage.render()
            |
            +-- sc.getAllPools  [Live UIのみ]
            +-- store.pool(poolName)
            +-- PoolTable
            |
            +-- store.stageList(null)
            +-- store.appSummary()
            |
            +-- summaryAndTableForStatus() [x5 ステータス]
                  +-- StageTableBase
                  +-- summary()
                  +-- table()
```

### データフロー図

```
[入力]                       [処理]                              [出力]

HTTP GET /stages/    ──▶  AllStagesPage.render()           ──▶  HTML レスポンス
                            |
AppStatusStore       ──▶  stageList / appSummary           ──▶  サマリーセクション
                            |
SparkContext         ──▶  getAllPools (Live UI)             ──▶  プールテーブル
                            |
                          summaryAndTableForStatus          ──▶  ステージテーブル(5種)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AllStagesPage.scala | `core/src/main/scala/org/apache/spark/ui/jobs/AllStagesPage.scala` | ソース | 全ステージ一覧ページの描画 |
| StagesTab.scala | `core/src/main/scala/org/apache/spark/ui/jobs/StagesTab.scala` | ソース | Stages タブの定義 |
| StageTableBase.scala | `core/src/main/scala/org/apache/spark/ui/jobs/StageTableBase.scala` | ソース | ステージテーブル共通コンポーネント |
| PoolTable.scala | `core/src/main/scala/org/apache/spark/ui/jobs/PoolTable.scala` | ソース | プール一覧テーブル |
| AppStatusStore.scala | `core/src/main/scala/org/apache/spark/status/AppStatusStore.scala` | ソース | データストアアクセス |
