# 帳票設計書 16-PoolPage

## 概要

本ドキュメントは、Apache Spark Web UI のスケジューリングプール詳細ページ（PoolPage）の帳票設計書である。Fair Scheduler 使用時に、特定のスケジューリングプールの設定情報とそのプールに属するアクティブステージの一覧をHTML形式で表示するレポートページを定義する。

### 本帳票の処理概要

**業務上の目的・背景**：Fair Scheduler を使用している Spark アプリケーションにおいて、各スケジューリングプールのリソース配分設定と、そのプール内で実行中のステージの状況を確認するために必要な帳票である。複数のジョブが同時実行される環境でのリソース配分の最適化やスケジューリング問題の調査に活用される。

**帳票の利用シーン**：AllStagesPage の Fair Scheduler Pools テーブルからプール名をクリックして遷移する場面、特定プールのリソース設定を確認する場面、プール内のアクティブステージの進捗を確認する場面で利用される。

**主要な出力内容**：
1. プールサマリーテーブル（プールの設定情報）
2. Active Stages テーブル（プールに属するアクティブステージの一覧）

**帳票の出力タイミング**：Spark Web UI で `/stages/pool/?poolname={poolName}` にアクセスした際に動的にレンダリングされる。Fair Scheduler 使用時のみ有効。

**帳票の利用者**：クラスタ管理者、データエンジニア、アプリケーション開発者

## 帳票種別

Web UI レポートページ（HTML形式詳細表示）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| 16 | Fair Scheduler Pool | `http://{host}:4040/stages/pool/?poolname={poolName}` | AllStagesPage のプール名リンクをクリック |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | HTML（動的レンダリング） |
| 用紙サイズ | 該当なし（ブラウザ表示） |
| 向き | 該当なし |
| ファイル名 | 該当なし（HTTP レスポンス） |
| 出力方法 | Spark Web UI からのブラウザ表示 |
| 文字コード | UTF-8 |

### PDF固有設定

該当なし

### Excel固有設定

該当なし

## 帳票レイアウト

### レイアウト概要

```
┌──────────────────────────────────────────┐
│  ページヘッダー                             │
│  (Fair Scheduler Pool: {poolName})        │
├──────────────────────────────────────────┤
│  Summary                                  │
│  プールサマリーテーブル（PoolTable）          │
├──────────────────────────────────────────┤
│  Active Stages テーブル（折りたたみ可能）     │
│  （StageTableBase）                        │
└──────────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Pool Name | プール名 | poolname パラメータ | 文字列 |

### 明細部

プールサマリーテーブル（PoolTable）の項目。

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Pool Name | プール名 | Schedulable.name | 文字列 | 自動 |
| 2 | Minimum Share | 最小リソース割り当て | Schedulable.minShare | 整数 | 自動 |
| 3 | Pool Weight | プールの重み | Schedulable.weight | 整数 | 自動 |
| 4 | Active Stages | アクティブステージ数 | uiPool.stageIds.size | 整数 | 自動 |
| 5 | Running Tasks | 実行中タスク数 | アクティブステージの合計 | 整数 | 自動 |
| 6 | SchedulingMode | スケジューリングモード | Schedulable.schedulingMode | FIFO/FAIR | 自動 |

### フッター部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| - | 該当なし | ページフッターはSparkUI共通フッター | - | - |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| poolname パラメータ | プール名（URLパラメータ） | Yes |
| Fair Scheduler | スケジューリングモードが FAIR であること | Yes（前提条件） |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | ステージID（StageTableBase デフォルト） | 昇順 |

### 改ページ条件

StageTableBase のページネーション機能を使用。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| AppStatusStore (KVStore) | プール・ステージ情報の取得 | poolName, stageId |

### テーブル別参照項目詳細

#### AppStatusStore / SparkContext

| 参照項目（メソッド） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| sc.getPoolForName(poolName) | プール情報（Schedulable） | poolName | Live UI のみ |
| store.pool(poolName) | プールデータ（PoolData） | poolName | stageIds 含む |
| store.lastStageAttempt(stageId) | アクティブステージデータ | stageId（PoolData.stageIdsから） | StageData |

## 計算仕様

### 計算項目一覧

該当なし（表示データは全てデータストアからの取得値）。

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[HTTP GET /stages/pool/?poolname=X] --> B[PoolPage.render]
    B --> C[poolname パラメータ取得・デコード]
    C --> D[sc.getPoolForName でプール取得]
    D --> E{プール存在?}
    E -->|No| F[IllegalArgumentException]
    E -->|Yes| G[store.pool でプールデータ取得]
    G --> H[uiPool.stageIds からアクティブステージ取得]
    H --> I[PoolTable 生成]
    I --> J[StageTableBase でアクティブステージテーブル生成]
    J --> K[HTML レスポンス構成]
    K --> L[UIUtils.headerSparkPage]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| パラメータ不足 | poolname パラメータが null | "Missing poolname parameter" | 正しいURLでアクセス |
| プール未発見 | 指定プール名が存在しない | "Unknown pool: {poolName}" | 正しいプール名を確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1プールあたり数個〜数十のアクティブステージ |
| 目標出力時間 | 1秒以内 |
| 同時出力数上限 | Web UI 同時接続数に依存 |

## セキュリティ考慮事項

- poolname パラメータは UIUtils.decodeURLParameter でデコードされる（URLエンコード対応）
- ステージキル機能は killEnabled フラグで制御される

## 備考

- プール情報は Live UI でのみ利用可能（History Server では利用不可）
- store.pool が存在しない場合はデフォルトの PoolData（空の stageIds セット）が使用される（行42-43）
- サブパスは "stages/pool" で StageTableBase に渡される（行47）

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Schedulable.scala | `core/src/main/scala/org/apache/spark/scheduler/Schedulable.scala` | Schedulable トレイトの定義（name, weight, minShare, schedulingMode） |
| 1-2 | PoolData.scala | `core/src/main/scala/org/apache/spark/status/PoolData.scala` | PoolData（poolName, stageIds）の定義 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | PoolPage.scala | `core/src/main/scala/org/apache/spark/ui/jobs/PoolPage.scala` | render メソッド（行30-67）全体。コンパクトなロジック |

**主要処理フロー**:
1. **行31-35**: poolname パラメータの取得とデコード
2. **行38-40**: sc.getPoolForName でプール情報を取得（存在しない場合は例外）
3. **行42-43**: store.pool でプールデータ取得（デフォルト値フォールバック）
4. **行44**: uiPool.stageIds から各ステージの最新試行データを取得
5. **行45-47**: StageTableBase でアクティブステージテーブル生成
6. **行49-64**: PoolTable + StageTableBase の HTML 構成

### プログラム呼び出し階層図

```
HttpServletRequest (?poolname=X)
    |
    +-- PoolPage.render()
            |
            +-- UIUtils.decodeURLParameter(poolname)
            +-- sc.getPoolForName(poolName)
            +-- store.pool(poolName)
            +-- uiPool.stageIds.map(store.lastStageAttempt)
            |
            +-- PoolTable
            +-- StageTableBase
```

### データフロー図

```
[入力]                          [処理]                           [出力]

HTTP GET /stages/pool/   ──▶  PoolPage.render()            ──▶  HTML レスポンス
  ?poolname=X                    |
                               sc.getPoolForName             ──▶  プールサマリーテーブル
                               store.pool                    ──▶  PoolData
                               store.lastStageAttempt        ──▶  アクティブステージテーブル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| PoolPage.scala | `core/src/main/scala/org/apache/spark/ui/jobs/PoolPage.scala` | ソース | プール詳細ページの描画 |
| PoolTable.scala | `core/src/main/scala/org/apache/spark/ui/jobs/PoolTable.scala` | ソース | プール情報テーブル |
| StagesTab.scala | `core/src/main/scala/org/apache/spark/ui/jobs/StagesTab.scala` | ソース | Stages タブの定義（行41でアタッチ） |
| StageTableBase.scala | `core/src/main/scala/org/apache/spark/ui/jobs/StageTableBase.scala` | ソース | ステージテーブル共通コンポーネント |
| Schedulable.scala | `core/src/main/scala/org/apache/spark/scheduler/Schedulable.scala` | ソース | スケジューリングプールのインターフェース |
