# 帳票設計書 17-StoragePage

## 概要

本ドキュメントは、Apache Spark Web UI の「Storage」タブにおけるRDDストレージ一覧ページ（StoragePage）の帳票設計書である。現在クラスタに永続化（persist/cache）されている全RDDの一覧と、DStreamストリーミングのレシーバーブロック情報をHTML形式で表示するレポートページを定義する。

### 本帳票の処理概要

**業務上の目的・背景**：Spark アプリケーションにおけるRDDのキャッシュ状況を把握し、メモリ使用量の最適化やストレージレベルの適切性を確認するために必要な帳票である。不要にキャッシュされたRDDの特定や、メモリ不足の原因調査に活用される。DStream利用時にはレシーバーブロックの分散状況も確認できる。

**帳票の利用シーン**：アプリケーション実行中にキャッシュされたRDDのメモリ/ディスク使用量を確認する場面、persist() の効果を検証する場面、DStream レシーバーブロックの分散状況を確認する場面で利用される。

**主要な出力内容**：
1. RDD一覧テーブル（ID、名前、ストレージレベル、キャッシュパーティション数、メモリ/ディスク使用量）
2. Receiver Blocks セクション（DStream使用時のみ）
   - Executor別ブロック集計テーブル
   - ブロック一覧テーブル

**帳票の出力タイミング**：Spark Web UI の「Storage」タブにアクセスした際に動的にレンダリングされる。

**帳票の利用者**：アプリケーション開発者、データエンジニア、クラスタ管理者

## 帳票種別

Web UI レポートページ（HTML形式一覧表）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| 17 | Storage | `http://{host}:4040/storage/` | ブラウザからアクセス |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | HTML（動的レンダリング） |
| 用紙サイズ | 該当なし（ブラウザ表示） |
| 向き | 該当なし |
| ファイル名 | 該当なし（HTTP レスポンス） |
| 出力方法 | Spark Web UI からのブラウザ表示 |
| 文字コード | UTF-8 |

### PDF固有設定

該当なし

### Excel固有設定

該当なし

## 帳票レイアウト

### レイアウト概要

```
┌─────────────────────────────────────┐
│  ページヘッダー (Storage)             │
├─────────────────────────────────────┤
│  RDDs テーブル（折りたたみ可能）       │
│  - ID / RDD Name / Storage Level     │
│  - Cached Partitions / Fraction      │
│  - Size in Memory / Size on Disk     │
├─────────────────────────────────────┤
│  Receiver Blocks（DStream使用時のみ） │
│  ├── Executor別集計テーブル           │
│  └── ブロック一覧テーブル             │
└─────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| - | 該当なし | ページレベルのサマリーヘッダーなし | - | - |

### 明細部（RDDテーブル）

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | ID | RDD識別子 | rdd.id | 整数 | 自動 |
| 2 | RDD Name | RDD名称 | rdd.name | リンク付き文字列 | 自動 |
| 3 | Storage Level | ストレージレベル | rdd.storageLevel | 文字列 | 自動 |
| 4 | Cached Partitions | キャッシュ済みパーティション数 | rdd.numCachedPartitions | 整数 | 自動 |
| 5 | Fraction Cached | キャッシュ割合 | numCachedPartitions / numPartitions * 100 | パーセント（小数2桁） | 自動 |
| 6 | Size in Memory | メモリ使用量 | rdd.memoryUsed | バイト表示 | 自動 |
| 7 | Size on Disk | ディスク使用量 | rdd.diskUsed | バイト表示 | 自動 |

### 明細部（Executor別ブロック集計テーブル）

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Executor ID | Executor識別子 | blocks.head.executorId | 文字列 | 自動 |
| 2 | Address | ホスト:ポート | blocks.head.hostPort | 文字列 | 自動 |
| 3 | Total Size in Memory | メモリ合計サイズ | blocks.map(_.memSize).sum | バイト表示 | 自動 |
| 4 | Total Size on Disk | ディスク合計サイズ | blocks.map(_.diskSize).sum | バイト表示 | 自動 |
| 5 | Stream Blocks | ストリームブロック数 | blocks.size | 整数 | 自動 |

### 明細部（ブロック一覧テーブル）

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Block ID | ブロック識別子 | block.name | 文字列 | 自動 |
| 2 | Replication Level | レプリケーション数 | replications.size | 整数 | 自動 |
| 3 | Location | ブロック配置先 | block.hostPort | 文字列 | 自動 |
| 4 | Storage Level | ストレージレベル | Disk/Memory/Memory Serialized | 文字列 | 自動 |
| 5 | Size | ブロックサイズ | memSize または diskSize | バイト表示 | 自動 |

### フッター部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| - | 該当なし | ページフッターはSparkUI共通フッター | - | - |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| RDD永続化有無 | 永続化されたRDDが存在する場合のみRDDテーブルを表示 | No |
| ストリームブロック有無 | ストリームブロックが存在する場合のみReceiver Blocksセクションを表示 | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | ストリームブロックはブロック名でソート | 昇順 |

### 改ページ条件

該当なし（全件表示）。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| AppStatusStore (KVStore) | RDD・ストリームブロック情報の取得 | なし |

### テーブル別参照項目詳細

#### AppStatusStore

| 参照項目（メソッド） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| rddList() | RDD一覧テーブル | なし | RDDStorageInfo のリスト |
| streamBlocksList() | ストリームブロック一覧 | なし | StreamBlockData のリスト |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| Fraction Cached | numCachedPartitions * 100.0 / numPartitions | 小数2桁（%.2f%%） | パーセント表示 |
| Total Size in Memory | blocks.map(_.memSize).sum | なし | Executor別集計 |
| Total Size on Disk | blocks.map(_.diskSize).sum | なし | Executor別集計 |
| Storage Level判定 | useDisk ? "Disk" : (useMemory && deserialized ? "Memory" : "Memory Serialized") | なし | ブロック単位 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[HTTP GET /storage/] --> B[StoragePage.render]
    B --> C[store.rddList でRDD一覧取得]
    B --> D[store.streamBlocksList でブロック一覧取得]
    C --> E{RDD存在?}
    E -->|Yes| F[rddTable 生成]
    E -->|No| G[RDDテーブルなし]
    D --> H{ストリームブロック存在?}
    H -->|Yes| I[receiverBlockTables 生成]
    H -->|No| J[ブロックセクションなし]
    I --> K[executorMetricsTable 生成]
    I --> L[streamBlockTable 生成]
    F --> M[HTML レスポンス構成]
    G --> M
    K --> M
    L --> M
    J --> M
    M --> N[UIUtils.headerSparkPage]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| 無効なストレージレベル | useDisk=false かつ useMemory=false | "Invalid Storage Level: {level}" | 正常データでは発生しない |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数十〜数百 RDD |
| 目標出力時間 | 1秒以内 |
| 同時出力数上限 | Web UI 同時接続数に依存 |

## セキュリティ考慮事項

- 特別なセキュリティ考慮事項なし（読み取り専用ページ）
- RDD名やストレージ情報には機密データを含まない想定

## 備考

- RDDが永続化されていない場合、RDDテーブルは表示されない（行43-45）
- ストリームブロックが存在しない場合、Receiver Blocksセクションは表示されない（行109-110）
- RDDテーブルには tooltips が定義されている（行78-85）
- ブロック一覧テーブルはソート不可（sortable = false、行174）

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | v1/api.scala | `core/src/main/scala/org/apache/spark/status/api/v1/api.scala` | RDDStorageInfo の定義（id, name, storageLevel, numPartitions, numCachedPartitions, memoryUsed, diskUsed） |
| 1-2 | StreamBlockData.scala | `core/src/main/scala/org/apache/spark/status/StreamBlockData.scala` | StreamBlockData の定義（name, executorId, hostPort, storageLevel, useDisk, useMemory, deserialized, memSize, diskSize） |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | StoragePage.scala | `core/src/main/scala/org/apache/spark/ui/storage/StoragePage.scala` | render メソッド（行34-38）。rddTable と receiverBlockTables の呼び出し |

**主要処理フロー**:
1. **行35**: store.rddList() で RDD 一覧取得、rddTable で HTML テーブル生成
2. **行36**: store.streamBlocksList() でブロック一覧取得、receiverBlockTables で HTML 生成

#### Step 3: RDDテーブル描画を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | StoragePage.scala | `core/src/main/scala/org/apache/spark/ui/storage/StoragePage.scala` | rddTable（行40-65）、rddHeader（行68-75）、rddRow（行88-106） |

#### Step 4: ストリームブロック描画を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | StoragePage.scala | `core/src/main/scala/org/apache/spark/ui/storage/StoragePage.scala` | receiverBlockTables（行108-121）、executorMetricsTable（行123-134）、streamBlockTable（行163-177） |
| 4-2 | StoragePage.scala | `core/src/main/scala/org/apache/spark/ui/storage/StoragePage.scala` | streamBlockStorageLevelDescriptionAndSize（行222-233）でストレージレベル判定 |

### プログラム呼び出し階層図

```
HttpServletRequest
    |
    +-- StoragePage.render()
            |
            +-- store.rddList()
            |     +-- rddTable()
            |           +-- UIUtils.listingTable(rddHeader, rddRow, ...)
            |
            +-- store.streamBlocksList()
                  +-- receiverBlockTables()
                        +-- executorMetricsTable()
                        |     +-- ExecutorStreamSummary
                        +-- streamBlockTable()
                              +-- streamBlockTableRow()
                                    +-- streamBlockStorageLevelDescriptionAndSize()
```

### データフロー図

```
[入力]                       [処理]                              [出力]

HTTP GET /storage/   ──▶  StoragePage.render()            ──▶  HTML レスポンス
                            |
AppStatusStore       ──▶  rddList()                      ──▶  RDDテーブル
                            |
                          streamBlocksList()              ──▶  Receiver Blocks
                            +-- groupBy(executorId)       ──▶    Executor集計テーブル
                            +-- groupBy(name).sorted      ──▶    ブロック一覧テーブル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| StoragePage.scala | `core/src/main/scala/org/apache/spark/ui/storage/StoragePage.scala` | ソース | ストレージ一覧ページの描画 |
| StorageTab.scala | `core/src/main/scala/org/apache/spark/ui/storage/StorageTab.scala` | ソース | Storage タブの定義 |
| ToolTips.scala | `core/src/main/scala/org/apache/spark/ui/storage/ToolTips.scala` | ソース | テーブルヘッダーのツールチップ定義 |
| AppStatusStore.scala | `core/src/main/scala/org/apache/spark/status/AppStatusStore.scala` | ソース | データストアアクセス |
| UIUtils.scala | `core/src/main/scala/org/apache/spark/ui/UIUtils.scala` | ソース | listingTable 等のHTMLユーティリティ |
