# 帳票設計書 18-RDDPage

## 概要

本ドキュメントは、Apache Spark Web UI の個別RDDストレージ詳細ページ（RDDPage）の帳票設計書である。特定のRDD IDに対して、ストレージレベル、キャッシュパーティション数、メモリ/ディスク使用量の概要、Executor別データ分散状況、パーティション別ブロック詳細をHTML形式で表示するレポートページを定義する。

### 本帳票の処理概要

**業務上の目的・背景**：個別RDDのキャッシュ状況を詳細に分析するために必要な帳票である。StoragePage（一覧）からドリルダウンして、特定RDDのデータがどのExecutorにどのように分散しているか、各パーティションのメモリ/ディスク使用量はどの程度かを確認できる。データの偏り（スキュー）の検出やメモリ最適化の判断材料として活用される。

**帳票の利用シーン**：StoragePage から特定 RDD 名をクリックして遷移する場面、RDD のデータ分散状況を確認する場面、パーティション別のメモリ/ディスク使用量を確認する場面、On-Heap/Off-Heap メモリの使い分けを確認する場面で利用される。

**主要な出力内容**：
1. RDD概要情報（ストレージレベル、キャッシュ/総パーティション数、メモリ/ディスクサイズ）
2. Data Distribution on Executors テーブル（Executor別データ分散）
3. Partitions テーブル（パーティション別ブロック詳細、ページネーション・ソート対応）

**帳票の出力タイミング**：Spark Web UI で `/storage/rdd/?id={rddId}` にアクセスした際に動的にレンダリングされる。

**帳票の利用者**：アプリケーション開発者、データエンジニア、パフォーマンスチューニング担当者

## 帳票種別

Web UI レポートページ（HTML形式詳細表示）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| 18 | RDD Storage Info | `http://{host}:4040/storage/rdd/?id={rddId}` | StoragePage の RDD 名リンクをクリック |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | HTML（動的レンダリング） |
| 用紙サイズ | 該当なし（ブラウザ表示） |
| 向き | 該当なし |
| ファイル名 | 該当なし（HTTP レスポンス） |
| 出力方法 | Spark Web UI からのブラウザ表示 |
| 文字コード | UTF-8 |

### PDF固有設定

該当なし

### Excel固有設定

該当なし

## 帳票レイアウト

### レイアウト概要

```
┌──────────────────────────────────────────┐
│  ページヘッダー                             │
│  (RDD Storage Info for {rddName})         │
├──────────────────────────────────────────┤
│  RDD概要情報                               │
│  - Storage Level / Cached Partitions       │
│  - Total Partitions                        │
│  - Memory Size / Disk Size                 │
├──────────────────────────────────────────┤
│  Data Distribution on X Executors          │
│  - Host / On Heap / Off Heap / Disk        │
├──────────────────────────────────────────┤
│  X Partitions                              │
│  - Block Name / Storage Level              │
│  - Size in Memory / Size on Disk           │
│  - Executors                               │
│  （ページネーション・ソート対応）              │
└──────────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Storage Level | ストレージレベル | rddStorageInfo.storageLevel | 文字列 |
| 2 | Cached Partitions | キャッシュ済みパーティション数 | rddStorageInfo.numCachedPartitions | 整数 |
| 3 | Total Partitions | 総パーティション数 | rddStorageInfo.numPartitions | 整数 |
| 4 | Memory Size | メモリ使用量 | rddStorageInfo.memoryUsed | バイト表示 |
| 5 | Disk Size | ディスク使用量 | rddStorageInfo.diskUsed | バイト表示 |

### 明細部（Data Distribution テーブル）

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Host | Executorのホストアドレス | worker.address | 文字列 | 自動 |
| 2 | On Heap Memory Usage | オンヒープメモリ使用量 (残量) | worker.onHeapMemoryUsed / onHeapMemoryRemaining | バイト表示 | 自動 |
| 3 | Off Heap Memory Usage | オフヒープメモリ使用量 (残量) | worker.offHeapMemoryUsed / offHeapMemoryRemaining | バイト表示 | 自動 |
| 4 | Disk Usage | ディスク使用量 | worker.diskUsed | バイト表示 | 自動 |

### 明細部（Partitions テーブル）

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Block Name | ブロック名 | rddPartition.blockName | 文字列 | 自動 |
| 2 | Storage Level | ストレージレベル | rddPartition.storageLevel | 文字列 | 自動 |
| 3 | Size in Memory | メモリ使用量 | rddPartition.memoryUsed | バイト表示 | 自動 |
| 4 | Size on Disk | ディスク使用量 | rddPartition.diskUsed | バイト表示 | 自動 |
| 5 | Executors | 配置先Executor | rddPartition.executors（アドレス変換済み） | 文字列（スペース区切り） | 自動 |

### フッター部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| - | 該当なし | ページフッターはSparkUI共通フッター | - | - |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| id パラメータ | RDD ID（URLパラメータ） | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | Block Name（デフォルト） | 昇順 |
| 2 | block.sort パラメータで動的変更可能 | 可変 |

### 改ページ条件

BlockPagedTable によるページネーション。block.page パラメータで制御。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| AppStatusStore (KVStore) | RDD・Executor情報の取得 | rddId |

### テーブル別参照項目詳細

#### AppStatusStore

| 参照項目（メソッド） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| rdd(rddId) | RDD ストレージ情報 | rddId | RDDStorageInfo（dataDistribution, partitions 含む） |
| executorList(true) | Executor ID→アドレスマッピング | activeOnly=true | ブロックテーブルの Executors カラム表示用 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| Executor アドレス変換 | executorIdToAddress.getOrElse(id, id) | なし | ExecutorSummary から Map 構築 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[HTTP GET /storage/rdd/?id=X] --> B[RDDPage.render]
    B --> C[id パラメータ検証]
    C --> D[store.rdd でRDD情報取得]
    D --> E{RDD存在?}
    E -->|No| F[RDD Not Found ページ]
    E -->|Yes| G[workerTable 生成]
    G --> H[BlockPagedTable 生成]
    H --> I[HTML レスポンス構成]
    I --> J[UIUtils.headerSparkPage]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| パラメータ不足 | id パラメータが null/空 | "Missing id parameter" | 正しいURLでアクセス |
| RDD未発見 | 指定RDD IDが存在しない（NoSuchElementException） | "RDD Not Found" | 正しいRDD IDを確認、またはunpersistされた可能性 |
| テーブル描画エラー | IllegalArgumentException / IndexOutOfBoundsException | エラーメッセージを div で表示 | ページパラメータを確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数十〜数千パーティション |
| 目標出力時間 | 1秒以内 |
| 同時出力数上限 | Web UI 同時接続数に依存 |

## セキュリティ考慮事項

- 特別なセキュリティ考慮事項なし（読み取り専用ページ）

## 備考

- ブロックソート後にテーブル位置に自動スクロールする JavaScript が含まれる（行67-81）
- On Heap / Off Heap メモリは Optional フィールドで、存在しない場合は 0 として表示（行144-149）
- Executors カラムは Executor ID をアドレスに変換して表示（行183-187）
- ソート対応カラム: Block Name, Storage Level, Size in Memory, Size on Disk, Executors（全カラムソート可能）

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | v1/api.scala | `core/src/main/scala/org/apache/spark/status/api/v1/api.scala` | RDDStorageInfo（dataDistribution, partitions）、RDDDataDistribution、RDDPartitionInfo の定義 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RDDPage.scala | `core/src/main/scala/org/apache/spark/ui/storage/RDDPage.scala` | render メソッド（行35-130）。パラメータ検証、データ取得、テーブル生成 |

**主要処理フロー**:
1. **行36-37**: id パラメータ検証
2. **行42-48**: store.rdd(rddId) で RDD 情報取得、NoSuchElementException で "RDD Not Found"
3. **行51-52**: workerTable 生成（UIUtils.listingTable）
4. **行54-65**: BlockPagedTable 生成（ページネーション対応）
5. **行83-126**: HTML レスポンス構成（概要 + Data Distribution + Partitions）

#### Step 3: ページネーション付きブロックテーブルを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | RDDPage.scala | `core/src/main/scala/org/apache/spark/ui/storage/RDDPage.scala` | BlockPagedTable（行210-271）、BlockDataSource（行163-208） |

**主要処理フロー**:
- **行163-208**: BlockDataSource でデータのソートとページネーション
- **行170**: blockRow でRDDPartitionInfoをBlockTableRowDataに変換
- **行193-207**: ordering メソッドで各カラムのソート定義
- **行249-260**: headers メソッドでテーブルヘッダー定義

### プログラム呼び出し階層図

```
HttpServletRequest (?id=X)
    |
    +-- RDDPage.render()
            |
            +-- store.rdd(rddId)
            +-- store.executorList(true)
            |
            +-- UIUtils.listingTable(workerHeader, workerRow, ...)
            |     +-- workerRow() [RDDDataDistribution → HTML]
            |
            +-- BlockPagedTable
                  +-- BlockDataSource
                  |     +-- blockRow() [RDDPartitionInfo → BlockTableRowData]
                  |     +-- ordering() [ソート定義]
                  +-- headers() / row() [テーブル描画]
```

### データフロー図

```
[入力]                          [処理]                           [出力]

HTTP GET /storage/rdd/   ──▶  RDDPage.render()             ──▶  HTML レスポンス
  ?id=X                         |
                               store.rdd(rddId)              ──▶  RDD概要情報
                                 +-- dataDistribution        ──▶  Executor分散テーブル
                                 +-- partitions              ──▶  パーティションテーブル
                               store.executorList(true)      ──▶  ID→アドレス変換Map
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RDDPage.scala | `core/src/main/scala/org/apache/spark/ui/storage/RDDPage.scala` | ソース | RDD詳細ページの描画 |
| StorageTab.scala | `core/src/main/scala/org/apache/spark/ui/storage/StorageTab.scala` | ソース | Storage タブの定義（行28でアタッチ） |
| AppStatusStore.scala | `core/src/main/scala/org/apache/spark/status/AppStatusStore.scala` | ソース | データストアアクセス |
| PagedTable.scala | `core/src/main/scala/org/apache/spark/ui/PagedTable.scala` | ソース | ページネーション付きテーブル基底クラス |
| UIUtils.scala | `core/src/main/scala/org/apache/spark/ui/UIUtils.scala` | ソース | listingTable, headerSparkPage 等のHTMLユーティリティ |
