# 帳票設計書 19-EnvironmentPage

## 概要

本ドキュメントは、Apache Spark Web UI の「Environment」タブにおける環境情報ページ（EnvironmentPage）の帳票設計書である。Spark アプリケーションの実行環境に関する設定情報（ランタイム情報、Spark プロパティ、リソースプロファイル、Hadoop プロパティ、システムプロパティ、メトリクスプロパティ、クラスパスエントリ）をHTML形式で表示するレポートページを定義する。

### 本帳票の処理概要

**業務上の目的・背景**：Spark アプリケーションの実行環境を一元的に確認するために必要な帳票である。設定ミスの検出、環境差異の比較、トラブルシューティングにおいて、アプリケーションがどのような設定で動作しているかを正確に把握する必要がある場面で活用される。機密情報はリダクト処理されて表示される。

**帳票の利用シーン**：アプリケーションの設定値を確認する場面、異なる環境間の設定差異を比較する場面、Java/Scala バージョンやクラスパスの確認が必要な場面、リソースプロファイルの設定を確認する場面で利用される。

**主要な出力内容**：
1. Runtime Information（Java バージョン、Java Home、Scala バージョン）
2. Spark Properties（Spark の設定プロパティ一覧、リダクト処理済み）
3. Resource Profiles（Executor/Task リソース要求の詳細）
4. Hadoop Properties（Hadoop の設定プロパティ一覧、折りたたみ）
5. System Properties（JVM システムプロパティ一覧、折りたたみ）
6. Metrics Properties（メトリクス設定プロパティ一覧、折りたたみ）
7. Classpath Entries（クラスパスエントリ一覧、折りたたみ）

**帳票の出力タイミング**：Spark Web UI の「Environment」タブにアクセスした際に動的にレンダリングされる。

**帳票の利用者**：アプリケーション開発者、クラスタ管理者、SRE チーム

## 帳票種別

Web UI レポートページ（HTML形式プロパティ一覧表）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| 19 | Environment | `http://{host}:4040/environment/` | ブラウザからアクセス |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | HTML（動的レンダリング） |
| 用紙サイズ | 該当なし（ブラウザ表示） |
| 向き | 該当なし |
| ファイル名 | 該当なし（HTTP レスポンス） |
| 出力方法 | Spark Web UI からのブラウザ表示 |
| 文字コード | UTF-8 |

### PDF固有設定

該当なし

### Excel固有設定

該当なし

## 帳票レイアウト

### レイアウト概要

各セクションは折りたたみ可能。Runtime Information、Spark Properties、Resource Profiles は初期展開状態、その他は初期折りたたみ状態で表示される。

```
┌─────────────────────────────────────┐
│  ページヘッダー (Environment)         │
├─────────────────────────────────────┤
│  Runtime Information（展開状態）       │
│  - Java Version / Java Home          │
│  - Scala Version                     │
├─────────────────────────────────────┤
│  Spark Properties（展開状態）          │
│  - Name / Value                      │
├─────────────────────────────────────┤
│  Resource Profiles（展開状態）         │
│  - Resource Profile Id / Contents    │
├─────────────────────────────────────┤
│  Hadoop Properties（折りたたみ状態）   │
│  - Name / Value                      │
├─────────────────────────────────────┤
│  System Properties（折りたたみ状態）   │
│  - Name / Value                      │
├─────────────────────────────────────┤
│  Metrics Properties（折りたたみ状態）  │
│  - Name / Value                      │
├─────────────────────────────────────┤
│  Classpath Entries（折りたたみ状態）   │
│  - Resource / Source                 │
└─────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| - | 該当なし | ページレベルのサマリーヘッダーなし | - | - |

### 明細部（Runtime Information）

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Java Version | Java のバージョン | appEnv.runtime.javaVersion | 文字列 | 自動 |
| 2 | Java Home | Java ホームディレクトリ | appEnv.runtime.javaHome | 文字列 | 自動 |
| 3 | Scala Version | Scala のバージョン | appEnv.runtime.scalaVersion | 文字列 | 自動 |

### 明細部（Spark Properties / Hadoop / System / Metrics Properties）

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Name | プロパティ名 | キー | 文字列 | 固定幅 |
| 2 | Value | プロパティ値（リダクト済み） | 値（Utils.redact適用後） | 文字列 | 固定幅 |

### 明細部（Resource Profiles）

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Resource Profile Id | リソースプロファイルID | rinfo.id | 整数 | 固定幅 |
| 2 | Resource Profile Contents | リソース要求の詳細 | Executor Reqs + Task Reqs | pre フォーマット文字列 | 固定幅 |

### 明細部（Classpath Entries）

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Resource | クラスパスリソースパス | appEnv.classpathEntries._1 | 文字列 | 固定幅 |
| 2 | Source | クラスパスソース | appEnv.classpathEntries._2 | 文字列 | 固定幅 |

### フッター部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| - | 該当なし | environmentpage.js がページ末尾にロードされる | - | - |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| なし | 全環境情報を表示（フィルタなし） | - |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | プロパティ名 | 昇順（.sorted） |
| 2 | リソースプロファイルID | 昇順（数値順） |

### 改ページ条件

該当なし（全件表示）。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| AppStatusStore (KVStore) | 環境情報の取得 | なし |

### テーブル別参照項目詳細

#### AppStatusStore

| 参照項目（メソッド） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| environmentInfo() | 全環境情報 | なし | ApplicationEnvironmentInfo |
| resourceProfileInfo() | リソースプロファイル情報 | なし | ResourceProfileInfo のリスト |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| リダクト処理 | Utils.redact(conf, properties) | なし | Spark/Hadoop/System/Metrics プロパティに適用 |
| Executor リソース文字列 | resourceName: [amount: X, discovery: Y, vendor: Z] | なし | constructExecutorRequestString |
| Task リソース文字列 | resourceName: [amount: X] | なし | constructTaskRequestString |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[HTTP GET /environment/] --> B[EnvironmentPage.render]
    B --> C[store.environmentInfo で環境情報取得]
    C --> D[store.resourceProfileInfo でリソースプロファイル取得]
    D --> E[JVM Information テーブル生成]
    E --> F[Spark Properties テーブル生成（リダクト済み）]
    F --> G[Resource Profiles テーブル生成]
    G --> H[Hadoop Properties テーブル生成（リダクト済み）]
    H --> I[System Properties テーブル生成（リダクト済み）]
    I --> J[Metrics Properties テーブル生成（リダクト済み）]
    J --> K[Classpath Entries テーブル生成]
    K --> L[HTML レスポンス構成]
    L --> M[UIUtils.headerSparkPage]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| 該当なし | 環境情報は常に存在する | - | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数百プロパティ |
| 目標出力時間 | 1秒以内 |
| 同時出力数上限 | Web UI 同時接続数に依存 |

## セキュリティ考慮事項

- Spark Properties、Hadoop Properties、System Properties、Metrics Properties は Utils.redact() によりリダクト処理される（パスワード等の機密情報を隠蔽）
- Classpath Entries はリダクト対象外
- Runtime Information はリダクト対象外

## 備考

- 各セクションの初期表示状態は arrow-open（展開）と arrow-closed（折りたたみ）の CSS クラスで制御
- Runtime Information, Spark Properties, Resource Profiles: 初期展開
- Hadoop Properties, System Properties, Metrics Properties, Classpath Entries: 初期折りたたみ
- Resource Profile Contents は pre タグで整形表示される（行184-185）
- hadoopProperties と metricsProperties は Option 型のため、null の場合は空シーケンスにフォールバック（行82, 88）
- テーブルは fixedWidth = true で固定幅レイアウト
- environmentpage.js がページ末尾でロードされる（行172）

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | v1/api.scala | `core/src/main/scala/org/apache/spark/status/api/v1/api.scala` | ApplicationEnvironmentInfo（runtime, sparkProperties, systemProperties, classpathEntries 等）の定義 |
| 1-2 | ResourceProfile.scala | `core/src/main/scala/org/apache/spark/resource/ResourceProfile.scala` | ExecutorResourceRequest, TaskResourceRequest の定義 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | EnvironmentPage.scala | `core/src/main/scala/org/apache/spark/ui/env/EnvironmentPage.scala` | render メソッド（行36-176）全体の流れ |

**主要処理フロー**:
1. **行37-41**: store.environmentInfo() で環境情報取得、JVM情報を Map 構築
2. **行43-56**: constructExecutorRequestString / constructTaskRequestString でリソース文字列生成
3. **行64-69**: store.resourceProfileInfo() でリソースプロファイル取得・変換
4. **行71-92**: 各プロパティテーブル生成（全てリダクト処理適用、sortedでソート）
5. **行93-173**: HTML構成（折りたたみ可能な各セクション）

#### Step 3: EnvironmentTab を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | EnvironmentPage.scala | `core/src/main/scala/org/apache/spark/ui/env/EnvironmentPage.scala` | EnvironmentTab（行191-195）。SparkUITab を継承し、EnvironmentPage をアタッチ |

### プログラム呼び出し階層図

```
HttpServletRequest
    |
    +-- EnvironmentPage.render()
            |
            +-- store.environmentInfo()
            |     +-- runtime (javaVersion, javaHome, scalaVersion)
            |     +-- sparkProperties
            |     +-- hadoopProperties
            |     +-- systemProperties
            |     +-- metricsProperties
            |     +-- classpathEntries
            |
            +-- store.resourceProfileInfo()
            |     +-- constructExecutorRequestString()
            |     +-- constructTaskRequestString()
            |
            +-- Utils.redact(conf, properties)  [x4 セクション]
            |
            +-- UIUtils.listingTable()  [x7 セクション]
```

### データフロー図

```
[入力]                       [処理]                              [出力]

HTTP GET /environment/ ──▶  EnvironmentPage.render()        ──▶  HTML レスポンス
                              |
AppStatusStore         ──▶  environmentInfo()               ──▶  各プロパティテーブル
                              +-- Utils.redact()                  （リダクト処理済み）
                              |
                            resourceProfileInfo()            ──▶  リソースプロファイルテーブル
                              +-- constructExecutorRequestString()
                              +-- constructTaskRequestString()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| EnvironmentPage.scala | `core/src/main/scala/org/apache/spark/ui/env/EnvironmentPage.scala` | ソース | 環境情報ページの描画 + EnvironmentTab の定義 |
| AppStatusStore.scala | `core/src/main/scala/org/apache/spark/status/AppStatusStore.scala` | ソース | データストアアクセス（environmentInfo, resourceProfileInfo） |
| Utils.scala | `core/src/main/scala/org/apache/spark/util/Utils.scala` | ソース | redact メソッドによる機密情報保護 |
| environmentpage.js | `core/src/main/resources/org/apache/spark/ui/static/environmentpage.js` | JavaScript | ページ固有のクライアントサイドロジック |
| UIUtils.scala | `core/src/main/scala/org/apache/spark/ui/UIUtils.scala` | ソース | listingTable, headerSparkPage 等のHTMLユーティリティ |
