# 帳票設計書 20-ExecutorsTab

## 概要

本ドキュメントは、Apache Spark Web UI の「Executors」タブにおけるExecutor一覧ページ（ExecutorsTab / ExecutorsPage）の帳票設計書である。Spark アプリケーションの全Executorのリソース使用状況（メモリ、ディスク、CPU等）を動的にHTML形式で表示するレポートページを定義する。タスクの実行状況やI/O統計、スレッドダンプ機能、ヒープヒストグラム機能も提供する。

### 本帳票の処理概要

**業務上の目的・背景**：Spark アプリケーションの各Executorのリソース使用状況をリアルタイムに監視するために必要な帳票である。メモリ不足やディスクスピルの発生状況を把握し、Executorの追加/削除のタイミングやリソース設定の最適化に活用される。スレッドダンプ機能によりデッドロックや長時間実行中のタスクの原因調査も可能である。

**帳票の利用シーン**：アプリケーション実行中にExecutorのリソース使用状況を監視する場面、メモリ不足やGC問題を診断する場面、Executorの追加/削除状況を確認する場面、スレッドダンプによるデバッグを行う場面、ヒープヒストグラムでメモリリークを調査する場面で利用される。

**主要な出力内容**：
1. Active Executors テーブル（動的レンダリング、executorspage.js）
   - Executor ID、ホスト、ポート
   - RDD Blocks数、メモリ使用量（On Heap / Off Heap）
   - ディスク使用量
   - アクティブタスク数、失敗タスク数、完了タスク数、タスク合計
   - タスク実行時間、GC時間
   - I/O統計（Input / Shuffle Read / Shuffle Write）
2. スレッドダンプリンク（有効時）
3. ヒープヒストグラムリンク（有効時）

**帳票の出力タイミング**：Spark Web UI の「Executors」タブにアクセスした際にレンダリングされる。テーブル内容は executorspage.js が REST API を呼び出して動的に取得・表示する。

**帳票の利用者**：クラスタ管理者、SRE チーム、アプリケーション開発者、データエンジニア

## 帳票種別

Web UI レポートページ（HTML形式一覧表、JavaScript動的レンダリング）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| 20 | Executors | `http://{host}:4040/executors/` | ブラウザからアクセス |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | HTML（JavaScript動的レンダリング、DataTables使用） |
| 用紙サイズ | 該当なし（ブラウザ表示） |
| 向き | 該当なし |
| ファイル名 | 該当なし（HTTP レスポンス） |
| 出力方法 | Spark Web UI からのブラウザ表示 |
| 文字コード | UTF-8 |

### PDF固有設定

該当なし

### Excel固有設定

該当なし

## 帳票レイアウト

### レイアウト概要

ページのHTML構造は最小限で、主要なテーブル描画は executorspage.js により REST API 経由で動的に行われる。

```
┌─────────────────────────────────────┐
│  ページヘッダー (Executors)           │
├─────────────────────────────────────┤
│  <div id="active-executors">        │
│  （executorspage.js が動的に描画）     │
│  ├── Summary テーブル               │
│  ├── Active Executors テーブル       │
│  └── Dead Executors テーブル         │
│                                     │
│  utils.js / executorspage.js ロード  │
└─────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| - | 該当なし | サーバーサイドでのヘッダー描画なし（JS動的描画） | - | - |

### 明細部

executorspage.js により動的に描画されるテーブルカラム（推定）。

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Executor ID | Executor識別子 | ExecutorSummary.id | 文字列 | 自動 |
| 2 | Address | ホスト:ポート | ExecutorSummary.hostPort | 文字列 | 自動 |
| 3 | Status | Executor状態 | Active/Dead | 文字列 | 自動 |
| 4 | RDD Blocks | RDDブロック数 | ExecutorSummary.rddBlocks | 整数 | 自動 |
| 5 | Storage Memory | ストレージメモリ使用量/最大 | memoryUsed / maxMemory | バイト表示 | 自動 |
| 6 | Disk Used | ディスク使用量 | ExecutorSummary.diskUsed | バイト表示 | 自動 |
| 7 | Cores | コア数 | ExecutorSummary.totalCores | 整数 | 自動 |
| 8 | Active Tasks | アクティブタスク数 | ExecutorSummary.activeTasks | 整数 | 自動 |
| 9 | Failed Tasks | 失敗タスク数 | ExecutorSummary.failedTasks | 整数 | 自動 |
| 10 | Complete Tasks | 完了タスク数 | ExecutorSummary.completedTasks | 整数 | 自動 |
| 11 | Total Tasks | タスク合計 | ExecutorSummary.totalTasks | 整数 | 自動 |
| 12 | Task Time | タスク実行時間 | ExecutorSummary.totalDuration | 時間フォーマット | 自動 |
| 13 | GC Time | GC時間 | ExecutorSummary.totalGCTime | 時間フォーマット | 自動 |
| 14 | Input | 入力サイズ | ExecutorSummary.totalInputBytes | バイト表示 | 自動 |
| 15 | Shuffle Read | シャッフル読み取り | ExecutorSummary.totalShuffleRead | バイト表示 | 自動 |
| 16 | Shuffle Write | シャッフル書き込み | ExecutorSummary.totalShuffleWrite | バイト表示 | 自動 |

### フッター部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| - | 該当なし | ページフッターはSparkUI共通フッター | - | - |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| なし | 全Executor情報を REST API 経由で取得 | - |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | DataTables のクライアントサイドソート | ユーザー操作による |

### 改ページ条件

DataTables のクライアントサイドページネーション。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| REST API (/api/v1/applications/{appId}/allexecutors) | Executor情報の取得 | なし |

### テーブル別参照項目詳細

#### REST API (executorspage.js経由)

| 参照項目（エンドポイント） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------------|----------------|---------|------|
| /api/v1/applications/{appId}/allexecutors | Executor一覧 | なし | ExecutorSummary の配列 |

## 計算仕様

### 計算項目一覧

該当なし（サーバーサイドでの計算処理なし。クライアントサイドで表示フォーマット処理）。

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[HTTP GET /executors/] --> B[ExecutorsPage.render]
    B --> C[最小限HTML生成]
    C --> D[utils.js / executorspage.js ロード]
    D --> E[setThreadDumpEnabled / setHeapHistogramEnabled 設定]
    E --> F[クライアントサイド: REST API 呼び出し]
    F --> G[/api/v1/applications/.../allexecutors]
    G --> H[DataTables でテーブル動的描画]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| REST API エラー | バックエンド API が応答しない | クライアントサイドエラー表示 | ページをリロード |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数十〜数千 Executor |
| 目標出力時間 | 初期ページロード: 1秒以内、API応答: 2秒以内 |
| 同時出力数上限 | Web UI 同時接続数に依存 |

## セキュリティ考慮事項

- スレッドダンプ機能は spark.ui.threadDumpsEnabled 設定で制御される（デフォルト有効）
- ヒープヒストグラム機能は spark.ui.heapHistogramEnabled 設定で制御される
- 両機能とも Live UI（sc.isDefined）でのみ有効

## 備考

- ExecutorsTab は init() メソッドでスレッドダンプ/ヒープヒストグラムの有効性に応じてサブページをアタッチする（行31-44）
- ExecutorsPage のサーバーサイドレンダリングは最小限（div#active-executors のみ）で、主要な描画はクライアントサイドの JavaScript で行われる
- executorspage.js は REST API を呼び出してデータを取得し、DataTables ライブラリでテーブルを描画する
- useDataTables = true で DataTables の CSS/JS がページに含まれる（行76）
- setThreadDumpEnabled と setHeapHistogramEnabled は JavaScript 関数として呼び出される（行64-65）

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | v1/api.scala | `core/src/main/scala/org/apache/spark/status/api/v1/api.scala` | ExecutorSummary の定義（id, hostPort, rddBlocks, memoryUsed, diskUsed, totalCores, activeTasks 等） |

**読解のコツ**: ExecutorsPage のテーブルカラムは executorspage.js で定義されるため、REST API のレスポンスモデル（ExecutorSummary）を理解することが重要。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ExecutorsTab.scala | `core/src/main/scala/org/apache/spark/ui/exec/ExecutorsTab.scala` | ExecutorsTab（行27-46）。init() でサブページアタッチ |
| 2-2 | ExecutorsTab.scala | `core/src/main/scala/org/apache/spark/ui/exec/ExecutorsTab.scala` | ExecutorsPage.render（行54-77）。最小限 HTML + JS ロード |

**主要処理フロー**:
1. **行27-46**: ExecutorsTab.init() - threadDumpEnabled/heapHistogramEnabled を判定し、対応ページをアタッチ
2. **行54-59**: formatImportJavaScript で JS モジュールのインポートコード生成
3. **行60-66**: setThreadDumpEnabled/setHeapHistogramEnabled のJS関数呼び出しコード
4. **行67-74**: div#active-executors + utils.js + executorspage.js のHTML構成
5. **行76**: useDataTables = true で DataTables 有効化

#### Step 3: クライアントサイドの動的描画を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | executorspage.js | `core/src/main/resources/org/apache/spark/ui/static/executorspage.js` | REST API呼び出し、DataTablesテーブル構築、Executor情報表示ロジック |

### プログラム呼び出し階層図

```
HttpServletRequest
    |
    +-- ExecutorsPage.render()
            |
            +-- formatImportJavaScript("executorspage.js", ...)
            +-- setThreadDumpEnabled(boolean)   [JavaScript呼び出し]
            +-- setHeapHistogramEnabled(boolean) [JavaScript呼び出し]
            |
            +-- [クライアントサイド]
                  |
                  +-- executorspage.js
                        |
                        +-- fetch(/api/v1/applications/.../allexecutors)
                        +-- DataTables テーブル構築
                        +-- Active/Dead Executors 分類表示

ExecutorsTab.init()
    |
    +-- ExecutorsPage (常にアタッチ)
    +-- ExecutorThreadDumpPage (threadDumpEnabled時のみ)
    +-- ExecutorHeapHistogramPage (heapHistogramEnabled時のみ)
```

### データフロー図

```
[入力]                       [処理]                              [出力]

HTTP GET /executors/ ──▶  ExecutorsPage.render()           ──▶  最小限HTML
                            |                                    + JavaScript
                            v
                          executorspage.js (クライアント)
                            |
                          REST API 呼び出し                 ──▶  JSON データ取得
                          /api/v1/.../allexecutors
                            |
                          DataTables テーブル構築            ──▶  動的テーブル表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ExecutorsTab.scala | `core/src/main/scala/org/apache/spark/ui/exec/ExecutorsTab.scala` | ソース | Executors タブ定義 + ExecutorsPage |
| ExecutorThreadDumpPage.scala | `core/src/main/scala/org/apache/spark/ui/exec/ExecutorThreadDumpPage.scala` | ソース | スレッドダンプページ |
| ExecutorHeapHistogramPage.scala | `core/src/main/scala/org/apache/spark/ui/exec/ExecutorHeapHistogramPage.scala` | ソース | ヒープヒストグラムページ |
| executorspage.js | `core/src/main/resources/org/apache/spark/ui/static/executorspage.js` | JavaScript | Executor テーブルの動的描画 |
| utils.js | `core/src/main/resources/org/apache/spark/ui/static/utils.js` | JavaScript | 共通ユーティリティ関数 |
| AppStatusStore.scala | `core/src/main/scala/org/apache/spark/status/AppStatusStore.scala` | ソース | REST API のバックエンドデータストア |
