# 帳票設計書 22-AllExecutionsPage（SQL）

## 概要

本ドキュメントは、Apache Spark Web UI における SQL/DataFrame 実行一覧ページ（AllExecutionsPage）の帳票設計書である。SQL クエリの実行状況を一覧形式で表示する HTML レポートページの仕様を定義する。

### 本帳票の処理概要

AllExecutionsPage は Spark SQL および DataFrame API で実行されたクエリの一覧を、実行状態（Running / Completed / Failed）ごとにグループ化して HTML テーブル形式で表示する帳票レポートページである。

**業務上の目的・背景**：Spark SQL/DataFrame を使用するデータ処理パイプラインにおいて、実行中・完了・失敗のクエリを一元的に把握することは、パフォーマンスチューニングや障害対応の出発点となる。本帳票により、全 SQL 実行の俯瞰的な状態把握が可能となる。

**帳票の利用シーン**：Spark アプリケーション実行中に SQL/DataFrame タブを開き、クエリの進捗状態を確認する際に利用される。特定のクエリが遅延していないか、エラーが発生していないかの初期確認に用いられる。

**主要な出力内容**：
1. Running Queries テーブル（実行中クエリ一覧）
2. Completed Queries テーブル（完了済みクエリ一覧）
3. Failed Queries テーブル（失敗クエリ一覧とエラーメッセージ）
4. 各クエリの ID、Query ID、Description、Submitted 時刻、Duration、関連 Job ID
5. Sub Execution のグルーピング表示（UI_SQL_GROUP_SUB_EXECUTION_ENABLED 有効時）

**帳票の出力タイミング**：Spark Web UI の「SQL / DataFrame」タブにアクセスした際にリアルタイムで生成・表示される。

**帳票の利用者**：データエンジニア、Spark アプリケーション開発者、パフォーマンスチューニング担当者

## 帳票種別

Web UI ページ（一覧表）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| 22 | AllExecutionsPage（SQL） | `/SQL/` | Spark UI の「SQL / DataFrame」タブをクリック |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | HTML（Web UI ページ） |
| 用紙サイズ | N/A（ブラウザ表示） |
| 向き | N/A |
| ファイル名 | N/A（動的 HTML レスポンス） |
| 出力方法 | ブラウザ上にリアルタイム表示 |
| 文字コード | UTF-8 |

### PDF固有設定

N/A

### Excel固有設定

N/A

## 帳票レイアウト

### レイアウト概要

ページは Running / Completed / Failed の3つのセクションに分かれ、各セクションに折り畳み可能なページ付きテーブルを配置する。

```
+---------------------------------------------+
|         Spark UI ヘッダー (SQL / DataFrame)    |
+---------------------------------------------+
| Running Queries: {count}                     |
| Completed Queries: {count}                   |
| Failed Queries: {count}                      |
+---------------------------------------------+
| ▼ Running Queries ({count})                  |
| +------------------------------------------+|
| | ID | Query ID | Description | Submitted  ||
| |    | Duration | Running Jobs | ...        ||
| +------------------------------------------+|
+---------------------------------------------+
| ▼ Completed Queries ({count})                |
| +------------------------------------------+|
| | ID | Query ID | Description | Submitted  ||
| |    | Duration | Succeeded Job IDs         ||
| +------------------------------------------+|
+---------------------------------------------+
| ▼ Failed Queries ({count})                   |
| +------------------------------------------+|
| | ID | Query ID | Description | Submitted  ||
| |    | Duration | ... | Error Message       ||
| +------------------------------------------+|
+---------------------------------------------+
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | サマリーリスト | 各ステータスのクエリ数 | running.size, completed.size, failed.size | "Running Queries: N" 等 |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | ID | SQL 実行 ID | executionUIData.executionId | 数値 | auto |
| 2 | Query ID | クエリ ID | executionUIData.queryId | テキスト（N/A の場合あり） | auto |
| 3 | Description | 実行の説明 | executionUIData.description | テキスト（+details 展開あり） | auto |
| 4 | Submitted | 実行開始時刻 | executionUIData.submissionTime | UIUtils.formatDate | auto |
| 5 | Duration | 実行時間 | completionTime - submissionTime | UIUtils.formatDuration | auto |
| 6 | Running Job IDs | 実行中ジョブ一覧 | jobs (RUNNING) | ジョブID リンク | auto |
| 7 | Succeeded Job IDs | 成功ジョブ一覧 | jobs (SUCCEEDED) | ジョブID リンク | auto |
| 8 | Failed Job IDs | 失敗ジョブ一覧 | jobs (FAILED) | ジョブID リンク | auto |
| 9 | Error Message | エラーメッセージ | executionUIData.errorMessage | テキスト（Failed のみ） | auto |
| 10 | Sub Execution IDs | サブ実行一覧 | executionIdToSubExecutions | 実行ID リンク | auto |

### フッター部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | ページネーション | テーブルのページ切り替え | PagedTable 基盤 | ページ番号リンク |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| executionStatus | RUNNING / COMPLETED / FAILED でフィルタ | No（全件表示） |
| {tag}.page | ページ番号 | No（デフォルト: 1） |
| {tag}.sort | ソートカラム名 | No（デフォルト: ID） |
| {tag}.desc | 降順フラグ | No（デフォルト: false） |
| {tag}.pageSize | 1ページあたりの件数 | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | ID（デフォルト） | 昇順（降順切替可能） |
| 2 | Query ID / Description / Submitted / Duration / Job IDs 等 | ユーザ選択可能 |

### 改ページ条件

PagedTable フレームワークにより pageSize 単位でページ分割される。

## データベース参照仕様

### 参照テーブル一覧

本帳票はデータベースではなく SQLAppStatusStore（インメモリ）を参照する。

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| SQLAppStatusStore | SQL 実行情報の取得 | N/A |

### テーブル別参照項目詳細

#### SQLAppStatusStore

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| executionsList() | 全クエリ一覧 | なし | SQLExecutionUIData のリストを返す |
| executionId | ID | - | Long 型 |
| queryId | Query ID | - | String 型（null の場合 N/A 表示） |
| description | Description | - | String 型 |
| submissionTime | Submitted | - | Long 型（ミリ秒） |
| completionTime | Duration 計算元 | - | Option[Date] |
| jobs | Job IDs | JobExecutionStatus でフィルタ | Map[Int, JobExecutionStatus] |
| errorMessage | Error Message | - | Option[String] |
| rootExecutionId | Sub Execution グルーピング | groupSubExecutionEnabled 時 | Long 型 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| Duration | completionTime.getOrElse(currentTime) - submissionTime | なし | 実行中の場合は現在時刻からの経過時間 |
| Running Jobs | jobs.filter(status == RUNNING) | N/A | ジョブID のリスト |
| Succeeded Jobs | jobs.filter(status == SUCCEEDED) | N/A | ジョブID のリスト |
| Failed Jobs | jobs.filter(status == FAILED) | N/A | ジョブID のリスト |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[HTTPリクエスト受信] --> B[sqlStore.executionsList 全件取得]
    B --> C[Sub Execution グルーピング処理]
    C --> D[Running / Completed / Failed に分類]
    D --> E{各カテゴリにデータあり？}
    E -->|Running あり| F[Running テーブル生成]
    E -->|Completed あり| G[Completed テーブル生成]
    E -->|Failed あり| H[Failed テーブル生成]
    F --> I[ExecutionPagedTable でページング・ソート]
    G --> I
    H --> I
    I --> J[サマリー + コンテンツ結合]
    J --> K[headerSparkPage で HTML 生成]
    K --> L[レスポンス返却]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| テーブル描画エラー | IllegalArgumentException / IndexOutOfBoundsException | "Error while rendering execution table: {exception}" | 不正なページ番号やソートカラム指定を修正する |
| 不明カラムエラー | 不正なソートカラム名が指定された | QueryExecutionErrors.unknownColumnError | 正しいカラム名を指定する |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数百～数千の SQL 実行エントリ |
| 目標出力時間 | PagedTable によるページング処理で表示は高速（1秒以内） |
| 同時出力数上限 | Spark Web UI のスレッドプール制約に従う |

## セキュリティ考慮事項

- SQL クエリの description やエラーメッセージにはビジネスロジック固有の情報が含まれる可能性がある。Spark UI のアクセス制御を適切に設定すること。
- エラーメッセージはUIUtils.errorMessageCellで表示され、HTMLエスケープが施される。

## 備考

- Sub Execution のグルーピング機能は `spark.sql.ui.sub.execution.enabled` 設定で制御される。
- ExecutionDataSource はデータのソートとページングを担当する PagedDataSource の実装である。
- 各実行の詳細は ExecutionPage（No.23）にリンクされる。

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SQLExecutionUIData | `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/SQLAppStatusStore.scala` | SQL 実行データの構造体定義（executionId, queryId, description, submissionTime, completionTime, jobs, errorMessage, rootExecutionId 等） |
| 1-2 | ExecutionTableRowData | `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/AllExecutionsPage.scala` | テーブル行データの構造体（行507-513） |

**読解のコツ**: SQLExecutionUIData の各フィールドがテーブルのどの列に対応するかを把握することが重要。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SQLTab.scala | `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/SQLTab.scala` | AllExecutionsPage の登録（行33）。prefix "SQL" でタブ登録 |
| 2-2 | AllExecutionsPage.scala | `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/AllExecutionsPage.scala` | render() メソッド（行40-195）が起点 |

**主要処理フロー**:
1. **行41**: currentTime 取得
2. **行48-72**: sqlStore.executionsList() で全件取得し、Running/Completed/Failed に分類、Sub Execution のグルーピング
3. **行74-157**: 各ステータスのテーブルHTML生成
4. **行164-192**: サマリー HTML 生成
5. **行194**: headerSparkPage で最終 HTML 生成

#### Step 3: テーブル描画を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AllExecutionsPage.scala | `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/AllExecutionsPage.scala` | ExecutionPagedTable クラス（行240-504）- PagedTable を継承したテーブル描画 |
| 3-2 | AllExecutionsPage.scala | `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/AllExecutionsPage.scala` | ExecutionDataSource クラス（行516-592）- データのソートとページング |

**主要処理フロー**:
- **行256**: ソートカラム・降順フラグ・ページサイズの取得
- **行298-331**: ヘッダー情報の定義（表示条件付き列制御）
- **行340-473**: row メソッドでのテーブル行HTML生成
- **行530**: データの変換とソート

### プログラム呼び出し階層図

```
SparkUI
    |
    +-- SQLTab (SparkUITab, prefix="SQL")
           |
           +-- AllExecutionsPage (WebUIPage, prefix="")
           |      |
           |      +-- render(request)
           |      |      +-- sqlStore.executionsList()
           |      |      +-- executionsTable() [Running/Completed/Failed 各々]
           |      |             +-- ExecutionPagedTable
           |      |                    +-- ExecutionDataSource
           |      |                    |      +-- executionRow() [データ変換]
           |      |                    |      +-- ordering() [ソート]
           |      |                    +-- headers() [ヘッダー生成]
           |      |                    +-- row() [行HTML生成]
           |      +-- UIUtils.headerSparkPage()
           |
           +-- ExecutionPage (No.23 で個別クエリ詳細表示)
```

### データフロー図

```
[入力]                    [処理]                           [出力]

HTTPリクエスト         AllExecutionsPage.render()
(page, sort,       --> パラメータ解析                 --> HTML レスポンス
 desc, pageSize)       |                                (Running/Completed/
                       v                                 Failed テーブル)
SQLAppStatusStore  --> executionsList()
(インメモリ)           |
                       +-- Sub Execution グルーピング
                       +-- Running/Completed/Failed 分類
                       +-- ExecutionPagedTable
                            +-- ソート・ページング
                            +-- HTML テーブル生成
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AllExecutionsPage.scala | `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/AllExecutionsPage.scala` | ソース | メインページクラス、テーブル・データソース |
| SQLTab.scala | `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/SQLTab.scala` | ソース | タブ登録、ページの管理 |
| SQLAppStatusStore.scala | `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/SQLAppStatusStore.scala` | ソース | SQL 実行データの永続化・取得 |
| UIUtils.scala | `core/src/main/scala/org/apache/spark/ui/UIUtils.scala` | ソース | HTML ユーティリティ |
| PagedTable.scala | `core/src/main/scala/org/apache/spark/ui/PagedTable.scala` | ソース | ページ付きテーブルの基盤クラス |
| ExecutionPage.scala | `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/ExecutionPage.scala` | ソース | 個別実行詳細（リンク先） |
