# 帳票設計書 23-ExecutionPage（SQL）

## 概要

本ドキュメントは、Apache Spark Web UI における個別 SQL クエリ実行の詳細ページ（ExecutionPage）の帳票設計書である。特定の SQL/DataFrame 実行に関する詳細情報（物理プラン、DAG 可視化、関連ジョブ一覧等）を表示する HTML レポートページの仕様を定義する。

### 本帳票の処理概要

ExecutionPage は、AllExecutionsPage（No.22）からリンクされる個別 SQL 実行の詳細ページであり、クエリの物理実行プラン、プラン可視化（DAG 図）、実行時間、関連ジョブ一覧、変更された SQL 設定等を表示する。

**業務上の目的・背景**：SQL クエリのパフォーマンスチューニングや問題調査において、クエリの物理実行プラン（Physical Plan）と DAG の可視化は不可欠である。本帳票により、どのオペレータがどのような順序で実行されるかを視覚的に把握でき、ボトルネックの特定を支援する。

**帳票の利用シーン**：AllExecutionsPage から特定のクエリ実行をクリックした際に遷移する詳細ページとして利用される。クエリの実行プランの確認、メトリクスの分析、失敗原因の調査などに使用される。

**主要な出力内容**：
1. 実行サマリー（開始時刻、Duration、Query ID、関連ジョブ一覧）
2. Plan Visualization（D3.js + dagre-d3 による DAG 可視化グラフ）
3. Plan Details（物理プランのテキスト表示、折り畳み式）
4. SQL / DataFrame Properties（変更された設定値一覧）
5. Pandas API Properties（Pandas on Spark 固有設定一覧）
6. サブ実行リンク（グルーピング有効時）

**帳票の出力タイミング**：AllExecutionsPage の特定実行 ID リンクをクリックした際に動的生成される。

**帳票の利用者**：データエンジニア、Spark アプリケーション開発者、パフォーマンスチューニング担当者

## 帳票種別

Web UI ページ（詳細表示）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| 23 | ExecutionPage（SQL） | `/SQL/execution/?id={executionId}` | AllExecutionsPage から実行 ID をクリック |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | HTML（Web UI ページ） |
| 用紙サイズ | N/A（ブラウザ表示） |
| 向き | N/A |
| ファイル名 | N/A（動的 HTML レスポンス） |
| 出力方法 | ブラウザ上にリアルタイム表示 |
| 文字コード | UTF-8 |

### PDF固有設定

N/A

### Excel固有設定

N/A

## 帳票レイアウト

### レイアウト概要

```
+---------------------------------------------+
|   Spark UI ヘッダー                            |
|   "Details for Query {executionId}"          |
+---------------------------------------------+
| Submitted Time: {date}                       |
| Duration: {duration}                         |
| Query ID: {queryId}                          |
| Parent Execution: {link} (該当時)             |
| Sub Executions: {links} (該当時)              |
| Running Jobs: {links}                        |
| Succeeded Jobs: {links}                      |
| Failed Jobs: {links}                         |
| [Download: SVG | DOT | TXT]                 |
+---------------------------------------------+
| ▼ Plan Visualization                         |
|   [DAG グラフ（D3.js + dagre-d3）]             |
+---------------------------------------------+
| ▶ Plan Details（折り畳み）                     |
|   {物理プランテキスト}                          |
+---------------------------------------------+
| ▶ SQL / DataFrame Properties（折り畳み）       |
|   | Name | Value |                           |
+---------------------------------------------+
| ▶ Pandas API Properties（折り畳み）            |
|   | Name | Value |                           |
+---------------------------------------------+
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Submitted Time | 実行開始時刻 | executionUIData.submissionTime | UIUtils.formatDate |
| 2 | Duration | 実行時間 | completionTime - submissionTime | UIUtils.formatDuration |
| 3 | Query ID | クエリ ID | executionUIData.queryId | テキスト |
| 4 | Parent Execution | 親実行へのリンク | executionUIData.rootExecutionId | リンク |
| 5 | Sub Executions | サブ実行へのリンク一覧 | sqlStore.executionsList() でフィルタ | リンク群 |
| 6 | Running Jobs | 実行中ジョブ | jobs (RUNNING) | ジョブリンク群 |
| 7 | Succeeded Jobs | 成功ジョブ | jobs (SUCCEEDED) | ジョブリンク群 |
| 8 | Failed Jobs | 失敗ジョブ | jobs (FAILED) | ジョブリンク群 |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Plan Visualization | DAG 可視化グラフ | sqlStore.planGraph(executionId) + sqlStore.executionMetrics() | SVG グラフ（D3.js） | 100% |
| 2 | Plan Details | 物理プランテキスト | executionUIData.physicalPlanDescription | pre タグ内テキスト | 100% |
| 3 | SQL Properties | 変更された SQL 設定 | executionUIData.modifiedConfigs | Name-Value テーブル | auto |
| 4 | Pandas API Properties | Pandas on Spark 設定 | modifiedConfigs (pandas_on_Spark. prefix) | Name-Value テーブル | auto |

### フッター部

N/A

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| id | SQL 実行 ID | Yes |

### ソート順

N/A（単一実行の詳細表示）

### 改ページ条件

N/A（単一ページ表示）

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| SQLAppStatusStore | SQL 実行詳細情報の取得 | executionId |

### テーブル別参照項目詳細

#### SQLAppStatusStore

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| execution(executionId) | 実行サマリー全体 | ID 指定 | SQLExecutionUIData を返す |
| executionMetrics(executionId) | プラン可視化メトリクス | ID 指定 | Map[Long, String] |
| planGraph(executionId) | DAG グラフデータ | ID 指定 | SparkPlanGraph |
| executionsList() | サブ実行一覧 | rootExecutionId でフィルタ | groupSubExecutionEnabled 時 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| Duration | completionTime.getOrElse(currentTime) - submissionTime | なし | ミリ秒単位 |
| DOT ファイル | graph.makeDotFile(metrics) | N/A | D3.js 可視化用 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[HTTPリクエスト受信] --> B{id パラメータあり？}
    B -->|No| C[エラー: Missing execution id]
    B -->|Yes| D[sqlStore.execution で詳細取得]
    D --> E{データ存在？}
    E -->|No| F[No information 表示]
    E -->|Yes| G[Duration 計算]
    G --> H[ジョブリンク生成]
    H --> I[Plan Visualization 生成]
    I --> J[Physical Plan Description 生成]
    J --> K[Modified Configs 生成]
    K --> L[headerSparkPage で HTML 生成]
    L --> M[レスポンス返却]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| パラメータ不足 | id パラメータが null または空 | "Missing execution id parameter" (require 例外) | 正しい実行 ID を指定する |
| データなし | 指定 ID のデータが存在しない | "No information to display for query {executionId}" | 正しい実行 ID を確認する |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 単一実行の詳細表示（DAG ノード数は数十～数百） |
| 目標出力時間 | 1秒以内（DAG の複雑さに依存） |
| 同時出力数上限 | Spark Web UI のスレッドプール制約に従う |

## セキュリティ考慮事項

- 物理プランの内容にはテーブル名やカラム名等のスキーマ情報が含まれる。
- SQL Properties には設定値が表示されるため、機密情報が含まれないよう注意が必要。
- DOT ファイルのダウンロード機能があるため、出力データの取り扱いに注意すること。

## 備考

- Plan Visualization は D3.js、dagre-d3.min.js、graphlib-dot.min.js を使用して描画される。
- Pandas on Spark の設定は `pandas_on_Spark.` プレフィックスで区別され、Python の repr() 形式に変換して表示される。
- Download 機能で SVG、DOT、TXT 形式でのプランエクスポートが可能。

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SQLExecutionUIData | `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/SQLAppStatusStore.scala` | 実行データ構造（physicalPlanDescription, modifiedConfigs 等） |
| 1-2 | SparkPlanGraph | `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/SparkPlanGraph.scala` | DAG グラフデータ構造と makeDotFile メソッド |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ExecutionPage.scala | `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/ExecutionPage.scala` | render() メソッド（行40-143）が起点 |

**主要処理フロー**:
1. **行41-43**: id パラメータの取得・検証
2. **行46**: sqlStore.execution() で実行データ取得
3. **行48-49**: Duration 計算
4. **行68-124**: サマリー HTML 生成（時刻、ジョブリンク、ダウンロードボタン）
5. **行126-128**: メトリクスとグラフデータの取得
6. **行131-136**: Plan Visualization + Plan Details + Config 表示の結合
7. **行141-142**: headerSparkPage で最終 HTML 生成

#### Step 3: プラン可視化を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ExecutionPage.scala | `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/ExecutionPage.scala` | planVisualization() メソッド（行156-184）- DOT データ埋め込みと JavaScript リソース読み込み |

#### Step 4: 設定表示を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | ExecutionPage.scala | `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/ExecutionPage.scala` | modifiedConfigs() メソッド（行203-225）と modifiedPandasOnSparkConfigs() メソッド（行227-265） |

### プログラム呼び出し階層図

```
SQLTab
    |
    +-- ExecutionPage (WebUIPage, prefix="execution")
           |
           +-- render(request)
                  |
                  +-- sqlStore.execution(executionId)
                  +-- sqlStore.executionMetrics(executionId)
                  +-- sqlStore.planGraph(executionId)
                  +-- planVisualization(request, metrics, graph)
                  |      +-- graph.makeDotFile(metrics)
                  |      +-- planVisualizationResources() [JS/CSS 読み込み]
                  +-- physicalPlanDescription()
                  +-- modifiedConfigs()
                  +-- modifiedPandasOnSparkConfigs()
                  +-- UIUtils.headerSparkPage()
```

### データフロー図

```
[入力]                    [処理]                           [出力]

HTTPリクエスト         ExecutionPage.render()
(id={executionId}) --> パラメータ解析                  --> HTML レスポンス
                       |                                 (サマリー +
SQLAppStatusStore  --> execution()                        DAG 可視化 +
(インメモリ)           executionMetrics()                  プラン詳細 +
                       planGraph()                        設定一覧)
                       |
                       +-- Duration 計算
                       +-- DAG DOT 生成
                       +-- HTML 組み立て
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ExecutionPage.scala | `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/ExecutionPage.scala` | ソース | メインページクラス |
| SQLTab.scala | `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/SQLTab.scala` | ソース | タブ登録 |
| SQLAppStatusStore.scala | `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/SQLAppStatusStore.scala` | ソース | データストア |
| SparkPlanGraph.scala | `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/SparkPlanGraph.scala` | ソース | DAG グラフ構造と DOT 生成 |
| spark-sql-viz.js | `sql/core/src/main/resources/org/apache/spark/sql/execution/ui/static/spark-sql-viz.js` | 静的リソース | DAG 可視化 JavaScript |
| spark-sql-viz.css | `sql/core/src/main/resources/org/apache/spark/sql/execution/ui/static/spark-sql-viz.css` | 静的リソース | DAG 可視化スタイル |
| d3.min.js | `core/src/main/resources/org/apache/spark/ui/static/d3.min.js` | 静的リソース | D3.js ライブラリ |
| dagre-d3.min.js | `core/src/main/resources/org/apache/spark/ui/static/dagre-d3.min.js` | 静的リソース | dagre-d3 レイアウトライブラリ |
