# 帳票設計書 26-StreamingPage（DStream）

## 概要

本ドキュメントは、Apache Spark Web UI における DStream ストリーミング統計ページ（StreamingPage）の帳票設計書である。Spark Streaming（DStream API）の全体統計情報（入力レート、スケジューリング遅延、処理時間、合計遅延）をタイムラインとヒストグラムで可視化し、バッチ一覧を表示する HTML レポートページの仕様を定義する。

### 本帳票の処理概要

StreamingPage は DStream ベースの Spark Streaming アプリケーションの統計ダッシュボードとして、入力レート・スケジューリング遅延・処理時間・合計遅延のグラフと、Running/Waiting/Completed バッチの一覧テーブルを表示する。

**業務上の目的・背景**：DStream ベースのストリーミング処理において、バッチ処理の遅延が蓄積していないか、入力レートと処理能力のバランスが取れているかを監視することは安定運用の要である。本帳票により、ストリーミングアプリケーションの健全性をリアルタイムに把握できる。

**帳票の利用シーン**：Spark Streaming アプリケーション実行中に「Streaming」タブを開いて統計情報を確認する際に利用される。バッチ処理遅延の検知、入力ソース別のレート分析、障害発生時の初期診断に使われる。

**主要な出力内容**：
1. 基本情報（バッチ間隔、稼働時間、開始時刻、完了バッチ数、受信レコード数）
2. Input Rate タイムライン・ヒストグラム（全ストリーム合計 + 入力ソース別展開）
3. Scheduling Delay タイムライン・ヒストグラム
4. Processing Time タイムライン・ヒストグラム
5. Total Delay タイムライン・ヒストグラム
6. Running Batches テーブル
7. Waiting Batches テーブル
8. Completed Batches テーブル

**帳票の出力タイミング**：Spark Web UI の「Streaming」タブにアクセスした際にリアルタイムで生成される。

**帳票の利用者**：ストリーミングパイプライン運用担当者、データエンジニア、SRE

## 帳票種別

Web UI ページ（統計グラフ + 一覧表）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| 26 | StreamingPage（DStream） | `/streaming/` | Spark UI の「Streaming」タブをクリック |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | HTML（Web UI ページ） |
| 用紙サイズ | N/A（ブラウザ表示） |
| 向き | N/A |
| ファイル名 | N/A（動的 HTML レスポンス） |
| 出力方法 | ブラウザ上にリアルタイム表示 |
| 文字コード | UTF-8 |

### PDF固有設定

N/A

### Excel固有設定

N/A

## 帳票レイアウト

### レイアウト概要

```
+---------------------------------------------+
|   Spark UI ヘッダー (Streaming Statistics)     |
+---------------------------------------------+
| Running batches of {batchDuration} for       |
| {timeSinceStart} since {startTime}           |
| ({completedBatches} completed batches,       |
|  {totalRecords} records)                     |
+---------------------------------------------+
| 統計テーブル                                   |
| +-------------------------------------------+|
| |           | Timelines  | Histograms       ||
| |-----------+------------+------------------||
| | Input Rate (expand) | [timeline] | [histo]||
| |  ▶ 入力ソース別展開                         ||
| | Scheduling Delay | [timeline] | [histo]   ||
| | Processing Time | [timeline] | [histo]    ||
| | Total Delay | [timeline] | [histogram]    ||
| +-------------------------------------------+|
+---------------------------------------------+
| ▼ Running Batches ({count})                  |
| ▼ Waiting Batches ({count})                  |
| ▼ Completed Batches (last N out of M)        |
+---------------------------------------------+
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | バッチ間隔 | DStream のバッチ間隔 | listener.batchDuration | formatDurationVerbose |
| 2 | 稼働時間 | アプリケーション稼働時間 | currentTime - startTime | formatDurationVerbose |
| 3 | 開始時刻 | アプリケーション開始時刻 | listener.startTime | formatDate |
| 4 | 完了バッチ数 | 完了バッチ総数 | listener.numTotalCompletedBatches | 数値 |
| 5 | 受信レコード数 | 受信レコード総数 | listener.numTotalReceivedRecords | 数値 |

### 明細部（統計グラフ）

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Input Rate | 全ストリーム合計入力レート | batches.numRecords * 1000 / batchDuration | タイムライン + ヒストグラム (records/sec) | 492px + 350px |
| 2 | 入力ソース別 | 各 InputDStream の入力レート | receivedRecordRateWithBatchTime | タイムライン + ヒストグラム (records/sec) | 同上 |
| 3 | Scheduling Delay | バッチスケジューリング遅延 | batchInfo.schedulingDelay | タイムライン + ヒストグラム (時間単位正規化) | 同上 |
| 4 | Processing Time | バッチ処理時間 | batchInfo.processingDelay | タイムライン + ヒストグラム (時間単位正規化) | 同上 |
| 5 | Total Delay | バッチ合計遅延 | batchInfo.totalDelay | タイムライン + ヒストグラム (時間単位正規化) | 同上 |

### 明細部（バッチ一覧）

バッチ一覧テーブルは Running / Waiting / Completed の3セクションに分かれ、StreamingPagedTable によるページ付きテーブルで表示される。

### フッター部

N/A

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| listener.retainedBatches | 保持バッチ数 | N/A |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | batchTime.milliseconds | 降順（最新バッチが上） |

### 改ページ条件

StreamingPagedTable によるページング。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| StreamingJobProgressListener | ストリーミングバッチ・レシーバ情報の取得 | N/A |

### テーブル別参照項目詳細

#### StreamingJobProgressListener

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| retainedBatches | グラフデータ・バッチ一覧 | - | Seq[BatchUIData] |
| batchDuration | バッチ間隔 | - | Long (ミリ秒) |
| startTime | 開始時刻 | - | Long |
| numTotalCompletedBatches | 完了バッチ数 | - | Long |
| numTotalReceivedRecords | 受信レコード数 | - | Long |
| receivedRecordRateWithBatchTime | 入力ソース別レート | - | Map[Int, Seq[(Long, Double)]] |
| receiverInfo(streamId) | レシーバ情報 | streamId 指定 | Option[ReceiverInfo] |
| runningBatches | 実行中バッチ | - | Seq[BatchUIData] |
| waitingBatches | 待機中バッチ | - | Seq[BatchUIData] |
| retainedCompletedBatches | 完了バッチ（保持分） | - | Seq[BatchUIData] |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| Input Rate (records/sec) | numRecords * 1000.0 / batchDuration | なし | 全ストリーム合計 |
| Time Unit 正規化 | schedulingDelay/processingTime/totalDelay の max を基に normalizedUnit を決定 | なし | UIUtils.normalizeDuration |
| Batch Interval (正規化単位) | UIUtils.convertToTimeUnit(batchDuration, normalizedUnit) | なし | Processing Time のリファレンスライン |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[HTTPリクエスト受信] --> B[listener.synchronized でデータ取得]
    B --> C[リソース読み込み・基本情報生成]
    C --> D[統計グラフ生成]
    D --> E[GraphUIData で各メトリクスのグラフ描画]
    E --> F[入力ソース別テーブル生成]
    F --> G[バッチ一覧テーブル生成]
    G --> H[headerSparkPage で HTML 生成]
    H --> I[レスポンス返却]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| テーブル描画エラー | IllegalArgumentException / IndexOutOfBoundsException | "Error while rendering streaming table: {exception}" | パラメータを修正する |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | retainedBatches サイズ（デフォルト 1000 バッチ） |
| 目標出力時間 | 2秒以内 |
| 同時出力数上限 | Spark Web UI のスレッドプール制約に従う |

## セキュリティ考慮事項

- listener.synchronized によるスレッドセーフなデータ取得が実装されている。
- レシーバ情報にはホスト名や Executor ID が含まれるため、Spark UI のアクセス制御を設定すること。

## 備考

- DStream API は Spark 3.4 以降で非推奨（deprecated）であり、Structured Streaming への移行が推奨されている。
- Scheduling Delay / Processing Time / Total Delay の Y 軸範囲は3つのメトリクスの最大値で統一される。
- Processing Time グラフにはバッチ間隔のリファレンスラインが表示される。

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | BatchUIData | `streaming/src/main/scala/org/apache/spark/streaming/ui/StreamingJobProgressListener.scala` | batchTime, schedulingDelay, processingDelay, totalDelay, numRecords 等 |
| 1-2 | MillisecondsStatUIData | `streaming/src/main/scala/org/apache/spark/streaming/ui/StreamingPage.scala` | 時間系メトリクスのデータ構造（行37-56） |
| 1-3 | RecordRateUIData | `streaming/src/main/scala/org/apache/spark/streaming/ui/StreamingPage.scala` | レコードレートのデータ構造（行64-71） |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | StreamingTab.scala | `streaming/src/main/scala/org/apache/spark/streaming/ui/StreamingTab.scala` | ページ登録（行36-37） |
| 2-2 | StreamingPage.scala | `streaming/src/main/scala/org/apache/spark/streaming/ui/StreamingPage.scala` | render() メソッド（行84-95） |

**主要処理フロー**:
1. **行85-86**: リソースと onClick 関数の生成
2. **行87**: 基本情報生成
3. **行90-93**: listener.synchronized 内で統計テーブルとバッチ一覧を生成

#### Step 3: 統計グラフ生成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | StreamingPage.scala | `streaming/src/main/scala/org/apache/spark/streaming/ui/StreamingPage.scala` | generateStatTable() メソッド（行172-347）- 全メトリクスのグラフ生成 |

#### Step 4: バッチ一覧生成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | StreamingPage.scala | `streaming/src/main/scala/org/apache/spark/streaming/ui/StreamingPage.scala` | generateBatchListTables() メソッド（行471-537）- Running/Waiting/Completed テーブル |

### プログラム呼び出し階層図

```
SparkUI
    |
    +-- StreamingTab (SparkUITab, prefix="streaming")
           |
           +-- StreamingPage (WebUIPage, prefix="")
           |      |
           |      +-- render(request)
           |             +-- generateLoadResources()
           |             +-- generateOnClickTimelineFunction()
           |             +-- generateBasicInfo()
           |             +-- listener.synchronized
           |                    +-- generateStatTable()
           |                    |      +-- RecordRateUIData
           |                    |      +-- MillisecondsStatUIData
           |                    |      +-- GraphUIData x4
           |                    |      +-- generateInputDStreamsTable()
           |                    +-- generateBatchListTables()
           |                           +-- StreamingPagedTable
           |
           +-- BatchPage (No.27)
```

### データフロー図

```
[入力]                         [処理]                           [出力]

HTTPリクエスト              render()
                       --> 基本情報 + 統計テーブル生成      --> HTML レスポンス
                            |                                (基本情報 +
StreamingJobProgressListener|                                 グラフ群 +
(インメモリ)            --> retainedBatches                    バッチ一覧)
                            receivedRecordRateWithBatchTime
                            receiverInfo
                            runningBatches / waitingBatches
                            retainedCompletedBatches
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| StreamingPage.scala | `streaming/src/main/scala/org/apache/spark/streaming/ui/StreamingPage.scala` | ソース | メインページクラス |
| StreamingTab.scala | `streaming/src/main/scala/org/apache/spark/streaming/ui/StreamingTab.scala` | ソース | タブ登録 |
| StreamingJobProgressListener.scala | `streaming/src/main/scala/org/apache/spark/streaming/ui/StreamingJobProgressListener.scala` | ソース | ストリーミングデータリスナー |
| UIUtils.scala | `streaming/src/main/scala/org/apache/spark/streaming/ui/UIUtils.scala` | ソース | DStream UI ユーティリティ（normalizeDuration, convertToTimeUnit 等） |
| GraphUIData.scala | `core/src/main/scala/org/apache/spark/ui/GraphUIData.scala` | ソース | グラフ描画基盤 |
| BatchPage.scala | `streaming/src/main/scala/org/apache/spark/streaming/ui/BatchPage.scala` | ソース | バッチ詳細（リンク先、No.27） |
| d3.min.js | `core/src/main/resources/org/apache/spark/ui/static/d3.min.js` | 静的リソース | D3.js |
| streaming-page.js | `core/src/main/resources/org/apache/spark/ui/static/streaming-page.js` | 静的リソース | ストリーミングページ JS |
| streaming-page.css | `core/src/main/resources/org/apache/spark/ui/static/streaming-page.css` | 静的リソース | ストリーミングページ CSS |
