# 帳票設計書 29-ThriftServerSessionPage

## 概要

本ドキュメントは、Apache Spark Web UI における Hive ThriftServer の個別セッション詳細ページ（ThriftServerSessionPage）の帳票設計書である。特定の JDBC/ODBC セッションに紐づく SQL 実行統計を表示する HTML レポートページの仕様を定義する。

### 本帳票の処理概要

ThriftServerSessionPage は ThriftServerPage（No.28）のセッション一覧からリンクされる個別セッションの詳細ページであり、セッションのユーザ情報・IP・作成時刻・SQL実行数の基本情報と、当該セッションで実行された SQL 文の統計テーブルを表示する。

**業務上の目的・背景**：特定のユーザセッションで実行されたSQLの履歴を確認する必要がある場合や、セッション単位での問題調査を行う場合に、セッションに紐づくSQL実行の全容を把握する必要がある。本帳票により、セッション粒度での SQL 実行分析が可能となる。

**帳票の利用シーン**：ThriftServerPage のセッション一覧から特定セッション ID をクリックして遷移する詳細ページとして利用される。ユーザ別の SQL 実行パターン分析、長時間セッションの調査、セッション内の問題クエリの特定に使われる。

**主要な出力内容**：
1. 基本統計（Started at、Time since start）
2. セッション情報（User、IP、Session created at、Total SQL 数）
3. SQL Statistics テーブル（当該セッションの SQL のみフィルタ）

**帳票の出力タイミング**：ThriftServerPage のセッション ID リンクをクリックした際に生成される。

**帳票の利用者**：ThriftServer 運用管理者、DBA

## 帳票種別

Web UI ページ（詳細表示）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| 29 | ThriftServerSessionPage | `/sqlserver/session/?id={sessionId}` | ThriftServerPage のセッション ID リンクをクリック |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | HTML（Web UI ページ） |
| 用紙サイズ | N/A（ブラウザ表示） |
| 向き | N/A |
| ファイル名 | N/A（動的 HTML レスポンス） |
| 出力方法 | ブラウザ上にリアルタイム表示 |
| 文字コード | UTF-8 |

### PDF固有設定

N/A

### Excel固有設定

N/A

## 帳票レイアウト

### レイアウト概要

```
+---------------------------------------------+
|   Spark UI ヘッダー (JDBC/ODBC Session)       |
+---------------------------------------------+
| Started at: {date}                           |
| Time since start: {duration}                 |
+---------------------------------------------+
| User {userName}, IP {ip},                    |
| Session created at {date},                   |
| Total run {N} SQL                            |
+---------------------------------------------+
| ▼ SQL Statistics                             |
| +------------------------------------------+|
| | User | JobID | GroupID | Start Time       ||
| | Finish Time | Close Time | Execution Time||
| | Duration | Statement | State | Detail    ||
| +------------------------------------------+|
+---------------------------------------------+
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Started at | サーバ起動時刻 | parent.startTime | formatDate |
| 2 | Time since start | 稼働時間 | currentTime - startTime | formatDurationVerbose |
| 3 | User | ユーザ名 | sessionStat.userName | テキスト |
| 4 | IP | クライアント IP | sessionStat.ip | テキスト |
| 5 | Session created at | セッション作成時刻 | sessionStat.startTimestamp | formatDate |
| 6 | Total SQL 数 | セッション内実行 SQL 数 | sessionStat.totalExecution | 数値 |

### 明細部（SQL Statistics）

No.28 ThriftServerPage の SQL Statistics テーブルと同一の列構成であるが、当該セッション ID に紐づく SQL のみをフィルタして表示する。SqlStatsPagedTable を subPath "sqlserver/session" で再利用する。

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1-11 | SQL Statistics の各列 | No.28 と同一 | store.getExecutionList.filter(_.sessionId == sessionID) | 同一 | auto |

### フッター部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | ページネーション | テーブルのページ切り替え | PagedTable 基盤 | ページ番号リンク |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| id | セッション ID | Yes |
| sessionId フィルタ | ExecutionList を sessionId でフィルタ | 自動（ページ側で適用） |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | Start Time（デフォルト） | 昇順（切替可能） |

### 改ページ条件

PagedTable フレームワークによるページング。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| HiveThriftServer2AppStatusStore | セッション・SQL実行情報の取得 | sessionId |

### テーブル別参照項目詳細

#### HiveThriftServer2AppStatusStore

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| getSession(sessionId) | セッション詳細 | sessionId 指定 | Option[SessionInfo] |
| getExecutionList | SQL 一覧 | sessionId でフィルタ | Seq[ExecutionInfo] |

## 計算仕様

### 計算項目一覧

No.28 ThriftServerPage と同一（Duration、Execution Time の計算）。

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[HTTPリクエスト受信] --> B{id パラメータあり？}
    B -->|No| C[エラー: Missing id parameter]
    B -->|Yes| D[store.getSession で取得]
    D --> E{セッション存在？}
    E -->|No| F[エラー: Invalid sessionID]
    E -->|Yes| G[基本統計生成]
    G --> H[セッション情報表示]
    H --> I[SQL テーブル生成（sessionId フィルタ）]
    I --> J[headerSparkPage で HTML 生成]
    J --> K[レスポンス返却]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| パラメータ不足 | id が null または空 | "Missing id parameter" | セッション ID を指定する |
| セッション不存在 | 指定セッション ID が見つからない | "Invalid sessionID[{id}]" | 正しいセッション ID を確認する |
| テーブル描画エラー | IllegalArgumentException 等 | "Error while rendering job table: {exception}" | パラメータを修正する |
| データなし | セッション内の SQL が空 | "No statistics have been generated yet." | SQL が実行されるまで待つ |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1セッションあたり数件～数百の SQL |
| 目標出力時間 | 1秒以内 |
| 同時出力数上限 | Spark Web UI のスレッドプール制約に従う |

## セキュリティ考慮事項

- No.28 ThriftServerPage と同様のセキュリティ考慮が適用される。
- store.synchronized でスレッドセーフにデータ取得される。

## 備考

- SqlStatsPagedTable を No.28 ThriftServerPage と共有している。subPath が "sqlserver/session" となる点で URL 構造が異なる。
- sqlTableTag は "sqlsessionstat" であり、No.28 の "sqlstat" とは異なるため、パラメータが混在しない。

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

No.28 ThriftServerPage と同一の SessionInfo、ExecutionInfo を使用する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SessionInfo / ExecutionInfo | `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2AppStatusStore.scala` | No.28 と同一 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ThriftServerSessionPage.scala | `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/ThriftServerSessionPage.scala` | render() メソッド（行36-55） |

**主要処理フロー**:
1. **行37-38**: id パラメータ取得・検証
2. **行40**: store.synchronized で一貫性保証
3. **行41-42**: getSession でセッション取得、require で存在検証
4. **行44-45**: 基本統計生成
5. **行47-51**: セッション情報表示
6. **行52**: generateSQLStatsTable でフィルタ済み SQL テーブル生成

#### Step 3: SQL テーブルのフィルタリングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ThriftServerSessionPage.scala | `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/ThriftServerSessionPage.scala` | generateSQLStatsTable() メソッド（行71-117）- sessionId でフィルタ（行72-73） |

### プログラム呼び出し階層図

```
ThriftServerTab
    |
    +-- ThriftServerSessionPage (WebUIPage, prefix="session")
           |
           +-- render(request) [store.synchronized]
                  +-- store.getSession(parameterId)
                  +-- generateBasicStats()
                  +-- generateSQLStatsTable(request, sessionId)
                         +-- store.getExecutionList.filter(_.sessionId == sessionID)
                         +-- SqlStatsPagedTable (No.28 と共有)
                                +-- SqlStatsTableDataSource
```

### データフロー図

```
[入力]                              [処理]                      [出力]

HTTPリクエスト                   render()
(id={sessionId})            --> store.synchronized          --> HTML レスポンス
                                 |                            (基本情報 +
HiveThriftServer2AppStatusStore  |                             セッション情報 +
(インメモリ)                --> getSession(sessionId)           SQL テーブル)
                                 getExecutionList
                                     .filter(sessionId)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ThriftServerSessionPage.scala | `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/ThriftServerSessionPage.scala` | ソース | メインページクラス |
| ThriftServerPage.scala | `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/ThriftServerPage.scala` | ソース | SqlStatsPagedTable の共有元 |
| ThriftServerTab.scala | `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/ThriftServerTab.scala` | ソース | タブ登録 |
| HiveThriftServer2AppStatusStore.scala | `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2AppStatusStore.scala` | ソース | データストア |
