# 帳票設計書 3-GraphiteSink メトリクスレポート

## 概要

本ドキュメントは、Apache Spark の MetricsSystem における GraphiteSink が出力する Graphite 形式メトリクスレポートの設計書である。Dropwizard Metrics ライブラリの GraphiteReporter を利用し、Spark の各コンポーネントのメトリクス情報を Graphite サーバへ定期的にネットワーク経由で送信する。TCP および UDP プロトコルを選択可能であり、メトリクス名のプレフィックスや正規表現フィルタリングにも対応している。

### 本帳票の処理概要

GraphiteSink メトリクスレポートは、Spark の内部メトリクスデータを Graphite 時系列データベースサーバへ定期送信する帳票機能である。

**業務上の目的・背景**：大規模 Spark クラスタの運用において、メトリクスデータを集約的に管理・可視化する必要がある。Graphite は広く普及した時系列データベースであり、Grafana 等の可視化ツールと組み合わせることで、クラスタ全体のパフォーマンスダッシュボードを構築できる。複数の Spark アプリケーション・ノードのメトリクスを一元管理し、時系列でのトレンド分析やアラート設定を可能にする。

**帳票の利用シーン**：(1) Graphite + Grafana ベースのモニタリング基盤を構築している環境での Spark メトリクス収集、(2) 複数 Spark クラスタのメトリクスを集約して一元監視する場合、(3) メトリクスデータの長期保存と時系列分析を行う場合。

**主要な出力内容**：
1. Gauge メトリクス（JVM メモリ使用量等）の時系列値
2. Counter メトリクス（タスク数等）の累積値
3. Histogram メトリクス（実行時間分布等）の統計値
4. Meter メトリクス（スループット等）のレート情報
5. Timer メトリクス（応答時間等）の統計値とレート

**帳票の出力タイミング**：MetricsSystem の start() 呼び出し時に定期送信が開始され、設定された間隔（デフォルト10秒）で自動的に Graphite サーバへ送信される。

**帳票の利用者**：Spark クラスタ管理者、SRE チーム、運用監視チーム。

## 帳票種別

メトリクスレポート（ネットワーク送信型の時系列データ）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| N/A | 設定ファイル駆動 | N/A | metrics.properties の設定により Graphite サーバへ自動送信 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | Graphite プレーンテキストプロトコル |
| 用紙サイズ | N/A（ネットワーク送信） |
| 向き | N/A |
| ファイル名 | N/A（ネットワーク送信） |
| 出力方法 | TCP または UDP で Graphite サーバへ送信 |
| 文字コード | UTF-8 |

### Graphite 固有設定

| 項目 | 内容 |
|-----|------|
| プロトコル | TCP（デフォルト）/ UDP |
| データフォーマット | `{prefix}.{metric_name} {value} {timestamp}\n` |
| 時間単位（Duration） | ミリ秒（MILLISECONDS） |
| レート単位 | 秒あたり（SECONDS） |
| プレフィックス | 設定可能（デフォルト: 空文字） |
| メトリクスフィルタ | 正規表現によるフィルタリング（regex 設定） |

## 帳票レイアウト

### レイアウト概要

Graphite プレーンテキストプロトコルに従い、1メトリクスにつき1行のテキストデータを送信する。

```
{prefix}.{metric_name}.{sub_metric} {value} {epoch_timestamp}
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| N/A | ヘッダーなし | Graphite プロトコルにヘッダーは存在しない | N/A | N/A |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | メトリクスパス | プレフィックス付きメトリクス名 | prefix + MetricRegistry キー | ドット区切り文字列 | 可変 |
| 2 | 値 | メトリクス値 | MetricRegistry の各メトリクス | 数値 | 可変 |
| 3 | タイムスタンプ | 送信時刻 | システム時刻 | エポック秒 | 10桁 |

### フッター部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| N/A | フッターなし | N/A | N/A | N/A |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| MetricRegistry 登録 | MetricRegistry に登録されているメトリクスが対象 | Yes |
| 正規表現フィルタ | regex 設定がある場合、マッチするメトリクスのみ送信 | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | メトリクス名 | Graphite サーバ側で管理 |

### 改ページ条件

ネットワーク送信のため改ページなし。

## データベース参照仕様

### 参照テーブル一覧

本帳票はデータベースを参照しない。

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| N/A（MetricRegistry） | メトリクスデータの取得元 | N/A |

### テーブル別参照項目詳細

#### MetricRegistry（インメモリ）

| 参照項目 | 帳票項目との対応 | 取得条件 | 備考 |
|---------|----------------|---------|------|
| Gauges | Gauge メトリクス送信 | registry.getGauges() | filter 適用後 |
| Counters | Counter メトリクス送信 | registry.getCounters() | filter 適用後 |
| Histograms | Histogram メトリクス送信 | registry.getHistograms() | filter 適用後 |
| Meters | Meter メトリクス送信 | registry.getMeters() | filter 適用後 |
| Timers | Timer メトリクス送信 | registry.getTimers() | filter 適用後 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| レート変換 | 元値 / 秒 | Dropwizard 既定 | convertRatesTo(TimeUnit.SECONDS) |
| Duration変換 | 元値(ns) -> ms | Dropwizard 既定 | convertDurationsTo(TimeUnit.MILLISECONDS) |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[MetricsSystem.start] --> B[GraphiteSink.start]
    B --> C[GraphiteReporter.start - 定期スケジュール登録]
    C --> D{定期タイマー発火}
    D --> E[GraphiteReporter.report]
    E --> F[MetricRegistry からメトリクス取得]
    F --> G[MetricFilter でフィルタリング]
    G --> H{プロトコル}
    H -->|TCP| I[Graphite TCP 接続で送信]
    H -->|UDP| J[GraphiteUDP で送信]
    I --> D
    J --> D
    K[MetricsSystem.stop] --> L[GraphiteSink.stop]
    L --> M[GraphiteReporter.stop]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| host 未設定 | property に host が設定されていない | SparkCoreErrors.graphiteSinkPropertyMissingError("host") | host 設定を追加 |
| port 未設定 | property に port が設定されていない | SparkCoreErrors.graphiteSinkPropertyMissingError("port") | port 設定を追加 |
| 不正プロトコル | protocol 設定が tcp/udp 以外 | SparkCoreErrors.graphiteSinkInvalidProtocolError(p) | tcp または udp を指定 |
| ポーリング間隔エラー | ポーリング間隔が1秒未満 | IllegalArgumentException | 設定値を1秒以上に変更 |
| 数値変換エラー | port/period 設定値が数値でない | NumberFormatException | 整数値を設定 |
| ネットワークエラー | Graphite サーバに接続できない | IOException（GraphiteReporter 内部） | ネットワーク設定・サーバ状態を確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | メトリクス数に依存（正規表現フィルタで絞込可能） |
| 目標出力時間 | 定期間隔内に送信完了（デフォルト10秒以内） |
| 同時出力数上限 | 1（単一スレッドでの定期レポート） |

## セキュリティ考慮事項

- Graphite サーバとの通信は暗号化されていない（プレーンテキストプロトコル）ため、機密性の高いメトリクスを送信する場合は VPN やネットワーク分離を検討すること
- ファイアウォール設定により、送信先 host:port へのアクセスを適切に制御すること

## 備考

- 設定は `metrics.properties` ファイルで行う。設定例：
  ```
  *.sink.graphite.class=org.apache.spark.metrics.sink.GraphiteSink
  *.sink.graphite.host=graphite-server
  *.sink.graphite.port=2003
  *.sink.graphite.period=10
  *.sink.graphite.unit=SECONDS
  *.sink.graphite.prefix=spark
  *.sink.graphite.protocol=tcp
  *.sink.graphite.regex=.*executor.*
  ```
- host と port は必須設定項目である
- protocol のデフォルトは TCP であり、UDP を使用する場合は明示的に設定が必要

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Sink.scala | `core/src/main/scala/org/apache/spark/metrics/sink/Sink.scala` | Sink トレイトの3メソッド定義（行20-24） |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MetricsSystem.scala | `core/src/main/scala/org/apache/spark/metrics/MetricsSystem.scala` | registerSinks()（行199-240）と start()（行97-106）での Sink ライフサイクル管理 |

#### Step 3: GraphiteSink の実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | GraphiteSink.scala | `core/src/main/scala/org/apache/spark/metrics/sink/GraphiteSink.scala` | クラス全体（行29-103）を通読。他の Sink と比べて host/port の必須バリデーション、TCP/UDP プロトコル選択、正規表現フィルタリングがある点が特徴 |

**主要処理フロー**:
- **行29-30**: Properties と MetricRegistry をコンストラクタ引数として受け取る
- **行31-41**: デフォルト値と設定キーの定義（period=10, unit=SECONDS, prefix="", protocol, regex）
- **行45-51**: host と port の必須チェック（未設定時は SparkCoreErrors でエラー）
- **行53-54**: host と port の取得
- **行56-66**: period, unit, prefix の読み込み
- **行68**: MetricsSystem.checkMinimalPollingPeriod() でポーリング間隔検証
- **行70-74**: protocol 設定に基づいて Graphite（TCP）または GraphiteUDP を生成。デフォルトは TCP
- **行76-83**: regex 設定に基づいて MetricFilter を生成。未設定時は MetricFilter.ALL（全メトリクス対象）
- **行85-90**: GraphiteReporter を構築。prefix 付き、filter 付き
- **行92-94**: start() で定期レポート開始
- **行96-98**: stop() で停止
- **行100-102**: report() で即時レポート

### プログラム呼び出し階層図

```
MetricsSystem.start()
    |
    +-- registerSinks()
    |       +-- Utils.classForName("GraphiteSink")
    |       +-- GraphiteSink.<init>(properties, registry)
    |               +-- host/port 必須チェック
    |               +-- MetricsSystem.checkMinimalPollingPeriod()
    |               +-- protocol に基づき Graphite/GraphiteUDP 生成
    |               +-- regex に基づき MetricFilter 生成
    |               +-- GraphiteReporter.forRegistry(registry)
    |                       .prefixedWith(prefix)
    |                       .filter(filter)
    |                       .build(graphite)
    |
    +-- sinks.foreach(_.start())
            +-- GraphiteSink.start()
                    +-- GraphiteReporter.start(pollPeriod, pollUnit)
                            +-- [定期スケジュール] GraphiteReporter.report()
                                    +-- MetricRegistry から取得
                                    +-- MetricFilter でフィルタリング
                                    +-- Graphite/GraphiteUDP へ送信
```

### データフロー図

```
[入力]                      [処理]                         [出力]

MetricRegistry          GraphiteSink                  Graphite サーバ
(Gauges,                +-- GraphiteReporter           host:port
 Counters,                  +-- MetricFilter(regex)    (TCP or UDP)
 Histograms,                +-- prefixedWith(prefix)
 Meters,                    +-- Graphite/GraphiteUDP
 Timers)

Properties              設定読み込み
(host, port, period,    +-- 必須チェック(host, port)
 unit, prefix,          +-- プロトコル選択
 protocol, regex)       +-- フィルタ生成
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Sink.scala | `core/src/main/scala/org/apache/spark/metrics/sink/Sink.scala` | ソース | Sink トレイト定義 |
| GraphiteSink.scala | `core/src/main/scala/org/apache/spark/metrics/sink/GraphiteSink.scala` | ソース | Graphite 送信 Sink の実装 |
| MetricsSystem.scala | `core/src/main/scala/org/apache/spark/metrics/MetricsSystem.scala` | ソース | Sink の登録・管理・起動 |
| SparkCoreErrors.scala | `core/src/main/scala/org/apache/spark/errors/SparkCoreErrors.scala` | ソース | エラーメッセージ定義 |
