# 帳票設計書 5-Slf4jSink メトリクスレポート

## 概要

本ドキュメントは、Apache Spark の MetricsSystem における Slf4jSink が出力する SLF4J ログ形式メトリクスレポートの設計書である。Dropwizard Metrics ライブラリの Slf4jReporter を利用し、Spark の各コンポーネントのメトリクス情報を SLF4J ロギングフレームワーク経由で定期的にログ出力する。

### 本帳票の処理概要

Slf4jSink メトリクスレポートは、Spark の内部メトリクスデータを SLF4J ログとして定期出力する帳票機能である。

**業務上の目的・背景**：Spark アプリケーションのログ管理基盤と統合してメトリクスデータを出力する必要がある場合に利用する。SLF4J は Java/Scala エコシステムで最も普及したロギングファサードであり、Log4j、Logback、java.util.logging 等の実装と組み合わせ可能である。既存のログ集約基盤（ELK Stack、Splunk 等）にメトリクスデータを統合する際に有効であり、ログレベルによるフィルタリングやログローテーションの恩恵を受けることができる。

**帳票の利用シーン**：(1) ログベースのモニタリング基盤（ELK Stack 等）にメトリクスを統合する場合、(2) 既存のログ管理ポリシーに従ってメトリクスを管理したい場合、(3) 外部メトリクスサーバを導入せずにログファイルでメトリクスを記録する場合。

**主要な出力内容**：
1. Gauge メトリクス（現在値）をログレコードとして出力
2. Counter メトリクス（累積値）をログレコードとして出力
3. Histogram メトリクス（統計分布）をログレコードとして出力
4. Meter メトリクス（スループット）をログレコードとして出力
5. Timer メトリクス（応答時間統計）をログレコードとして出力

**帳票の出力タイミング**：MetricsSystem の start() 呼び出し時に定期出力が開始され、設定された間隔（デフォルト10秒）で SLF4J ログとして出力される。

**帳票の利用者**：Spark クラスタ管理者、ログ分析エンジニア、運用監視チーム。

## 帳票種別

メトリクスレポート（ログ出力型の定期モニタリングデータ）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| N/A | 設定ファイル駆動 | N/A | metrics.properties の設定により SLF4J ログへ自動出力 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | SLF4J ログ（Logback/Log4j 等の設定に従う） |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | SLF4J 実装の設定に依存 |
| 出力方法 | SLF4J ロギングフレームワーク経由 |
| 文字コード | SLF4J 実装の設定に依存 |

### SLF4J 固有設定

| 項目 | 内容 |
|-----|------|
| ログレベル | INFO（Slf4jReporter デフォルト） |
| 時間単位（Duration） | ミリ秒（MILLISECONDS） |
| レート単位 | 秒あたり（SECONDS） |

## 帳票レイアウト

### レイアウト概要

Slf4jReporter は各メトリクスを個別のログレコードとして出力する。フォーマットは SLF4J 実装の設定に依存する。

```
[timestamp] [level] [logger] type={type}, name={name}, value={value}, ...
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | タイムスタンプ | ログ出力日時 | SLF4J 実装 | ログフォーマット依存 |
| 2 | ログレベル | 出力レベル | Slf4jReporter | INFO |
| 3 | ロガー名 | レポータークラス名 | Slf4jReporter | クラスFQCN |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | type | メトリクス種別 | Slf4jReporter | GAUGE/COUNTER/HISTOGRAM/METER/TIMER | 可変 |
| 2 | name | メトリクス名 | MetricRegistry キー | 文字列 | 可変 |
| 3 | value | メトリクス値（種別により複数フィールド） | MetricRegistry | 数値 | 可変 |

### フッター部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| N/A | フッターなし | N/A | N/A | N/A |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| MetricRegistry 登録 | MetricRegistry に登録されている全メトリクスが対象 | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | メトリクス種別 | 固定順 |
| 2 | メトリクス名 | 昇順 |

### 改ページ条件

ログ出力のため改ページなし。

## データベース参照仕様

### 参照テーブル一覧

本帳票はデータベースを参照しない。

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| N/A（MetricRegistry） | メトリクスデータの取得元 | N/A |

### テーブル別参照項目詳細

#### MetricRegistry（インメモリ）

| 参照項目 | 帳票項目との対応 | 取得条件 | 備考 |
|---------|----------------|---------|------|
| Gauges | Gauge ログレコード | registry.getGauges() | 全 Gauge を出力 |
| Counters | Counter ログレコード | registry.getCounters() | 全 Counter を出力 |
| Histograms | Histogram ログレコード | registry.getHistograms() | 全 Histogram を出力 |
| Meters | Meter ログレコード | registry.getMeters() | 全 Meter を出力 |
| Timers | Timer ログレコード | registry.getTimers() | 全 Timer を出力 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| レート変換 | 元値 / 秒 | Dropwizard 既定 | convertRatesTo(TimeUnit.SECONDS) |
| Duration変換 | 元値(ns) -> ms | Dropwizard 既定 | convertDurationsTo(TimeUnit.MILLISECONDS) |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[MetricsSystem.start] --> B[Slf4jSink.start]
    B --> C[Slf4jReporter.start - 定期スケジュール登録]
    C --> D{定期タイマー発火}
    D --> E[Slf4jReporter.report]
    E --> F[MetricRegistry からメトリクス取得]
    F --> G[各メトリクスを SLF4J ログレコードとして出力]
    G --> D
    H[MetricsSystem.stop] --> I[Slf4jSink.stop]
    I --> J[Slf4jReporter.stop]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| ポーリング間隔エラー | ポーリング間隔が1秒未満 | IllegalArgumentException | 設定値を1秒以上に変更 |
| 数値変換エラー | period 設定値が数値でない | NumberFormatException | 整数値を設定 |
| TimeUnit 変換エラー | unit 設定値が不正 | IllegalArgumentException | 有効な TimeUnit 値を設定 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | メトリクス数に依存 |
| 目標出力時間 | 定期間隔内に完了（デフォルト10秒以内） |
| 同時出力数上限 | 1（単一スレッドでの定期レポート） |

## セキュリティ考慮事項

- ログファイルの出力先・アクセス権限は SLF4J 実装（Logback/Log4j）の設定に依存する
- メトリクスデータにはクラスタ内部状態が含まれるため、ログファイルのアクセス制御を適切に設定すること

## 備考

- 設定は `metrics.properties` ファイルで行う。設定例：
  ```
  *.sink.slf4j.class=org.apache.spark.metrics.sink.Slf4jSink
  *.sink.slf4j.period=10
  *.sink.slf4j.unit=SECONDS
  ```
- Slf4jReporter は Dropwizard Metrics ライブラリの機能を利用している
- ConsoleSink と構造が非常に類似しており、出力先が System.out ではなく SLF4J ロガーである点のみが異なる

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Sink.scala | `core/src/main/scala/org/apache/spark/metrics/sink/Sink.scala` | Sink トレイトの3メソッド定義（行20-24） |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MetricsSystem.scala | `core/src/main/scala/org/apache/spark/metrics/MetricsSystem.scala` | registerSinks()（行199-240）と start()（行97-106） |

#### Step 3: Slf4jSink の実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Slf4jSink.scala | `core/src/main/scala/org/apache/spark/metrics/sink/Slf4jSink.scala` | クラス全体（行27-63）を通読。ConsoleSink と同じ構造で、ConsoleReporter が Slf4jReporter に替わっている |

**主要処理フロー**:
- **行27-28**: Properties と MetricRegistry をコンストラクタ引数として受け取る
- **行29-33**: デフォルト値と設定キーの定義（period=10, unit=SECONDS）
- **行35-43**: Properties から period と unit を読み込み
- **行45**: MetricsSystem.checkMinimalPollingPeriod() でポーリング間隔検証
- **行47-50**: Slf4jReporter.forRegistry() でレポーターを構築。Duration はミリ秒、Rate は秒単位
- **行52-54**: start() で定期レポート開始
- **行56-58**: stop() で停止
- **行60-62**: report() で即時レポート

### プログラム呼び出し階層図

```
MetricsSystem.start()
    |
    +-- registerSinks()
    |       +-- Slf4jSink.<init>(properties, registry)
    |               +-- MetricsSystem.checkMinimalPollingPeriod()
    |               +-- Slf4jReporter.forRegistry(registry).build()
    |
    +-- sinks.foreach(_.start())
            +-- Slf4jSink.start()
                    +-- Slf4jReporter.start(pollPeriod, pollUnit)
                            +-- [定期スケジュール] Slf4jReporter.report()
                                    +-- SLF4J Logger.info(...)
```

### データフロー図

```
[入力]                     [処理]                        [出力]

MetricRegistry         Slf4jSink                    SLF4J ログ
(Gauges,               +-- Slf4jReporter             (Logback/Log4j 等)
 Counters,                 +-- forRegistry()          -> ログファイル
 Histograms,               +-- convertDurations(ms)  -> コンソール
 Meters,                   +-- convertRates(/s)      -> ログ集約サーバ
 Timers)                   +-- build()

Properties             設定読み込み
(period, unit)         +-- pollPeriod, pollUnit
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Sink.scala | `core/src/main/scala/org/apache/spark/metrics/sink/Sink.scala` | ソース | Sink トレイト定義 |
| Slf4jSink.scala | `core/src/main/scala/org/apache/spark/metrics/sink/Slf4jSink.scala` | ソース | SLF4J ログ出力 Sink の実装 |
| MetricsSystem.scala | `core/src/main/scala/org/apache/spark/metrics/MetricsSystem.scala` | ソース | Sink の登録・管理・起動 |
